/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.lifecycle;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.ConnectionDefinition;
import de.elpro.ewms.core.component.ClientComponentBase;
import de.elpro.ewms.core.component.ClientInfo;
import de.elpro.ewms.core.component.ServerInfo;
import de.elpro.ewms.core.component.VersionUtils;
import de.elpro.ewms.gui.Messages;
import de.elpro.ewms.gui.lifecycle.SplashScreen;
import de.elpro.ewms.gui.model.ClientFootprint;
import de.elpro.ewms.gui.model.ILifeCycleHook;
import de.elpro.ui.fx.dialog.utils.AlertDialogUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.Window;
import javax.inject.Inject;
import jidefx.scene.control.validation.ValidationIcons;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.services.restart.LifecycleRV;
import org.osgi.framework.Version;

public class Manager {
    public static final String LIFECYCLE_EXTENSION_POINT_ID = "de.elpro.ewms.gui.lifecycle";
    private static final String REPOSITORY_LOC = System.getProperty("updatehandler.repo");
    private static final boolean DEBUG = Boolean.getBoolean("com.eos.gui.debug");
    private static final IEclipsePreferences PREFERENCES = InstanceScope.INSTANCE.getNode("eos.core.client");
    private static Manager INSTANCE;
    private SplashScreen splashScreen;
    private Pane controlsFxPane = null;
    private String updateName = null;
    private final ThreadSynchronize.BlockCondition<LifecycleRV> fxBlock = new ThreadSynchronize.BlockCondition();
    @Inject
    private ThreadSynchronize sync;
    @Inject
    private IEclipseContext context;
    @Inject
    private IProvisioningAgent agent;
    private IProfile selfProfile;
    private ClientInfo clientInfo;
    @Log
    @Inject
    private Logger logger;

    static {
        System.setProperty("efxclipse.eclipse.compat.sash", System.getProperty("efxclipse.eclipse.compat.sash", "true"));
        ValidationIcons.setInstance((ValidationIcons)new de.elpro.ui.controls.decoration.ValidationIcons());
    }

    public Manager() {
        INSTANCE = this;
    }

    public static Manager getInstance() {
        return INSTANCE;
    }

    @PostContextCreate
    protected LifecycleRV postContextCreate(IExtensionRegistry extensionRegistry) throws IOException, InterruptedException {
        if (DEBUG) {
            this.logger.info("Client running in debug mode. Wait 10s before start application. Add\r\n\t-Xdebug\r\n\t-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=8998\r\nto launcher.ini to allow remote java debuging at port 8998.");
            Thread.sleep(10000L);
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)this.agent.getService(IProfileRegistry.class);
        this.selfProfile = profileRegistry.getProfile("_SELF_");
        if (this.selfProfile != null) {
            this.logger.info("Profile ID: " + this.selfProfile.getProfileId());
        } else {
            this.logger.error("Profile ID is NULL");
        }
        this.clientInfo = this.getClientInfo();
        this.context.set(ClientInfo.class, (Object)this.clientInfo);
        this.splashScreen = new SplashScreen();
        LifecycleRV rv = LifecycleRV.CONTINUE;
        if (REPOSITORY_LOC != null && !REPOSITORY_LOC.isBlank()) {
            rv = this.executeUpdate(this.sync, REPOSITORY_LOC);
        }
        String lastLogin = ConnectionDefinition.INSTANCE.getLogin();
        String lastConnectionUrl = ConnectionDefinition.INSTANCE.getConnectionUrl();
        if (rv == LifecycleRV.CONTINUE) {
            this.initializeControlsFX();
            this.sync.block(this.fxBlock);
            for (final ILifeCycleHook startupHook : this.getStartupHooks(extensionRegistry)) {
                this.splashScreen.getStatusBarText().set((Object)startupHook.getJobName());
                final ThreadSynchronize.BlockCondition hookBlock = new ThreadSynchronize.BlockCondition();
                this.splashScreen.setOnCloseRequest(e -> {
                    if (hookBlock.isBlocked()) {
                        this.sync.syncExec(() -> hookBlock.release((Object)LifecycleRV.SHUTDOWN));
                    }
                });
                Job hookJob = new Job(startupHook.getJobName()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ILifeCycleHook.HookResult result = startupHook.hook(Manager.this.context, Manager.this.splashScreen);
                            Manager.this.sync.syncExec(() -> hookBlock.release((Object)result.getResult()));
                            return Status.OK_STATUS;
                        }
                        catch (Throwable exc) {
                            exc.printStackTrace();
                            Manager.this.sync.syncExec(() -> {
                                ExceptionDialog dlg = new ExceptionDialog(exc);
                                dlg.initOwner(Manager.this.splashScreen.getScene().getWindow());
                                dlg.setContentText(String.format(Messages.lifecycle_Manager_ErrorAs1, startupHook.getJobName()));
                                dlg.showAndWait();
                                hookBlock.release((Object)LifecycleRV.SHUTDOWN);
                            });
                            return Status.CANCEL_STATUS;
                        }
                    }
                };
                hookJob.schedule();
                LifecycleRV lifecycleRV = (LifecycleRV)this.sync.block(hookBlock);
                if (lifecycleRV == LifecycleRV.CONTINUE) continue;
                this.splashScreen.close();
                return lifecycleRV;
            }
        }
        this.splashScreen.close();
        this.context.set(ServerInfo.class, (Object)Client.getServerInfo());
        ClientFootprint lastClientInfo = this.loadLastClientFootprint();
        if (lastClientInfo != null) {
            boolean clearPersistedState = false;
            clearPersistedState |= !VersionUtils.exactMatchNoQualifier((Version)Version.parseVersion((String)lastClientInfo.getCoreVersion()), (Version)this.clientInfo.getCoreComponent().getVersion());
            clearPersistedState |= !VersionUtils.exactMatchNoQualifier((Version)Version.parseVersion((String)lastClientInfo.getProductVersion()), (Version)this.clientInfo.getProductVersion());
            if (clearPersistedState |= lastClientInfo.getProductId() != null && !lastClientInfo.getProductId().equals(this.clientInfo.getProductId())) {
                this.context.set("clearPersistedState", (Object)true);
            }
        }
        this.storeClientInfo(this.clientInfo);
        String newLogin = ConnectionDefinition.INSTANCE.getLogin();
        String newConnectionUrl = ConnectionDefinition.INSTANCE.getConnectionUrl();
        if (newLogin != null && !newLogin.equals(lastLogin) || newConnectionUrl != null && !newConnectionUrl.equals(lastConnectionUrl)) {
            this.context.set("clearPersistedState", (Object)true);
        }
        return rv;
    }

    public IProfile getSelfProfile() {
        return this.selfProfile;
    }

    private static IInstallableUnit getSelfProductUI(IProfile profile) {
        if (profile == null) {
            return null;
        }
        String profileId = profile.getProfileId();
        IQuery iuProductQuery = QueryUtil.createIUProductQuery();
        IQueryResult result = profile.query(iuProductQuery, null);
        if (result == null) {
            return null;
        }
        for (IInstallableUnit productIU : result) {
            if (!profileId.equals(productIU.getId())) continue;
            return productIU;
        }
        return null;
    }

    private ClientInfo getClientInfo() {
        IInstallableUnit selfProductUI = Manager.getSelfProductUI(this.selfProfile);
        String selfProductName = "Unavailable in IDE runtime";
        String selfProductId = "Id unknown";
        Version selfProductVersion = Version.emptyVersion;
        if (selfProductUI != null) {
            selfProductName = selfProductUI.getProperty("org.eclipse.equinox.p2.name");
            selfProductId = selfProductUI.getId();
            selfProductVersion = Version.parseVersion((String)selfProductUI.getVersion().toString());
        }
        String javaVersion = System.getProperty("java.version");
        ClientComponentBase[] components = (ClientComponentBase[])ServiceUtils.getServiceList(ClientComponentBase.class).toArray(ClientComponentBase[]::new);
        ClientInfo info = new ClientInfo(selfProductName, selfProductId, selfProductVersion, javaVersion, components);
        return info;
    }

    private List<ILifeCycleHook> getStartupHooks(IExtensionRegistry extensionRegistry) {
        List hooks = ServiceUtils.getServiceList(ILifeCycleHook.class);
        Collections.sort(hooks, new Comparator<ILifeCycleHook>(){

            @Override
            public int compare(ILifeCycleHook o1, ILifeCycleHook o2) {
                return Integer.compare(o2.getPriority(), o1.getPriority());
            }
        });
        hooks.forEach(h -> ContextInjectionFactory.inject((Object)h, (IEclipseContext)this.context));
        return hooks;
    }

    public LifecycleRV executeUpdate(final ThreadSynchronize sync, final String repositoryLocation) {
        final ThreadSynchronize.BlockCondition block = new ThreadSynchronize.BlockCondition();
        this.sync.syncExec(() -> this.splashScreen.getStatusBarText().set((Object)Messages.lifecycle_Manager_Searching_for_updates));
        Job j = new Job("Update Job"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final IStatus status = Manager.this.checkForUpdates(sync, repositoryLocation, Manager.this.agent, monitor);
                    sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (status == null) {
                                sync.syncExec(() -> (this).Manager.this.splashScreen.getStatusBarText().set((Object)Messages.lifecycle_Manager_updateError));
                                block.release((Object)LifecycleRV.CONTINUE);
                            } else if (status.getCode() == 10000 || status.getSeverity() == 2) {
                                sync.syncExec(() -> (this).Manager.this.splashScreen.getStatusBarText().set((Object)Messages.lifecycle_Manager_no_updates_found));
                                block.release((Object)LifecycleRV.CONTINUE);
                            } else if (status.isOK()) {
                                AlertDialogUtils.showWaitAlert((Alert.AlertType)Alert.AlertType.INFORMATION, (Window)(this).Manager.this.splashScreen, (String)Messages.lifecycle_Manager_Update_successful, (String)String.format(Messages.lifecycle_Manager_Update_installed_restart, (this).Manager.this.updateName));
                                block.release((Object)LifecycleRV.RESTART_CLEAR_STATE);
                            } else {
                                ExceptionDialog dlg = new ExceptionDialog((Throwable)new Exception(status.getMessage()));
                                dlg.initOwner((this).Manager.this.splashScreen.getScene().getWindow());
                                if (status.getException() != null) {
                                    dlg = new ExceptionDialog(status.getException());
                                }
                                dlg.setHeaderText(Messages.lifecycle_Manager_Updates_failed_Download);
                                dlg.showAndWait();
                                block.release((Object)LifecycleRV.SHUTDOWN);
                            }
                        }
                    });
                    return status;
                }
                catch (Exception exc) {
                    sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                            dlg.initOwner((this).Manager.this.splashScreen.getScene().getWindow());
                            dlg.showAndWait();
                            block.release((Object)LifecycleRV.SHUTDOWN);
                        }
                    });
                    return Status.CANCEL_STATUS;
                }
            }
        };
        j.schedule();
        return (LifecycleRV)sync.block(block);
    }

    private IStatus checkForUpdates(final ThreadSynchronize sync, String repositoryLocation, IProvisioningAgent agent, IProgressMonitor monitor) {
        ButtonType type;
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        URI uri = null;
        if (repositoryLocation == null) {
            this.logger.info("No Update Repository URI specified. You can set it up in config.ini over -Dupdatehandler.repo=http://myorl.org/ paremeter.");
            return new Status(2, "de.elpro.ewms.gui", "No Update Repository URI specified. You can set it up in config.ini over -Dupdatehandler.repo=http://myorl.org/ paremeter.");
        }
        try {
            uri = new URI(repositoryLocation);
            this.logger.debug("Update URI " + uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.logger.warning("Wrong Update URI Syntax");
            return new Status(2, "de.elpro.ewms.gui", "Wrong Update URI Syntax");
        }
        String uriHostName = uri.getHost();
        if (uriHostName != null && !uriHostName.isEmpty()) {
            boolean reachable = false;
            try {
                String checkHostMessage = String.format(Messages.lifecycle_Manager_connectingUpdateServer, uriHostName);
                this.logger.info(checkHostMessage);
                sync.syncExec(() -> this.splashScreen.getStatusBarText().set((Object)checkHostMessage));
                reachable = InetAddress.getByName(uriHostName).isReachable(1000);
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (IOException iOException) {
                String warningText = String.format(Messages.lifecycle_Manager_timeoutCheckingHost, uriHostName);
                this.logger.warning(warningText);
                return new Status(2, "de.elpro.ewms.gui", warningText);
            }
            if (!reachable) {
                String warningText = String.format(Messages.lifecycle_Manager_updateHostUnreachable, uriHostName);
                this.logger.error(warningText);
                return new Status(2, "de.elpro.ewms.gui", warningText);
            }
        }
        operation.getProvisioningContext().setArtifactRepositories(new URI[]{uri});
        operation.getProvisioningContext().setMetadataRepositories(new URI[]{uri});
        IStatus status = operation.resolveModal(monitor);
        if (status.getCode() == 10000) {
            this.logger.debug("Nothing to update");
            return status;
        }
        ProvisioningJob provisioningJob = operation.getProvisioningJob(monitor);
        if (provisioningJob == null) {
            this.logger.debug("updates cannot run from within Eclipse IDE!!!");
            return new Status(2, "de.elpro.ewms.gui", Messages.lifecycle_Manager_updates_cannot_run);
        }
        Update[] updates = operation.getPossibleUpdates();
        if (updates != null && updates.length == 1) {
            this.updateName = updates[0].replacement.toString();
        }
        if ((type = (ButtonType)sync.syncExec(() -> {
            this.splashScreen.getStatusBarText().set((Object)Messages.lifecycle_Manager_Updating_application);
            Alert alert = AlertDialogUtils.getConfirmAlert((Window)this.splashScreen.getScene().getWindow(), (String)Messages.lifecycle_Manager_updateFound, (String)Messages.lifecycle_Manager_installUpdateNow, (String)String.format(Messages.lifecycle_Manager_updateVersion, this.updateName));
            return (ButtonType)alert.showAndWait().get();
        }, null)) != ButtonType.OK) {
            return null;
        }
        Update[] updateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            Update update = updateArray[n2];
            this.logger.debug("Update " + update.replacement.toString());
            ++n2;
        }
        return provisioningJob.runModal(new IProgressMonitor(){

            public void worked(int work) {
            }

            public void subTask(final String name) {
                sync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).Manager.this.splashScreen.getStatusBarText().set((Object)name);
                    }
                });
            }

            public void setTaskName(String name) {
            }

            public void setCanceled(boolean value) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void internalWorked(double work) {
            }

            public void done() {
                sync.syncExec(() -> Manager.this.splashScreen.getStatusBarText().set((Object)Messages.lifecycle_Manager_Update_done));
            }

            public void beginTask(final String name, int totalWork) {
                sync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).Manager.this.splashScreen.getStatusBarText().set((Object)name);
                    }
                });
            }
        });
    }

    private void initializeControlsFX() {
        this.splashScreen.getStatusBarText().set((Object)Messages.lifecycle_Manager_Initializing_graphics_library);
        new Job("Initialize FX"){

            protected IStatus run(IProgressMonitor monitor) {
                PropertySheet sheet = new PropertySheet();
                Manager.this.controlsFxPane = new BorderPane((Node)sheet);
                Manager.this.sync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).Manager.this.splashScreen.getRoot() != null) {
                            for (Node node : (this).Manager.this.splashScreen.getRoot().getChildren()) {
                                if (node.getId() == null || !node.getId().equals("fxcontainer") || !(node instanceof Pane)) continue;
                                Pane pane = (Pane)node;
                                (this).Manager.this.controlsFxPane.setVisible(false);
                                pane.getChildren().add((Object)(this).Manager.this.controlsFxPane);
                            }
                        }
                    }
                });
                Manager.this.sync.syncExec(() -> Manager.this.fxBlock.release((Object)LifecycleRV.CONTINUE));
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private ClientFootprint loadLastClientFootprint() {
        ClientFootprint clientFootprint;
        String productName = PREFERENCES.get("last.productName", null);
        String productId = PREFERENCES.get("last.productId", null);
        String productVersion = PREFERENCES.get("last.productVersion", null);
        String coreVersion = PREFERENCES.get("last.coreVersion", null);
        String javaVersion = PREFERENCES.get("last.javaVersion", null);
        if (coreVersion == null || coreVersion.isBlank()) {
            return null;
        }
        try {
            clientFootprint = new ClientFootprint(productName, productId, productVersion, coreVersion, javaVersion);
        }
        catch (Exception exc) {
            this.logger.error("Error reading last ClientInfo", (Throwable)exc);
            return null;
        }
        return clientFootprint;
    }

    private void storeClientInfo(ClientInfo clientInfo) {
        PREFERENCES.put("last.productName", clientInfo.getProductName());
        PREFERENCES.put("last.productId", clientInfo.getProductId());
        if (clientInfo.getProductVersion() != null) {
            PREFERENCES.put("last.productVersion", clientInfo.getProductVersion().toString());
        }
        if (clientInfo.getCoreComponent().getVersion() != null) {
            PREFERENCES.put("last.coreVersion", clientInfo.getCoreComponent().getVersion().toString());
        }
        PREFERENCES.put("last.javaVersion", clientInfo.getJavaVersion());
        try {
            PREFERENCES.flush();
        }
        catch (Exception exc) {
            this.logger.error("Error store last ClientInfo", (Throwable)exc);
        }
    }
}

