/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.menu.handler;

import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.fx.dialogs.CreateRawValuesViewDialog;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRange;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import javafx.scene.Scene;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.fx.core.ThreadSynchronize;

public class CreateRawValuesViewHandler {
    @Execute
    public void execute(Scene scene, ThreadSynchronize sync, @Optional ITimeRangeFilter timeRangeFilter) {
        TimeRange timeRange = null;
        if (timeRangeFilter != null) {
            timeRange = timeRangeFilter.getTimeRange(null);
        }
        if (timeRange == TimeRange.REALTIME) {
            timeRange = ServerDAO.getRealtimeViewArchiveTimeRange();
        } else if (timeRange == null) {
            timeRange = ServerDAO.getGlobalViewArchiveTimeRange();
        }
        LocalDateTime from = timeRange != null ? LocalDateTime.ofInstant(timeRange.getFrom(), ZoneOffset.systemDefault()) : null;
        LocalDateTime to = timeRange != null ? LocalDateTime.ofInstant(timeRange.getTo(), ZoneOffset.systemDefault()) : null;
        CreateRawValuesViewDialog dialog = new CreateRawValuesViewDialog(scene.getWindow(), sync, from, to, Raster.Second_1);
        dialog.showAndWait();
    }
}

