/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.menu.handler;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.gui.utils.ExportUtils;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.utils.TaskUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.Execute;

public class ExportExcelVariablesConfigHandler {
    private static final String EXPORT_ALIAS = "variables_config_excel";
    @Inject
    private Stage stage;

    @Execute
    public void execute() {
        final ExportConfig exportConfig = this.getExcelFile("Variables Config");
        if (exportConfig.myWorkbook == null) {
            return;
        }
        exportConfig.initExcelProperties();
        CallableTask<Void> task = new CallableTask<Void>(){

            public Void call() throws Exception {
                try {
                    ExportExcelVariablesConfigHandler.this.writeVarConfig(exportConfig);
                    exportConfig.myWorkbook.write((OutputStream)exportConfig.fos);
                    exportConfig.fos.close();
                    exportConfig.myWorkbook.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        TaskUtils.executeUITask((CallableTask)task).consumeResult((arg_0, arg_1) -> this.lambda$0((CallableTask)task, arg_0, arg_1));
    }

    private void writeVarConfig(ExportConfig exportConfig) {
        Transaction trx = Transactions.begin();
        try {
            StructureClass[] structureClassArray = StructureClassDAO.getAll((Transaction)trx);
            int n = structureClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureClass structureClass = structureClassArray[n2];
                Variable[] vars = VariableDAO.getByClass((Transaction)trx, (StructureClass)structureClass);
                if (vars.length != 0) {
                    HashMap<Integer, StructureObject> allObjects = new HashMap<Integer, StructureObject>();
                    StructureObject[] structureObjectArray = StructureClassDAO.getAllObjects((Transaction)trx, (StructureClass)structureClass);
                    int n3 = structureObjectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        StructureObject object = structureObjectArray[n4];
                        allObjects.put(object.getId(), object);
                        ++n4;
                    }
                    Sheet sheet = exportConfig.myWorkbook.createSheet(structureClass.toString());
                    int rowIndex = 0;
                    Row summaryRow = sheet.createRow(rowIndex++);
                    Cell classTextCell = summaryRow.createCell(0);
                    classTextCell.setCellValue(String.format("Class Name: %s", structureClass));
                    rowIndex += 3;
                    Variable[] variableArray = vars;
                    int n5 = vars.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Variable var = variableArray[n6];
                        Row varHeaderRow = sheet.createRow(rowIndex++);
                        Row varFieldsRow = sheet.createRow(rowIndex++);
                        int varHeaderColumnIndex = 0;
                        ExportExcelVariablesConfigHandler.createTextCell(varHeaderRow, varHeaderColumnIndex, "Variable Name").setCellStyle(exportConfig.lockedHeaderStyle);
                        ExportExcelVariablesConfigHandler.createTextCell(varFieldsRow, varHeaderColumnIndex++, var.toString());
                        ExportExcelVariablesConfigHandler.createTextCell(varHeaderRow, varHeaderColumnIndex, "Measuring Unit").setCellStyle(exportConfig.lockedHeaderStyle);
                        ExportExcelVariablesConfigHandler.createTextCell(varFieldsRow, varHeaderColumnIndex++, String.format("%s [%s]", var.getMeasuringUnit().getKey(), var.getMeasuringUnit().getDisplayUnitText()));
                        ExportExcelVariablesConfigHandler.createTextCell(varHeaderRow, varHeaderColumnIndex, "Description").setCellStyle(exportConfig.lockedHeaderStyle);
                        ExportExcelVariablesConfigHandler.createTextCell(varFieldsRow, varHeaderColumnIndex++, var.getDescription());
                        ExportExcelVariablesConfigHandler.createTextCell(varHeaderRow, varHeaderColumnIndex, "Default Calculation Formula").setCellStyle(exportConfig.lockedHeaderStyle);
                        ExportExcelVariablesConfigHandler.createTextCell(varFieldsRow, varHeaderColumnIndex++, var.getDefaultCalculationFormula());
                        Row instancesHeaderRow = sheet.createRow(rowIndex++);
                        int instanceColumnIndex = 0;
                        ExportExcelVariablesConfigHandler.createTextCell(instancesHeaderRow, instanceColumnIndex++, "Variable Instance Object Name").setCellStyle(exportConfig.lockedLightHeaderStyle);
                        ExportExcelVariablesConfigHandler.createTextCell(instancesHeaderRow, instanceColumnIndex++, "OPC UA Identifier").setCellStyle(exportConfig.lockedLightHeaderStyle);
                        ExportExcelVariablesConfigHandler.createTextCell(instancesHeaderRow, instanceColumnIndex++, "Description").setCellStyle(exportConfig.lockedLightHeaderStyle);
                        ExportExcelVariablesConfigHandler.createTextCell(instancesHeaderRow, instanceColumnIndex++, "Calculation Formula").setCellStyle(exportConfig.lockedLightHeaderStyle);
                        ExportExcelVariablesConfigHandler.createTextCell(instancesHeaderRow, instanceColumnIndex++, "Datasource Address").setCellStyle(exportConfig.lockedLightHeaderStyle);
                        ExportExcelVariablesConfigHandler.createTextCell(instancesHeaderRow, instanceColumnIndex++, "Instance Type").setCellStyle(exportConfig.lockedLightHeaderStyle);
                        ExportExcelVariablesConfigHandler.createTextCell(instancesHeaderRow, instanceColumnIndex++, "Supplement Strategy").setCellStyle(exportConfig.lockedLightHeaderStyle);
                        VariableInstance[] variableInstanceArray = VariableInstanceDAO.getAll((Transaction)trx, (Variable)var);
                        int n7 = variableInstanceArray.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            VariableInstance instance = variableInstanceArray[n8];
                            instance.setStructureObject((StructureObject)allObjects.get(instance.getStructureObject().getId()));
                            instance.setVariable(var);
                            instanceColumnIndex = 0;
                            Row instanceFieldsRow = sheet.createRow(rowIndex++);
                            ExportExcelVariablesConfigHandler.createTextCell(instanceFieldsRow, instanceColumnIndex++, instance.getStructureObject().toString());
                            ExportExcelVariablesConfigHandler.createTextCell(instanceFieldsRow, instanceColumnIndex++, instance.getTextIdentifier());
                            ExportExcelVariablesConfigHandler.createTextCell(instanceFieldsRow, instanceColumnIndex++, instance.getDescription());
                            ExportExcelVariablesConfigHandler.createTextCell(instanceFieldsRow, instanceColumnIndex++, instance.getType() == VariableInstanceType.Calculated ? instance.getCalculationFormula() : null);
                            ExportExcelVariablesConfigHandler.createTextCell(instanceFieldsRow, instanceColumnIndex++, instance.getPlcDatasourceKey());
                            ExportExcelVariablesConfigHandler.createTextCell(instanceFieldsRow, instanceColumnIndex++, instance.getType().toString());
                            ExportExcelVariablesConfigHandler.createTextCell(instanceFieldsRow, instanceColumnIndex++, instance.getSupplementValueStrategy() != null ? instance.getSupplementValueStrategy().toString() : null);
                            ++n8;
                        }
                        sheet.createRow(rowIndex++);
                        ++n6;
                    }
                }
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private static Cell createTextCell(Row row, int column, String text) {
        Cell cell = row.createCell(column);
        cell.setCellValue(text);
        return cell;
    }

    private ExportConfig getExcelFile(String itemName) {
        ExportConfig exportConfig = new ExportConfig();
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter xlsxExtFilter = new FileChooser.ExtensionFilter("EXCEL files (*.xlsx)", new String[]{"*.xlsx"});
        fileChooser.getExtensionFilters().add((Object)xlsxExtFilter);
        fileChooser.setInitialDirectory(ExportUtils.getDefaultExportFolder(EXPORT_ALIAS));
        fileChooser.setInitialFileName(String.format("%s", itemName));
        File file = fileChooser.showSaveDialog((Window)this.stage);
        ButtonType bt = null;
        do {
            try {
                if (file == null) continue;
                String folderName = file.isDirectory() ? file.getPath() : file.getParent();
                ExportUtils.setDefaultExportFolderPath(EXPORT_ALIAS, folderName);
                exportConfig.fos = new FileOutputStream(file);
                exportConfig.myWorkbook = new HSSFWorkbook();
                bt = ButtonType.FINISH;
            }
            catch (Exception exc) {
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setHeaderText("Fehler!");
                dlg.setContentText("Unbehandelter Fehler beim Speichern der EXCEL-Datei.\nM\u00f6chten sie es nochmal versuchen?");
                dlg.showAndWait();
                bt = (ButtonType)dlg.getResult();
                if (bt != null) continue;
                bt = ButtonType.OK;
            }
        } while (bt != null && bt == ButtonType.OK);
        return exportConfig;
    }

    private /* synthetic */ void lambda$0(CallableTask callableTask, Worker.State status, Void result) {
        Platform.runLater(() -> {
            TaskUtils.removeTaskFromView((CallableTask)callableTask);
            if (status == Worker.State.SUCCEEDED) {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.initOwner(this.stage.getScene().getWindow());
                alert.setContentText("Export finished.");
                alert.show();
            }
        });
    }

    private static class ExportConfig {
        private Workbook myWorkbook;
        private FileOutputStream fos;
        private CellStyle lockedHeaderStyle;
        private CellStyle lockedLightHeaderStyle;
        private CellStyle lockedRedHeaderStyle;
        private CellStyle unlockedCellStyle;
        private CellStyle unlockedRedCellStyle;
        private CellStyle lockedCellStyle;
        private CellStyle lockedBoldCellStyle;
        private CellStyle lockedRedCellStyle;
        private CellStyle lockedRedSumCellStyle;
        private Font f1;
        private Font f2;
        private Font f3;

        private ExportConfig() {
        }

        void initExcelProperties() {
            this.f1 = this.myWorkbook.createFont();
            this.f1.setFontName("Arial");
            this.f1.setFontHeightInPoints((short)12);
            this.f1.setBold(true);
            this.f2 = this.myWorkbook.createFont();
            this.f2.setFontName("Arial");
            this.f2.setFontHeightInPoints((short)10);
            this.f2.setBold(false);
            this.f3 = this.myWorkbook.createFont();
            this.f3.setFontName("Arial");
            this.f3.setFontHeightInPoints((short)10);
            this.f3.setBold(true);
            this.lockedHeaderStyle = this.myWorkbook.createCellStyle();
            this.lockedHeaderStyle.setAlignment(HorizontalAlignment.CENTER);
            this.lockedHeaderStyle.setFont(this.f1);
            this.lockedHeaderStyle.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
            this.lockedHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.lockedHeaderStyle.setLocked(true);
            this.lockedLightHeaderStyle = this.myWorkbook.createCellStyle();
            this.lockedLightHeaderStyle.setAlignment(HorizontalAlignment.CENTER);
            this.lockedLightHeaderStyle.setFont(this.f1);
            this.lockedLightHeaderStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            this.lockedLightHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.lockedLightHeaderStyle.setLocked(true);
            this.lockedRedHeaderStyle = this.myWorkbook.createCellStyle();
            this.lockedRedHeaderStyle.setAlignment(HorizontalAlignment.CENTER);
            this.lockedRedHeaderStyle.setFont(this.f1);
            this.lockedRedHeaderStyle.setFillForegroundColor(IndexedColors.ROSE.getIndex());
            this.lockedRedHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.lockedRedHeaderStyle.setLocked(true);
            this.unlockedCellStyle = this.myWorkbook.createCellStyle();
            this.unlockedCellStyle.setAlignment(HorizontalAlignment.LEFT);
            this.unlockedCellStyle.setFont(this.f2);
            this.unlockedCellStyle.setLocked(false);
            this.unlockedRedCellStyle = this.myWorkbook.createCellStyle();
            this.unlockedRedCellStyle.setAlignment(HorizontalAlignment.LEFT);
            this.unlockedRedCellStyle.setFont(this.f2);
            this.unlockedRedCellStyle.setLocked(false);
            this.lockedCellStyle = this.myWorkbook.createCellStyle();
            this.lockedCellStyle.setAlignment(HorizontalAlignment.LEFT);
            this.lockedCellStyle.setFont(this.f2);
            this.lockedCellStyle.setLocked(true);
            this.lockedBoldCellStyle = this.myWorkbook.createCellStyle();
            this.lockedBoldCellStyle.setBorderTop(BorderStyle.MEDIUM);
            this.lockedBoldCellStyle.setAlignment(HorizontalAlignment.LEFT);
            this.lockedBoldCellStyle.setFont(this.f3);
            this.lockedBoldCellStyle.setLocked(true);
            this.lockedRedCellStyle = this.myWorkbook.createCellStyle();
            this.lockedRedCellStyle.setAlignment(HorizontalAlignment.LEFT);
            this.lockedRedCellStyle.setFont(this.f2);
            this.lockedRedCellStyle.setLocked(true);
            this.lockedRedSumCellStyle = this.myWorkbook.createCellStyle();
            this.lockedRedSumCellStyle.setBorderTop(BorderStyle.MEDIUM);
            this.lockedRedSumCellStyle.setAlignment(HorizontalAlignment.LEFT);
            this.lockedRedSumCellStyle.setFont(this.f2);
            this.lockedRedSumCellStyle.setLocked(true);
        }
    }
}

