/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.menu.handler;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.SupplementValueChange;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.utils.TaskUtils;
import java.io.File;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.prefs.BackingStoreException;

public class ImportMSAccessSupplementValuesHandler {
    private static final IEclipsePreferences prefNode = InstanceScope.INSTANCE.getNode("gui-prefs");
    @Inject
    @Log
    private Logger logger;

    @Execute
    public void execute(Scene scene) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter xlsxExtFilter = new FileChooser.ExtensionFilter("MS Access", new String[]{"*.accdb", "*.mdb"});
        fileChooser.getExtensionFilters().add((Object)xlsxExtFilter);
        String exportPath = prefNode.get("VariablesConfigImportPath", System.getProperty("user.home"));
        File exportPathFile = new File(exportPath);
        if (!(exportPathFile.exists() || exportPathFile.getParentFile() != null && exportPathFile.getParentFile().exists())) {
            exportPathFile = new File(System.getProperty("user.home"));
        }
        fileChooser.setInitialDirectory(exportPathFile.isDirectory() ? exportPathFile : exportPathFile.getParentFile());
        fileChooser.setInitialFileName(exportPathFile.isDirectory() ? "Values.mdb" : exportPathFile.getName());
        final File file = fileChooser.showOpenDialog(scene.getWindow());
        if (file == null) {
            return;
        }
        prefNode.put("VariablesConfigImportPath", file.getAbsolutePath());
        try {
            prefNode.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        CallableTask<Void> task = new CallableTask<Void>(){

            public Void call() throws Exception {
                Database db = DatabaseBuilder.open((File)file);
                this.updateProgress(0L, 1L);
                Row lRow = null;
                try {
                    try {
                        HashMap<String, Integer> instanceIds = new HashMap<String, Integer>();
                        Table configTable = db.getTable("Config");
                        for (Row row : configTable) {
                            instanceIds.put(row.getString("Key"), row.getInt("EOS_ID"));
                        }
                        Table importTable = db.getTable("Import Supplement Values");
                        Raster raster = ServerDAO.getGlobalViewRaster();
                        LinkedList<SupplementValueChange> changes = new LinkedList<SupplementValueChange>();
                        Iterator iterator = importTable.iterator();
                        while (iterator.hasNext()) {
                            Row row;
                            lRow = row = (Row)iterator.next();
                            String key = row.getString("Instance Key");
                            Integer instanceId = (Integer)instanceIds.get(key);
                            if (instanceId == null) {
                                throw new Exception(String.format("No Variable Instance for Key %s found. Row (%s)", key, row.toString()));
                            }
                            LocalDateTime from = row.getLocalDateTime("From (UTC)");
                            LocalDateTime to = row.getLocalDateTime("To (UTC)");
                            if (from == null || to == null) {
                                throw new Exception(String.format("From and To fields cannot be null. Row (%s)", row.toString()));
                            }
                            if (!to.isAfter(from)) {
                                throw new Exception(String.format("To must be after From. Row (%s)", row.toString()));
                            }
                            long fromTs = from.atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
                            long toTs = to.atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
                            if (fromTs != raster.getRasterEnd(fromTs)) {
                                throw new Exception(String.format("From Timestamp is not in Raster %s. Row (%s)", raster.toString(), row.toString()));
                            }
                            if (toTs != raster.getRasterEnd(toTs)) {
                                throw new Exception(String.format("To Timestamp is not in Raster %s. Row (%s)", raster.toString(), row.toString()));
                            }
                            Double value = row.getDouble("Value");
                            if (value == null || !Double.isFinite(value)) {
                                value = Double.NaN;
                            }
                            SupplementValueChange change = new SupplementValueChange(new VariableInstance(instanceId.intValue()), Instant.ofEpochMilli(fromTs), Instant.ofEpochMilli(toTs), null, value.doubleValue());
                            changes.add(change);
                        }
                        VariableInstanceDAO.applySupplementValuesChanges((SupplementValueChange[])changes.toArray(new SupplementValueChange[0]), (boolean)false);
                    }
                    catch (Exception exc) {
                        throw new Exception(String.format("Error importing row (%s)", lRow), exc);
                    }
                }
                finally {
                    db.close();
                }
                return null;
            }
        };
        TaskUtils.executeUITask((CallableTask)task).consumeResult((arg_0, arg_1) -> ImportMSAccessSupplementValuesHandler.lambda$0(scene, (CallableTask)task, arg_0, arg_1));
    }

    private static /* synthetic */ void lambda$0(Scene scene, CallableTask callableTask, Worker.State state, Void result) {
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.initOwner(scene.getWindow());
            alert.setContentText("Export finished.");
            alert.show();
            TaskUtils.removeTaskFromView((CallableTask)callableTask);
        });
    }
}

