/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.menu.handler;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.client.variable.VariableRoleDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.gui.menu.part.ImportMSAccessVariableValuesDialog;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.prefs.BackingStoreException;

public class ImportMSAccessVariableValuesHandler {
    private static final IEclipsePreferences prefNode = InstanceScope.INSTANCE.getNode("gui-prefs");
    @Inject
    @Log
    private Logger logger;

    @Execute
    public void execute(Scene scene, ThreadSynchronize sync) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter xlsxExtFilter = new FileChooser.ExtensionFilter("MS Access", new String[]{"*.accdb", "*.mdb"});
        fileChooser.getExtensionFilters().add((Object)xlsxExtFilter);
        String exportPath = prefNode.get("VariablesConfigImportPath", System.getProperty("user.home"));
        File exportPathFile = new File(exportPath);
        if (!(exportPathFile.exists() || exportPathFile.getParentFile() != null && exportPathFile.getParentFile().exists())) {
            exportPathFile = new File(System.getProperty("user.home"));
        }
        fileChooser.setInitialDirectory(exportPathFile.isDirectory() ? exportPathFile : exportPathFile.getParentFile());
        fileChooser.setInitialFileName(exportPathFile.isDirectory() ? "Values.mdb" : exportPathFile.getName());
        File file = fileChooser.showOpenDialog(scene.getWindow());
        if (file == null) {
            return;
        }
        prefNode.put("VariablesConfigImportPath", file.getAbsolutePath());
        try {
            prefNode.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        try {
            Map<VariableInstance, ImportMSAccessVariableInstanceValuesConfig> instanceCandidates = this.findMatchingInstances(file);
            ImportMSAccessVariableValuesDialog importDialog = new ImportMSAccessVariableValuesDialog(scene, sync, file, instanceCandidates);
            ButtonType btn = importDialog.showAndWait().orElse(ButtonType.CANCEL);
            if (btn == ButtonType.OK) {
                Alert info = new Alert(Alert.AlertType.INFORMATION);
                info.initOwner(scene.getWindow());
                info.setContentText(String.format("Success import of %s", file.getName()));
                info.show();
            }
        }
        catch (IOException e) {
            ExceptionDialog excDialog = new ExceptionDialog((Throwable)e);
            excDialog.initOwner(scene.getWindow());
            excDialog.showAndWait();
        }
    }

    private Map<VariableInstance, ImportMSAccessVariableInstanceValuesConfig> findMatchingInstances(File dbFile) throws IOException {
        LinkedHashMap<VariableInstance, ImportMSAccessVariableInstanceValuesConfig> result = new LinkedHashMap<VariableInstance, ImportMSAccessVariableInstanceValuesConfig>();
        Database db = DatabaseBuilder.open((File)dbFile);
        Transaction trx = Transactions.begin();
        try {
            Table configTable = db.getTable("Config");
            for (Row row : configTable) {
                VariableInstance instanceCandidate;
                int instanceId = row.getInt("EOS_ID");
                String key = row.getString("Key");
                String varName = row.getString("Variable");
                String varRoles = row.getString("Variable Roles");
                String objectKey = row.getString("Object Key");
                String physicalUnitKey = row.getString("Physical Unit");
                String measuringUnitKey = row.getString("Measuring Unit");
                String[] roles = varRoles != null && !varRoles.isBlank() ? varRoles.substring(1, varRoles.length() - 1).split(",") : new String[]{};
                VariableInstance instance = null;
                if (roles.length > 0 && objectKey != null && !objectKey.isBlank()) {
                    String[] stringArray = roles;
                    int n = roles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String roleId = stringArray[n2];
                        try {
                            VariableInstance instanceCandidate2 = VariableRoleDAO.getVariableInstance((Transaction)trx, (String)roleId, (String)objectKey);
                            Variable variable = VariableDAO.get((Transaction)trx, (int)instanceCandidate2.getVariable().getId());
                            instanceCandidate2.setVariable(variable);
                            if (variable.getPhysicalUnit().getKey().equals(physicalUnitKey)) {
                                instance = instanceCandidate2;
                                break;
                            }
                        }
                        catch (IllegalConfigException illegalConfigException) {}
                        ++n2;
                    }
                }
                if (instance == null && (instanceCandidate = VariableInstanceDAO.get((Transaction)trx, (int)instanceId)) != null) {
                    Variable variable = VariableDAO.get((Transaction)trx, (int)instanceCandidate.getVariable().getId());
                    instanceCandidate.setVariable(variable);
                    if (variable.getPhysicalUnit().getKey().equals(physicalUnitKey) && varName.equals(variable.toString())) {
                        instance = instanceCandidate;
                    }
                }
                if (instance == null) continue;
                instance.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)instance.getStructureObject().getId()));
                String muKey = MeasuringUnit.createId((String)physicalUnitKey, (String)measuringUnitKey);
                result.put(instance, new ImportMSAccessVariableInstanceValuesConfig(key, MeasuringUnit.getMeasuringUnit((String)muKey)));
            }
        }
        finally {
            Transactions.close((Transaction)trx);
            db.close();
        }
        return result;
    }

    public static class ImportMSAccessVariableInstanceValuesConfig {
        public final String key;
        public final MeasuringUnit measuringUnit;

        public ImportMSAccessVariableInstanceValuesConfig(String key, MeasuringUnit measuringUnit) {
            this.key = key;
            this.measuringUnit = measuringUnit;
        }
    }
}

