/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.menu.part;

import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.IndexBuilder;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TableBuilder;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.gui.Messages;
import de.elpro.ewms.gui.utils.ExportUtils;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.MultChoicesPropertyItem;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.fx.core.ThreadSynchronize;

public class ExportMSAccessDBDialog
extends Dialog<ButtonType> {
    private static final String EXPORT_ALIAS = "ms_access";
    private ObjectProperty<Database.FileFormat> dbFormatProperty = new SimpleObjectProperty((Object)Database.FileFormat.V2019);
    private ObservableList<StructureClass> classes = FXCollections.observableArrayList();
    private ObservableList<Variable> variables = FXCollections.observableArrayList();
    private Collection<VariableInstanceType> instanceTypes = new ArrayList<VariableInstanceType>();
    private Collection<SupplementValueStrategy> supplementStategyTypes = new ArrayList<SupplementValueStrategy>();
    private BooleanProperty filterByRolesVariables = new SimpleBooleanProperty(false);
    private BooleanProperty exportValues = new SimpleBooleanProperty(false);
    private ObjectProperty<ComplexRaster> virtualRasterProperty = new SimpleObjectProperty();
    private List<StructureClass> allClasses;
    private List<Variable> allVariables;

    public ExportMSAccessDBDialog(Stage stage, ThreadSynchronize sync, ITimeRangeFilter timeRangeFilter) {
        this.initOwner(stage.getScene().getWindow());
        this.setResizable(true);
        this.getDialogPane().setPrefWidth(500.0);
        this.getDialogPane().setPrefHeight(400.0);
        Transaction trx2 = Transactions.begin();
        try {
            this.allClasses = Arrays.asList(StructureClassDAO.getAll((Transaction)trx2));
            this.allVariables = Arrays.asList(VariableDAO.getAll((Transaction)trx2));
        }
        finally {
            Transactions.close((Transaction)trx2);
        }
        EnumPropertyItem dbFormatItem = new EnumPropertyItem(Messages.menu_dialog_ExportMSAccessDBDialog_DbFormat, Database.FileFormat.class, this.dbFormatProperty);
        dbFormatItem.setNullable(false);
        MultChoicesPropertyItem classesItem = new MultChoicesPropertyItem(Messages.menu_dialog_ExportMSAccessDBDialog_Classes, this.classes, this.allClasses);
        MultChoicesPropertyItem variablesItem = new MultChoicesPropertyItem(Messages.menu_dialog_ExportMSAccessDBDialog_Variables, this.variables, this.allVariables);
        MultChoicesPropertyItem instanceTypesItem = new MultChoicesPropertyItem(Messages.menu_dialog_ExportMSAccessDBDialog_InstanceTypes, this.instanceTypes, Arrays.asList(VariableInstanceType.values()));
        MultChoicesPropertyItem ssTypesItem = new MultChoicesPropertyItem(Messages.menu_dialog_ExportMSAccessDBDialog_SupplementTypes, this.supplementStategyTypes, Arrays.asList(SupplementValueStrategy.values()));
        BooleanPropertyItem filterByRolesVariablesItem = new BooleanPropertyItem("With Roles", (ReadOnlyProperty)this.filterByRolesVariables);
        BooleanPropertyItem exportValuesItem = new BooleanPropertyItem(Messages.menu_dialog_ExportMSAccessDBDialog_ExportValues, (ReadOnlyProperty)this.exportValues);
        Raster minRaster = ServerDAO.getRawValuesViewRaster((RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex());
        ChoicePropertyItem rasterItem = new ChoicePropertyItem(Messages.menu_dialog_ExportMSAccessDBDialog_Raster, this.virtualRasterProperty, Arrays.stream(ComplexRaster.values()).filter(c -> c.ordinal() >= minRaster.ordinal()).toList());
        rasterItem.readOnlyProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.exportValues));
        this.classes.addListener(il -> {
            if (this.classes.isEmpty()) {
                variablesItem.setChoises(this.allVariables);
            } else {
                Transaction trx = Transactions.begin();
                try {
                    variablesItem.setChoises(this.getFilteredVariables(trx));
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        });
        PropertySheet sheet = new PropertySheet();
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{dbFormatItem, classesItem, variablesItem, instanceTypesItem, ssTypesItem, filterByRolesVariablesItem, exportValuesItem, rasterItem});
        BorderPane pane = new BorderPane((Node)sheet);
        this.getDialogPane().setContent((Node)pane);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setOnCloseRequest(event -> {});
        this.setResultConverter(type -> {
            if (type != ButtonType.OK) {
                return type;
            }
            sheet.setDisable(true);
            this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().unbind();
            this.getDialogPane().lookupButton(ButtonType.OK).setDisable(true);
            this.getDialogPane().lookupButton(ButtonType.CANCEL).setDisable(true);
            ProgressBar progressBar = new ProgressBar(0.0);
            progressBar.setPadding(new Insets(3.0));
            progressBar.setMaxWidth(Double.MAX_VALUE);
            Label progressLabel = new Label();
            progressLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
            VBox box = new VBox(3.0, new Node[]{progressBar, progressLabel});
            VBox.setVgrow((Node)progressBar, (Priority)Priority.ALWAYS);
            pane.setBottom((Node)box);
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter xlsxExtFilter = new FileChooser.ExtensionFilter("MS Access", new String[]{"*.accdb", "*.mdb"});
            fileChooser.getExtensionFilters().add((Object)xlsxExtFilter);
            fileChooser.setInitialDirectory(ExportUtils.getDefaultExportFolder(EXPORT_ALIAS));
            fileChooser.setInitialFileName("Values.accdb");
            File file = fileChooser.showSaveDialog((Window)stage);
            if (file == null) {
                return null;
            }
            if (file.exists()) {
                file.delete();
            }
            if (ExportUtils.STORE_EXPORT_FOLDER) {
                ExportUtils.setDefaultExportFolderPath(EXPORT_ALIAS, file.getParentFile().getPath());
            }
            ThreadSynchronize.BlockCondition condition = new ThreadSynchronize.BlockCondition();
            new Thread(() -> this.doExport(sync, file, (Database.FileFormat)dbFormatItem.getValue(), timeRangeFilter, minRaster, progressBar, (ThreadSynchronize.BlockCondition<ButtonType>)condition)).start();
            return (ButtonType)sync.block(condition);
        });
    }

    private void doExport(ThreadSynchronize sync, File file, Database.FileFormat dbFormat, ITimeRangeFilter timeRangeFilter, Raster minRaster, ProgressBar progressBar, ThreadSynchronize.BlockCondition<ButtonType> blockCondition) {
        block37: {
            progressBar.setProgress(0.0);
            Database db = null;
            Transaction trx = Transactions.begin();
            Collection<Object> variables = new TreeSet<Variable>();
            HashSet<StructureClass> availableClasses = new HashSet<StructureClass>();
            TreeMap<String, VariableInstance> instances = new TreeMap<String, VariableInstance>();
            try {
                if (this.variables.isEmpty()) {
                    if (this.classes.isEmpty()) {
                        variables.addAll(this.allVariables);
                    } else {
                        variables.addAll(this.getFilteredVariables(trx));
                    }
                } else {
                    variables.addAll((Collection<Variable>)this.variables);
                }
                if (!this.classes.isEmpty()) {
                    for (StructureClass clazz : this.classes) {
                        availableClasses.addAll(Arrays.asList(StructureClassDAO.getAllExtendClasses((Transaction)trx, (int)clazz.getId())));
                    }
                }
                if (this.filterByRolesVariables.get()) {
                    variables = variables.stream().filter(v -> !v.getRoleIds().isEmpty()).collect(Collectors.toList());
                }
                HashMap<Integer, StructureObject> objects = new HashMap<Integer, StructureObject>();
                for (Variable var : variables) {
                    String varName = var.toString();
                    VariableInstance[] variableInstanceArray = VariableInstanceDAO.getAll((Transaction)trx, (Variable)var);
                    int n = variableInstanceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VariableInstance instance = variableInstanceArray[n2];
                        StructureObject object = (StructureObject)objects.get(instance.getStructureObject().getId());
                        if (object == null) {
                            object = StructureObjectDAO.get((Transaction)trx, (int)instance.getStructureObject().getId());
                            objects.put(object.getId(), object);
                        }
                        if (availableClasses.isEmpty() || availableClasses.contains(object.getStructureClass())) {
                            instance.setVariable(var);
                            instance.setStructureObject(object);
                            String key = String.format("%s__%s", varName, object.getKey() != null ? object.getKey() : String.format("object_id_%d", object.getId())).replace('.', '_');
                            boolean instanceFilter = this.instanceTypes.isEmpty() || this.instanceTypes.contains(instance.getType());
                            if (instanceFilter &= this.supplementStategyTypes.isEmpty() || this.supplementStategyTypes.contains(instance.getSupplementValueStrategy())) {
                                instances.put(key, instance);
                            }
                        }
                        ++n2;
                    }
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            progressBar.setProgress(0.1);
            AbstractList rows = new LinkedList<Object[]>();
            try {
                try {
                    db = DatabaseBuilder.create((Database.FileFormat)dbFormat, (File)file);
                    Table varsTable = new TableBuilder("Config").addColumn(new ColumnBuilder("EOS_ID", DataType.LONG)).addColumn(new ColumnBuilder("Key", DataType.TEXT)).addColumn(new ColumnBuilder("Variable", DataType.TEXT)).addColumn(new ColumnBuilder("Variable Roles", DataType.TEXT)).addColumn(new ColumnBuilder("Object", DataType.TEXT)).addColumn(new ColumnBuilder("Object Key", DataType.TEXT)).addColumn(new ColumnBuilder("Physical Unit", DataType.TEXT)).addColumn(new ColumnBuilder("Measuring Unit", DataType.TEXT)).addColumn(new ColumnBuilder("Description", DataType.TEXT)).addColumn(new ColumnBuilder("Var Type", DataType.TEXT)).addColumn(new ColumnBuilder("Suppl Type", DataType.TEXT)).addIndex(new IndexBuilder("PrimaryKey").addColumns(new String[]{"EOS_ID"}).setPrimaryKey()).addIndex(new IndexBuilder("KeyIndex").addColumns(new String[]{"Key"})).toTable(db);
                    for (Map.Entry entry : instances.entrySet()) {
                        String key = (String)entry.getKey();
                        VariableInstance instance = (VariableInstance)entry.getValue();
                        Variable var = instance.getVariable();
                        String varName = var.toString();
                        String varRoles = var.getRoleIds().isEmpty() ? null : Arrays.toString(var.getRoleIds().toArray());
                        StructureObject object = instance.getStructureObject();
                        String objectKey = object.getKey();
                        rows.add(new Object[]{instance.getId(), key, varName, varRoles, object.getLocalName(), objectKey, var.getPhysicalUnit().getKey(), var.getMeasuringUnit().getKey(), instance.getResultDescription(), instance.getType().name(), instance.getSupplementValueStrategy() != null ? instance.getSupplementValueStrategy().name() : null});
                    }
                    varsTable.addRows(rows);
                    progressBar.setProgress(0.2);
                    int index = 0;
                    if (this.exportValues.get()) {
                        for (Map.Entry entry : instances.entrySet()) {
                            String key = (String)entry.getKey();
                            VariableInstance instance = (VariableInstance)entry.getValue();
                            Table instanceValsTable = new TableBuilder("Variable_" + key).addColumn(new ColumnBuilder("From (UTC)", DataType.SHORT_DATE_TIME)).addColumn(new ColumnBuilder("To (UTC)", DataType.SHORT_DATE_TIME)).addColumn(new ColumnBuilder("Value", DataType.DOUBLE)).addColumn(new ColumnBuilder("Quality", DataType.DOUBLE)).addIndex(new IndexBuilder("ToIndex").addColumns(new String[]{"To (UTC)"})).addIndex(new IndexBuilder("FromIndex").addColumns(new String[]{"From (UTC)"})).toTable(db);
                            rows = new ArrayList(10000);
                            ComplexRaster complexRaster = this.virtualRasterProperty.get() != null ? (ComplexRaster)this.virtualRasterProperty.get() : ComplexRaster.of((Raster)minRaster);
                            Instant from = null;
                            Instant to = null;
                            if (timeRangeFilter.getType().toRawValueViewType() == RawValuesViewType.GlobalView) {
                                from = timeRangeFilter.getFrom();
                                to = timeRangeFilter.getTo();
                            }
                            int counter = 0;
                            for (IVarValue vv : VariableInstanceDAO.getVarValues((RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex(), (int)instance.getId(), (Instant)from, (Instant)to, (ComplexRaster)complexRaster)) {
                                long toTs = vv.getEndTimestamp();
                                long fromTs = vv instanceof IStoredVarValue ? ((IStoredVarValue)vv).getStartTimestamp() : complexRaster.getRasterBegin(Instant.ofEpochMilli(toTs)).toEpochMilli();
                                if (Double.isFinite(vv.getValue())) {
                                    LocalDateTime fromUTC = LocalDateTime.ofInstant(Instant.ofEpochMilli(fromTs), ZoneOffset.UTC);
                                    LocalDateTime toUTC = LocalDateTime.ofInstant(Instant.ofEpochMilli(toTs), ZoneOffset.UTC);
                                    rows.add(new Object[]{fromUTC, toUTC, vv.getValue(), vv.getQuality()});
                                    ++counter;
                                }
                                if (counter != 10000) continue;
                                instanceValsTable.addRows(rows);
                                rows.clear();
                                counter = 0;
                                db.flush();
                            }
                            try {
                                if (counter > 0) {
                                    instanceValsTable.addRows(rows);
                                }
                            }
                            catch (Exception exc) {
                                exc.printStackTrace();
                            }
                            progressBar.setProgress(0.2 + 0.8 * (double)(++index) / (double)instances.size());
                        }
                    }
                    new TableBuilder("Import Supplement Values").addColumn(new ColumnBuilder("Instance Key", DataType.TEXT)).addColumn(new ColumnBuilder("From (UTC)", DataType.SHORT_DATE_TIME)).addColumn(new ColumnBuilder("To (UTC)", DataType.SHORT_DATE_TIME)).addColumn(new ColumnBuilder("Value", DataType.DOUBLE)).addIndex(new IndexBuilder("Index").addColumns(new String[]{"Instance Key", "From (UTC)", "To (UTC)"})).toTable(db);
                    progressBar.setProgress(1.0);
                    sync.asyncExec(() -> blockCondition.release((Object)ButtonType.OK));
                }
                catch (Exception exc) {
                    sync.asyncExec(() -> {
                        ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                        dlg.showAndWait();
                        blockCondition.release(null);
                    });
                    if (db == null) break block37;
                    try {
                        db.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (db != null) {
                    try {
                        db.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private Collection<Variable> getFilteredVariables(Transaction trx) {
        TreeSet<Variable> variables = new TreeSet<Variable>();
        for (StructureClass clazz : this.classes) {
            variables.addAll(Arrays.asList(VariableDAO.get((Transaction)trx, (int[])clazz.getVariables().stream().mapToInt(v -> v.getId()).toArray())));
        }
        return variables;
    }
}

