/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.menu.part;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import de.elpro.ewms.core.client.measurements.MeasurementsDAO;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMap;
import de.elpro.ewms.gui.menu.handler.ImportMSAccessVariableValuesHandler;
import de.elpro.ui.fx.utils.FXUtils;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.control.CheckTreeView;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.fx.core.ThreadSynchronize;

public class ImportMSAccessVariableValuesDialog
extends Dialog<ButtonType> {
    public ImportMSAccessVariableValuesDialog(Scene scene, ThreadSynchronize sync, File dbFile, Map<VariableInstance, ImportMSAccessVariableValuesHandler.ImportMSAccessVariableInstanceValuesConfig> exportCandidates) {
        this.initOwner(scene.getWindow());
        this.setResizable(true);
        this.setTitle("MSAccess Values Import");
        this.setHeaderText("Select Variable Instances to import Values from MS Access Database.\r\nOnly PLC Instances with matching Physical Units can be Imported.");
        this.getDialogPane().setPrefWidth(600.0);
        this.getDialogPane().setPrefHeight(500.0);
        CheckBoxTreeItem rootItem = new CheckBoxTreeItem();
        TreeMap<Variable, CheckBoxTreeItem> variableItems = new TreeMap<Variable, CheckBoxTreeItem>();
        HashMap<VariableInstance, CheckBoxTreeItem> instanceItems = new HashMap<VariableInstance, CheckBoxTreeItem>();
        for (Map.Entry<VariableInstance, ImportMSAccessVariableValuesHandler.ImportMSAccessVariableInstanceValuesConfig> entry : exportCandidates.entrySet()) {
            VariableInstance instance = entry.getKey();
            Variable variable = instance.getVariable();
            CheckBoxTreeItem variableItem = (CheckBoxTreeItem)variableItems.get(variable);
            if (variableItem == null) {
                variableItem = new CheckBoxTreeItem((Object)variable, variable.getGraphic());
                variableItems.put(variable, variableItem);
                rootItem.getChildren().add((Object)variableItem);
            }
            CheckBoxTreeItem instanceItem = new CheckBoxTreeItem((Object)instance, instance.getGraphic());
            instanceItems.put(instance, instanceItem);
            variableItem.getChildren().add((Object)instanceItem);
        }
        FXUtils.sortTreeItemsTree((TreeItem)rootItem);
        CheckTreeView treeView = new CheckTreeView(rootItem);
        treeView.setShowRoot(false);
        CheckBox ignoreValuesQualityCB = new CheckBox("ignore values qualities");
        ignoreValuesQualityCB.setPadding(new Insets(10.0));
        BorderPane pane = new BorderPane((Node)treeView, (Node)ignoreValuesQualityCB, null, null, null);
        this.getDialogPane().setContent((Node)pane);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setOnCloseRequest(event -> {});
        this.setResultConverter(type -> {
            if (type != ButtonType.OK) {
                return type;
            }
            treeView.setDisable(true);
            this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().unbind();
            this.getDialogPane().lookupButton(ButtonType.OK).setDisable(true);
            this.getDialogPane().lookupButton(ButtonType.CANCEL).setDisable(true);
            ProgressBar progressBar = new ProgressBar(0.0);
            progressBar.setPadding(new Insets(3.0));
            progressBar.setMaxWidth(Double.MAX_VALUE);
            Label progressLabel = new Label();
            progressLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
            VBox box = new VBox(3.0, new Node[]{progressBar, progressLabel});
            VBox.setVgrow((Node)progressBar, (Priority)Priority.ALWAYS);
            pane.setBottom((Node)box);
            ThreadSynchronize.BlockCondition condition = new ThreadSynchronize.BlockCondition();
            ArrayList<VariableInstance> selectedInstances = new ArrayList<VariableInstance>();
            for (Map.Entry entry : instanceItems.entrySet()) {
                if (!((CheckBoxTreeItem)entry.getValue()).isSelected()) continue;
                selectedInstances.add((VariableInstance)entry.getKey());
            }
            new Thread(() -> this.doImport(dbFile, selectedInstances, exportCandidates, ignoreValuesQualityCB.isSelected(), sync, progressBar, (ThreadSynchronize.BlockCondition<ButtonType>)condition)).start();
            return (ButtonType)sync.block(condition);
        });
    }

    private void doImport(File dbFile, List<VariableInstance> selectedInstances, Map<VariableInstance, ImportMSAccessVariableValuesHandler.ImportMSAccessVariableInstanceValuesConfig> instanceConfigs, boolean ignoreValuesQuality, ThreadSynchronize sync, ProgressBar progressBar, ThreadSynchronize.BlockCondition<ButtonType> blockCondition) {
        block29: {
            progressBar.setProgress(0.0);
            Database db = null;
            try {
                try {
                    db = DatabaseBuilder.open((File)dbFile);
                    int i = 0;
                    VarInstanceValuesCollectionMap importValues = new VarInstanceValuesCollectionMap();
                    for (VariableInstance instance : selectedInstances) {
                        try {
                            Table table;
                            if (instance.getType() != VariableInstanceType.PLC) continue;
                            ImportMSAccessVariableValuesHandler.ImportMSAccessVariableInstanceValuesConfig srcConfig = instanceConfigs.get(instance);
                            String key = srcConfig.key;
                            MeasuringUnit srcMU = srcConfig.measuringUnit;
                            MeasuringUnit dstMU = instance.getVariable().getMeasuringUnit();
                            if (!srcMU.getPhysicalUnit().equals((Object)dstMU.getPhysicalUnit()) || (table = db.getTable("Variable_" + key)) == null) continue;
                            Throwable throwable = null;
                            Object var19_21 = null;
                            try (IVarValuesCollection instanceValues = new IVarValuesCollection();){
                                for (Row row : table) {
                                    this.readTableRow(instanceValues, row, srcMU, dstMU, ignoreValuesQuality);
                                }
                                importValues.put(instance, instanceValues);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            progressBar.setProgress((double)(++i) / (double)selectedInstances.size() * 0.7);
                        }
                    }
                    progressBar.setProgress(0.7);
                    MeasurementsDAO.importMeasuredValues((VarInstanceValuesCollectionMap)importValues);
                    progressBar.setProgress(1.0);
                    sync.asyncExec(() -> blockCondition.release((Object)ButtonType.OK));
                }
                catch (Exception exc) {
                    sync.asyncExec(() -> {
                        ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                        dlg.showAndWait();
                        blockCondition.release(null);
                    });
                    if (db == null) break block29;
                    try {
                        db.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (db != null) {
                    try {
                        db.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void readTableRow(IVarValuesCollection instanceValues, Row row, MeasuringUnit srcMU, MeasuringUnit dstMU, boolean ignoreValuesQuality) throws Exception {
        Double quality;
        LocalDateTime from = row.getLocalDateTime("From (UTC)");
        LocalDateTime to = row.getLocalDateTime("To (UTC)");
        if (from == null || to == null) {
            throw new Exception(String.format("From and To fields cannot be null. Row (%s)", row.toString()));
        }
        if (!to.isAfter(from)) {
            throw new Exception(String.format("To must be after From. Row (%s)", row.toString()));
        }
        long fromTs = from.atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
        long toTs = to.atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
        Double value = row.getDouble("Value");
        if (value == null || !Double.isFinite(value)) {
            value = Double.NaN;
        }
        if ((quality = row.getDouble("Quality")) == null || !Double.isFinite(quality)) {
            quality = -1.0;
        }
        if (Double.isFinite(value) && quality >= 0.0) {
            value = dstMU.convert(value.doubleValue(), srcMU);
            MeasuredValue mv = new MeasuredValue(fromTs, toTs, value.doubleValue(), ignoreValuesQuality ? 1.0 : quality);
            instanceValues.add((IVarValue)mv);
        }
    }
}

