/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.partdescriptors;

import de.elpro.ewms.core.dataview.ViewNode;
import de.elpro.ewms.core.dataview.ViewType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ui.model.UIModelElement;
import javafx.scene.Node;
import javafx.scene.image.ImageView;

public class ViewNodeInstance
implements UIModelElement {
    private final String name;
    private final ViewNode node;
    private final StructureObject dataObject;
    private final ITimeRangeFilter timeRangeFilter;
    private final VirtualRaster virtualRaster;

    public ViewNodeInstance(ViewNode node, StructureObject dataObject) {
        this(null, node, dataObject, null, null);
    }

    public ViewNodeInstance(ViewNode node, StructureObject dataObject, ITimeRangeFilter timeRangeFilter, VirtualRaster virtualRaster) {
        this(null, node, dataObject, timeRangeFilter, virtualRaster);
    }

    public ViewNodeInstance(String name, ViewNode node, StructureObject dataObject, ITimeRangeFilter timeRangeFilter, VirtualRaster virtualRaster) {
        this.name = name;
        this.node = node;
        this.dataObject = dataObject;
        this.timeRangeFilter = timeRangeFilter;
        this.virtualRaster = virtualRaster;
    }

    public ViewNode getViewNode() {
        return this.node;
    }

    public StructureObject getDataObject() {
        return this.dataObject;
    }

    public ITimeRangeFilter getTimeRangeFilter() {
        return this.timeRangeFilter;
    }

    public VirtualRaster getVirtualRaster() {
        return this.virtualRaster;
    }

    public Node getGraphic() {
        if (this.name != null && this.node.getViewType() != ViewType.Empty && this.timeRangeFilter != null) {
            return new ImageView(ViewNode.AUTO_TIME_RANGE_ICON.toString());
        }
        if (this.node.getCustomIconKey() != null && !this.node.getCustomIconKey().isEmpty()) {
            return this.node.getTreeItemGraphic();
        }
        if (this.node.getDataClass() != null || this.node.getDataObject() != null) {
            return this.dataObject.getGraphic();
        }
        if (this.node.getViewType() == ViewType.SplitContainer || this.node.getViewType() == ViewType.TabContainer) {
            return new ImageView(ViewNode.COMPLEX_VIEW_WITH_CONTENT_ICON.toString());
        }
        return this.node.getTreeItemGraphic();
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        if (this.node.getLocalCustomName() != null && !this.node.getLocalCustomName().isEmpty()) {
            return this.node.getLocalCustomName();
        }
        if (this.node.getDataClass() != null || this.node.getDataObject() != null) {
            return this.dataObject.toString();
        }
        return this.node.toString();
    }

    public int hashCode() {
        int code = ViewNodeInstance.class.hashCode();
        if (this.name != null) {
            code += this.name.hashCode();
        }
        if (this.node != null && this.node.getId() != null) {
            code += this.node.hashCode() * 7;
        }
        if (this.dataObject != null) {
            code += this.dataObject.hashCode() * 7 * 7;
        }
        if (this.timeRangeFilter != null) {
            code += (this.timeRangeFilter.getFrom().hashCode() + this.timeRangeFilter.getTo().hashCode()) * 7 * 7 * 7;
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ViewNodeInstance)) {
            return false;
        }
        ViewNodeInstance o = (ViewNodeInstance)obj;
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (this.node.getId() != null && !this.node.equals((Object)o.node)) {
            return false;
        }
        if (this.dataObject == null || o.dataObject == null ? this.dataObject != o.dataObject : this.dataObject.getId() != null && !this.dataObject.equals((Object)o.dataObject)) {
            return false;
        }
        if (this.timeRangeFilter != null || o.timeRangeFilter != null) {
            if (this.timeRangeFilter == null || o.timeRangeFilter == null) {
                return false;
            }
            if (!this.timeRangeFilter.getFrom().equals(o.timeRangeFilter.getFrom())) {
                return false;
            }
            if (!this.timeRangeFilter.getTo().equals(o.timeRangeFilter.getTo())) {
                return false;
            }
        }
        return true;
    }
}

