/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.partdescriptors;

import com.gluonhq.richtextarea.RichTextArea;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.Chart3DDAO;
import de.elpro.ewms.core.client.charts.ChartDAO;
import de.elpro.ewms.core.client.charts.SankeyChartDAO;
import de.elpro.ewms.core.client.dataview.ViewNodeDAO;
import de.elpro.ewms.core.client.graphs.GraphDefinitionDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.client.tables.viewprefs.TableViewPrefsDAO;
import de.elpro.ewms.core.dataview.ViewNode;
import de.elpro.ewms.core.dataview.ViewNodeDocumentPlacementPolicy;
import de.elpro.ewms.core.dataview.ViewType;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.fx.charts.Chart2DView;
import de.elpro.ewms.core.fx.charts.Chart3DView;
import de.elpro.ewms.core.fx.charts.SankeyChartView;
import de.elpro.ewms.core.fx.graph.GraphChartView;
import de.elpro.ewms.core.fx.model.IDataSelection;
import de.elpro.ewms.core.fx.model.IExportable;
import de.elpro.ewms.core.fx.model.UIObjectState;
import de.elpro.ewms.core.fx.notes.Notes;
import de.elpro.ewms.core.fx.properties.ObjectPropertiesView;
import de.elpro.ewms.core.fx.tables.ChartValuesTable;
import de.elpro.ewms.core.fx.tables.SaveSupplementValueChangesDialog;
import de.elpro.ewms.core.fx.tables.VarTableView;
import de.elpro.ewms.core.graph.GraphChart;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.tables.viewprefs.TableViewPrefs;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.SupplementValueChange;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.gui.Messages;
import de.elpro.ewms.gui.di.PersistedIdObject;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.fx.e4.PersistenceJob;
import de.elpro.ui.fx.e4.PersistenceWorker;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.ColumnsPersistedState;
import de.elpro.ui.fx.utils.FXUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.core.Memento;
import org.eclipse.fx.core.di.ContextScope;
import org.eclipse.fx.core.di.ContextValue;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.panes.SashPane;

public class ViewNodeInstancePart {
    public static final String ID = "de.elpro.ewms.gui.partdescriptor.viewnodeinstance";
    @Log
    @Inject
    private Logger logger;
    @Inject
    @PersistedIdObject
    private ViewNode viewNode;
    @Inject
    @PersistedIdObject
    private StructureObject object;
    @Optional
    @Inject
    private VirtualRaster fixedRaster;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    @Inject
    private Scene scene;
    @Inject
    @ContextValue(value="exportable-items", scope=ContextScope.LOCAL)
    private Property<List<IExportable>> exportItems;
    @Inject
    private IEclipseContext context;
    private ITimeRangeFilter timeRangeFilter;
    private final List<Chart2DView> charts2DCache = new LinkedList<Chart2DView>();
    private final List<Chart3DView> charts3DCache = new LinkedList<Chart3DView>();
    private final List<SankeyChartView> sankeyCache = new LinkedList<SankeyChartView>();
    private final List<VarTableView> varTablesCache = new LinkedList<VarTableView>();
    private final List<ObjectPropertiesView> propertieViewsCache = new LinkedList<ObjectPropertiesView>();
    private final List<GraphChartView> graphCache = new LinkedList<GraphChartView>();
    private final List<Notes> notesCache = new LinkedList<Notes>();
    private final Map<Chart2DView, ChartValuesTable> chart2DValuesTableCache = new HashMap<Chart2DView, ChartValuesTable>();
    private final Map<Chart3DView, ChartValuesTable> chart3DValuesTableCache = new HashMap<Chart3DView, ChartValuesTable>();
    private final Map<ChartValuesTable, ProgressIndicatorPane> flatTablesNodeCache = new HashMap<ChartValuesTable, ProgressIndicatorPane>();
    private final SimpleObjectProperty<IDataSelection> dataSelection = new SimpleObjectProperty();
    private ObservableBooleanValue hasChanges = new SimpleBooleanProperty();
    private ProgressIndicatorPane persistProgressIndicatorPane;
    private PersistenceWorker persistenceWorker;
    private Pane parent = null;
    private volatile boolean updatingSelection = false;
    private final ChangeListener<Boolean> hasChangesListener = (o, ov, nv) -> Platform.runLater(() -> this.part.setDirty(nv.booleanValue()));

    @PostConstruct
    public void postConstruct(BorderPane parent) throws IllegalConfigException {
        this.parent = parent;
        if (this.part.getLabel() == null) {
            this.part.setLabel("loading ...");
        }
        new Thread(() -> Platform.runLater(() -> {
            Transaction trx = Transactions.begin();
            try {
                this.viewNode = ViewNodeDAO.get((Transaction)trx, (int)this.viewNode.getId());
                if (this.viewNode == null || this.object == null) {
                    this.partService.hidePart(this.part, true);
                    return;
                }
                try {
                    this.viewNode.refreshReferenceObject();
                    this.object = StructureObjectDAO.get((Transaction)trx, (int)this.object.getId());
                    String lbl = this.object.toString();
                    String localCustomName = this.viewNode.getLocalCustomName();
                    if (localCustomName != null && !localCustomName.isEmpty()) {
                        lbl = localCustomName.replaceAll("\\{object\\}", this.object.toString());
                    }
                    if (this.fixedRaster != null) {
                        VirtualRaster raster = this.fixedRaster;
                        raster = raster == VirtualRaster.Month ? VirtualRaster.Year : (raster == VirtualRaster.Day ? VirtualRaster.Month : VirtualRaster.Day);
                        String rangeLbl = raster.getLabel(this.timeRangeFilter.getFrom());
                        lbl = String.format("%s (%s)", lbl, rangeLbl);
                    }
                    this.part.setLabel(lbl);
                    LinkedList<IExportable> exportables = new LinkedList<IExportable>();
                    this.persistProgressIndicatorPane = new ProgressIndicatorPane(this.createFX(trx, this.viewNode, this.object, this.scene, exportables));
                    this.persistenceWorker = new PersistenceWorker(this.persistProgressIndicatorPane);
                    parent.setCenter((Node)this.persistProgressIndicatorPane);
                    this.exportItems.setValue(exportables);
                    this.hasChanges.addListener(this.hasChangesListener);
                    this.dataSelection.addListener((o, ov, nv) -> {
                        if (nv == null || this.updatingSelection) {
                            return;
                        }
                        LinkedList<Object> dataCompositions = new LinkedList<Object>();
                        dataCompositions.addAll(this.charts2DCache);
                        dataCompositions.addAll(this.varTablesCache);
                        dataCompositions.addAll(this.chart2DValuesTableCache.values());
                        dataCompositions.addAll(this.chart3DValuesTableCache.values());
                        dataCompositions.addAll(this.charts3DCache);
                        this.updatingSelection = true;
                        dataCompositions.forEach(dc -> dc.selectData(nv.getEndTimestamp(), nv.getObject()));
                        this.updatingSelection = false;
                    });
                }
                catch (InjectionException exc) {
                    this.logger.error("Injection Exception", (Throwable)exc);
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        })).start();
    }

    protected Node createFX(Transaction trx, ViewNode viewNode, StructureObject structureObject, Scene scene, List<IExportable> exportablesNodes) {
        viewNode.refreshReferenceObject();
        SankeyChartView node = null;
        if (viewNode.getDataClass() != null) {
            Object[] candidates;
            if (viewNode.getDataObject() != null) {
                if (!structureObject.equals((Object)viewNode.getDataObject())) {
                    structureObject = StructureObjectDAO.get((Transaction)trx, (int)viewNode.getDataObject().getId());
                }
            } else if (viewNode.getViewType() != ViewType.TabContainer && ((candidates = StructureObjectDAO.findObjects((Transaction)trx, (StructureObject)structureObject, (StructureClass)viewNode.getDataClass(), (SearchPolicy)SearchPolicy.ThisOrParent)).length <= 0 || Arrays.binarySearch(candidates, structureObject) < 0)) {
                if (candidates.length != 1) {
                    String errorMessage = String.format(Messages.partdescriptors_ViewNodeInstancePart_CannotFindEnclosingInstance, viewNode, structureObject);
                    this.logger.error(errorMessage);
                    return null;
                }
                structureObject = candidates[0];
            }
        }
        if (viewNode.getViewType() == ViewType.Chart2D && viewNode.getReferenceObject() instanceof Chart2D) {
            Chart2D chart2D = ChartDAO.loadNormalized((Transaction)trx, (int)viewNode.getReferenceObjectId());
            try {
                IEclipseContext chart2DContext = this.context.createChild();
                chart2DContext.set(Chart2D.class, (Object)chart2D);
                chart2DContext.set(StructureObject.class, structureObject);
                Chart2DView chart2DView = Chart2DView.create((Chart2D)chart2D, (IEclipseContext)chart2DContext);
                chart2DView.dataSelectionProperty().addListener((o, ov, nv) -> this.dataSelection.set(nv));
                this.hasChanges = Bindings.or((ObservableBooleanValue)this.hasChanges, (ObservableBooleanValue)chart2DView.hasChangesProperty());
                this.charts2DCache.add(chart2DView);
                exportablesNodes.add((IExportable)chart2DView);
                SashPane spliter = new SashPane();
                spliter.getItems().add((Object)chart2DView);
                spliter.setHorizontal(false);
                CheckMenuItem showTableValuesItem = new CheckMenuItem(Messages.partdescriptors_ViewNodeInstancePart_Values, (Node)new ImageView(ChartValuesTable.DEFAULT_ICON.toString()));
                showTableValuesItem.setOnAction(e -> {
                    if (showTableValuesItem.isSelected()) {
                        ProgressIndicatorPane flatTableNode;
                        ChartValuesTable flatTable = this.chart2DValuesTableCache.get(chart2DView);
                        if (flatTable == null) {
                            flatTable = new ChartValuesTable(chart2DView.toString());
                            flatTable.getColumns().addAll(chart2DView.getVarValuesColumns());
                            this.hasChanges.removeListener(this.hasChangesListener);
                            this.hasChanges = Bindings.or((ObservableBooleanValue)this.hasChanges, (ObservableBooleanValue)flatTable.hasChangesProperty());
                            this.hasChanges.addListener(this.hasChangesListener);
                            this.chart2DValuesTableCache.put(chart2DView, flatTable);
                            flatTableNode = new ProgressIndicatorPane((Node)flatTable);
                            this.flatTablesNodeCache.put(flatTable, flatTableNode);
                            ProgressIndicatorPane pip = flatTableNode;
                            ChartValuesTable fvvt = flatTable;
                            chart2DView.stateProperty().addListener((o, ov, nv) -> {
                                pip.showIndicator(nv == UIObjectState.Loading);
                                if (nv == UIObjectState.Ready) {
                                    fvvt.getColumns().setAll(chart2DView.getVarValuesColumns());
                                }
                            });
                            fvvt.dataSelectionProperty().addListener((o, ov, nv) -> this.dataSelection.set(nv));
                        } else {
                            flatTableNode = this.flatTablesNodeCache.get(flatTable);
                        }
                        List exportables = (List)this.exportItems.getValue();
                        exportables.add(flatTable);
                        this.exportItems.setValue(new LinkedList(exportables));
                        spliter.getItems().add((Object)flatTableNode);
                    } else {
                        Node varTable = null;
                        ChartValuesTable flatTable = null;
                        for (Node tableCandidate : spliter.getItems()) {
                            if (!(tableCandidate instanceof ProgressIndicatorPane) || !(((ProgressIndicatorPane)tableCandidate).getContent() instanceof ChartValuesTable)) continue;
                            flatTable = (ChartValuesTable)((ProgressIndicatorPane)tableCandidate).getContent();
                            varTable = tableCandidate;
                        }
                        if (varTable != null) {
                            spliter.getItems().remove(varTable);
                            List exportables = (List)this.exportItems.getValue();
                            exportables.remove(flatTable);
                            this.exportItems.setValue(new LinkedList(exportables));
                        }
                    }
                });
                chart2DView.setContextMenu(new ContextMenu(new MenuItem[]{showTableValuesItem}));
                node = spliter;
            }
            catch (Exception exc) {
                this.logger.error("Error Creating Chart View", (Throwable)exc);
            }
        } else if (viewNode.getViewType() == ViewType.Chart3D && viewNode.getReferenceObject() instanceof Chart3D) {
            Chart3D chart3D = Chart3DDAO.loadNormalized((Transaction)trx, (int)viewNode.getReferenceObjectId());
            IEclipseContext chart3DContext = this.context.createChild();
            chart3DContext.set(Chart3D.class, (Object)chart3D);
            chart3DContext.set(StructureObject.class, structureObject);
            Chart3DView chart3DView = Chart3DView.create((IEclipseContext)chart3DContext);
            chart3DView.dataSelectionProperty().addListener((o, ov, nv) -> this.dataSelection.set(nv));
            this.charts3DCache.add(chart3DView);
            this.hasChanges = Bindings.or((ObservableBooleanValue)this.hasChanges, (ObservableBooleanValue)chart3DView.hasChangesProperty());
            SashPane spliter = new SashPane();
            spliter.getItems().add((Object)chart3DView);
            spliter.setHorizontal(false);
            CheckMenuItem showTableValuesItem = new CheckMenuItem(Messages.partdescriptors_ViewNodeInstancePart_Values, (Node)new ImageView(ChartValuesTable.DEFAULT_ICON.toString()));
            showTableValuesItem.setOnAction(e -> {
                if (showTableValuesItem.isSelected()) {
                    ProgressIndicatorPane flatTableNode;
                    ChartValuesTable flatTable = this.chart3DValuesTableCache.get(chart3DView);
                    if (flatTable == null) {
                        flatTable = new ChartValuesTable(chart3DView.toString());
                        flatTable.getColumns().addAll(chart3DView.getVarValuesColumns());
                        this.hasChanges.removeListener(this.hasChangesListener);
                        this.hasChanges = Bindings.or((ObservableBooleanValue)this.hasChanges, (ObservableBooleanValue)flatTable.hasChangesProperty());
                        this.hasChanges.addListener(this.hasChangesListener);
                        this.chart3DValuesTableCache.put(chart3DView, flatTable);
                        flatTableNode = new ProgressIndicatorPane((Node)flatTable);
                        this.flatTablesNodeCache.put(flatTable, flatTableNode);
                        ProgressIndicatorPane pip = flatTableNode;
                        ChartValuesTable fvvt = flatTable;
                        chart3DView.stateProperty().addListener((o, ov, nv) -> {
                            pip.showIndicator(nv == UIObjectState.Loading);
                            if (nv == UIObjectState.Ready) {
                                fvvt.getColumns().setAll(chart3DView.getVarValuesColumns());
                            }
                        });
                        fvvt.dataSelectionProperty().addListener((o, ov, nv) -> this.dataSelection.set(nv));
                    } else {
                        flatTableNode = this.flatTablesNodeCache.get(flatTable);
                    }
                    List exportables = (List)this.exportItems.getValue();
                    exportables.add(flatTable);
                    this.exportItems.setValue(new LinkedList(exportables));
                    spliter.getItems().add((Object)flatTableNode);
                } else {
                    Node varTable = null;
                    ChartValuesTable flatTable = null;
                    for (Node tableCandidate : spliter.getItems()) {
                        if (!(tableCandidate instanceof ProgressIndicatorPane) || !(((ProgressIndicatorPane)tableCandidate).getContent() instanceof ChartValuesTable)) continue;
                        flatTable = (ChartValuesTable)((ProgressIndicatorPane)tableCandidate).getContent();
                        varTable = tableCandidate;
                    }
                    if (varTable != null) {
                        spliter.getItems().remove(varTable);
                        List exportables = (List)this.exportItems.getValue();
                        exportables.remove(flatTable);
                        this.exportItems.setValue(new LinkedList(exportables));
                    }
                }
            });
            chart3DView.setContextMenu(new ContextMenu(new MenuItem[]{showTableValuesItem}));
            node = spliter;
        } else if (viewNode.getViewType() == ViewType.SankeyChart && viewNode.getReferenceObject() instanceof SankeyChart) {
            SankeyChart chart = SankeyChartDAO.loadNormalized((Transaction)trx, (int)viewNode.getReferenceObjectId());
            SankeyChartView sankeyView = new SankeyChartView(chart, structureObject, this.timeRangeFilter);
            this.sankeyCache.add(sankeyView);
            node = sankeyView;
        } else if (viewNode.getViewType() == ViewType.Table && viewNode.getReferenceObject() instanceof Table) {
            Table table = TableDAO.loadNormalized((Transaction)trx, (int)viewNode.getReferenceObjectId());
            VarTableView vtv = new VarTableView(table, structureObject, scene.getWindow(), this.timeRangeFilter, this.fixedRaster);
            vtv.dataSelectionProperty().addListener((o, ov, nv) -> this.dataSelection.set(nv));
            this.hasChanges = Bindings.or((ObservableBooleanValue)this.hasChanges, (ObservableBooleanValue)vtv.hasChangesProperty());
            this.varTablesCache.add(vtv);
            exportablesNodes.add((IExportable)vtv);
            node = vtv;
        } else if (viewNode.getViewType() == ViewType.ObjectProperties) {
            ObjectPropertiesView opv = new ObjectPropertiesView(structureObject);
            this.hasChanges = Bindings.or((ObservableBooleanValue)this.hasChanges, (ObservableBooleanValue)opv.hasChangesProperty());
            this.propertieViewsCache.add(opv);
            node = opv;
        } else if (viewNode.getViewType() == ViewType.GraphChart) {
            GraphChart graphChart = GraphDefinitionDAO.get((Transaction)trx, (int)viewNode.getReferenceObjectId());
            GraphChartView gv = new GraphChartView(this.object, graphChart, this.timeRangeFilter);
            this.hasChanges = Bindings.or((ObservableBooleanValue)this.hasChanges, (ObservableBooleanValue)gv.hasChangesProperty());
            gv.setAdjustable(false);
            this.graphCache.add(gv);
            node = gv;
        } else if (viewNode.getViewType() == ViewType.Notes) {
            Notes notes = new Notes(structureObject, this.timeRangeFilter);
            this.hasChanges = Bindings.or((ObservableBooleanValue)this.hasChanges, (ObservableBooleanValue)notes.hasChangesProperty());
            this.notesCache.add(notes);
            node = notes;
        } else if (viewNode.getViewType() == ViewType.TabContainer) {
            TabPane tabPane = new TabPane();
            tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
            tabPane.setSide(Side.BOTTOM);
            ViewNode[] showTableValuesItem = ViewNodeDAO.getChildren((Transaction)trx, (ViewNode)viewNode);
            int spliter = showTableValuesItem.length;
            int chart3DView = 0;
            while (chart3DView < spliter) {
                ViewNode childViewNode = showTableValuesItem[chart3DView];
                if (!childViewNode.isTreeItem()) {
                    childViewNode.setParent(viewNode);
                    if (viewNode.getDataClass() == null) {
                        childNode = this.createFX(trx, childViewNode, (StructureObject)structureObject, scene, exportablesNodes);
                        if (childNode != null) {
                            text = childViewNode.getLocalCustomName();
                            if (text == null || text.isBlank()) {
                                text = childNode.toString();
                            }
                            tab = new Tab(text, childNode);
                            tabPane.getTabs().add((Object)tab);
                        }
                    } else if (viewNode.getDataObject() == null) {
                        StructureObject[] structureObjects;
                        SearchPolicy searchPolicy = viewNode.getDataObjectSearchPolicy() != null ? viewNode.getDataObjectSearchPolicy() : SearchPolicy.Auto;
                        StructureObject[] structureObjectArray = structureObjects = StructureObjectDAO.findObjects((Transaction)trx, (StructureObject)structureObject, (StructureClass)viewNode.getDataClass(), (SearchPolicy)searchPolicy);
                        int n = structureObjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            StructureObject object = structureObjectArray[n2];
                            Node childNode = this.createFX(trx, childViewNode, object, scene, exportablesNodes);
                            if (childNode != null) {
                                String text = childViewNode.getLocalCustomName();
                                if (text == null || text.isBlank()) {
                                    text = object.toString();
                                }
                                Tab tab = new Tab(text, childNode);
                                tabPane.getTabs().add((Object)tab);
                            }
                            ++n2;
                        }
                    } else {
                        structureObject = StructureObjectDAO.get((Transaction)trx, (int)viewNode.getDataObject().getId());
                        childNode = this.createFX(trx, childViewNode, (StructureObject)structureObject, scene, exportablesNodes);
                        if (childNode != null) {
                            text = childViewNode.getLocalCustomName();
                            if (text == null || text.isBlank()) {
                                text = structureObject.toString();
                            }
                            tab = new Tab(text, childNode);
                            tabPane.getTabs().add((Object)tab);
                        }
                    }
                }
                ++chart3DView;
            }
            node = tabPane;
        } else if (viewNode.getViewType() == ViewType.SplitContainer) {
            String[] sarr;
            LinkedList<Node> childNodes = new LinkedList<Node>();
            int[] splitData = null;
            ViewNode[] viewNodeArray = ViewNodeDAO.getChildren((Transaction)trx, (ViewNode)viewNode);
            int showTableValuesItem = viewNodeArray.length;
            int spliter = 0;
            while (spliter < showTableValuesItem) {
                ViewNode childViewNode = viewNodeArray[spliter];
                if (!childViewNode.isTreeItem()) {
                    childViewNode.setParent(viewNode);
                    Node childNode = this.createFX(trx, childViewNode, (StructureObject)structureObject, scene, exportablesNodes);
                    if (childNode != null) {
                        if (viewNode.isSplitContainerFixed()) {
                            if (viewNode.getSplitContainerOrientation() == Orientation.HORIZONTAL) {
                                GridPane.setHgrow((Node)childNode, (Priority)Priority.ALWAYS);
                            } else {
                                GridPane.setVgrow((Node)childNode, (Priority)Priority.ALWAYS);
                            }
                        }
                        childNodes.add(childNode);
                    }
                }
                ++spliter;
            }
            if (viewNode.getSplitContainerData() != null && (sarr = viewNode.getSplitContainerData().split("\\|")).length == childNodes.size()) {
                try {
                    splitData = new int[sarr.length];
                    int i = 0;
                    while (i < sarr.length) {
                        splitData[i] = Integer.parseInt(sarr[i]);
                        ++i;
                    }
                }
                catch (Exception exception) {
                    splitData = null;
                }
            }
            if (viewNode.isSplitContainerFixed()) {
                GridPane pane = new GridPane();
                if (viewNode.getSplitContainerOrientation() == Orientation.HORIZONTAL) {
                    pane.addRow(0, childNodes.toArray(new Node[0]));
                    RowConstraints rc = new RowConstraints();
                    rc.setMaxHeight(Double.POSITIVE_INFINITY);
                    rc.setVgrow(Priority.ALWAYS);
                    pane.getRowConstraints().add((Object)rc);
                    if (splitData != null) {
                        int[] nArray = splitData;
                        int n = splitData.length;
                        int n3 = 0;
                        while (n3 < n) {
                            double splitPercentage = nArray[n3];
                            ColumnConstraints cc = new ColumnConstraints();
                            cc.setPercentWidth(splitPercentage);
                            pane.getColumnConstraints().add((Object)cc);
                            ++n3;
                        }
                    }
                } else {
                    pane.addColumn(0, childNodes.toArray(new Node[0]));
                    ColumnConstraints cc = new ColumnConstraints();
                    cc.setMaxWidth(Double.POSITIVE_INFINITY);
                    cc.setHgrow(Priority.ALWAYS);
                    pane.getColumnConstraints().add((Object)cc);
                    if (splitData != null) {
                        int[] nArray = splitData;
                        int n = splitData.length;
                        int n4 = 0;
                        while (n4 < n) {
                            double splitPercentage = nArray[n4];
                            RowConstraints rc = new RowConstraints();
                            rc.setPercentHeight(splitPercentage);
                            pane.getRowConstraints().add((Object)rc);
                            ++n4;
                        }
                    }
                }
                node = pane;
            } else {
                SashPane splitPane = new SashPane();
                splitPane.getItems().addAll((Object[])childNodes.toArray(new Node[0]));
                splitPane.setHorizontal(viewNode.getSplitContainerOrientation() == Orientation.HORIZONTAL);
                if (splitData != null) {
                    splitPane.setWeights(splitData);
                }
                node = splitPane;
            }
        }
        if (viewNode.isShowDocument() && viewNode.getDocument() != null) {
            RichTextArea attachement;
            RichTextArea richTextArea = new RichTextArea();
            richTextArea.setEditable(false);
            richTextArea.setDocument(viewNode.getDocument());
            if (node == null) {
                return richTextArea;
            }
            SankeyChartView center = viewNode.getDocumentPlacementPolicy() == ViewNodeDocumentPlacementPolicy.ContentCentered ? node : richTextArea;
            Object object = attachement = viewNode.getDocumentPlacementPolicy() == ViewNodeDocumentPlacementPolicy.ContentCentered ? richTextArea : node;
            if (attachement instanceof Region) {
                Region region = (Region)attachement;
                if (viewNode.getDocumentPreferedWidth() != null) {
                    region.setPrefWidth(viewNode.getDocumentPreferedWidth().doubleValue());
                }
                if (viewNode.getDocumentPreferedHeight() != null) {
                    region.setPrefHeight(viewNode.getDocumentPreferedHeight().doubleValue());
                }
            }
            switch (viewNode.getDocumentPosition()) {
                case Top: {
                    return new BorderPane((Node)center, (Node)attachement, null, null, null);
                }
                case Right: {
                    return new BorderPane((Node)center, null, (Node)attachement, null, null);
                }
                case Bottom: {
                    return new BorderPane((Node)center, null, null, (Node)attachement, null);
                }
                case Left: {
                    return new BorderPane((Node)center, null, null, null, (Node)attachement);
                }
                case MainTab: {
                    Tab richtTextTab = new Tab("Document", (Node)richTextArea);
                    Tab contentTab = new Tab("Content", (Node)node);
                    return new TabPane(new Tab[]{richtTextTab, contentTab});
                }
                case SecondaryTab: {
                    Tab richtTextTab = new Tab("Document", (Node)richTextArea);
                    Tab contentTab = new Tab("Content", (Node)node);
                    return new TabPane(new Tab[]{contentTab, richtTextTab});
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + viewNode.getDocumentPosition());
        }
        return node;
    }

    @Refresh
    public void refresh() {
        for (Chart2DView chart2DView : this.charts2DCache) {
            chart2DView.reloadData();
        }
        for (Chart3DView chart3DView : this.charts3DCache) {
            chart3DView.reloadData();
        }
        for (SankeyChartView sankeyChartView : this.sankeyCache) {
            sankeyChartView.reloadData();
        }
        for (VarTableView varTableView : this.varTablesCache) {
            varTableView.reloadData();
        }
        for (GraphChartView graphChartView : this.graphCache) {
            graphChartView.reloadData();
        }
        for (Notes notes : this.notesCache) {
            notes.reloadData();
        }
    }

    @Refresh
    public void refreshOnlyNotfailed(List<Control> failed) {
        for (Chart2DView chart2DView : this.charts2DCache) {
            if (failed.contains(chart2DView)) continue;
            chart2DView.reloadData();
        }
        for (Chart3DView chart3DView : this.charts3DCache) {
            if (failed.contains(chart3DView)) continue;
            chart3DView.reloadData();
        }
        for (SankeyChartView sankeyChartView : this.sankeyCache) {
            if (failed.contains(sankeyChartView)) continue;
            sankeyChartView.reloadData();
        }
        for (VarTableView varTableView : this.varTablesCache) {
            if (failed.contains(varTableView)) continue;
            varTableView.reloadData();
        }
        for (GraphChartView graphChartView : this.graphCache) {
            if (failed.contains(graphChartView)) continue;
            graphChartView.reloadData();
        }
        for (Notes notes : this.notesCache) {
            if (failed.contains(notes)) continue;
            notes.reloadData();
        }
    }

    @Persist
    public void save() {
        if (this.hasChanges.get()) {
            this.parent.requestFocus();
            PersistenceJob onSave = () -> {
                HashMap<SaveSupplementValueChangesDialog.ChangeGroup, List<SupplementValueChange>> unrasterizedChanges = new HashMap<SaveSupplementValueChangesDialog.ChangeGroup, List<SupplementValueChange>>();
                for (VarTableView table : this.varTablesCache) {
                    for (Map.Entry entry : table.getColumnSupplementValueChanges().entrySet()) {
                        Column column = (Column)entry.getKey();
                        SaveSupplementValueChangesDialog.ChangeGroup changeGroup = new SaveSupplementValueChangesDialog.ChangeGroup(String.format("%s [%s]", column.getLocalName(), column.getResultDisplayMeasuringUnit().getDisplayUnitText(DisplayUnitFormat.SIMPLE)), column.getLocalName());
                        for (SupplementValueChange svc : (List)entry.getValue()) {
                            if (!svc.isUnrasterizedValue()) continue;
                            LinkedList<SupplementValueChange> cc = (LinkedList<SupplementValueChange>)unrasterizedChanges.get(entry.getKey());
                            if (cc == null) {
                                cc = new LinkedList<SupplementValueChange>();
                                unrasterizedChanges.put(changeGroup, cc);
                            }
                            cc.add(svc);
                        }
                    }
                }
                for (GraphChartView graph : this.graphCache) {
                    for (SupplementValueChange supplementValueChange : graph.getSupplementValuesChanges()) {
                        VariableInstance instance = supplementValueChange.getInstance();
                        String name = String.format("[%s]", instance.getVariable().getPhysicalUnit());
                        String shortName = instance.getFullName();
                        SaveSupplementValueChangesDialog.ChangeGroup changeGroup = new SaveSupplementValueChangesDialog.ChangeGroup(name, shortName);
                        unrasterizedChanges.put(changeGroup, Collections.singletonList(supplementValueChange));
                    }
                }
                Instant unrasterizedValuesTs = this.timeRangeFilter.getFrom();
                boolean deleteLaterUnrasterizedValues = false;
                if (!unrasterizedChanges.isEmpty()) {
                    Pair pair = (Pair)FXUtils.runAndWait(() -> {
                        SaveSupplementValueChangesDialog ssvcDialog = new SaveSupplementValueChangesDialog(this.scene.getWindow(), unrasterizedChanges, this.timeRangeFilter);
                        return new Pair((Object)ssvcDialog, (Object)((ButtonType)ssvcDialog.showAndWait().get()));
                    });
                    if (pair.getValue() != ButtonType.OK) {
                        return;
                    }
                    unrasterizedValuesTs = ((SaveSupplementValueChangesDialog)pair.getKey()).getChangeFrom();
                    deleteLaterUnrasterizedValues = ((SaveSupplementValueChangesDialog)pair.getKey()).isOverwriteValues();
                }
                for (VarTableView varTableView : this.varTablesCache) {
                    if (!varTableView.hasChanges()) continue;
                    varTableView.saveChanges(unrasterizedValuesTs, deleteLaterUnrasterizedValues);
                }
                for (GraphChartView graphChartView : this.graphCache) {
                    if (!graphChartView.hasChanges()) continue;
                    graphChartView.saveChanges(unrasterizedValuesTs, deleteLaterUnrasterizedValues);
                }
                for (ChartValuesTable chartValuesTable : this.chart2DValuesTableCache.values()) {
                    if (!chartValuesTable.hasChanges()) continue;
                    chartValuesTable.saveChanges();
                }
                for (ChartValuesTable chartValuesTable : this.chart3DValuesTableCache.values()) {
                    if (!chartValuesTable.hasChanges()) continue;
                    chartValuesTable.saveChanges();
                }
                for (ObjectPropertiesView objectPropertiesView : this.propertieViewsCache) {
                    if (!objectPropertiesView.hasChanges()) continue;
                    objectPropertiesView.saveChanges();
                }
                for (Notes notes : this.notesCache) {
                    if (!notes.hasChanges()) continue;
                    notes.saveChanges();
                }
                if (this.charts2DCache.stream().anyMatch(c -> c.hasChanges())) {
                    Transaction transaction = Transactions.begin();
                    try {
                        for (Chart2DView chart : this.charts2DCache) {
                            if (!chart.hasChanges()) continue;
                            chart.saveChanges(transaction);
                        }
                        Transactions.commitSync((Transaction)transaction);
                        for (Chart2DView chart : this.charts2DCache) {
                            if (!chart.hasChanges()) continue;
                            chart.resetChanges();
                        }
                    }
                    finally {
                        Transactions.close((Transaction)transaction);
                    }
                }
                ArrayList<Control> arrayList = new ArrayList<Control>();
                if (this.charts3DCache.stream().anyMatch(c -> c.hasChanges())) {
                    Transaction trx = Transactions.begin();
                    try {
                        for (Chart3DView chart : this.charts3DCache) {
                            if (!chart.hasChanges()) continue;
                            try {
                                chart.saveChanges(trx);
                            }
                            catch (DAOOperationException e) {
                                if (e.getOperationResult().getType() == ResultType.ExpectedError) {
                                    arrayList.add((Control)chart);
                                    continue;
                                }
                                throw e;
                            }
                        }
                        Transactions.commitSync((Transaction)trx);
                        for (Chart3DView chart : this.charts3DCache) {
                            if (!chart.hasChanges() || arrayList.contains(chart)) continue;
                            chart.clearCharacteristicFunctionChanges();
                        }
                    }
                    finally {
                        Transactions.close((Transaction)trx);
                    }
                }
                if (arrayList.size() > 0) {
                    this.refreshOnlyNotfailed(arrayList);
                } else {
                    this.refresh();
                }
            };
            Consumer<Exception> onError = exc -> {
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText(Messages.partdescriptors_ViewNodeInstancePart_ErrorSavingSupplValues);
                dlg.show();
            };
            this.persistenceWorker.persist(onSave, null, onError);
        }
    }

    @Inject
    public void reload(ITimeRangeFilter timeRangeFilter) {
        this.timeRangeFilter = timeRangeFilter;
        for (Chart2DView chartView : this.charts2DCache) {
            chartView.loadData(timeRangeFilter);
        }
        for (Chart3DView chart3DView : this.charts3DCache) {
            chart3DView.loadData(timeRangeFilter);
        }
        for (SankeyChartView sankeyView : this.sankeyCache) {
            sankeyView.loadData(timeRangeFilter);
        }
        for (VarTableView vtv : this.varTablesCache) {
            vtv.loadData(timeRangeFilter);
        }
        for (GraphChartView gv : this.graphCache) {
            gv.loadData(timeRangeFilter);
        }
        for (Notes notes : this.notesCache) {
            notes.loadData(timeRangeFilter);
        }
    }

    @PersistState
    public void persistUIState(Memento state) {
        if (this.viewNode != null) {
            state.put(ViewNode.class.getName(), (Object)this.viewNode, "fx.idobject_serializer");
        }
        if (this.object != null) {
            state.put(StructureObject.class.getName(), (Object)this.object, "fx.idobject_serializer");
        }
    }

    @PreDestroy
    public void preDestroy() {
        block11: {
            for (Chart2DView chart2DView : this.charts2DCache) {
                chart2DView.dispose();
            }
            this.charts2DCache.clear();
            for (Chart3DView chart3DView : this.charts3DCache) {
                chart3DView.dispose();
            }
            this.charts3DCache.clear();
            if (!this.varTablesCache.isEmpty()) {
                Transaction transaction = Transactions.begin();
                try {
                    try {
                        for (VarTableView table : this.varTablesCache) {
                            ColumnsPersistedState state = new ColumnsPersistedState();
                            state.persistColumns(((TableView)FXUtils.findChild((Node)table, TableView.class)).getColumns());
                            table.getLastViewPrefs().setColumnsPersistedState(state.toString());
                            TableViewPrefsDAO.saveOrUpdate((Transaction)transaction, (TableViewPrefs)table.getLastViewPrefs());
                            table.dispose();
                        }
                        this.varTablesCache.clear();
                        Transactions.commitAsync((Transaction)transaction);
                    }
                    catch (Exception exception) {
                        Transactions.rollback((Transaction)transaction);
                        Transactions.close((Transaction)transaction);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    Transactions.close((Transaction)transaction);
                    throw throwable;
                }
                Transactions.close((Transaction)transaction);
            }
        }
        for (ChartValuesTable chartValuesTable : this.chart2DValuesTableCache.values()) {
            chartValuesTable.dispose();
        }
        this.chart2DValuesTableCache.clear();
        for (ChartValuesTable chartValuesTable : this.chart3DValuesTableCache.values()) {
            chartValuesTable.dispose();
        }
        this.chart3DValuesTableCache.clear();
        this.flatTablesNodeCache.clear();
        this.exportItems.setValue(null);
        this.persistProgressIndicatorPane = null;
        this.persistenceWorker = null;
        this.parent.getChildren().clear();
        System.gc();
    }
}

