/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.partdescriptors;

import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.Chart3DDAO;
import de.elpro.ewms.core.client.charts.ChartDAO;
import de.elpro.ewms.core.client.charts.ChartGroupDAO;
import de.elpro.ewms.core.client.charts.SankeyChartDAO;
import de.elpro.ewms.core.client.dataview.ViewNodeDAO;
import de.elpro.ewms.core.client.dataview.ViewPerspectiveDAO;
import de.elpro.ewms.core.client.graphs.GraphDefinitionDAO;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.dataview.AutoTimeRangeType;
import de.elpro.ewms.core.dataview.ViewNode;
import de.elpro.ewms.core.dataview.ViewPerspective;
import de.elpro.ewms.core.dataview.ViewType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.GlobalViewDateTimeRangeFilter;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ewms.gui.Messages;
import de.elpro.ewms.gui.di.PersistedIdObject;
import de.elpro.ewms.gui.partdescriptors.TimeOrientedViewNodeInstance;
import de.elpro.ewms.gui.partdescriptors.ViewNodeInstance;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.resources.Icons;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.fx.cells.uimodel.UIModelTreeCell;
import de.elpro.ui.fx.controls.tree.LazyTreeItem;
import de.elpro.ui.fx.controls.tree.LazyTreeView;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.utils.e4.PartUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.PickResult;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.core.Memento;
import org.eclipse.fx.core.di.ContextValue;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class ViewPerspectiveNavigationPart {
    public static final String ID = "de.elpro.ewms.gui.partdescriptor.perspectivenavigation";
    public static final String POPUP_MENU_ID = "de.elpro.ewms.gui.partdescriptor.perspectivenavigation.popupmenu";
    public static final String NAVI_SELECTION = "navi-selection";
    public static final String SELECTED_VIEW_NODE = "navi-selected-view-node";
    public static final String SELECTED_OBJECT = "navi-selected-object";
    private final TreeView<ViewNodeInstance> view = new LazyTreeView();
    private final ProgressIndicatorPane progressIndicator = new ProgressIndicatorPane(this.view);
    @Inject
    @Log
    private Logger logger;
    @Inject
    private EModelService modelService;
    @Inject
    private EMenuService menuService;
    @Inject
    @PersistedIdObject
    private ViewPerspective perspective;
    @Inject
    @ContextValue(value="navi-selection")
    private Property<ViewNodeInstance> naviSelection;
    @Inject
    private MApplication app;
    private TimeRange lowResTimeRange = null;
    private final MenuItem refreshItem = new MenuItem(Messages.menu_Refresh, (Node)new ImageView(Icons.REFRESH_ITEM_URL.toString()));
    private Function<TreeItem<ViewNodeInstance>, List<TreeItem<ViewNodeInstance>>> CHILDREN_LIST_CREATOR = new Function<TreeItem<ViewNodeInstance>, List<TreeItem<ViewNodeInstance>>>(){

        @Override
        public List<TreeItem<ViewNodeInstance>> apply(TreeItem<ViewNodeInstance> treeItem) {
            ViewNodeInstance vni = (ViewNodeInstance)treeItem.getValue();
            LinkedList<TreeItem<ViewNodeInstance>> children = new LinkedList<TreeItem<ViewNodeInstance>>();
            Transaction trx = Transactions.begin();
            try {
                for (ViewNode child : vni.getViewNode().getChildren()) {
                    if (!child.isTreeItem()) continue;
                    if (!child.isAutoTimeRange() || child.getAutoTimeRangeType() != AutoTimeRangeType.TimeSelectorFirst) {
                        TreeItem<ViewNodeInstance> childItem;
                        if (child.getDataObject() != null) {
                            childItem = ViewPerspectiveNavigationPart.this.createChildObject(child, StructureObjectDAO.get((Transaction)trx, (int)child.getDataObject().getId()));
                            children.add(childItem);
                            continue;
                        }
                        if (child.getDataClass() != null) {
                            StructureObject[] nextLvlObjects = child.getDataObjectSearchPolicy() == null ? StructureObjectDAO.getTopChildrenOfClass((Transaction)trx, (StructureObject)vni.getDataObject(), (StructureClass)child.getDataClass()) : StructureObjectDAO.findObjects((Transaction)trx, (StructureObject)vni.getDataObject(), (StructureClass)child.getDataClass(), (SearchPolicy)child.getDataObjectSearchPolicy());
                            if (nextLvlObjects == null) continue;
                            StructureObject[] structureObjectArray = nextLvlObjects;
                            int n = nextLvlObjects.length;
                            int n2 = 0;
                            while (n2 < n) {
                                StructureObject childObj = structureObjectArray[n2];
                                Iterator childItem2 = ViewPerspectiveNavigationPart.this.createChildObject(child, childObj);
                                children.add((TreeItem<ViewNodeInstance>)childItem2);
                                ++n2;
                            }
                            continue;
                        }
                        childItem = ViewPerspectiveNavigationPart.this.createChildObject(child, vni.getDataObject());
                        if (child.getReferenceObject() instanceof ChartGroup) {
                            ChartGroup chartGroup = (ChartGroup)child.getReferenceObject();
                            block5: for (Chart2D chart : chartGroup.getCharts()) {
                                for (StructureClass allowedAtClass : chart.getStructureClasses()) {
                                    if (!StructureClassDAO.isSubclass((Transaction)trx, (StructureClass)allowedAtClass, (StructureClass)vni.getDataObject().getStructureClass())) continue;
                                    ViewNode chartNode = new ViewNode();
                                    chartNode.setViewType(ViewType.Chart2D);
                                    childItem.getChildren().add((Object)new TreeItem((Object)new ViewNodeInstance(chartNode, vni.getDataObject())));
                                    continue block5;
                                }
                            }
                        }
                        children.add(childItem);
                        continue;
                    }
                    StructureObject[] dataObjects = child.getDataObject() != null ? new StructureObject[]{child.getDataObject()} : (child.getDataClass() == null ? new StructureObject[]{vni.getDataObject()} : StructureObjectDAO.getTopChildrenOfClass((Transaction)trx, (StructureObject)vni.getDataObject(), (StructureClass)child.getDataClass()));
                    TimeRange lowResRange = ViewPerspectiveNavigationPart.this.getLowResRange();
                    LocalDate fromDate = VirtualZone.INSTANCE.getOffsetDateTime(lowResRange.getFrom()).toLocalDate();
                    LocalDate toDate = VirtualZone.INSTANCE.getOffsetDateTime(lowResRange.getTo()).toLocalDate();
                    int maxYear = toDate.getYear();
                    int minYear = fromDate.getYear();
                    int year = maxYear;
                    while (year >= minYear) {
                        LocalDate rangeFrom = LocalDate.of(year, 1, 1);
                        LocalDate rangeTo = rangeFrom.plusYears(1L).minusDays(1L);
                        if (rangeFrom.isBefore(fromDate)) {
                            rangeFrom = fromDate;
                        }
                        if (rangeTo.isAfter(toDate)) {
                            rangeTo = toDate;
                        }
                        String name = Integer.toString(year);
                        Instant utcFrom = VirtualRaster.getDayStart((LocalDate)rangeFrom).minusNanos(1L);
                        Instant utcTo = VirtualRaster.getDayEnd((LocalDate)rangeTo);
                        if (utcTo.isAfter(lowResRange.getTo())) {
                            utcTo = lowResRange.getTo();
                        }
                        GlobalViewDateTimeRangeFilter prefs = new GlobalViewDateTimeRangeFilter(utcFrom, utcTo);
                        TimeOrientedViewNodeInstance tovni = new TimeOrientedViewNodeInstance(name, new EmptyTimeRangeNode(), null, child, dataObjects, (ITimeRangeFilter)prefs, VirtualRaster.Month);
                        LazyTreeItem yaerItem = new LazyTreeItem((Object)tovni, ViewPerspectiveNavigationPart.this.TIME_ORIENTED_AUTO_RANGED_CHILDREN_LIST_CREATOR);
                        children.add((TreeItem<ViewNodeInstance>)yaerItem);
                        --year;
                    }
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            return children;
        }
    };
    private Function<TreeItem<ViewNodeInstance>, List<TreeItem<ViewNodeInstance>>> TIME_ORIENTED_AUTO_RANGED_CHILDREN_LIST_CREATOR = new Function<TreeItem<ViewNodeInstance>, List<TreeItem<ViewNodeInstance>>>(){

        @Override
        public List<TreeItem<ViewNodeInstance>> apply(TreeItem<ViewNodeInstance> treeItem) {
            TimeRange lowResRange = ViewPerspectiveNavigationPart.this.getLowResRange();
            TimeOrientedViewNodeInstance tovni = (TimeOrientedViewNodeInstance)treeItem.getValue();
            if (((ViewNodeInstance)treeItem.getValue()).getVirtualRaster() == VirtualRaster.Month) {
                Object name;
                LinkedList<TreeItem<ViewNodeInstance>> months_and_objects = new LinkedList<TreeItem<ViewNodeInstance>>();
                ITimeRangeFilter timeRangeFilter = ((ViewNodeInstance)treeItem.getValue()).getTimeRangeFilter();
                LocalDate fromDate = VirtualZone.INSTANCE.getOffsetDateTime(timeRangeFilter.getFrom()).toLocalDate();
                LocalDate toDate = VirtualZone.INSTANCE.getOffsetDateTime(timeRangeFilter.getTo()).minusNanos(1L).toLocalDate();
                int year = fromDate.getYear();
                int maxMonth = toDate.getMonthValue();
                int minMonth = fromDate.getMonthValue();
                int month = maxMonth;
                while (month >= minMonth) {
                    LocalDate rangeFrom = LocalDate.of(year, month, 1);
                    LocalDate rangeTo = rangeFrom.plusMonths(1L).minusDays(1L);
                    if (rangeFrom.isBefore(fromDate)) {
                        rangeFrom = fromDate;
                    }
                    if (rangeTo.isAfter(toDate)) {
                        rangeTo = toDate;
                    }
                    name = rangeFrom.getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault());
                    Instant utcFrom = VirtualRaster.getDayStart((LocalDate)rangeFrom).minusNanos(1L);
                    Instant utcTo = VirtualRaster.getDayEnd((LocalDate)rangeTo);
                    if (utcTo.isAfter(lowResRange.getTo())) {
                        utcTo = lowResRange.getTo();
                    }
                    GlobalViewDateTimeRangeFilter prefs = new GlobalViewDateTimeRangeFilter(utcFrom, utcTo);
                    LazyTreeItem monthItem = new LazyTreeItem((Object)new TimeOrientedViewNodeInstance((String)name, new EmptyTimeRangeNode(), tovni.getOriginalNode(), tovni.getObjects(), (ITimeRangeFilter)prefs, VirtualRaster.Day), ViewPerspectiveNavigationPart.this.TIME_ORIENTED_AUTO_RANGED_CHILDREN_LIST_CREATOR);
                    months_and_objects.add((TreeItem<ViewNodeInstance>)monthItem);
                    --month;
                }
                name = tovni.getObjects();
                int rangeTo = ((StructureObject[])name).length;
                int rangeFrom = 0;
                while (rangeFrom < rangeTo) {
                    StructureObject dataObject = name[rangeFrom];
                    months_and_objects.add((TreeItem<ViewNodeInstance>)new TreeItem((Object)new ViewNodeInstance(tovni.getOriginalNode(), dataObject, timeRangeFilter, VirtualRaster.Month)));
                    ++rangeFrom;
                }
                return months_and_objects;
            }
            if (((ViewNodeInstance)treeItem.getValue()).getVirtualRaster() == VirtualRaster.Day) {
                LinkedList<TreeItem<ViewNodeInstance>> days_and_objects = new LinkedList<TreeItem<ViewNodeInstance>>();
                ITimeRangeFilter timeRangeFilter = ((ViewNodeInstance)treeItem.getValue()).getTimeRangeFilter();
                LocalDate fromDate = VirtualZone.INSTANCE.getOffsetDateTime(timeRangeFilter.getFrom()).toLocalDate();
                LocalDate toDate = VirtualZone.INSTANCE.getOffsetDateTime(timeRangeFilter.getTo()).minusNanos(1L).toLocalDate();
                int year = fromDate.getYear();
                int month = fromDate.getMonthValue();
                int maxDay = toDate.getDayOfMonth();
                int minDay = fromDate.getDayOfMonth();
                int day = maxDay;
                while (day >= minDay) {
                    LocalDate rangeFrom;
                    LocalDate rangeTo = rangeFrom = LocalDate.of(year, month, day);
                    if (rangeFrom.isBefore(fromDate)) {
                        rangeFrom = fromDate;
                    }
                    if (rangeTo.isAfter(toDate)) {
                        rangeTo = toDate;
                    }
                    String name = Integer.toString(day);
                    Instant utcFrom = VirtualRaster.getDayStart((LocalDate)rangeFrom).minusNanos(1L);
                    Instant utcTo = VirtualRaster.getDayEnd((LocalDate)rangeTo);
                    if (utcTo.isAfter(lowResRange.getTo())) {
                        utcTo = lowResRange.getTo();
                    }
                    GlobalViewDateTimeRangeFilter prefs = new GlobalViewDateTimeRangeFilter(utcFrom, utcTo);
                    LazyTreeItem dayItem = new LazyTreeItem((Object)new TimeOrientedViewNodeInstance(name, new EmptyTimeRangeNode(), tovni.getOriginalNode(), tovni.getObjects(), (ITimeRangeFilter)prefs, VirtualRaster.Hour), ViewPerspectiveNavigationPart.this.TIME_ORIENTED_AUTO_RANGED_CHILDREN_LIST_CREATOR);
                    days_and_objects.add((TreeItem<ViewNodeInstance>)dayItem);
                    --day;
                }
                StructureObject[] structureObjectArray = tovni.getObjects();
                int n = structureObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StructureObject dataObject = structureObjectArray[n2];
                    days_and_objects.add((TreeItem<ViewNodeInstance>)new TreeItem((Object)new ViewNodeInstance(tovni.getOriginalNode(), dataObject, timeRangeFilter, VirtualRaster.Day)));
                    ++n2;
                }
                return days_and_objects;
            }
            if (((ViewNodeInstance)treeItem.getValue()).getVirtualRaster() == VirtualRaster.Hour) {
                LinkedList<TreeItem<ViewNodeInstance>> objects = new LinkedList<TreeItem<ViewNodeInstance>>();
                ITimeRangeFilter timeRangeFilter = ((ViewNodeInstance)treeItem.getValue()).getTimeRangeFilter();
                StructureObject[] structureObjectArray = tovni.getObjects();
                int n = structureObjectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    StructureObject dataObject = structureObjectArray[n3];
                    objects.add((TreeItem<ViewNodeInstance>)new TreeItem((Object)new ViewNodeInstance(tovni.getOriginalNode(), dataObject, timeRangeFilter, VirtualRaster.Hour)));
                    ++n3;
                }
                return objects;
            }
            return new LinkedList<TreeItem<ViewNodeInstance>>();
        }
    };
    private Function<TreeItem<ViewNodeInstance>, List<TreeItem<ViewNodeInstance>>> NODE_ORIENTED_AUTO_RANGED_CHILDREN_LIST_CREATOR = new Function<TreeItem<ViewNodeInstance>, List<TreeItem<ViewNodeInstance>>>(){

        @Override
        public List<TreeItem<ViewNodeInstance>> apply(TreeItem<ViewNodeInstance> treeItem) {
            ViewNode node = ((ViewNodeInstance)treeItem.getValue()).getViewNode();
            StructureObject dataObject = ((ViewNodeInstance)treeItem.getValue()).getDataObject();
            TimeRange lowResRange = ViewPerspectiveNavigationPart.this.getLowResRange();
            if (((ViewNodeInstance)treeItem.getValue()).getVirtualRaster() == null) {
                LocalDate fromDate = VirtualZone.INSTANCE.getOffsetDateTime(lowResRange.getFrom()).toLocalDate();
                LocalDate toDate = VirtualZone.INSTANCE.getOffsetDateTime(lowResRange.getTo()).toLocalDate();
                int maxYear = toDate.getYear();
                int minYear = fromDate.getYear();
                LinkedList<TreeItem<ViewNodeInstance>> years = new LinkedList<TreeItem<ViewNodeInstance>>();
                int year = maxYear;
                while (year >= minYear) {
                    LocalDate rangeFrom = LocalDate.of(year, 1, 1);
                    LocalDate rangeTo = rangeFrom.plusYears(1L).minusDays(1L);
                    if (rangeFrom.isBefore(fromDate)) {
                        rangeFrom = fromDate;
                    }
                    if (rangeTo.isAfter(toDate)) {
                        rangeTo = toDate;
                    }
                    String name = Integer.toString(year);
                    Instant utcFrom = VirtualRaster.getDayStart((LocalDate)rangeFrom).minusNanos(1L);
                    Instant utcTo = VirtualRaster.getDayEnd((LocalDate)rangeTo);
                    if (utcTo.isAfter(lowResRange.getTo())) {
                        utcTo = lowResRange.getTo();
                    }
                    GlobalViewDateTimeRangeFilter prefs = new GlobalViewDateTimeRangeFilter(utcFrom, utcTo);
                    LazyTreeItem yearItem = new LazyTreeItem((Object)new ViewNodeInstance(name, node, dataObject, (ITimeRangeFilter)prefs, VirtualRaster.Month), ViewPerspectiveNavigationPart.this.NODE_ORIENTED_AUTO_RANGED_CHILDREN_LIST_CREATOR);
                    years.add((TreeItem<ViewNodeInstance>)yearItem);
                    --year;
                }
                return years;
            }
            if (((ViewNodeInstance)treeItem.getValue()).getVirtualRaster() == VirtualRaster.Month) {
                ITimeRangeFilter timeRangeFilter = ((ViewNodeInstance)treeItem.getValue()).getTimeRangeFilter();
                LocalDate fromDate = VirtualZone.INSTANCE.getOffsetDateTime(timeRangeFilter.getFrom()).toLocalDate();
                LocalDate toDate = VirtualZone.INSTANCE.getOffsetDateTime(timeRangeFilter.getTo()).minusNanos(1L).toLocalDate();
                int year = fromDate.getYear();
                int maxMonth = toDate.getMonthValue();
                int minMonth = fromDate.getMonthValue();
                LinkedList<TreeItem<ViewNodeInstance>> months = new LinkedList<TreeItem<ViewNodeInstance>>();
                int month = maxMonth;
                while (month >= minMonth) {
                    LocalDate rangeFrom = LocalDate.of(year, month, 1);
                    LocalDate rangeTo = rangeFrom.plusMonths(1L).minusDays(1L);
                    if (rangeFrom.isBefore(fromDate)) {
                        rangeFrom = fromDate;
                    }
                    if (rangeTo.isAfter(toDate)) {
                        rangeTo = toDate;
                    }
                    String name = rangeFrom.getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault());
                    Instant utcFrom = VirtualRaster.getDayStart((LocalDate)rangeFrom).minusNanos(1L);
                    Instant utcTo = VirtualRaster.getDayEnd((LocalDate)rangeTo);
                    if (utcTo.isAfter(lowResRange.getTo())) {
                        utcTo = lowResRange.getTo();
                    }
                    GlobalViewDateTimeRangeFilter prefs = new GlobalViewDateTimeRangeFilter(utcFrom, utcTo);
                    LazyTreeItem monthItem = new LazyTreeItem((Object)new ViewNodeInstance(name, node, dataObject, (ITimeRangeFilter)prefs, VirtualRaster.Day), ViewPerspectiveNavigationPart.this.NODE_ORIENTED_AUTO_RANGED_CHILDREN_LIST_CREATOR);
                    months.add((TreeItem<ViewNodeInstance>)monthItem);
                    --month;
                }
                return months;
            }
            if (((ViewNodeInstance)treeItem.getValue()).getVirtualRaster() == VirtualRaster.Day) {
                ITimeRangeFilter timeRangeFilter = ((ViewNodeInstance)treeItem.getValue()).getTimeRangeFilter();
                LocalDate fromDate = VirtualZone.INSTANCE.getOffsetDateTime(timeRangeFilter.getFrom()).toLocalDate();
                LocalDate toDate = VirtualZone.INSTANCE.getOffsetDateTime(timeRangeFilter.getTo()).minusNanos(1L).toLocalDate();
                int year = fromDate.getYear();
                int month = fromDate.getMonthValue();
                int maxDay = toDate.getDayOfMonth();
                int minDay = fromDate.getDayOfMonth();
                LinkedList<TreeItem<ViewNodeInstance>> days = new LinkedList<TreeItem<ViewNodeInstance>>();
                int day = maxDay;
                while (day >= minDay) {
                    LocalDate rangeFrom;
                    LocalDate rangeTo = rangeFrom = LocalDate.of(year, month, day);
                    if (rangeFrom.isBefore(fromDate)) {
                        rangeFrom = fromDate;
                    }
                    if (rangeTo.isAfter(toDate)) {
                        rangeTo = toDate;
                    }
                    String name = Integer.toString(day);
                    Instant utcFrom = VirtualRaster.getDayStart((LocalDate)rangeFrom).minusNanos(1L);
                    Instant utcTo = VirtualRaster.getDayEnd((LocalDate)rangeTo);
                    if (utcTo.isAfter(lowResRange.getTo())) {
                        utcTo = lowResRange.getTo();
                    }
                    GlobalViewDateTimeRangeFilter prefs = new GlobalViewDateTimeRangeFilter(utcFrom, utcTo);
                    TreeItem dayItem = new TreeItem((Object)new ViewNodeInstance(name, node, dataObject, (ITimeRangeFilter)prefs, VirtualRaster.Hour));
                    days.add((TreeItem<ViewNodeInstance>)dayItem);
                    --day;
                }
                return days;
            }
            return new LinkedList<TreeItem<ViewNodeInstance>>();
        }
    };

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        this.view.setShowRoot(false);
        this.view.setCellFactory(cf -> new UIModelTreeCell(me -> EOSPartUtils.pinSelectedMPart(this.modelService, this.app, "de.elpro.ewms.gui.partstack.editors")));
        this.view.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            if (nv != null) {
                this.naviSelection.setValue((Object)((ViewNodeInstance)nv.getValue()));
            } else {
                this.naviSelection.setValue(null);
            }
        });
        parent.setCenter((Node)this.progressIndicator);
        this.view.setOnMouseClicked(me -> {
            if (me.getClickCount() == 1) {
                PickResult pr = me.getPickResult();
                Node intersectedNode = pr.getIntersectedNode();
                TreeCell cell = (TreeCell)FXUtils.findParent((Node)intersectedNode, TreeCell.class);
                if (cell == null || !(cell.getItem() instanceof ViewNodeInstance)) {
                    return;
                }
                Set labelNodes = FXUtils.findChildren((Node)cell, Node.class, e -> e instanceof Text || e instanceof ImageView);
                if (!labelNodes.stream().filter(n -> n.localToScene(n.getBoundsInLocal()).getMinX() <= me.getSceneX()).findAny().isPresent()) {
                    return;
                }
                ViewNodeInstance viewNodeInstance = (ViewNodeInstance)cell.getItem();
                this.naviSelection.setValue((Object)viewNodeInstance);
                if (me.getButton() == MouseButton.PRIMARY) {
                    this.onClick(viewNodeInstance);
                }
            }
        });
        this.menuService.registerContextMenu(this.view, POPUP_MENU_ID);
        ContextMenu contextMenu = this.view.getContextMenu();
        contextMenu.getItems().add(0, (Object)this.refreshItem);
        if (contextMenu.getItems().size() > 2) {
            contextMenu.getItems().add(1, (Object)new SeparatorMenuItem());
        }
        this.refreshItem.setOnAction(e -> {
            TreeItem treeItem = (TreeItem)this.view.getSelectionModel().getSelectedItem();
            if (treeItem instanceof LazyTreeItem) {
                Transaction trx = Transactions.begin();
                try {
                    this.loadViewNodeTree(trx, ((ViewNodeInstance)treeItem.getValue()).getViewNode());
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
                ((LazyTreeItem)treeItem).refreshChildren();
            }
        });
        this.loadStructure();
    }

    private boolean onClick(ViewNodeInstance viewNodeInstance) {
        if (viewNodeInstance == null || viewNodeInstance.getDataObject() == null) {
            return false;
        }
        ViewNode viewNode = viewNodeInstance.getViewNode();
        StructureObject structureObject = viewNodeInstance.getDataObject();
        ITimeRangeFilter prefs = viewNodeInstance.getTimeRangeFilter();
        VirtualRaster subRaster = viewNodeInstance.getVirtualRaster();
        if (viewNode.getViewType() != ViewType.Empty && viewNode.getViewType() != ViewType.ChartGroup || viewNode.isShowDocument() && viewNode.getDocument() != null) {
            String partDescriptorId;
            String string = partDescriptorId = viewNode.getViewType() == ViewType.Part ? viewNode.getPartDescriptorId() : "de.elpro.ewms.gui.partdescriptor.viewnodeinstance";
            if (prefs == null) {
                PartUtils.showOrReplacePart((String)"de.elpro.ewms.gui.partstack.editors", (String)partDescriptorId, (MApplication)this.app, (boolean)true, (Object[])new Object[]{structureObject, viewNode});
            } else {
                PartUtils.showOrReplacePartWithNamedContext((String)"de.elpro.ewms.gui.partstack.editors", (String)partDescriptorId, (MApplication)this.app, (boolean)true, (Object[])new Object[]{StructureObject.class, ViewNode.class, ITimeRangeFilter.class, VirtualRaster.class}, (Object[])new Object[]{structureObject, viewNode, prefs, subRaster});
            }
            return true;
        }
        return false;
    }

    private void loadViewNodeTree(Transaction trx, ViewNode parent) {
        if (parent instanceof EmptyTimeRangeNode) {
            return;
        }
        parent.getChildren().clear();
        List<ViewNode> children = Arrays.asList(ViewNodeDAO.getChildren((Transaction)trx, (ViewNode)parent));
        parent.getChildren().addAll(children.stream().filter(n -> n.isEnabled()).collect(Collectors.toList()));
        for (ViewNode child : parent.getChildren()) {
            this.loadViewNodeTree(trx, child);
        }
        if (parent.getViewType() == ViewType.Chart2D && parent.getReferenceObjectId() != null) {
            parent.setReferenceObject((Object)ChartDAO.get((Transaction)trx, (int)parent.getReferenceObjectId()));
        } else if (parent.getViewType() == ViewType.Chart3D && parent.getReferenceObjectId() != null) {
            parent.setReferenceObject((Object)Chart3DDAO.get((Transaction)trx, (int)parent.getReferenceObjectId()));
        } else if (parent.getViewType() == ViewType.SankeyChart && parent.getReferenceObjectId() != null) {
            parent.setReferenceObject((Object)SankeyChartDAO.get((Transaction)trx, (int)parent.getReferenceObjectId()));
        } else if (parent.getViewType() == ViewType.Table && parent.getReferenceObjectId() != null) {
            parent.setReferenceObject((Object)TableDAO.get((Transaction)trx, (int)parent.getReferenceObjectId()));
        } else if (parent.getViewType() == ViewType.GraphChart) {
            parent.setReferenceObject((Object)GraphDefinitionDAO.get((Transaction)trx, (int)parent.getReferenceObjectId()));
        } else if (parent.getViewType() == ViewType.ChartGroup && parent.getReferenceObjectId() != null) {
            ChartGroup chartGroup = ChartGroupDAO.get((Transaction)trx, (int)parent.getReferenceObjectId());
            parent.setReferenceObject((Object)chartGroup);
            if (chartGroup != null) {
                ArrayList<Chart2D> charts = new ArrayList<Chart2D>();
                for (Chart2D chart : chartGroup.getCharts()) {
                    chart = ChartDAO.get((Transaction)trx, (int)chart.getId());
                    charts.add(chart);
                }
                chartGroup.getCharts().clear();
                chartGroup.getCharts().addAll(charts);
            }
        }
    }

    private void loadStructure() {
        CallableTask<Pair<TimeRange, TreeItem<ViewNodeInstance>>> task = new CallableTask<Pair<TimeRange, TreeItem<ViewNodeInstance>>>(){

            public Pair<TimeRange, TreeItem<ViewNodeInstance>> call() throws Exception {
                TreeItem containerItem = new TreeItem();
                Transaction trx = Transactions.begin();
                TimeRange lowResRange = ServerDAO.getGlobalViewTimeRange();
                try {
                    ViewNode[] viewNodeArray = ViewPerspectiveDAO.getRootNodes((Transaction)trx, (ViewPerspective)ViewPerspectiveNavigationPart.this.perspective);
                    int n = viewNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ViewNode rootNode = viewNodeArray[n2];
                        if (rootNode.isEnabled()) {
                            ViewPerspectiveNavigationPart.this.loadViewNodeTree(trx, rootNode);
                            LinkedList<StructureObject> dataObjects = new LinkedList<StructureObject>();
                            if (rootNode.getDataObject() != null) {
                                dataObjects.add(StructureObjectDAO.get((Transaction)trx, (int)rootNode.getDataObject().getId()));
                            } else {
                                dataObjects.addAll(Arrays.asList(StructureClassDAO.getAllObjects((Transaction)trx, (int)rootNode.getDataClass().getId())));
                            }
                            for (StructureObject dataObject : dataObjects) {
                                TreeItem<ViewNodeInstance> rootItem = ViewPerspectiveNavigationPart.this.createChildObject(rootNode, dataObject);
                                containerItem.getChildren().add(rootItem);
                            }
                        }
                        ++n2;
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
                return new Pair((Object)lowResRange, (Object)containerItem);
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)task).consumeResult((state, result) -> {
            if (state == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    ViewPerspectiveNavigationPart viewPerspectiveNavigationPart = this;
                    synchronized (viewPerspectiveNavigationPart) {
                        this.lowResTimeRange = (TimeRange)result.getKey();
                        this.view.setRoot((TreeItem)result.getValue());
                    }
                });
            } else {
                Platform.runLater(() -> this.view.setRoot(null));
            }
        });
    }

    private TreeItem<ViewNodeInstance> createChildObject(ViewNode child, StructureObject structureObject) {
        if (child.isAutoTimeRange() && child.getViewType() != ViewType.Empty) {
            return new LazyTreeItem((Object)new ViewNodeInstance(child, structureObject), this.NODE_ORIENTED_AUTO_RANGED_CHILDREN_LIST_CREATOR);
        }
        if (child.getChildren().stream().filter(n -> n.isTreeItem()).findAny().isPresent()) {
            return new LazyTreeItem((Object)new ViewNodeInstance(child, structureObject), this.CHILDREN_LIST_CREATOR);
        }
        return new TreeItem((Object)new ViewNodeInstance(child, structureObject));
    }

    protected synchronized TimeRange getLowResRange() {
        return this.lowResTimeRange;
    }

    @Refresh
    public void refresh() {
        this.loadStructure();
    }

    @PersistState
    public void persistUIState(Memento state) {
        state.put(ViewPerspective.class.getName(), (Object)this.perspective, "fx.idobject_serializer");
    }

    private static class EmptyTimeRangeNode
    extends ViewNode {
        public EmptyTimeRangeNode() {
            this.setViewType(ViewType.SplitContainer);
            this.setAutoTimeRange(true);
        }
    }
}

