/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.renderers;

import com.google.common.base.Strings;
import de.elpro.ewms.gui.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.core.bindings.FXBindings;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDFeedbackService;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMinMaxableWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPopupMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WStack;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.DefStackRenderer;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.DnDSupport;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.fx.ui.workbench.services.ModelService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PinnableStackRenderer
extends DefStackRenderer {
    public static final String PINNABLE_PARTS_STACK = "fx_pinnable_parts_stack";

    protected Class<? extends WStack<Node, Object, Node>> getWidgetClass(MPartStack stack) {
        if (stack.getTags().contains(PINNABLE_PARTS_STACK)) {
            return PinnableStackWidgetImpl.class;
        }
        return super.getWidgetClass(stack);
    }

    protected static class PinableTabLabel
    extends HBox {
        private static final Tooltip pinTooltip = new Tooltip(Messages.renderers_PinnableStackRenderer_pinTooltop);
        private static final Tooltip unpinTooltip = new Tooltip(Messages.renderers_PinnableStackRenderer_unpinTooltip);
        private Node graphic;
        private Label label;
        private CheckBox pinButton = new CheckBox();
        private String labelText = null;
        private boolean closable = true;

        public PinableTabLabel() {
            super(5.0);
            this.getStyleClass().add((Object)"pinnable-tab-label");
            this.getStylesheets().add((Object)PinableTabLabel.class.getResource("pinnable-tab-label.css").toExternalForm());
            this.pinButton.setTooltip(pinTooltip);
            this.updateContent();
        }

        public void setGraphic(Node graphic) {
            this.graphic = graphic;
            this.updateContent();
        }

        public void setText(String labelText) {
            this.labelText = labelText;
            if (this.label == null) {
                this.label = new Label(labelText);
            } else {
                this.label.setText(labelText);
            }
            this.updateContent();
        }

        public void setClosable(boolean closable) {
            this.closable = closable;
            this.updateContent();
        }

        public boolean isPinned() {
            return this.pinButton.isSelected();
        }

        public void setPinned(boolean pinned) {
            this.pinButton.setTooltip(pinned ? unpinTooltip : pinTooltip);
            this.pinButton.setSelected(pinned);
        }

        public BooleanProperty pinedProperty() {
            return this.pinButton.selectedProperty();
        }

        protected void updateContent() {
            ArrayList<Object> content = new ArrayList<Object>(3);
            if (this.graphic != null) {
                content.add(this.graphic);
            }
            if (this.labelText != null) {
                this.label.setText(this.labelText);
                content.add(this.label);
            }
            if (this.closable) {
                content.add(this.pinButton);
            }
            this.getChildren().setAll(content);
        }
    }

    protected static class PinnableStackItemImpl
    implements WStack.WStackItem<Object, Node> {
        PinableTabLabel tabLabel;
        Tab tab;
        private WCallback<WStack.WStackItem<Object, Node>, Node> initCallback;
        WCallback<WStack.WStackItem<Object, Node>, Boolean> closeCallback;
        private MStackElement domElement;
        @Inject
        private GraphicsLoader graphicsLoader;
        @Inject
        private EModelService modelService;
        @Inject
        IPresentationEngine engine;
        @Inject
        IEclipseContext renderingContext;
        private String label;
        private boolean dirty;
        private boolean pinned;
        private ObjectProperty<org.eclipse.fx.core.URI> iconUri = new SimpleObjectProperty((Object)this, "iconUri", null);
        private ChangeListener<Boolean> pinnedListener = (o, ov, nv) -> this.renderingContext.set("pinned", nv);

        @Inject
        public PinnableStackItemImpl(@Named(value="localizedLabel") @Optional @Named(value="localizedLabel") String label, @Named(value="dirty") @Optional @Named(value="dirty") boolean dirty, @Named(value="pinned") @Optional @Named(value="pinned") boolean pinned) {
            this.label = label;
            this.dirty = dirty;
            this.pinned = pinned;
        }

        @PostConstruct
        void init(@NonNull IEventBroker eventBroker) {
            this.getWidget();
            this.getWidgetLabel();
        }

        public void setDomElement(MStackElement domElement) {
            this.domElement = domElement;
            if (this.domElement instanceof MPart) {
                ((MPart)this.domElement).getMenus().stream().filter(m -> m instanceof MPopupMenu).filter(m -> m.getTags().contains("tabmenu")).findFirst().map(m -> (ContextMenu)((WPopupMenu)this.engine.createGui((MUIElement)m, null, this.modelService.getContainingContext((MUIElement)domElement.getParent()))).getWidget()).ifPresent(arg_0 -> ((Tab)this.getWidget()).setContextMenu(arg_0));
                String pinnedString = (String)this.domElement.getPersistedState().get("elpro.fx.part.pinned");
                if (pinnedString != null) {
                    try {
                        this.getWidgetLabel().setPinned(Boolean.parseBoolean(pinnedString));
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.getWidget().setContextMenu(null);
            }
        }

        public MStackElement getDomElement() {
            return this.domElement;
        }

        protected Tab getWidget() {
            if (this.tab == null) {
                this.tab = this.createWidget();
            }
            this.tab.setUserData((Object)this);
            return this.tab;
        }

        protected PinableTabLabel getWidgetLabel() {
            if (this.tabLabel == null) {
                this.tabLabel = new PinableTabLabel();
                this.tabLabel.pinedProperty().addListener(this.pinnedListener);
                this.getWidget().setGraphic((Node)this.tabLabel);
            }
            this.tabLabel.setUserData(this);
            return this.tabLabel;
        }

        protected Tab createWidget() {
            Tab t = new Tab();
            t.setOnCloseRequest(this::handleOnCloseRequest);
            return t;
        }

        private void handleOnCloseRequest(Event event) {
            if (((Boolean)this.closeCallback.call((Object)this)).booleanValue()) {
                event.consume();
            }
        }

        void handleSelection() {
            if (this.initCallback != null) {
                Node node = (Node)this.initCallback.call((Object)this);
                Util.attachNode((Node)node, arg_0 -> ((Tab)this.tab).setContent(arg_0));
                this.initCallback = null;
            }
            if (WLayoutedWidgetImpl.OPTIMIZED_STACK_LAYOUT) {
                if (this.tab.getContent() instanceof Parent) {
                    this.domElement.getParent().setSelectedElement((MUIElement)this.domElement);
                    ((Parent)this.tab.getContent()).requestLayout();
                } else {
                    this.tab.getTabPane().requestLayout();
                }
            }
        }

        public void setInitCallback(WCallback<WStack.WStackItem<Object, Node>, Node> initCallback) {
            this.initCallback = initCallback;
        }

        public Tab getNativeItem() {
            return this.getWidget();
        }

        @Inject
        public void setLabel(@Named(value="localizedLabel") @Optional @Named(value="localizedLabel") String label) {
            this.label = label;
            this.getWidgetLabel().setText(this.dirty ? "*" + PinnableStackItemImpl.notNull(label) : PinnableStackItemImpl.notNull(label));
        }

        @Inject
        public void setTooltip(@Named(value="localizedTooltip") @Optional @Named(value="localizedTooltip") String tooltip) {
            if (tooltip != null && !tooltip.isEmpty()) {
                this.getWidget().setTooltip(new Tooltip(tooltip));
            } else {
                this.getWidget().setTooltip(null);
            }
        }

        @Inject
        public void setCloseable(@Named(value="closeable") @Optional @Named(value="closeable") boolean closeable) {
            this.getWidgetLabel().setClosable(closeable);
            this.getWidget().setClosable(closeable);
        }

        @Inject
        public void setIcon(@Named(value="iconURI") @Optional @Named(value="iconURI") String iconUri) {
            if (!Strings.isNullOrEmpty((String)iconUri)) {
                EMFUri uri = new EMFUri(URI.createURI((String)iconUri));
                this.iconUri.set((Object)uri);
                this.getWidgetLabel().setGraphic(this.graphicsLoader.getGraphicsNode((org.eclipse.fx.core.URI)uri));
            } else {
                this.iconUri.set(null);
                this.getWidgetLabel().setGraphic(null);
            }
        }

        @Inject
        public void setDirty(@Named(value="dirty") @Optional @Named(value="dirty") boolean dirty) {
            this.dirty = dirty;
            this.getWidgetLabel().setText(dirty ? "*" + PinnableStackItemImpl.notNull(this.label) : PinnableStackItemImpl.notNull(this.label));
        }

        @Inject
        public void setPinned(@Named(value="pinned") @Optional @Named(value="pinned") boolean pinned) {
            this.pinned = pinned;
            this.getWidgetLabel().setPinned(pinned);
            if (this.domElement != null) {
                this.domElement.getPersistedState().put("elpro.fx.part.pinned", Boolean.toString(pinned));
            }
        }

        public void setOnCloseCallback(WCallback<WStack.WStackItem<Object, Node>, Boolean> callback) {
            this.closeCallback = callback;
        }

        private static String notNull(String s) {
            return s == null ? "" : s;
        }

        @PreDestroy
        public void dispose() {
            this.initCallback = null;
            this.closeCallback = null;
            this.graphicsLoader = null;
            this.tab.setOnCloseRequest(null);
            this.tab = null;
            this.tabLabel.pinedProperty().removeListener(this.pinnedListener);
            this.tabLabel = null;
            this.pinnedListener = null;
        }
    }

    public static class PinnableStackWidgetImpl
    extends WLayoutedWidgetImpl<Node, Node, MPartStack>
    implements WStack<Node, Object, Node> {
        WCallback<WStack.WStackItem<Object, Node>, Void> mouseSelectedItemCallback;
        WCallback<WStack.WStackItem<Object, Node>, Void> keySelectedItemCallback;
        WCallback<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull WDragSourceWidget.DragData, @NonNull Boolean> dragStartCallback;
        protected WCallback<WMinMaxableWidget.WMinMaxState, Void> minMaxCallback;
        boolean inKeyTraversal;
        @Inject
        @NonNull DnDFeedbackService dndFeedback;
        @Inject
        @Optional
        @Nullable DnDService dndService;
        @Inject
        @NonNull ModelService modelService;
        @Inject
        GraphicsLoader graphicsLoader;
        private final @NonNull MPartStack domainElement;
        private BorderPane pane;
        private Label titleLabel;

        @Inject
        public PinnableStackWidgetImpl(@Named(value="fx.rendering.domElement") @Named(value="fx.rendering.domElement") @NonNull MPartStack domainElement) {
            this.domainElement = domainElement;
        }

        protected Pane createStaticPane() {
            return new StackPane(){

                protected void layoutChildren() {
                    super.layoutChildren();
                }
            };
        }

        public void setMouseSelectedItemCallback(WCallback<WStack.WStackItem<Object, Node>, Void> mouseSelectedItemCallback) {
            this.mouseSelectedItemCallback = mouseSelectedItemCallback;
        }

        public void setKeySelectedItemCallback(WCallback<WStack.WStackItem<Object, Node>, Void> keySelectedItemCallback) {
            this.keySelectedItemCallback = keySelectedItemCallback;
        }

        public TabPane getWidget() {
            return (TabPane)super.getWidget();
        }

        public int indexOf(WStack.WStackItem<Object, Node> item) {
            return this.getWidget().getTabs().indexOf(item.getNativeItem());
        }

        public int getItemCount() {
            return this.getWidget().getTabs().size();
        }

        public void setMinMaxCallback(WCallback<WMinMaxableWidget.WMinMaxState, Void> minMaxCallback) {
            this.minMaxCallback = minMaxCallback;
        }

        public void setMinMaxState(WMinMaxableWidget.WMinMaxState state) {
        }

        protected TabPane createWidget() {
            Side v;
            DnDSupport dnd = new DnDSupport(param -> this.dragStartCallback, param -> this.getDropDroppedCallback(), this.dndFeedback, this.domainElement, this.dndService, this.modelService);
            TabPane p = DndTabPaneFactory.createDndTabPane(s -> {
                s.setStartFunction(arg_0 -> ((DnDSupport)dnd).handleDragStart(arg_0));
                s.setDropConsumer(arg_0 -> ((DnDSupport)dnd).handleDropped(arg_0));
                s.setFeedbackConsumer(arg_0 -> ((DnDSupport)dnd).handleFeedback(arg_0));
                s.setDragFinishedConsumer(arg_0 -> ((DnDSupport)dnd).handleFinished(arg_0));
                s.setClipboardDataFunction(arg_0 -> ((DnDSupport)dnd).clipboardDataFunction(arg_0));
            }, (boolean)DnDSupport.DETACHABLE_DRAG);
            String location = (String)this.domainElement.getPersistedState().get("fx.stack.tabslocation");
            if (location != null && (v = Side.valueOf((String)location)) != null) {
                p.setSide(v);
            }
            p.setOnMouseClicked(e -> {
                if (e.getClickCount() > 1 && this.minMaxCallback != null) {
                    p.getChildrenUnmodifiable().stream().filter(n -> n.getStyleClass().contains((Object)"tab-header-area")).findFirst().ifPresent(node -> {
                        if (node.localToScene(node.getBoundsInLocal()).contains(e.getSceneX(), e.getSceneY())) {
                            this.minMaxCallback.call((Object)WMinMaxableWidget.WMinMaxState.TOGGLE);
                        }
                    });
                }
            });
            if (this.domainElement.getTags().contains("fx_tab_closing_policy_allTabs")) {
                p.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
            }
            if (this.domainElement.getTags().contains("fx_tab_closing_policy_unavailable")) {
                p.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
            }
            if (this.domainElement.getTags().contains("fx_tab_closing_policy_selectedTab")) {
                p.setTabClosingPolicy(TabPane.TabClosingPolicy.SELECTED_TAB);
            }
            p.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    inKeyTraversal = true;
                }
            });
            p.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    inKeyTraversal = false;
                }
            });
            p.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){
                boolean inUpdate;

                public void changed(ObservableValue<? extends Tab> observable, Tab oldValue, Tab newValue) {
                    if (titleLabel != null) {
                        titleLabel.textProperty().unbind();
                        titleLabel.graphicProperty().unbind();
                        titleLabel.setGraphic(null);
                        titleLabel.setText(null);
                        if (newValue != null) {
                            PinnableStackItemImpl d = (PinnableStackItemImpl)newValue.getUserData();
                            titleLabel.graphicProperty().bind((ObservableValue)FXBindings.map(d.iconUri, u -> graphicsLoader.getGraphicsNode(u)));
                            titleLabel.textProperty().bind((ObservableValue)newValue.textProperty());
                        }
                    }
                    if (newValue == null || this.getWidgetState() != WWidget.WidgetState.CREATED && this.getWidgetState() != WWidget.WidgetState.IN_SETUP) {
                        return;
                    }
                    final PinnableStackItemImpl w = (PinnableStackItemImpl)newValue.getUserData();
                    w.handleSelection();
                    final WCallback<WStack.WStackItem<Object, Node>, Void> cb = !inKeyTraversal ? mouseSelectedItemCallback : keySelectedItemCallback;
                    if (cb != null) {
                        if (w.tab.getContent() != null && !w.tab.getContent().isVisible()) {
                            w.tab.getContent().visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                                    w.tab.getContent().visibleProperty().removeListener((ChangeListener)this);
                                    if (newValue.booleanValue()) {
                                        cb.call((Object)w);
                                    }
                                }
                            });
                        } else if (w.tab.getContent() == null || w.tab.getContent().getScene() != null) {
                            if (!this.inUpdate) {
                                this.inUpdate = true;
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        cb.call((Object)w);
                                        inUpdate = false;
                                    }
                                });
                            } else {
                                logger.debug("An endless activation update has been blocked!");
                            }
                        } else {
                            cb.call((Object)w);
                        }
                    }
                }
            });
            return p;
        }

        public Node getWidgetNode() {
            if (this.pane == null) {
                this.pane = new BorderPane();
                if (this.domainElement.getTags().contains("showTopTrimArea")) {
                    HBox box = new HBox();
                    box.getStyleClass().add((Object)"tool-bar");
                    this.titleLabel = new Label();
                    box.getChildren().add((Object)this.titleLabel);
                    this.pane.setTop((Node)box);
                }
                TabPane widget = this.getWidget();
                if (this.domainElement.getTags().contains("fx_scrollable")) {
                    ScrollPane scroll = new ScrollPane((Node)widget);
                    scroll.setFitToWidth(true);
                    scroll.setFitToHeight(true);
                    widget = scroll;
                }
                this.pane.setCenter((Node)widget);
            }
            return this.pane;
        }

        public Class<? extends WStack.WStackItem<Object, Node>> getStackItemClass() {
            return PinnableStackItemImpl.class;
        }

        public void addItem(WStack.WStackItem<Object, Node> item) {
            this.addItems(Collections.singletonList(item));
        }

        public void addItems(List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items) {
            List<Tab> extractTabs = PinnableStackWidgetImpl.extractTabs(items);
            List<Node> nodes = extractTabs.stream().map(Tab::getContent).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                nodes.forEach(Util::disableStyle);
                this.getWidget().getTabs().addAll(extractTabs);
            }
            finally {
                nodes.forEach(Util::restoreStyle);
            }
        }

        public void addItems(int index, List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items) {
            if (index >= this.getWidget().getTabs().size()) {
                this.addItems(items);
            } else {
                List<Tab> extractTabs = PinnableStackWidgetImpl.extractTabs(items);
                List<Node> nodes = extractTabs.stream().map(Tab::getContent).filter(Objects::nonNull).collect(Collectors.toList());
                try {
                    nodes.forEach(Util::disableStyle);
                    this.getWidget().getTabs().addAll(index, extractTabs);
                }
                finally {
                    nodes.forEach(Util::restoreStyle);
                }
            }
        }

        private static final List<Tab> extractTabs(List<WStack.WStackItem<Object, Node>> items) {
            ArrayList<Tab> tabs = new ArrayList<Tab>(items.size());
            for (WStack.WStackItem<Object, Node> t : items) {
                tabs.add((Tab)t.getNativeItem());
            }
            return tabs;
        }

        public void selectItem(int idx) {
            this.getWidget().getSelectionModel().select(idx);
        }

        public List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> getItems() {
            ArrayList<WStack.WStackItem> rv = new ArrayList<WStack.WStackItem>();
            for (Tab t : this.getWidget().getTabs()) {
                WStack.WStackItem i = (WStack.WStackItem)t.getUserData();
                if (i == null) continue;
                rv.add(i);
            }
            return Collections.unmodifiableList(rv);
        }

        public void removeItems(List<WStack.WStackItem<Object, Node>> items) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (WStack.WStackItem<Object, Node> i : items) {
                l.add(i.getNativeItem());
            }
            this.getWidget().getTabs().removeAll(l);
        }

        public void setDragStartCallback(@NonNull WCallback<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull WDragSourceWidget.DragData, @NonNull Boolean> dragStackCallback) {
            this.dragStartCallback = dragStackCallback;
        }
    }
}

