/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.roles;

import de.elpro.ewms.core.tables.ITableRole;
import de.elpro.ewms.gui.bundle.Activator;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.fx.core.log.Logger;

public class Roles {
    public static final String EXTENSION_POINT_ID = "de.elpro.ewms.gui.roles";
    private static Logger logger;
    public static final Map<String, ITableRole> tableRoles;

    static {
        IConfigurationElement[] elements;
        logger = Activator.getLoggerFactory().createLogger(Roles.class.toString());
        tableRoles = new TreeMap<String, ITableRole>();
        IConfigurationElement[] iConfigurationElementArray = elements = Activator.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o;
                if ("table_role".equals(e.getName()) && (o = e.createExecutableExtension("table_role")) instanceof ITableRole) {
                    ITableRole tableRole = (ITableRole)o;
                    if (tableRoles.containsKey(tableRole.getId())) {
                        logger.error(String.format("Cannot add TableRole with id %s. Duplicate id", tableRole.getId()));
                    }
                    tableRoles.put(tableRole.getId(), tableRole);
                }
            }
            catch (Exception e1) {
                logger.error("Error initializing class role", (Throwable)e1);
            }
            ++n2;
        }
    }

    public static ITableRole getTableRole(String roleId) {
        if (roleId == null) {
            return null;
        }
        return tableRoles.get(roleId);
    }

    public static Collection<ITableRole> getTableRoles() {
        return tableRoles.values();
    }
}

