/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.toolbar;

import de.elpro.ewms.core.client.log.LogMessageDAO;
import de.elpro.ewms.core.log.LogLevel;
import de.elpro.ewms.core.log.LogMessage;
import de.elpro.ewms.core.log.LogType;
import de.elpro.ewms.gui.Messages;
import de.elpro.resources.Icons;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.utils.TextUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.annotation.PostConstruct;

public class ImportantMessagePart {
    final Button moreButton = new Button("\u2026");
    private HBox errorPane;
    Stage listStage;
    Scene listScene;
    double tableWidth = 0.0;
    double maxTableWidth = 1200.0;

    @PostConstruct
    public void createGui(final Scene scene, HBox errorPane) {
        this.errorPane = errorPane;
        errorPane.setPadding(new Insets(2.0, 5.0, 2.0, 5.0));
        errorPane.setSpacing(10.0);
        errorPane.setAlignment(Pos.CENTER_RIGHT);
        errorPane.setMaxWidth(Double.MAX_VALUE);
        this.moreButton.setDisable(true);
        this.moreButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Dialog dialog = new Dialog();
                dialog.initOwner(scene.getWindow());
                int messageCount = LogMessageDAO.getMessageCount((LogType)LogType.User, (LogLevel)LogLevel.INFO);
                dialog.setHeaderText(String.format(Messages.toolbar_ImportantMessagePart_Messages1, messageCount));
                Object[] messages = LogMessageDAO.getLastMessages((LogType)LogType.User, (int)200, (LogLevel)LogLevel.INFO);
                TableView tableView = new TableView();
                TableColumn timeColumn = new TableColumn(Messages.toolbar_ImportantMessagePart_Timestamp);
                timeColumn.setCellValueFactory(cellData -> {
                    LocalDateTime ldt = LocalDateTime.ofInstant(((LogMessage)cellData.getValue()).getTimestamp(), ZoneId.systemDefault());
                    return new SimpleStringProperty(TimeFormatType.DateTimeHMs.format((TemporalAccessor)ldt));
                });
                TableColumn levelColumn = new TableColumn(Messages.toolbar_ImportantMessagePart_Level);
                levelColumn.setCellValueFactory(cellData -> new SimpleStringProperty(((LogMessage)cellData.getValue()).getLevel().toString()));
                levelColumn.setCellFactory((Callback)new Callback<TableColumn<LogMessage, String>, TableCell<LogMessage, String>>(){

                    public TableCell<LogMessage, String> call(TableColumn<LogMessage, String> param) {
                        return new TableCell<LogMessage, String>(){

                            protected void updateItem(String item, boolean empty) {
                                super.updateItem((Object)item, empty);
                                if (!this.isEmpty()) {
                                    if (item.equals(LogLevel.ERROR.toString())) {
                                        this.setTextFill((Paint)Color.RED);
                                    } else if (item.equals(LogLevel.WARNING.toString())) {
                                        this.setTextFill((Paint)Color.DARKGOLDENROD);
                                    } else if (item.equals(LogLevel.INFO.toString())) {
                                        this.setTextFill((Paint)Color.BLUE);
                                    }
                                    this.setText(item);
                                }
                            }
                        };
                    }
                });
                TableColumn sourceColumn = new TableColumn(Messages.toolbar_ImportantMessagePart_Source);
                sourceColumn.setCellValueFactory(cellData -> new SimpleStringProperty(((LogMessage)cellData.getValue()).getSource()));
                TableColumn messageColumn = new TableColumn(Messages.toolbar_ImportantMessagePart_Message);
                messageColumn.setCellValueFactory(cellData -> new SimpleStringProperty(TextUtils.getFirstLine((String)((LogMessage)cellData.getValue()).getMessage(), (int)200)));
                tableView.getItems().addAll(messages);
                tableView.getColumns().addAll((Object[])new TableColumn[]{timeColumn, levelColumn, sourceColumn, messageColumn});
                TextArea messageArea = new TextArea();
                ScrollPane messageAreaContainer = new ScrollPane((Node)messageArea);
                messageAreaContainer.setFitToHeight(true);
                messageAreaContainer.setFitToWidth(true);
                SplitPane container = new SplitPane(new Node[]{tableView, messageArea});
                container.setOrientation(Orientation.VERTICAL);
                tableView.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> messageArea.setText(nv != null ? nv.getMessage() : null));
                dialog.getDialogPane().setContent((Node)container);
                dialog.setGraphic((Node)new ImageView(Icons.HOME_ITEM_URL.toString()));
                dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
                ImportantMessagePart.this.tableWidth = 0.0;
                tableView.getColumns().forEach(col -> ImportantMessagePart.this.tableWidth += col.getWidth());
                if (ImportantMessagePart.this.tableWidth > ImportantMessagePart.this.maxTableWidth) {
                    ImportantMessagePart.this.tableWidth = ImportantMessagePart.this.maxTableWidth;
                }
                dialog.setWidth(ImportantMessagePart.this.tableWidth + 26.0);
                dialog.setResizable(true);
                dialog.show();
            }
        });
        new Thread(() -> {
            try {
                while (!Thread.interrupted()) {
                    LogMessage message = LogMessageDAO.getLastMessage((LogType)LogType.User, (LogLevel)LogLevel.INFO);
                    if (message != null) {
                        Platform.runLater(() -> this.updateMessage(message));
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (Exception exception) {
                return;
            }
        }, "Update Last Message from Log").start();
        errorPane.getChildren().add((Object)this.moreButton);
    }

    public void updateMessage(LogMessage message) {
        if (message == null) {
            this.moreButton.setDisable(false);
            this.errorPane.getChildren().setAll((Object[])new Node[]{this.moreButton});
            return;
        }
        Label sourceLabel = new Label(String.valueOf(message.getSource()) + " \u21d2");
        Label messageLabel = new Label();
        messageLabel.setText(TextUtils.getFirstLine((String)message.getMessage(), (int)80));
        messageLabel.setMaxWidth(Double.MAX_VALUE);
        if (message.getLevel().ordinal() >= LogLevel.ERROR.ordinal()) {
            messageLabel.setTextFill((Paint)Color.RED);
        } else if (message.getLevel().ordinal() == LogLevel.WARNING.ordinal()) {
            messageLabel.setTextFill((Paint)Color.DARKGOLDENROD);
        }
        this.errorPane.getChildren().setAll((Object[])new Node[]{sourceLabel, messageLabel, this.moreButton});
        if (LogMessageDAO.getMessageCount((LogType)LogType.User, (LogLevel)LogLevel.INFO) > 0) {
            this.moreButton.setDisable(false);
        } else {
            this.moreButton.setDisable(true);
        }
    }
}

