/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.toolbar;

import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.time.TimelinePhase;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.resources.Formatters;
import java.time.LocalDate;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class RangeValuesLabel
extends HBox {
    private final RangeValueLabel fromLabel = new RangeValueLabel();
    private Node separator = new Label("<->");
    private final RangeValueLabel toLabel = new RangeValueLabel();

    public RangeValuesLabel(boolean compact) {
        super((double)(compact ? 5 : 20));
        if (!compact) {
            HBox.setHgrow((Node)this.fromLabel, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.toLabel, (Priority)Priority.ALWAYS);
        }
    }

    public void updateLabels(String text) {
        this.getChildren().setAll((Object[])new Node[]{this.fromLabel});
        this.fromLabel.setAlignment(Pos.CENTER);
        this.fromLabel.updateLabel(null, text);
    }

    public void updateLabels(LocalDate fromDate, LocalDate toDate) {
        this.updateLabels(null, fromDate, null, toDate);
    }

    public void updateLabels(TimelinePhase fromObject, LocalDate fromDate, TimelinePhase toObject, LocalDate toDate) {
        if (fromObject != null && fromObject.equals((Object)toObject) || fromDate != null && fromDate.equals(toDate)) {
            this.getChildren().setAll((Object[])new Node[]{this.fromLabel});
            this.fromLabel.setAlignment(Pos.CENTER);
            if (fromObject != null) {
                TimelinePhase phase = fromObject;
                this.fromLabel.updateLabel(phase, String.format(" (%s - %s)", Formatters.getDefaultDateFormatter().format(fromDate), Formatters.getDefaultDateFormatter().format(toDate)));
            } else {
                this.fromLabel.updateLabel(null, Formatters.getDefaultDateFormatter().format(fromDate));
            }
        } else {
            this.fromLabel.setAlignment(Pos.CENTER_RIGHT);
            this.getChildren().setAll((Object[])new Node[]{this.fromLabel, this.separator, this.toLabel});
            if (fromObject != null) {
                this.fromLabel.updateLabel(fromObject, String.format(" (%s)", Formatters.getDefaultDateFormatter().format(fromDate)));
                this.toLabel.updateLabel(toObject, String.format(" (%s)", Formatters.getDefaultDateFormatter().format(toDate)));
            } else {
                this.fromLabel.updateLabel(fromDate, null);
                if (toDate == null) {
                    toDate = VirtualZone.INSTANCE.getOffsetDateTime(ServerDAO.getGlobalViewTimeRange().getTo().minusNanos(1L)).toLocalDate();
                }
                this.toLabel.updateLabel(toDate, null);
            }
        }
    }

    private class RangeValueLabel
    extends HBox {
        private final Label label;

        public RangeValueLabel() {
            super(5.0);
            this.label = new Label();
        }

        public void updateLabel(Object object, String text) {
            if (object instanceof LocalDate) {
                this.getChildren().setAll((Object[])new Node[]{this.label});
                this.label.setText(Formatters.getDefaultDateFormatter().format((LocalDate)object));
            } else if (object instanceof TimelinePhase) {
                TimelinePhase phase = (TimelinePhase)object;
                this.getChildren().setAll((Object[])new Node[]{phase.getGraphic(), this.label});
                this.label.setText(String.valueOf(phase.getLocalLabel()) + (text == null ? "" : text));
            } else {
                this.getChildren().setAll((Object[])new Node[]{this.label});
                this.label.setText(text);
            }
        }
    }
}

