/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.toolbar;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.rawvalues.RawValuesViewDAO;
import de.elpro.ewms.core.client.time.TimeRangeFilterPreferenceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.rawvalues.RawValuesViewDescriptor;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.TimeRangeFilterPreference;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ewms.gui.Messages;
import de.elpro.ewms.gui.toolbar.RangeValuesLabel;
import de.elpro.ewms.gui.toolbar.TimeRangeFilterEditor;
import java.time.OffsetDateTime;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.controlsfx.control.PopOver;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.ThreadSynchronize;

public class TimeFilterPart {
    private static final PopOver popOverFilter = TimeFilterPart.createPopOver();
    private static final RangeValuesLabel rangeValuesLabel = new RangeValuesLabel(true);
    private static final Region toggleButtonGraphic = new Region();
    private static final Node toggleButtonNode = new HBox(5.0, new Node[]{toggleButtonGraphic, rangeValuesLabel});
    private static final ToggleButton showFilterButton = new ToggleButton(null, toggleButtonNode);
    @Inject
    private MApplication app;
    private Timeline timeline;

    @PostConstruct
    public void createGui(Group group, Scene scene, ThreadSynchronize sync) {
        toggleButtonGraphic.getStyleClass().add((Object)"toggle-button-imageview");
        toggleButtonNode.getStyleClass().add((Object)"toggle-button-content");
        HBox hbox = new HBox(10.0);
        hbox.getChildren().addAll((Object[])new Node[]{showFilterButton});
        showFilterButton.selectedProperty().addListener((o, ov, nv) -> {
            if (nv.booleanValue() && !popOverFilter.isShowing()) {
                popOverFilter.show((Node)showFilterButton);
            } else if (!nv.booleanValue() && popOverFilter.isShowing()) {
                popOverFilter.hide();
            }
        });
        popOverFilter.showingProperty().addListener((o, ov, nv) -> showFilterButton.setSelected(nv.booleanValue()));
        group.focusedProperty().addListener((o, ov, nv) -> {
            if (!nv.booleanValue()) {
                popOverFilter.hide();
            }
        });
        group.getChildren().add((Object)hbox);
        popOverFilter.setOnShowing(eh -> {
            Transaction trx = Transactions.begin();
            TimeRangeFilterPreference timeRangeFilterPrefs = null;
            try {
                timeRangeFilterPrefs = TimeRangeFilterPreferenceDAO.getUserPreferences((Transaction)trx);
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            if (timeRangeFilterPrefs == null) {
                timeRangeFilterPrefs = new TimeRangeFilterPreference();
            }
            popOverFilter.setContentNode((Node)new TimeRangeFilterEditor(scene.getWindow(), sync, timeRangeFilterPrefs, (Callback<ITimeRangeFilter>)((Callback)this::applyFilter)));
        });
    }

    private void applyFilter(ITimeRangeFilter timeRangeFilter) {
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline = null;
        }
        if (timeRangeFilter.getType() != TimeRangeFilterType.CustomView && timeRangeFilter.getAutoUpdateInterval() != null) {
            this.initAutoUpdateTimeline(timeRangeFilter);
        }
        this.app.getContext().set(ITimeRangeFilter.class, (Object)timeRangeFilter);
    }

    private void initAutoUpdateTimeline(ITimeRangeFilter timeRangeFilter) {
        if (this.timeline != null) {
            this.timeline.stop();
        }
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)timeRangeFilter.getAutoUpdateInterval().toMilli()), ae -> {
            if (timeRangeFilter.getType() == TimeRangeFilterType.CustomView) {
                return;
            }
            Transaction trx = Transactions.begin();
            try {
                this.app.getContext().set(ITimeRangeFilter.class, (Object)TimeRangeFilterEditor.createFilter(TimeRangeFilterPreferenceDAO.getUserPreferences((Transaction)trx)));
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }, new KeyValue[0])});
        this.timeline.setCycleCount(-1);
        this.timeline.play();
    }

    @Inject
    private void updateLabels(@Optional ITimeRangeFilter timeRangeFilter) {
        if (timeRangeFilter == null) {
            rangeValuesLabel.updateLabels("Select Time");
            return;
        }
        TimeRangeFilterType type = timeRangeFilter.getType();
        Integer customViewIndex = timeRangeFilter.getCustomViewIndex();
        switch (type) {
            case RealtimeView: {
                rangeValuesLabel.updateLabels(Messages.toolbar_Real_Time_Values);
                break;
            }
            case GlobalView_Date: 
            case GlobalView_Timeline: {
                OffsetDateTime fromTime = VirtualZone.INSTANCE.getOffsetDateTime(timeRangeFilter.getFrom());
                OffsetDateTime toTime = timeRangeFilter.getTo() != null ? VirtualZone.INSTANCE.getOffsetDateTime(timeRangeFilter.getTo()).minusNanos(1L) : VirtualZone.INSTANCE.getOffsetDateTime(ServerDAO.getGlobalViewTimeRange().getTo().minusNanos(1L));
                if (type == TimeRangeFilterType.GlobalView_Date) {
                    rangeValuesLabel.updateLabels(fromTime.toLocalDate(), toTime.toLocalDate());
                    break;
                }
                rangeValuesLabel.updateLabels(timeRangeFilter.getPhaseFrom(), fromTime.toLocalDate(), timeRangeFilter.getPhaseTo(), toTime.toLocalDate());
                break;
            }
            case CustomView: {
                RawValuesViewDescriptor customView = RawValuesViewDAO.getView((RawValuesViewType)RawValuesViewType.CustomView, (Integer)customViewIndex);
                rangeValuesLabel.updateLabels(customView.toString());
            }
        }
        if (this.timeline == null && timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView && timeRangeFilter.getAutoUpdateInterval() != null) {
            this.initAutoUpdateTimeline(timeRangeFilter);
        }
    }

    private static PopOver createPopOver() {
        PopOver popOverFilter = new PopOver();
        popOverFilter.setTitle(Messages.toolbar_TimeFilterPart_Filteroptions);
        popOverFilter.setDetachable(true);
        popOverFilter.setHideOnEscape(true);
        popOverFilter.setArrowLocation(PopOver.ArrowLocation.TOP_RIGHT);
        popOverFilter.setAutoHide(true);
        return popOverFilter;
    }
}

