/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.toolbar;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.rawvalues.RawValuesViewDAO;
import de.elpro.ewms.core.client.rawvalues.RawValuesViewFutureTimeRangeDAO;
import de.elpro.ewms.core.client.time.TimeRangeFilterPreferenceDAO;
import de.elpro.ewms.core.client.time.TimelineDAO;
import de.elpro.ewms.core.client.time.TimelinePhaseDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.rawvalues.RawValuesViewDescriptor;
import de.elpro.ewms.core.rawvalues.RawValuesViewFutureTimeRange;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ewms.core.time.TimeRangeFilterPreference;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.time.Timeline;
import de.elpro.ewms.core.time.TimelinePhase;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ewms.gui.Messages;
import de.elpro.ewms.gui.dialogs.AdjustCustomViewDialog;
import de.elpro.ewms.gui.dialogs.FutureConfigDialog;
import de.elpro.ewms.gui.toolbar.RangeValuesLabel;
import de.elpro.resources.Resources;
import de.elpro.ui.fx.cells.uimodel.UIModelListCell;
import de.elpro.ui.fx.controls.RangeSlider;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javafx.util.StringConverter;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.ThreadSynchronize;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.dashicons.Dashicons;
import org.kordamp.ikonli.javafx.FontIcon;

public class TimeRangeFilterEditor
extends GridPane {
    private static final LocalDateTimeline DAY_TIMELINE = new LocalDateTimeline();
    private final TimeRangeFilterPreference timeRangeFilterPref;
    private final LocalDate lowerBound;
    private final LocalDate upperBound;
    private final LocalDate now;
    private LocalDate filteredLowerBound;
    private LocalDate filteredUpperBound;
    private final Label customViewLabel = new Label();
    private final ComboBox<RawValuesViewDescriptor> customViewCb = new ComboBox();
    private final Button adjustCustomViewsBtn = new Button(null, (Node)FontIcon.of((Ikon)Dashicons.ADMIN_GENERIC, (int)18, (Color)Color.WHITE));
    private final ArrayList<TimelinePhase> actualTimelinePhases = new ArrayList();
    private ComboBox<UIModelElement> rangeTypeCb = new ComboBox();
    private CheckComboBox<TimelinePhase> phasesCb = new CheckComboBox();
    private final Button adjustFutureBtn = new Button(null, (Node)FontIcon.of((Ikon)Dashicons.CHART_LINE, (int)18, (Color)Color.WHITE));
    private final RangeValuesLabel rangeValuesLabel = new RangeValuesLabel(false);
    private final BorderPane rangeSliderContainer = new BorderPane((Node)new RangeSlider());
    private final VBox intervalPane = new VBox(new Node[]{new BorderPane((Node)this.rangeSliderContainer, null, (Node)this.adjustFutureBtn, null, null), this.rangeValuesLabel});
    private final Label rangeLabel = new Label();
    private final VBox rangeContainer = new VBox();
    private final Button applyFilterOptions = new Button(Messages.toolbar_TimeRangeFilterEditor_Apply_Timefilter);
    private final Window rootWindow;
    private final ThreadSynchronize sync;
    private final Callback<ITimeRangeFilter> onApply;

    public TimeRangeFilterEditor(Window rootWindow, ThreadSynchronize sync, TimeRangeFilterPreference timeRangeFilter, Callback<ITimeRangeFilter> onApply) {
        this.setHgap(5.0);
        this.setVgap(5.0);
        this.setPrefWidth(600.0);
        this.setPadding(new Insets(10.0));
        this.rootWindow = rootWindow;
        this.sync = sync;
        this.onApply = onApply;
        TimeRange globalViewTimeRange = ServerDAO.getGlobalViewTimeRange();
        if (globalViewTimeRange == null) {
            this.createEmptyUI();
            this.now = null;
            this.upperBound = null;
            this.lowerBound = null;
            this.timeRangeFilterPref = new TimeRangeFilterPreference();
            return;
        }
        Instant globalViewNow = ServerDAO.getGlobalViewArchiveTimeRange().getTo();
        Object[] customViews = RawValuesViewDAO.getViews((RawValuesViewType)RawValuesViewType.CustomView);
        this.customViewCb.getItems().setAll(customViews);
        if (timeRangeFilter.getCustomViewIndex() != null) {
            Arrays.stream(customViews).filter(v -> v.getId().equals(timeRangeFilter.getCustomViewIndex())).findAny().ifPresent(selectedView -> this.customViewCb.getSelectionModel().select(selectedView));
        } else if (customViews.length > 0) {
            this.customViewCb.getSelectionModel().select(0);
        }
        if (timeRangeFilter.getType() == TimeRangeFilterType.CustomView && customViews.length == 0) {
            timeRangeFilter.setType(TimeRangeFilterType.RealtimeView);
        }
        OffsetDateTime virtualZoneFrom = VirtualZone.INSTANCE.getOffsetDateTime(globalViewTimeRange.getFrom());
        OffsetDateTime virtualZoneTo = VirtualZone.INSTANCE.getOffsetDateTime(globalViewTimeRange.getTo().minusNanos(1L));
        this.lowerBound = virtualZoneFrom.toLocalDate();
        this.upperBound = virtualZoneTo.toLocalDate();
        this.now = VirtualZone.INSTANCE.getOffsetDateTime(globalViewNow.minusNanos(1L)).toLocalDate();
        if (timeRangeFilter.getYearFilterFrom() < this.lowerBound.getYear() || timeRangeFilter.getYearFilterFrom() > this.upperBound.getYear() || timeRangeFilter.getYearFilterFrom() > timeRangeFilter.getYearFilterTo()) {
            timeRangeFilter.setYearFilterFrom(this.lowerBound.getYear());
        }
        if (timeRangeFilter.getYearFilterTo() > this.upperBound.getYear() || timeRangeFilter.getYearFilterTo() < this.lowerBound.getYear() || timeRangeFilter.getYearFilterFrom() > timeRangeFilter.getYearFilterTo()) {
            timeRangeFilter.setYearFilterTo(this.upperBound.getYear());
        }
        this.timeRangeFilterPref = timeRangeFilter;
        if (this.timeRangeFilterPref.getDateTo() == null) {
            this.timeRangeFilterPref.setYearFilterTo(this.upperBound.getYear());
        }
        if (this.timeRangeFilterPref.getTimeline() == null) {
            if (this.timeRangeFilterPref.getDateFrom() != null && this.timeRangeFilterPref.getYearFilterFrom() > this.timeRangeFilterPref.getDateFrom().getYear()) {
                this.timeRangeFilterPref.setYearFilterFrom(timeRangeFilter.getDateFrom().getYear());
            }
            if (this.timeRangeFilterPref.getDateTo() != null && this.timeRangeFilterPref.getYearFilterTo() < this.timeRangeFilterPref.getDateTo().getYear()) {
                this.timeRangeFilterPref.setYearFilterTo(timeRangeFilter.getDateTo().getYear());
            }
        }
        this.createUI();
        this.applyFilterOptions.setOnAction(e -> this.applyFilter());
        this.setOnKeyPressed(e -> {
            if (KeyCode.ENTER.equals((Object)e.getCode())) {
                this.applyFilter();
            }
        });
    }

    private void applyFilter() {
        this.onApply.call((Object)TimeRangeFilterEditor.createFilter(this.timeRangeFilterPref));
        Transaction trx = Transactions.begin();
        try {
            try {
                TimeRangeFilterPreferenceDAO.saveOrUpdate((Transaction)trx, (TimeRangeFilterPreference)this.timeRangeFilterPref);
                Transactions.commitSync((Transaction)trx);
            }
            catch (Exception exception) {
                Transactions.rollback((Transaction)trx);
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private void createEmptyUI() {
        this.addRow(0, new Node[]{new BorderPane((Node)new Label("Values database not initialized."))});
        this.getRowConstraints().add((Object)new RowConstraints(){
            {
                this.setVgrow(Priority.ALWAYS);
            }
        });
        this.getColumnConstraints().add((Object)new ColumnConstraints(){
            {
                this.setHgrow(Priority.ALWAYS);
            }
        });
    }

    private void createUI() {
        double minLabelWidth = 95.0;
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioButton realtimeRb = new RadioButton(Messages.toolbar_Real_Time_Values);
        realtimeRb.setToggleGroup(toggleGroup);
        realtimeRb.selectedProperty().addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.timeRangeFilterPref.setType(TimeRangeFilterType.RealtimeView);
            }
        });
        GridPane commonPane = new GridPane();
        commonPane.setHgap(5.0);
        commonPane.setVgap(5.0);
        commonPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(minLabelWidth){
            {
                this.setMinWidth(d);
            }
        }, new ColumnConstraints(){
            {
                this.setHgrow(Priority.ALWAYS);
            }
        }});
        ComboBox autoUpdateRaster = new ComboBox(FXCollections.observableArrayList((Object[])AutoUpdateRaster.RASTERS));
        autoUpdateRaster.setValue((Object)AutoUpdateRaster.find(this.timeRangeFilterPref.getAutoUpdateInterval()));
        autoUpdateRaster.valueProperty().addListener(il -> this.timeRangeFilterPref.setAutoUpdateInterval(((AutoUpdateRaster)autoUpdateRaster.getValue()).getRaster()));
        commonPane.addRow(0, new Node[]{new Label(Messages.toolbar_TimeRangeFilterEditor_Autoupdate), autoUpdateRaster});
        GridPane realtimePane = new GridPane();
        realtimePane.setHgap(5.0);
        realtimePane.setVgap(5.0);
        realtimePane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(minLabelWidth){
            {
                this.setMinWidth(d);
            }
        }, new ColumnConstraints(){
            {
                this.setHgrow(Priority.ALWAYS);
            }
        }});
        realtimePane.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)realtimeRb.selectedProperty()));
        RadioButton customViewRb = new RadioButton(Messages.toolbar_TimeFilterPart_CustomViewValues);
        customViewRb.setToggleGroup(toggleGroup);
        customViewRb.selectedProperty().addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.timeRangeFilterPref.setType(TimeRangeFilterType.CustomView);
                if (this.customViewCb.getSelectionModel().getSelectedItem() != null) {
                    this.timeRangeFilterPref.setCustomViewIndex(((RawValuesViewDescriptor)this.customViewCb.getSelectionModel().getSelectedItem()).getId());
                }
            }
        });
        customViewRb.setDisable(this.customViewCb.getItems().isEmpty());
        GridPane customViewPane = new GridPane();
        customViewPane.setHgap(5.0);
        customViewPane.setVgap(5.0);
        customViewPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(minLabelWidth){
            {
                this.setMinWidth(d);
            }
        }, new ColumnConstraints(){
            {
                this.setHgrow(Priority.ALWAYS);
            }
        }, new ColumnConstraints(){
            {
                this.setHgrow(Priority.NEVER);
            }
        }});
        customViewPane.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)customViewRb.selectedProperty()));
        this.customViewLabel.setText(Messages.toolbar_TimeFilterPart_View);
        this.customViewCb.setMaxWidth(Double.MAX_VALUE);
        customViewPane.addRow(0, new Node[]{this.customViewLabel, this.customViewCb, this.adjustCustomViewsBtn});
        this.customViewCb.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.timeRangeFilterPref.setCustomViewIndex(nv.getId()));
        this.adjustCustomViewsBtn.setOnAction(e -> {
            AdjustCustomViewDialog dlg = new AdjustCustomViewDialog(this.rootWindow, this.sync);
            dlg.showAndWait();
        });
        RadioButton historicalRb = new RadioButton(Messages.toolbar_TimeRangeFilterEditor_Historical_Values);
        historicalRb.setToggleGroup(toggleGroup);
        historicalRb.selectedProperty().addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.timeRangeFilterPref.setType(this.timeRangeFilterPref.getTimeline() == null ? TimeRangeFilterType.GlobalView_Date : TimeRangeFilterType.GlobalView_Timeline);
            }
        });
        switch (this.timeRangeFilterPref.getType().toRawValueViewType()) {
            case RealtimeView: {
                realtimeRb.setSelected(true);
                break;
            }
            case CustomView: {
                customViewRb.setSelected(true);
                break;
            }
            case GlobalView: {
                historicalRb.setSelected(true);
            }
        }
        GridPane historicalPane = new GridPane();
        historicalPane.setHgap(5.0);
        historicalPane.setVgap(5.0);
        historicalPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(minLabelWidth){
            {
                this.setMinWidth(d);
            }
        }, new ColumnConstraints(){
            {
                this.setHgrow(Priority.ALWAYS);
            }
        }});
        historicalPane.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)historicalRb.selectedProperty()));
        this.rangeSliderContainer.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        Transaction trx = Transactions.begin();
        try {
            ObservableList rangeTypes = FXCollections.observableArrayList((Object[])new UIModelElement[]{DAY_TIMELINE});
            rangeTypes.addAll((Object[])TimelineDAO.getAll((Transaction)trx));
            this.rangeTypeCb.getItems().addAll((Collection)rangeTypes);
            this.rangeTypeCb.setButtonCell((ListCell)new UIModelListCell());
            this.rangeTypeCb.setCellFactory(cf -> new UIModelListCell());
            if (this.timeRangeFilterPref.getTimeline() != null && rangeTypes.contains((Object)this.timeRangeFilterPref.getTimeline())) {
                this.rangeTypeCb.setValue((Object)this.timeRangeFilterPref.getTimeline());
            } else {
                this.rangeTypeCb.getSelectionModel().selectFirst();
            }
            this.rangeTypeCb.valueProperty().addListener(il -> {
                if (this.rangeTypeCb.getValue() instanceof Timeline) {
                    this.timeRangeFilterPref.setType(TimeRangeFilterType.GlobalView_Timeline);
                    this.timeRangeFilterPref.setTimeline((Timeline)this.rangeTypeCb.getValue());
                } else {
                    this.timeRangeFilterPref.setType(TimeRangeFilterType.GlobalView_Date);
                    this.timeRangeFilterPref.setTimeline(null);
                }
            });
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.timeRangeFilterPref.timelineProperty().addListener((o, ov, nv) -> this.updateRangeUI());
        historicalPane.addRow(1, new Node[]{new Label(Messages.toolbar_TimeRangeFilterEditor_Timeline), this.rangeTypeCb});
        RangeSlider yearsRs = new RangeSlider();
        yearsRs.setMin((double)this.lowerBound.getYear());
        yearsRs.setMax((double)this.upperBound.getYear());
        yearsRs.setShowTickLabels(true);
        yearsRs.setShowTickMarks(true);
        yearsRs.setSnapToTicks(true);
        yearsRs.setLabelFormatter((StringConverter)new StringConverter<Number>(){

            public String toString(Number object) {
                return Integer.toString(object.intValue());
            }

            public Number fromString(String string) {
                return null;
            }
        });
        yearsRs.setBlockIncrement(1.0);
        yearsRs.setMajorTickUnit(1.0);
        yearsRs.setMinorTickCount(0);
        yearsRs.lowValueProperty().addListener((o, ov, nv) -> this.timeRangeFilterPref.yearFilterFromProperty().set((int)Math.round(nv.doubleValue())));
        yearsRs.highValueProperty().addListener((o, ov, nv) -> this.timeRangeFilterPref.yearFilterToProperty().set((int)Math.round(nv.doubleValue())));
        yearsRs.setHighValue((double)Math.max(this.lowerBound.getYear(), Math.min(this.upperBound.getYear(), this.timeRangeFilterPref.getYearFilterTo())));
        yearsRs.setLowValue((double)Math.min(this.upperBound.getYear(), Math.max(this.lowerBound.getYear(), this.timeRangeFilterPref.getYearFilterFrom())));
        this.timeRangeFilterPref.yearFilterFromProperty().addListener((o, ov, nv) -> this.updateRangeUI());
        this.timeRangeFilterPref.yearFilterToProperty().addListener((o, ov, nv) -> this.updateRangeUI());
        historicalPane.addRow(2, new Node[]{new Label(Messages.toolbar_TimeRangeFilterEditor_Year_Filter), yearsRs});
        this.rangeValuesLabel.setStyle("-fx-font-weight: bold;");
        this.updateRangeUI();
        this.rangeLabel.setText(Messages.toolbar_TimeRangeFilterEditor_Range);
        this.rangeContainer.getChildren().setAll((Object[])new Node[]{this.intervalPane});
        historicalPane.addRow(3, new Node[]{this.rangeLabel, this.rangeContainer});
        this.adjustFutureBtn.setTooltip(new Tooltip("Forecast"));
        this.adjustFutureBtn.setOnAction(e -> {
            FutureConfigDialog dlg = new FutureConfigDialog(this.rootWindow);
            if (dlg.showAndWait().get() == ButtonType.OK) {
                try {
                    RawValuesViewFutureTimeRangeDAO.set((RawValuesViewFutureTimeRange)dlg.getFuture());
                    this.applyFilter();
                }
                catch (DAOOperationException e1) {
                    ExceptionDialog excDlg = new ExceptionDialog((Throwable)e1);
                    excDlg.initOwner(this.rootWindow);
                    excDlg.show();
                }
            }
        });
        GridPane.setHgrow((Node)this.applyFilterOptions, (Priority)Priority.ALWAYS);
        this.applyFilterOptions.setMaxWidth(Double.MAX_VALUE);
        int mRow = 0;
        this.addRow(mRow++, new Node[]{realtimeRb});
        this.addRow(mRow++, new Node[]{realtimePane});
        this.addRow(mRow++, new Node[]{new Separator(Orientation.HORIZONTAL)});
        this.addRow(mRow++, new Node[]{customViewRb});
        this.addRow(mRow++, new Node[]{customViewPane});
        this.addRow(mRow++, new Node[]{new Separator(Orientation.HORIZONTAL)});
        this.addRow(mRow++, new Node[]{historicalRb});
        this.addRow(mRow++, new Node[]{historicalPane});
        this.addRow(mRow++, new Node[]{new Separator(Orientation.HORIZONTAL)});
        this.addRow(mRow++, new Node[]{commonPane});
        this.addRow(mRow++, new Node[]{new Separator(Orientation.HORIZONTAL)});
        this.addRow(mRow++, new Node[]{this.applyFilterOptions});
    }

    private void updateRangeUI() {
        this.updateRangeSlider();
        this.updateTimeRange();
    }

    protected void updateRangeSlider() {
        RangeSlider rangeSlider;
        int min = 0;
        LocalDate filterFrom = LocalDate.of(this.timeRangeFilterPref.getYearFilterFrom(), 1, 1);
        LocalDate filterTo = LocalDate.of(this.timeRangeFilterPref.getYearFilterTo(), 12, 31);
        this.filteredLowerBound = filterFrom.isAfter(this.lowerBound) ? filterFrom : this.lowerBound;
        LocalDate localDate = this.filteredUpperBound = filterTo.isBefore(this.upperBound) ? filterTo : this.upperBound;
        if (this.timeRangeFilterPref.getType() == TimeRangeFilterType.GlobalView_Date || this.timeRangeFilterPref.getTimeline() == null) {
            if (this.timeRangeFilterPref.getDateTo() == null && this.filteredUpperBound.isBefore(this.upperBound)) {
                this.timeRangeFilterPref.setDateTo(this.filteredUpperBound);
            }
            if (this.timeRangeFilterPref.getDateFrom() == null) {
                this.timeRangeFilterPref.setDateFrom(this.filteredLowerBound);
            }
            if (this.timeRangeFilterPref.getDateFrom().isBefore(this.filteredLowerBound)) {
                this.timeRangeFilterPref.setDateFrom(this.filteredLowerBound);
            }
            if (this.timeRangeFilterPref.getDateTo() != null) {
                if (this.filteredUpperBound.isBefore(this.timeRangeFilterPref.getDateTo())) {
                    this.timeRangeFilterPref.setDateTo(this.filteredUpperBound);
                }
                if (this.timeRangeFilterPref.getDateTo().equals(this.upperBound)) {
                    this.timeRangeFilterPref.setDateTo(null);
                }
            }
            int totalDays = (int)(this.filteredUpperBound.toEpochDay() + 1L - this.filteredLowerBound.toEpochDay());
            double middle = (double)((int)(this.now.toEpochDay() - this.filteredLowerBound.toEpochDay())) + 0.5;
            int max = totalDays - 1;
            if (this.timeRangeFilterPref.getDateFrom() == null) {
                this.timeRangeFilterPref.setDateFrom(this.filteredLowerBound);
            }
            int lowVal = Math.max(0, (int)(this.timeRangeFilterPref.getDateFrom().toEpochDay() - this.filteredLowerBound.toEpochDay()));
            int highVal = max;
            if (this.timeRangeFilterPref.getDateTo() != null) {
                highVal = Math.max(0, Math.min(max, (int)(this.timeRangeFilterPref.getDateTo().toEpochDay() - this.filteredLowerBound.toEpochDay())));
            }
            if (lowVal > max || highVal < 0) {
                lowVal = 0;
                highVal = max;
            }
            rangeSlider = new RangeSlider((double)min, (double)max, 0.0, (double)highVal);
            rangeSlider.setLowValue((double)lowVal);
            rangeSlider.setMiddle(middle);
            rangeSlider.setMajorTickUnit((double)Math.max(1, totalDays / 50));
            rangeSlider.setSnapToTicks(totalDays <= 50);
        } else {
            Timeline timeline = this.timeRangeFilterPref.getTimeline();
            Transaction trx = Transactions.begin();
            int lowVal = Integer.MIN_VALUE;
            int highVal = Integer.MAX_VALUE;
            try {
                this.actualTimelinePhases.clear();
                this.actualTimelinePhases.addAll(TimelinePhaseDAO.getAll((Transaction)trx, (Timeline)timeline, (LocalDate)this.filteredLowerBound, (LocalDate)filterTo));
                int i = 0;
                while (i < this.actualTimelinePhases.size()) {
                    TimelinePhase phase = this.actualTimelinePhases.get(i);
                    if (phase.equals((Object)this.timeRangeFilterPref.getPhaseFrom())) {
                        lowVal = i;
                    }
                    if (phase.equals((Object)this.timeRangeFilterPref.getPhaseTo())) {
                        highVal = i;
                    }
                    ++i;
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            if (this.actualTimelinePhases.isEmpty()) {
                return;
            }
            int max = this.actualTimelinePhases.size() - 1;
            if (lowVal > highVal) {
                lowVal = min;
                highVal = max;
            }
            lowVal = Math.max(min, lowVal);
            highVal = Math.min(max, highVal);
            TimelinePhase phaseFrom = this.actualTimelinePhases.get(lowVal);
            LocalDate dateFrom = phaseFrom.getFrom().isAfter(this.lowerBound) ? phaseFrom.getFrom() : this.lowerBound;
            this.timeRangeFilterPref.setPhaseFrom(phaseFrom);
            this.timeRangeFilterPref.setDateFrom(dateFrom);
            int afterToIndex = highVal + 1;
            LocalDate dateTo = afterToIndex < this.actualTimelinePhases.size() ? this.actualTimelinePhases.get(afterToIndex).getFrom().minusDays(1L) : (this.actualTimelinePhases.get(this.actualTimelinePhases.size() - 1).getFrom().isAfter(this.upperBound) ? this.actualTimelinePhases.get(this.actualTimelinePhases.size() - 1).getFrom() : null);
            this.timeRangeFilterPref.setPhaseTo(this.actualTimelinePhases.get(highVal));
            this.timeRangeFilterPref.setDateTo(dateTo);
            rangeSlider = new RangeSlider((double)min, (double)max, 0.0, (double)highVal);
            rangeSlider.setLowValue((double)lowVal);
            rangeSlider.setMajorTickUnit(1.0);
            rangeSlider.setSnapToTicks(true);
        }
        rangeSlider.setShowTickLabels(false);
        rangeSlider.setShowTickMarks(true);
        rangeSlider.setMinorTickCount(0);
        rangeSlider.lowValueProperty().addListener((o, ov, nv) -> {
            if (this.timeRangeFilterPref.getType() == TimeRangeFilterType.GlobalView_Date) {
                LocalDate date = this.filteredLowerBound.plusDays((int)Math.round(nv.doubleValue()));
                this.timeRangeFilterPref.setDateFrom(date);
            } else if (this.timeRangeFilterPref.getType() == TimeRangeFilterType.GlobalView_Timeline) {
                int index = (int)Math.round(nv.doubleValue());
                TimelinePhase phaseFrom = this.actualTimelinePhases.get(index);
                LocalDate dateFrom = phaseFrom.getFrom().isAfter(this.lowerBound) ? phaseFrom.getFrom() : this.lowerBound;
                this.timeRangeFilterPref.setPhaseFrom(phaseFrom);
                this.timeRangeFilterPref.setDateFrom(dateFrom);
            }
            this.updateTimeRange();
        });
        rangeSlider.highValueProperty().addListener((o, ov, nv) -> {
            if (this.timeRangeFilterPref.getType() == TimeRangeFilterType.GlobalView_Date) {
                LocalDate date = this.filteredLowerBound.plusDays((int)Math.round(nv.doubleValue()));
                this.timeRangeFilterPref.setDateTo(date.isBefore(this.upperBound) ? date : null);
            } else if (this.timeRangeFilterPref.getType() == TimeRangeFilterType.GlobalView_Timeline) {
                int index = (int)Math.round(nv.doubleValue());
                int afterToIndex = index + 1;
                TimelinePhase phaseTo = this.actualTimelinePhases.get(index);
                LocalDate dateTo = afterToIndex < this.actualTimelinePhases.size() ? this.actualTimelinePhases.get(afterToIndex).getFrom().minusDays(1L) : (phaseTo.getFrom().isAfter(this.upperBound) ? phaseTo.getFrom() : null);
                this.timeRangeFilterPref.setPhaseTo(phaseTo);
                this.timeRangeFilterPref.setDateTo(dateTo);
            }
            this.updateTimeRange();
        });
        rangeSlider.setBlockIncrement(1.0);
        this.rangeSliderContainer.setCenter((Node)rangeSlider);
    }

    protected void updateTimeRange() {
        if (this.timeRangeFilterPref.getTimeline() == null) {
            this.rangeValuesLabel.updateLabels(null, this.timeRangeFilterPref.getDateFrom(), null, this.timeRangeFilterPref.getDateTo());
        } else {
            TimelinePhase fromPhase = this.timeRangeFilterPref.getPhaseFrom();
            TimelinePhase toPhase = this.timeRangeFilterPref.getPhaseTo();
            if (fromPhase == null || toPhase == null) {
                return;
            }
            int afterToIndex = this.actualTimelinePhases.indexOf(toPhase) + 1;
            LocalDate fromDate = fromPhase.getFrom();
            LocalDate toDate = afterToIndex < this.actualTimelinePhases.size() ? this.actualTimelinePhases.get(afterToIndex).getFrom().minusDays(1L) : (toPhase.getFrom().isAfter(this.upperBound) ? toPhase.getFrom() : this.upperBound);
            this.rangeValuesLabel.updateLabels(fromPhase, fromDate, toPhase, toDate);
        }
    }

    public void addPhasesInvalidationListener(InvalidationListener il) {
        this.rangeTypeCb.valueProperty().addListener(il);
        this.phasesCb.getCheckModel().getCheckedItems().addListener(il);
    }

    public static ITimeRangeFilter createFilter(TimeRangeFilterPreference timeRangeFilterPref) {
        RawValuesViewDescriptor customView = null;
        if (timeRangeFilterPref.getType() == TimeRangeFilterType.CustomView && (customView = RawValuesViewDAO.getView((RawValuesViewType)RawValuesViewType.CustomView, (Integer)timeRangeFilterPref.getCustomViewIndex())) == null) {
            timeRangeFilterPref.setType(TimeRangeFilterType.RealtimeView);
            timeRangeFilterPref.setCustomViewIndex(null);
        }
        Instant utcFrom = null;
        Instant utcTo = null;
        TimeRangeFilterType type = timeRangeFilterPref.getType();
        Raster autoUpdateInterval = timeRangeFilterPref.getAutoUpdateInterval();
        Integer customViewIndex = timeRangeFilterPref.getCustomViewIndex();
        LocalDate fromDate = timeRangeFilterPref.getDateFrom();
        LocalDate toDate = timeRangeFilterPref.getDateTo();
        utcFrom = VirtualRaster.getDayStart((LocalDate)fromDate);
        if (toDate != null) {
            utcTo = VirtualRaster.getDayEnd((LocalDate)toDate);
        } else {
            utcTo = ServerDAO.getGlobalViewTimeRange().getTo();
            toDate = VirtualZone.INSTANCE.getOffsetDateTime(utcTo.minusNanos(1L)).toLocalDate();
        }
        LinkedHashMap<TimelinePhase, Instant> phases = null;
        switch (type) {
            case RealtimeView: {
                break;
            }
            case GlobalView_Date: {
                if (timeRangeFilterPref.getDateTo() != null) break;
                utcTo = null;
                break;
            }
            case GlobalView_Timeline: {
                phases = new LinkedHashMap<TimelinePhase, Instant>();
                Transaction trx = Transactions.begin();
                try {
                    TimelinePhase[] allPhases = TimelinePhaseDAO.getAll((Transaction)trx, (Timeline)timeRangeFilterPref.getTimeline());
                    TimelinePhase prevPhase = null;
                    int i = 0;
                    while (i < allPhases.length) {
                        TimelinePhase phase = allPhases[i];
                        if (prevPhase != null) {
                            Instant prevPhaseEnd = VirtualZone.INSTANCE.getStartOfDay(phase.getFrom()).minusNanos(1L);
                            if (prevPhase.getFrom().isBefore(toDate) && prevPhaseEnd.isAfter(utcFrom)) {
                                phases.put(prevPhase, prevPhaseEnd);
                            }
                        }
                        prevPhase = phase;
                        if (phase.getFrom().isAfter(toDate)) break;
                        ++i;
                    }
                    if (prevPhase == null) break;
                    Instant prevPhaseEnd = utcTo;
                    if (!prevPhase.getFrom().isBefore(toDate) || !prevPhaseEnd.isAfter(utcFrom)) break;
                    phases.put(prevPhase, prevPhaseEnd);
                    break;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            case CustomView: {
                utcFrom = customView.getTimeRangeBegin();
                utcTo = customView.getTimeRangeEnd();
            }
        }
        return new TimeRangeFilter(type, autoUpdateInterval, customViewIndex, phases, utcFrom, utcTo, timeRangeFilterPref.getPhaseFrom(), timeRangeFilterPref.getPhaseTo());
    }

    private static class AutoUpdateRaster {
        public static final AutoUpdateRaster[] RASTERS = (AutoUpdateRaster[])Stream.concat(Stream.of(new AutoUpdateRaster(null)), Arrays.stream(Raster.values()).filter(r -> r.toMilli() >= Raster.Second_30.toMilli()).map(r -> new AutoUpdateRaster((Raster)r))).toArray(AutoUpdateRaster[]::new);
        private final Raster raster;

        public AutoUpdateRaster(Raster raster) {
            this.raster = raster;
        }

        public Raster getRaster() {
            return this.raster;
        }

        public String toString() {
            return this.raster != null ? this.raster.toString() : Messages.toolbar_TimeRangeFilterEditor_Never;
        }

        public static AutoUpdateRaster find(Raster raster) {
            AutoUpdateRaster[] autoUpdateRasterArray = RASTERS;
            int n = RASTERS.length;
            int n2 = 0;
            while (n2 < n) {
                AutoUpdateRaster aur = autoUpdateRasterArray[n2];
                if (aur.getRaster() == raster) {
                    return aur;
                }
                ++n2;
            }
            return RASTERS[0];
        }
    }

    private static class LocalDateTimeline
    implements UIModelElement {
        public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/waiting.gif");

        private LocalDateTimeline() {
        }

        public String toString() {
            return Messages.toolbar_TimeRangeFilterEditor_Day_Interval;
        }

        public String getIconUri() {
            return DEFAULT_ICON.toString();
        }
    }

    private static class TimeRangeFilter
    implements ITimeRangeFilter {
        private final TimeRangeFilterType type;
        private final Raster autoUpdateInterval;
        private final Integer customViewIndex;
        private final LinkedHashMap<TimelinePhase, Instant> phases;
        private final Instant from;
        private final Instant to;
        private final TimelinePhase phaseFrom;
        private final TimelinePhase phaseTo;

        public TimeRangeFilter(TimeRangeFilterType type, Raster autoUpdateInterval, Integer customViewIndex, LinkedHashMap<TimelinePhase, Instant> phases, Instant from, Instant to, TimelinePhase phaseFrom, TimelinePhase phaseTo) {
            this.type = type;
            this.autoUpdateInterval = autoUpdateInterval;
            this.customViewIndex = customViewIndex;
            this.phases = phases;
            this.from = from;
            this.to = to;
            this.phaseFrom = phaseFrom;
            this.phaseTo = phaseTo;
        }

        public TimeRangeFilterType getType() {
            return this.type;
        }

        public Raster getAutoUpdateInterval() {
            return this.autoUpdateInterval;
        }

        public Integer getCustomViewIndex() {
            return this.customViewIndex;
        }

        public Map<TimelinePhase, Instant> getPhases() {
            return this.phases;
        }

        public Instant getFrom() {
            return this.from;
        }

        public Instant getTo() {
            if (this.to == null) {
                return ServerDAO.getGlobalViewTimeRange().getTo();
            }
            return this.to;
        }

        public TimelinePhase getPhaseFrom() {
            return this.phaseFrom;
        }

        public TimelinePhase getPhaseTo() {
            return this.phaseTo;
        }

        public TimeRange getTimeRange(TimelinePhase timelinePhase) {
            switch (this.type) {
                case RealtimeView: {
                    return TimeRange.REALTIME;
                }
                case GlobalView_Date: {
                    return new TimeRange(this.getFrom(), this.getTo());
                }
                case GlobalView_Timeline: {
                    if (timelinePhase == null) {
                        return new TimeRange(this.getFrom(), this.getTo());
                    }
                    Instant phaseFrom = VirtualZone.INSTANCE.getStartOfDay(timelinePhase.getFrom()).minusNanos(1L);
                    Instant phaseTo = this.phases.get(timelinePhase);
                    if (phaseTo == null) {
                        phaseTo = this.to;
                    }
                    return new TimeRange(phaseFrom, phaseTo);
                }
            }
            return new TimeRange(this.getFrom(), this.getTo());
        }

        public String toString() {
            return String.format("%s <-> %s", this.getFrom(), this.getTo());
        }
    }
}

