/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.utils;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.resources.ResourceDirectoryDAO;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.resources.ResourceDirectory;
import de.elpro.ewms.gui.Messages;
import de.elpro.ewms.gui.dialogs.ResourceDirectoryBrowser;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.utils.TaskUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Dialog;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.io.FileUtils;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class ExportUtils {
    public static final boolean STORE_EXPORT_FOLDER;
    public static final boolean IGNORE_STORED_EXPORT_FOLDER;
    private static final IEclipsePreferences PREFERENCES;
    private static final String DEFAULT_EXPORT_FOLDER_PROP = "default-export-folder";
    private static final String INITIAL_FOLDER_PATH;

    static {
        PREFERENCES = InstanceScope.INSTANCE.getNode("ExportUtils");
        INITIAL_FOLDER_PATH = System.getProperty("eos.export.folder.initial");
        boolean storeExportFolder = true;
        boolean ignoreStoredExportFolder = false;
        try {
            storeExportFolder = Boolean.parseBoolean(System.getProperty("eos.export.folder.store", "true"));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {}
        try {
            ignoreStoredExportFolder = Boolean.parseBoolean(System.getProperty("eos.export.folder.ignore_stored", "false"));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {}
        STORE_EXPORT_FOLDER = storeExportFolder;
        IGNORE_STORED_EXPORT_FOLDER = ignoreStoredExportFolder;
    }

    public static String getInitialExportFolderPath() {
        return ExportUtils.replacePathWildcards(INITIAL_FOLDER_PATH);
    }

    public static String getDefaultExportFolderPath() {
        return ExportUtils.getDefaultExportFolderPath(null);
    }

    public static String getDefaultExportFolderPath(String alias) {
        File folder;
        String property = DEFAULT_EXPORT_FOLDER_PROP + (alias != null && !alias.isBlank() ? "." + alias : "");
        String lastExportFolder = PREFERENCES.get(property, null);
        if (!IGNORE_STORED_EXPORT_FOLDER && lastExportFolder != null && (folder = new File(lastExportFolder)).isDirectory() && folder.exists()) {
            return ExportUtils.replacePathWildcards(lastExportFolder);
        }
        return ExportUtils.replacePathWildcards(ExportUtils.getInitialExportFolderPath());
    }

    public static File getDefaultExportFolder() {
        return ExportUtils.getDefaultExportFolder(null);
    }

    public static File getDefaultExportFolder(String alias) {
        String path = ExportUtils.getDefaultExportFolderPath(alias);
        if (path == null) {
            return null;
        }
        File folder = new File(path);
        if (folder.exists() && folder.isDirectory() && folder.canWrite()) {
            return folder;
        }
        return null;
    }

    public static void setDefaultExportFolderPath(String folder) {
        ExportUtils.setDefaultExportFolderPath(null, folder);
    }

    public static void setDefaultExportFolderPath(String alias, String folder) {
        String property = DEFAULT_EXPORT_FOLDER_PROP + (alias != null && !alias.isBlank() ? "." + alias : "");
        PREFERENCES.put(property, folder);
        try {
            PREFERENCES.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private static String replacePathWildcards(String path) {
        if (path == null || path.isBlank()) {
            return path;
        }
        String userHome = System.getProperty("user.home");
        path = path.replace("@user.home", userHome);
        return path;
    }

    public static boolean exportFile(Stage stage, String initialFileName, String exportDescription, String fileExtension, final byte[] data) {
        CallableTask<byte[]> exportTask = new CallableTask<byte[]>(){

            public byte[] call() throws Exception {
                return data;
            }
        };
        return ExportUtils.exportFile(stage, initialFileName, exportDescription, fileExtension, exportTask, false);
    }

    public static boolean exportFile(Stage stage, String initialFileName, String exportDescription, String fileExtension, CallableTask<byte[]> exportTask) {
        return ExportUtils.exportFile(stage, initialFileName, exportDescription, fileExtension, exportTask, true);
    }

    public static boolean exportFile(Stage stage, String initialFileName, String exportDescription, String fileExtension, CallableTask<byte[]> exportTask, boolean useUITasks) {
        ResourceDirectory[] rds;
        ResourceDirectory rd;
        block18: {
            rd = ResourceDirectory.LOCAL_FS;
            try {
                Throwable throwable = null;
                Object var9_9 = null;
                try (Transaction trx = Transactions.begin();){
                    int resourceDirId;
                    rds = ResourceDirectoryDAO.getAll((Transaction)trx);
                    if (rds.length <= 0 || (resourceDirId = PREFERENCES.getInt("resoure_directory_id", -1)) < 0) break block18;
                    ResourceDirectory[] resourceDirectoryArray = rds;
                    int n = rds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ResourceDirectory resDir = resourceDirectoryArray[n2];
                        if (Integer.valueOf(resourceDirId).equals(resDir.getId())) {
                            rd = resDir;
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                rds = new ResourceDirectory[]{};
            }
        }
        if (rds.length > 0) {
            ArrayList<ResourceDirectory> choices = new ArrayList<ResourceDirectory>();
            choices.add(ResourceDirectory.LOCAL_FS);
            Collections.addAll(choices, rds);
            ChoiceDialog rdChoiceDialog = new ChoiceDialog((Object)rd, choices);
            rdChoiceDialog.initOwner(stage.getScene().getWindow());
            rdChoiceDialog.setContentText(Messages.report_utils_saveDestination);
            rd = (ResourceDirectory)rdChoiceDialog.showAndWait().get();
            PREFERENCES.putInt("resoure_directory_id", rd.getId() != null ? rd.getId() : -1);
            try {
                PREFERENCES.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        if (rd != ResourceDirectory.LOCAL_FS) {
            ResourceDirectoryBrowserDialog browserDialog = new ResourceDirectoryBrowserDialog(stage, rd, initialFileName, exportTask, useUITasks);
            return browserDialog.showAndWait().orElse(null) == ButtonType.OK;
        }
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(exportDescription, new String[]{fileExtension});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        fileChooser.setInitialFileName(initialFileName.replace('\\', '-').replace('/', '-'));
        fileChooser.setInitialDirectory(ExportUtils.getDefaultExportFolder());
        File file = fileChooser.showSaveDialog((Window)stage);
        if (file != null) {
            TaskUtils.ConsumableFuture future = useUITasks ? TaskUtils.executeUITask(exportTask) : TaskUtils.executeTask(exportTask);
            future.consumeResult((state, data) -> {
                if (data != null) {
                    try {
                        FileUtils.writeByteArrayToFile((File)file, (byte[])data);
                        Platform.runLater(() -> {
                            if (STORE_EXPORT_FOLDER) {
                                ExportUtils.setDefaultExportFolderPath(file.getParentFile().getPath());
                            }
                            Alert info = new Alert(Alert.AlertType.INFORMATION);
                            info.initOwner(stage.getScene().getWindow());
                            info.setContentText(Messages.report_utils_fileExportedSuccessfullfy);
                            info.show();
                        });
                    }
                    catch (IOException e) {
                        Platform.runLater(() -> {
                            ExceptionDialog eDlg = new ExceptionDialog((Throwable)e);
                            eDlg.setContentText(String.format(Messages.report_utils_errorSavingFile, file));
                            eDlg.initOwner(stage.getScene().getWindow());
                            eDlg.show();
                        });
                    }
                }
            });
            return true;
        }
        return false;
    }

    private static class ResourceDirectoryBrowserDialog
    extends Dialog<ButtonType> {
        private ResourceDirectoryBrowser browser;

        public ResourceDirectoryBrowserDialog(Stage stage, ResourceDirectory resourceDirectory, String defaultFileName, CallableTask<byte[]> exportTask, boolean useUITasks) {
            this.setResizable(true);
            this.initOwner(stage.getScene().getWindow());
            this.browser = new ResourceDirectoryBrowser(resourceDirectory, defaultFileName);
            this.getDialogPane().setContent((Node)this.browser);
            this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
            Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
            okButton.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableStringValue)this.browser.fileNameProperty()));
            this.setOnCloseRequest(event -> {
                if (this.getResult() == ButtonType.CANCEL) {
                    return;
                }
                if (this.getResult() != ButtonType.OK) {
                    event.consume();
                    return;
                }
                String fileName = this.browser.getFileName();
                String[] path = this.browser.getFolder().getPath();
                Transaction trx = Transactions.begin();
                try {
                    if (ResourceDirectoryDAO.checkFileExists((Transaction)trx, (ResourceDirectory)resourceDirectory, (String)fileName, (String[])path) == Boolean.TRUE) {
                        Transactions.close((Transaction)trx);
                        trx = null;
                        Alert replafeFileDialog = new Alert(Alert.AlertType.CONFIRMATION);
                        replafeFileDialog.initOwner(stage.getScene().getWindow());
                        replafeFileDialog.setContentText(Messages.report_utils_fileExistsReplace);
                        if (replafeFileDialog.showAndWait().get() != ButtonType.OK) {
                            event.consume();
                            return;
                        }
                    }
                }
                catch (Exception exc) {
                    ExceptionDialog excDlg = new ExceptionDialog((Throwable)exc);
                    excDlg.initOwner(stage.getScene().getWindow());
                    excDlg.show();
                    event.consume();
                    return;
                }
                finally {
                    if (trx != null) {
                        Transactions.close((Transaction)trx);
                    }
                }
                TaskUtils.ConsumableFuture future = useUITasks ? TaskUtils.executeUITask((CallableTask)exportTask) : TaskUtils.executeTask((CallableTask)exportTask);
                future.consumeResult((state, data) -> {
                    if (state == Worker.State.SUCCEEDED && data != null) {
                        OperationResult result;
                        Transaction t = Transactions.begin();
                        try {
                            result = ResourceDirectoryDAO.storeFile((byte[])data, (Transaction)t, (ResourceDirectory)resourceDirectory, (String)fileName, (String[])path);
                        }
                        finally {
                            Transactions.close((Transaction)t);
                        }
                        Platform.runLater(() -> {
                            if (result.getType() == ResultType.Success) {
                                Alert info = new Alert(Alert.AlertType.INFORMATION);
                                info.initOwner(stage.getScene().getWindow());
                                info.setContentText(Messages.report_utils_fileExportedSuccessfullfy);
                                info.show();
                            } else {
                                Alert info = new Alert(Alert.AlertType.ERROR);
                                info.initOwner(stage.getScene().getWindow());
                                info.setContentText(result.getMessage());
                                info.show();
                            }
                        });
                    }
                });
            });
        }
    }
}

