/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.resources;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Resources {
    public static final String ICONS_16x16 = "/icons/16x16/";
    public static final String ICONS_16x16_FLAGS = "/icons/16x16/flags/";
    public static final String ICONS_SVG = "/icons/svg/";
    private static Map<String, URL> icons_16x16 = new TreeMap<String, URL>();
    private static Map<String, URL> icons_svg = new TreeMap<String, URL>();
    private static Map<String, URL> resources = new TreeMap<String, URL>();

    public static void addResources(String rKey, Enumeration<URL> icons) {
        block3: {
            block2: {
                if (!rKey.equals(ICONS_16x16)) break block2;
                while (icons.hasMoreElements()) {
                    URL url = icons.nextElement();
                    String fileName = url.getFile();
                    String key = fileName.replaceAll(ICONS_16x16, "");
                    icons_16x16.put(key, url);
                    resources.put(url.getFile(), url);
                }
                break block3;
            }
            if (!rKey.equals(ICONS_SVG)) break block3;
            while (icons.hasMoreElements()) {
                URL url = icons.nextElement();
                String fileName = url.getFile();
                String key = fileName.replaceAll(ICONS_SVG, "");
                icons_svg.put(key, url);
                resources.put(url.getFile(), url);
            }
        }
    }

    public static URL getResourceUrl(String key) {
        try {
            return resources.get(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URL getResourceUrl(String prefix, String suffix) {
        try {
            if (prefix.startsWith(ICONS_16x16)) {
                String subPrefix = prefix.replace(ICONS_16x16, "");
                if (subPrefix.isEmpty()) {
                    return icons_16x16.get(suffix);
                }
                return icons_16x16.get(String.valueOf(subPrefix) + suffix);
            }
            if (prefix.equals(ICONS_SVG)) {
                return icons_svg.get(suffix);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public static Collection<URL> getResources(String prefix) {
        if (prefix.startsWith(ICONS_16x16)) {
            if (prefix.equals(ICONS_16x16)) {
                return icons_16x16.values();
            }
            return icons_16x16.values().stream().filter(url -> url.getFile().startsWith(prefix) && !url.getFile().contains("@2x")).collect(Collectors.toList());
        }
        if (prefix.equals(ICONS_SVG)) {
            return icons_svg.values();
        }
        return new LinkedList<URL>();
    }
}

