/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.sankey;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import de.elpro.ui.fx.charts.Messages;
import de.elpro.ui.fx.charts.sankey.SankeyFXLink;
import de.elpro.ui.fx.charts.sankey.SankeyFXNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.EventHandler;
import javafx.scene.chart.Chart;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class SankeyFXChart
extends Chart {
    private double nodeWidth = 24.0;
    private double nodePadding = 12.0;
    private double valueToHeightRatio = 0.0;
    private final ArrayList<Double> columnHight = new ArrayList();
    private ObservableSet<SankeyFXNode> nodes;
    private ObservableSet<SankeyFXLink> links;
    private Set<SankeyFXNode> newNodes = new HashSet<SankeyFXNode>();
    private SimpleBooleanProperty showLinkValues = new SimpleBooleanProperty(true);
    private SetChangeListener<SankeyFXNode> nodesChangeListener = new SetChangeListener<SankeyFXNode>(){

        public void onChanged(SetChangeListener.Change<? extends SankeyFXNode> change) {
        }
    };
    private SetChangeListener<SankeyFXLink> linksChangeListener = new SetChangeListener<SankeyFXLink>(){

        public void onChanged(SetChangeListener.Change<? extends SankeyFXLink> change) {
        }
    };

    public SankeyFXChart() {
        this((ObservableSet<SankeyFXNode>)FXCollections.emptyObservableSet(), (ObservableSet<SankeyFXLink>)FXCollections.emptyObservableSet());
    }

    public SankeyFXChart(ObservableSet<SankeyFXNode> nodes, ObservableSet<SankeyFXLink> links) {
        CheckMenuItem showLinkValuesMenuItem = new CheckMenuItem(Messages.sankey_SankeyFXChart_ShowValues);
        showLinkValuesMenuItem.setSelected(this.isShowLinkValues());
        this.showLinkValues.bind((ObservableValue)showLinkValuesMenuItem.selectedProperty());
        final ContextMenu menu = new ContextMenu(new MenuItem[]{showLinkValuesMenuItem});
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (MouseButton.SECONDARY.equals((Object)event.getButton())) {
                    menu.show(SankeyFXChart.this.getScene().getWindow(), event.getScreenX(), event.getScreenY());
                }
            }
        });
        this.showLinkValues.addListener(il -> this.requestChartLayout());
        this.nodes = nodes;
        this.nodes.addListener(this.nodesChangeListener);
        this.newNodes.addAll((Collection<SankeyFXNode>)nodes);
        this.nodes.stream().forEach(node -> node.setChart(this));
        this.links = links;
        this.links.addListener(this.linksChangeListener);
        this.links.stream().forEach(link -> link.setChart(this));
        this.getChartChildren().addAll(links);
        this.getChartChildren().addAll(nodes);
        this.widthProperty().addListener(o -> this.clearNodesPosition());
        this.heightProperty().addListener(o -> this.clearNodesPosition());
    }

    public void clearNodesPosition() {
        this.newNodes.clear();
        this.newNodes.addAll((Collection<SankeyFXNode>)this.nodes);
    }

    protected void layoutChartChildren(double top, double left, double width, double height) {
        this.computeNodesValue();
        this.computeNodesHorizontalPosition();
        this.computeNodesVerticalPosition();
        this.computeValueToHeightRatio(height);
        this.computeCoordinatesForNewNodes(top, left, width, height);
        this.computeLinksCoordinates();
    }

    void computeLinksCoordinates() {
        this.links.stream().forEach(this::computeCoordinatesForLinks);
    }

    private void computeCoordinatesForLinks(SankeyFXLink link) {
        SankeyFXNode source = link.getSource();
        SankeyFXNode target = link.getTarget();
        double yOffset = this.links.stream().filter(l -> ((Object)((Object)l.getSource())).equals((Object)source)).sorted(Comparator.comparingDouble(l -> l.getTarget().getY())).filter(l -> l.getTarget().getY() < target.getY()).reduce(0.0, (offset, l) -> offset + l.getValue() * this.valueToHeightRatio, (offset1, offset2) -> offset1 + offset2);
        link.setRefPoints(source.getX() + source.getWidth(), source.getY() + yOffset, target.getX(), target.getY(), link.getValue() * this.valueToHeightRatio);
    }

    void computeCoordinatesForNewNodes(double top, double left, double width, double height) {
        this.nodes.stream().forEach(node -> node.setHeight(node.getValue() * this.valueToHeightRatio));
        this.nodes.stream().forEach(node -> node.setWidth(this.nodeWidth));
        double xNodesPadding = this.computeNodesHorizontalPadding(Math.max(10.0, width));
        this.newNodes.stream().forEach(node -> node.setX(left + (double)node.getHorizontalPosition() * xNodesPadding));
        this.computeColumnHights();
        this.computeNodesYCoordinate(top);
        this.newNodes.clear();
    }

    private void computeNodesYCoordinate(double top) {
        int biggestColumn = this.columnHight.size() > 0 ? this.columnHight.indexOf(this.columnHight.stream().max((d1, d2) -> Double.compare(d1, d2)).get()) : -1;
        this.newNodes.stream().mapToInt(SankeyFXNode::getHorizontalPosition).distinct().forEach(column -> this.computeYCoordinateForNodesInColumn(column, top, biggestColumn));
    }

    private void computeColumnHights() {
        this.columnHight.clear();
        this.nodes.stream().sorted((o1, o2) -> Integer.compare(o1.getHorizontalPosition(), o2.getHorizontalPosition())).forEach(node -> {
            double hight;
            double d = hight = this.columnHight.size() > node.getHorizontalPosition() ? this.columnHight.get(node.getHorizontalPosition()) : 0.0;
            if (hight > 0.0) {
                hight += this.nodePadding;
            }
            hight += node.getHeight();
            if (this.columnHight.size() > node.getHorizontalPosition()) {
                this.columnHight.set(node.getHorizontalPosition(), hight);
            } else {
                this.columnHight.add(hight);
            }
        });
    }

    private void computeYCoordinateForNodesInColumn(int column, double top, int biggestColumn) {
        List nodesInColumn = this.nodes.stream().filter(node -> node.getHorizontalPosition() == column).sorted((o1, o2) -> Integer.compare(o1.getVerticalPosition(), o2.getVerticalPosition())).collect(Collectors.toList());
        double currentY = top;
        if (biggestColumn > 0 && column < biggestColumn) {
            currentY += (this.columnHight.get(biggestColumn) - this.columnHight.get(column)) / 2.0;
        }
        for (SankeyFXNode node2 : nodesInColumn) {
            node2.setY(currentY);
            currentY += node2.getHeight() + this.nodePadding;
        }
    }

    private double computeNodesHorizontalPadding(double width) {
        long numberOfColumn = this.nodes.stream().mapToInt(SankeyFXNode::getHorizontalPosition).distinct().count();
        double maxLastNodeWidth = this.nodes.stream().filter(n -> (long)n.getHorizontalPosition() == numberOfColumn - 1L).mapToDouble(n -> n.getLabelWidth()).max().getAsDouble();
        return numberOfColumn > 1L ? (width - maxLastNodeWidth - this.nodeWidth - 6.0) / (double)(numberOfColumn - 1L) : 0.0;
    }

    private void computeValueToHeightRatio(double height) {
        HashMap<Integer, Double> columnValues = new HashMap<Integer, Double>();
        HashMap<Integer, Integer> columnNodes = new HashMap<Integer, Integer>();
        Double totalValueOfTheBiggestColumn = Double.NEGATIVE_INFINITY;
        int maxItemsCount = 0;
        for (SankeyFXNode node : this.nodes) {
            int column = node.getHorizontalPosition();
            Double value = (Double)columnValues.get(column);
            if (value == null) {
                value = 0.0;
            }
            value = value + node.getValue();
            columnValues.put(column, value);
            Integer count = (Integer)columnNodes.get(column);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            columnNodes.put(column, count);
            if (value > totalValueOfTheBiggestColumn) {
                totalValueOfTheBiggestColumn = value;
            }
            if (count <= maxItemsCount) continue;
            maxItemsCount = count;
        }
        this.valueToHeightRatio = totalValueOfTheBiggestColumn > 0.0 ? (height - (double)(maxItemsCount - 1) * this.nodePadding) / totalValueOfTheBiggestColumn : 0.0;
    }

    void computeNodesVerticalPosition() {
        this.nodes.stream().mapToInt(SankeyFXNode::getHorizontalPosition).distinct().sorted().forEach(this::computeVerticalPositionForNodesInColumn);
    }

    private void computeVerticalPositionForNodesInColumn(int column) {
        List columnNodes = this.nodes.stream().filter(node -> node.getHorizontalPosition() == column).collect(Collectors.toList());
        HashMap<SankeyFXNode, SankeyFXNode> nodeLinks = new HashMap<SankeyFXNode, SankeyFXNode>();
        for (SankeyFXLink link : this.links) {
            if (link.getSource().getHorizontalPosition() != column - 1) continue;
            nodeLinks.put(link.getTarget(), link.getSource());
        }
        LinkedListMultimap mm = LinkedListMultimap.create();
        for (SankeyFXNode node2 : columnNodes) {
            SankeyFXNode source = (SankeyFXNode)((Object)nodeLinks.get((Object)node2));
            mm.put((Object)source, (Object)node2);
        }
        int i = 0;
        for (SankeyFXNode source : mm.keys().stream().sorted((o1, o2) -> Integer.compare(o1.getVerticalPosition(), o2.getVerticalPosition())).collect(Collectors.toList())) {
            SankeyFXNode[] sankeyFXNodeArray = (SankeyFXNode[])mm.get((Object)source).stream().sorted((o1, o2) -> o1.getValue().compareTo(o2.getValue())).toArray(SankeyFXNode[]::new);
            int n = sankeyFXNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SankeyFXNode node3 = sankeyFXNodeArray[n2];
                node3.setVerticalPosition(i++);
                ++n2;
            }
        }
    }

    void computeNodesHorizontalPosition() {
        Object frontier = this.nodes;
        while (!frontier.isEmpty()) {
            HashSet<SankeyFXNode> newFrontier = new HashSet<SankeyFXNode>();
            for (SankeyFXNode node : frontier) {
                Set incomingNodes = this.incomingNodesOf(node).stream().filter(arg_0 -> frontier.contains(arg_0)).filter(incomingNode -> incomingNode.getHorizontalPosition() <= node.getHorizontalPosition()).collect(Collectors.toSet());
                if (incomingNodes.isEmpty()) continue;
                node.moveToRight();
                newFrontier.add(node);
            }
            frontier = newFrontier;
        }
    }

    void computeNodesValue() {
        this.nodes.stream().forEach(this::updateValueFor);
    }

    void updateValueFor(SankeyFXNode node) {
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)Messages.sankey_SankeyFXChart_NodeCannotBeNull);
        double linksFrom = this.sumOfLinksFrom(node);
        double linksTo = this.sumOfLinksTargeting(node);
        if (node.getHorizontalPosition() == 0) {
            linksTo = Math.max(0.0, node.getValue());
        }
        node.setValue(Math.max(linksFrom, linksTo));
    }

    double sumOfLinksTargeting(SankeyFXNode node) {
        return this.links.stream().filter(link -> ((Object)((Object)link.getTarget())).equals((Object)node)).mapToDouble(SankeyFXLink::getValue).sum();
    }

    double sumOfLinksFrom(SankeyFXNode node) {
        return this.links.stream().filter(link -> ((Object)((Object)link.getSource())).equals((Object)node)).mapToDouble(SankeyFXLink::getValue).sum();
    }

    Collection<SankeyFXNode> incomingNodesOf(SankeyFXNode node) {
        return this.links.stream().filter(link -> ((Object)((Object)link.getTarget())).equals((Object)node)).map(SankeyFXLink::getSource).collect(Collectors.toList());
    }

    public void valueHasChangedFor(SankeyFXLink sankeyLink) {
        this.requestChartLayout();
    }

    public void nameHasChangedFor(SankeyFXNode sankeyNode) {
    }

    public void positionHasChangedFor(SankeyFXNode sankeyNode) {
        this.requestChartLayout();
    }

    public boolean isShowLinkValues() {
        return this.showLinkValues.get();
    }

    public void setShowLinkValues(boolean showLinkValues) {
        this.showLinkValues.set(showLinkValues);
    }
}

