/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz;

import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.axis.ItemColorPolicy;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxes;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxis2DRenderer;
import de.elpro.ui.fx.charts.xyz.axis.XYZLabeldGridAxis2DRenderer;
import de.elpro.ui.fx.charts.xyz.series.AreaSurfaceEditMode;
import de.elpro.ui.fx.charts.xyz.series.XYAreaBounds;
import de.elpro.ui.fx.charts.xyz.series.XYZAreaSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZAreaSeries2DRenderer;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import de.elpro.ui.fx.charts.xyz.series.XYZItemSeries2DRenderer;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries2DRenderer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import javafx.animation.AnimationTimer;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;

public class XYZChart2D
extends BorderPane {
    private final XYZAxis2DRenderer axisRenderer = new XYZLabeldGridAxis2DRenderer();
    private final LinkedHashSet<XYZSeries2DRenderer> seriesRenderers = new LinkedHashSet();
    private final XYZAxes axes;
    private final BooleanProperty deriveItemColorFromZAxis = new SimpleBooleanProperty(true);
    private final ObjectProperty<ItemColorPolicy> zAxisColorPolicy = new SimpleObjectProperty((Object)ItemColorPolicy.SeriesBaseColor);
    private final ObjectProperty<ItemColorPolicy> wAxisColorPolicy = new SimpleObjectProperty((Object)ItemColorPolicy.WGreenToRed);
    private final ObservableList<XYZSeries> seriesList = FXCollections.observableArrayList();
    private final ObservableList<XYZItem> selectedItems = FXCollections.observableArrayList();
    private final ObjectProperty<XYZAreaSeries> editAreaSeries = new SimpleObjectProperty();
    private final IntegerProperty xAxisTickStep = new SimpleIntegerProperty(150);
    private final IntegerProperty yAxisTickStep = new SimpleIntegerProperty(150);
    private final ObjectProperty<XYZDataViewRange> defaultViewRange = new SimpleObjectProperty();
    private final ObjectProperty<XYZDataViewRange> selectionViewRange = new SimpleObjectProperty();
    private final ObjectProperty<Insets> axesPadding = new SimpleObjectProperty((Object)new Insets(40.0, 40.0, 80.0, 80.0));
    private final BooleanProperty showZIsolines = new SimpleBooleanProperty(true);
    private final BooleanProperty showWIsolines = new SimpleBooleanProperty(true);
    private EditEventListener editEventListener = null;
    private EditMode editMode = EditMode.NoEdit;
    private AreaSurfaceEditMode surfaceEditMode = AreaSurfaceEditMode.Amplify;
    private int surfaceEditRadius = 6;
    private int surfaceEditAmplitude = 5;
    private boolean surfaceEditZ = true;
    private boolean surfaceEditW = true;
    private Point2D clickPoint = null;
    private Point2D clickDomainPoint = null;
    private Point2D currentEditBoundsPoint = null;
    private XYAreaBounds currentEditAreaBounds = null;
    private Point2D currentDomainPoint = null;
    private XYZDataViewRange clickViewRange = null;
    private AnimationTimer editSurfaceAnimationTimer = new AnimationTimer(){
        long lastTs = -1L;

        public void stop() {
            super.stop();
            this.lastTs = -1L;
        }

        public void handle(long now) {
            if (XYZChart2D.this.editMode != EditMode.EditSurface) {
                return;
            }
            if (this.lastTs == -1L) {
                this.lastTs = now;
                return;
            }
            long tsDelta = now - this.lastTs;
            this.lastTs = now;
            DrawBounds drawBounds = XYZChart2D.this.drawRegion.getDrawBounds();
            XYZAreaSeries areaSeries = XYZChart2D.this.getEditAreaSeries();
            boolean notify = XYZChart2D.this.isNotify();
            try {
                try {
                    double wAmplitude;
                    XYZChart2D.this.setNotify(false);
                    XYZDataViewRange viewRange = drawBounds.getViewRange();
                    double tsRatio = 5.0E-9 * (double)tsDelta;
                    double xRadius = (viewRange.getMaxX() - viewRange.getMinX()) / 100.0 * (double)XYZChart2D.this.surfaceEditRadius;
                    double yRadius = (viewRange.getMaxY() - viewRange.getMinY()) / 100.0 * (double)XYZChart2D.this.surfaceEditRadius;
                    double zAmplitude = XYZChart2D.this.surfaceEditZ ? tsRatio * (double)XYZChart2D.this.surfaceEditAmplitude : Double.NaN;
                    double d = wAmplitude = XYZChart2D.this.surfaceEditW ? tsRatio * (double)XYZChart2D.this.surfaceEditAmplitude : Double.NaN;
                    if (XYZChart2D.this.surfaceEditMode != AreaSurfaceEditMode.Equate) {
                        zAmplitude *= (viewRange.getMaxZ() - viewRange.getMinZ()) / 500.0;
                        wAmplitude *= (viewRange.getMaxW() - viewRange.getMinW()) / 500.0;
                    }
                    areaSeries.modifySurface(XYZChart2D.this.surfaceEditMode, XYZChart2D.this.clickDomainPoint, XYZChart2D.this.currentDomainPoint, xRadius, yRadius, zAmplitude, wAmplitude);
                    if (XYZChart2D.this.editEventListener != null) {
                        XYZChart2D.this.editEventListener.onEdit();
                    }
                    XYZChart2D.this.editSurfaceAnimationTimer.start();
                    XYZChart2D.this.setHasChanges(true);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.stop();
                    XYZChart2D.this.setNotify(notify);
                    XYZChart2D.this.drawRegion.drawIfNeed();
                }
            }
            finally {
                XYZChart2D.this.setNotify(notify);
                XYZChart2D.this.drawRegion.drawIfNeed();
            }
        }
    };
    private final DrawRegion drawRegion = new DrawRegion();
    private final ToolboxContainer toolbox;
    private final BooleanProperty notify = new SimpleBooleanProperty(true);
    private final BooleanProperty hasChanges = new SimpleBooleanProperty(true);

    public XYZChart2D(String xAxisName, String yAxisName, String zAxisName) {
        this(new XYZAxes(xAxisName, yAxisName, zAxisName));
    }

    public XYZChart2D(String xAxisName, String yAxisName, String zAxisName, String wAxisName) {
        this(new XYZAxes(xAxisName, yAxisName, zAxisName, wAxisName));
    }

    public XYZChart2D(XYZAxes axes) {
        this.getStyleClass().setAll((Object[])new String[]{"xyz-chart-2d"});
        String cssResource = ((Object)((Object)this)).getClass().getResource("xyz-chart-2d.css").toExternalForm();
        this.getStylesheets().add((Object)cssResource);
        this.seriesRenderers.addAll(Arrays.asList(new XYZItemSeries2DRenderer(), new XYZAreaSeries2DRenderer()));
        this.axes = axes;
        this.surfaceEditW = axes.getWAxis() != null;
        this.toolbox = new ToolboxContainer();
        this.setCenter((Node)this.drawRegion);
        InvalidationListener propertyChangeListener = il -> {
            this.setHasChanges(true);
            this.drawRegion.drawIfNeed();
        };
        this.deriveItemColorFromZAxis.addListener(propertyChangeListener);
        this.zAxisColorPolicy.addListener(propertyChangeListener);
        this.wAxisColorPolicy.addListener(propertyChangeListener);
        this.seriesList.addListener(propertyChangeListener);
        this.selectedItems.addListener(propertyChangeListener);
        this.editAreaSeries.addListener(il -> {
            this.setTop((Node)(this.getEditAreaSeries() != null ? this.toolbox : null));
            this.setHasChanges(true);
            this.drawRegion.drawIfNeed();
        });
        this.xAxisTickStep.addListener(propertyChangeListener);
        this.yAxisTickStep.addListener(propertyChangeListener);
        this.defaultViewRange.addListener(propertyChangeListener);
        this.selectionViewRange.addListener(propertyChangeListener);
        this.axesPadding.addListener(propertyChangeListener);
        this.showZIsolines.addListener(propertyChangeListener);
        this.showWIsolines.addListener(propertyChangeListener);
    }

    public final BooleanProperty notifyProperty() {
        return this.notify;
    }

    public final boolean isNotify() {
        return this.notifyProperty().get();
    }

    public final void setNotify(boolean notify) {
        this.notifyProperty().set(notify);
        this.drawRegion.drawIfNeed();
    }

    public final BooleanProperty hasChangesProperty() {
        return this.hasChanges;
    }

    public final boolean hasChanges() {
        return this.hasChangesProperty().get();
    }

    protected void setHasChanges(boolean hasChanges) {
        this.hasChanges.set(hasChanges);
    }

    public XYZAxes getAxes() {
        return this.axes;
    }

    public final BooleanProperty deriveItemColorFromZAxisProperty() {
        return this.deriveItemColorFromZAxis;
    }

    public final boolean isDeriveItemColorFromZAxis() {
        return this.deriveItemColorFromZAxisProperty().get();
    }

    public final void setDeriveItemColorFromZAxis(boolean deriveItemColorFromZAxis) {
        this.deriveItemColorFromZAxisProperty().set(deriveItemColorFromZAxis);
    }

    public final ObjectProperty<ItemColorPolicy> zAxisColorPolicyProperty() {
        return this.zAxisColorPolicy;
    }

    public final ItemColorPolicy getZAxisColorPolicy() {
        return (ItemColorPolicy)((Object)this.zAxisColorPolicyProperty().get());
    }

    public final void setZAxisColorPolicy(ItemColorPolicy zAxisColorPolicy) {
        this.zAxisColorPolicyProperty().set((Object)zAxisColorPolicy);
    }

    public final ObjectProperty<ItemColorPolicy> wAxisColorPolicyProperty() {
        return this.wAxisColorPolicy;
    }

    public final ItemColorPolicy getWAxisColorPolicy() {
        return (ItemColorPolicy)((Object)this.wAxisColorPolicyProperty().get());
    }

    public final void setWAxisColorPolicy(ItemColorPolicy wAxisColorPolicy) {
        this.wAxisColorPolicyProperty().set((Object)wAxisColorPolicy);
    }

    public ObservableList<XYZSeries> getSeriesList() {
        return this.seriesList;
    }

    public final ObjectProperty<XYZAreaSeries> editAreaSeriesProperty() {
        return this.editAreaSeries;
    }

    public final XYZAreaSeries getEditAreaSeries() {
        return (XYZAreaSeries)this.editAreaSeriesProperty().get();
    }

    public final void setEditAreaSeries(XYZAreaSeries editAreaSeries) {
        this.editAreaSeriesProperty().set((Object)editAreaSeries);
    }

    public final IntegerProperty xAxisTickStepProperty() {
        return this.xAxisTickStep;
    }

    public final int getXAxisTickStep() {
        return this.xAxisTickStepProperty().get();
    }

    public final void setXAxisTickStep(int xAxisTickStep) {
        this.xAxisTickStepProperty().set(xAxisTickStep);
    }

    public final IntegerProperty yAxisTickStepProperty() {
        return this.yAxisTickStep;
    }

    public final int getYAxisTickStep() {
        return this.yAxisTickStepProperty().get();
    }

    public final void setYAxisTickStep(int yAxisTickStep) {
        this.yAxisTickStepProperty().set(yAxisTickStep);
    }

    public final ObjectProperty<Insets> axesPaddingProperty() {
        return this.axesPadding;
    }

    public final Insets getAxesPadding() {
        return (Insets)this.axesPaddingProperty().get();
    }

    public final void setAxesPadding(Insets axesPadding) {
        this.axesPaddingProperty().set((Object)axesPadding);
    }

    public final BooleanProperty showZIsolinesProperty() {
        return this.showZIsolines;
    }

    public final boolean isShowZIsolines() {
        return this.showZIsolinesProperty().get();
    }

    public final void setShowZIsolines(boolean showZIsolines) {
        this.showZIsolinesProperty().set(showZIsolines);
    }

    public final BooleanProperty showWIsolinesProperty() {
        return this.showWIsolines;
    }

    public final boolean isShowWIsolines() {
        return this.showWIsolinesProperty().get();
    }

    public final void setShowWIsolines(boolean showWIsolines) {
        this.showWIsolinesProperty().set(showWIsolines);
    }

    public final ObjectProperty<XYZDataViewRange> defaultViewRangeProperty() {
        return this.defaultViewRange;
    }

    public final XYZDataViewRange getDefaultViewRange() {
        return (XYZDataViewRange)this.defaultViewRangeProperty().get();
    }

    public final void setDefaultViewRange(XYZDataViewRange defaultViewRange) {
        this.defaultViewRangeProperty().set((Object)defaultViewRange);
    }

    public final ObjectProperty<XYZDataViewRange> selectionViewRangeProperty() {
        return this.selectionViewRange;
    }

    public final XYZDataViewRange getSelectionViewRange() {
        return (XYZDataViewRange)this.selectionViewRangeProperty().get();
    }

    public final void setSelectionViewRange(XYZDataViewRange selectionViewRange) {
        this.selectionViewRangeProperty().set((Object)selectionViewRange);
    }

    public XYZDataViewRange getEffectiveViewRange() {
        XYZDataViewRange range = this.getSelectionViewRange();
        return range != null ? range : this.getDefaultViewRange();
    }

    public EditEventListener getEditEventListener() {
        return this.editEventListener;
    }

    public void setEditEventListener(EditEventListener editEventListener) {
        this.editEventListener = editEventListener;
    }

    public <T extends XYZSeries2DRenderer> T getRenderer(Class<T> clazz) {
        return (T)((XYZSeries2DRenderer)this.seriesRenderers.stream().filter(r -> clazz.isAssignableFrom(r.getClass())).findFirst().orElse(null));
    }

    public static class DrawBounds {
        private final XYZDataViewRange viewRange;
        private final double canvasWidth;
        private final double canvasHeigth;
        private final Insets axesInsets;

        public DrawBounds(XYZDataViewRange viewRange, double canvasWidth, double canvasHeigth, Insets axesInsets) {
            this.viewRange = viewRange;
            this.canvasWidth = canvasWidth;
            this.canvasHeigth = canvasHeigth;
            this.axesInsets = axesInsets;
        }

        public XYZDataViewRange getViewRange() {
            return this.viewRange;
        }

        public double getCanvasWidth() {
            return this.canvasWidth;
        }

        public double getCanvasHeigth() {
            return this.canvasHeigth;
        }

        public Insets getAxesInsets() {
            return this.axesInsets;
        }

        public Point2D domainToDraw(Point2D domainPoint) {
            double xRatio = (domainPoint.getX() - this.viewRange.getMinX()) / (this.viewRange.getMaxX() - this.viewRange.getMinX());
            double drawPointX = this.axesInsets.getLeft() + (this.canvasWidth - this.axesInsets.getLeft() - this.axesInsets.getRight() - 10.799999999999999) * xRatio;
            double yRatio = (domainPoint.getY() - this.viewRange.getMinY()) / (this.viewRange.getMaxY() - this.viewRange.getMinY());
            double drawPointY = this.canvasHeigth - this.axesInsets.getBottom() - (this.canvasHeigth - this.axesInsets.getTop() - this.axesInsets.getBottom() - 10.799999999999999) * yRatio;
            return new Point2D(drawPointX, drawPointY);
        }

        public Point2D drawToDomain(Point2D drawPoint) {
            double xRatio = (drawPoint.getX() - this.axesInsets.getLeft()) / (this.canvasWidth - this.axesInsets.getLeft() - this.axesInsets.getRight() - 10.799999999999999);
            double domainX = this.viewRange.getMinX() + (this.viewRange.getMaxX() - this.viewRange.getMinX()) * xRatio;
            double yRatio = (this.canvasHeigth - drawPoint.getY() - this.axesInsets.getBottom()) / (this.canvasHeigth - this.axesInsets.getTop() - this.axesInsets.getBottom() - 10.799999999999999);
            double domainY = this.viewRange.getMinY() + (this.viewRange.getMaxY() - this.viewRange.getMinY()) * yRatio;
            return new Point2D(domainX, domainY);
        }

        public double getDrawHeigth() {
            return this.canvasHeigth - this.axesInsets.getTop() - this.axesInsets.getBottom();
        }

        public double getDrawWidth() {
            return this.canvasWidth - this.axesInsets.getLeft() - this.axesInsets.getRight();
        }
    }

    private class DrawRegion
    extends Region {
        private final Canvas chartCanvas = new Canvas();
        private final Canvas overlayCanvas = new Canvas();

        public DrawRegion() {
            this.overlayCanvas.setMouseTransparent(true);
            this.getChildren().addAll((Object[])new Node[]{this.chartCanvas, this.overlayCanvas});
            this.initMouseHandlers();
            this.initKeyHandlers();
        }

        protected void initMouseHandlers() {
            this.chartCanvas.setOnMousePressed(e -> {
                XYZChart2D.this.clickPoint = new Point2D(e.getX(), e.getY());
                XYZChart2D.this.currentDomainPoint = XYZChart2D.this.clickDomainPoint = this.getDrawBounds().drawToDomain(XYZChart2D.this.clickPoint);
                XYZChart2D.this.clickViewRange = XYZChart2D.this.getEffectiveViewRange();
                if (XYZChart2D.this.editMode == EditMode.EditBounds && XYZChart2D.this.getEditAreaSeries() != null) {
                    boolean notify = XYZChart2D.this.isNotify();
                    try {
                        XYZChart2D.this.setNotify(false);
                        XYZDataViewRange viewRange = this.getDrawBounds().getViewRange();
                        double xEpsilon = (viewRange.getMaxX() - viewRange.getMinX()) / 20.0;
                        double yEpsilon = (viewRange.getMaxY() - viewRange.getMinY()) / 20.0;
                        XYZAreaSeries editAreaSeries = XYZChart2D.this.getEditAreaSeries();
                        XYAreaBounds xyAreaBounds = editAreaSeries.getXYAreaBounds();
                        if (xyAreaBounds == null) {
                            XYZChart2D.this.currentEditBoundsPoint = XYZChart2D.this.clickDomainPoint;
                            xyAreaBounds = new XYAreaBounds(XYZChart2D.this.currentEditBoundsPoint.getX(), XYZChart2D.this.currentEditBoundsPoint.getY());
                        } else {
                            Point2D foundPoint = xyAreaBounds.findPoint(XYZChart2D.this.clickDomainPoint, xEpsilon, yEpsilon);
                            if (foundPoint != null) {
                                XYZChart2D.this.currentEditBoundsPoint = foundPoint;
                            } else {
                                xyAreaBounds.addPoint(XYZChart2D.this.clickDomainPoint, xEpsilon, yEpsilon);
                                XYZChart2D.this.currentEditBoundsPoint = XYZChart2D.this.clickDomainPoint;
                            }
                        }
                        editAreaSeries.setXYAreaBounds(xyAreaBounds);
                        XYZChart2D.this.currentEditAreaBounds = xyAreaBounds;
                        if (XYZChart2D.this.editEventListener != null) {
                            XYZChart2D.this.editEventListener.onEdit();
                        }
                        XYZChart2D.this.setHasChanges(true);
                    }
                    finally {
                        XYZChart2D.this.setNotify(notify);
                    }
                } else if (XYZChart2D.this.editMode == EditMode.EditSurface && XYZChart2D.this.getEditAreaSeries() != null) {
                    DrawBounds drawBounds = this.getDrawBounds();
                    if (drawBounds.getViewRange() == null) {
                        return;
                    }
                    this.drawMouseSurfaceEditTool(XYZChart2D.this.surfaceEditMode, drawBounds, (MouseEvent)e, true);
                    XYZChart2D.this.editSurfaceAnimationTimer.start();
                }
            });
            this.chartCanvas.setOnMouseDragged(e -> {
                if (e.isPrimaryButtonDown()) {
                    DrawBounds drawBounds = this.getDrawBounds();
                    XYZDataViewRange viewRange = drawBounds.getViewRange();
                    if (viewRange == null) {
                        return;
                    }
                    if (XYZChart2D.this.editMode == EditMode.NoEdit) {
                        if (viewRange.getMinX() > XYZChart2D.this.clickDomainPoint.getX() || viewRange.getMinY() > XYZChart2D.this.clickDomainPoint.getY()) {
                            return;
                        }
                        this.clearOverlay();
                        Point2D domainPoint = drawBounds.drawToDomain(new Point2D(e.getX(), e.getY()));
                        XYZChart2D.this.clickDomainPoint = this.getDrawBounds().drawToDomain(XYZChart2D.this.clickPoint);
                        if (e.isAltDown()) {
                            double deltaX = domainPoint.getX() - XYZChart2D.this.clickDomainPoint.getX();
                            double deltaY = domainPoint.getY() - XYZChart2D.this.clickDomainPoint.getY();
                            boolean notify = XYZChart2D.this.isNotify();
                            try {
                                XYZChart2D.this.setNotify(false);
                                XYZDataViewRange newViewRange = new XYZDataViewRange(XYZChart2D.this.clickViewRange.getMinX() - deltaX, XYZChart2D.this.clickViewRange.getMaxX() - deltaX, XYZChart2D.this.clickViewRange.getMinY() - deltaY, XYZChart2D.this.clickViewRange.getMaxY() - deltaY, XYZChart2D.this.clickViewRange.getMinZ(), XYZChart2D.this.clickViewRange.getMaxZ(), XYZChart2D.this.clickViewRange.getMinW(), XYZChart2D.this.clickViewRange.getMaxW());
                                XYZChart2D.this.setSelectionViewRange(newViewRange);
                            }
                            finally {
                                XYZChart2D.this.setNotify(notify);
                            }
                            XYZChart2D.this.currentDomainPoint = null;
                        } else {
                            XYZChart2D.this.currentDomainPoint = domainPoint;
                            if (e.getX() > XYZChart2D.this.clickPoint.getX()) {
                                DrawRegion.drawOverlaySelection(this.overlayCanvas.getGraphicsContext2D(), XYZChart2D.this.clickPoint, new Point2D(e.getX(), e.getY()));
                            }
                        }
                    } else if (XYZChart2D.this.editMode == EditMode.EditBounds && XYZChart2D.this.getEditAreaSeries() != null && XYZChart2D.this.currentEditBoundsPoint != null) {
                        double xEpsilon = (viewRange.getMaxX() - viewRange.getMinX()) / 20.0;
                        double yEpsilon = (viewRange.getMaxY() - viewRange.getMinY()) / 20.0;
                        XYZAreaSeries editAreaSeries = XYZChart2D.this.getEditAreaSeries();
                        Point2D domainPoint = drawBounds.drawToDomain(new Point2D(e.getX(), e.getY()));
                        boolean notify = XYZChart2D.this.isNotify();
                        try {
                            XYZChart2D.this.setNotify(false);
                            XYZChart2D.this.currentEditAreaBounds.movePoints(XYZChart2D.this.currentEditBoundsPoint, domainPoint, xEpsilon, yEpsilon);
                            editAreaSeries.setXYAreaBounds(XYZChart2D.this.currentEditAreaBounds);
                            XYZChart2D.this.currentEditBoundsPoint = domainPoint;
                            if (XYZChart2D.this.editEventListener != null) {
                                XYZChart2D.this.editEventListener.onEdit();
                            }
                            XYZChart2D.this.setHasChanges(true);
                        }
                        finally {
                            XYZChart2D.this.setNotify(notify);
                        }
                    } else if (XYZChart2D.this.editMode == EditMode.EditSurface && XYZChart2D.this.getEditAreaSeries() != null) {
                        XYZChart2D.this.currentDomainPoint = drawBounds.drawToDomain(new Point2D(e.getX(), e.getY()));
                        this.drawMouseSurfaceEditTool(XYZChart2D.this.surfaceEditMode, drawBounds, (MouseEvent)e, true);
                    }
                }
            });
            this.chartCanvas.setOnMouseMoved(e -> {
                if (XYZChart2D.this.editMode == EditMode.EditSurface && XYZChart2D.this.getEditAreaSeries() != null) {
                    DrawBounds drawBounds = this.getDrawBounds();
                    if (drawBounds.getViewRange() == null) {
                        return;
                    }
                    this.drawMouseSurfaceEditTool(XYZChart2D.this.surfaceEditMode, drawBounds, (MouseEvent)e, false);
                }
            });
            this.chartCanvas.setOnMouseReleased(this::lambda$3);
            this.chartCanvas.setOnScroll(e -> {
                if (e.isDirect()) {
                    return;
                }
                DrawBounds drawBound = this.getDrawBounds();
                if (drawBound.getViewRange() == null) {
                    return;
                }
                boolean notify = XYZChart2D.this.isNotify();
                try {
                    XYZChart2D.this.setNotify(false);
                    Point2D domainPoint = drawBound.drawToDomain(new Point2D(e.getX(), e.getY()));
                    XYZDataViewRange viewRange = drawBound.getViewRange();
                    if (viewRange.getMinX() <= domainPoint.getX() && domainPoint.getX() <= viewRange.getMaxX() && viewRange.getMinY() <= domainPoint.getY() && domainPoint.getY() <= viewRange.getMaxY()) {
                        double deltaY = e.getDeltaY() / 10.0 / 100.0;
                        double newMinX = viewRange.getMinX() + (domainPoint.getX() - viewRange.getMinX()) * deltaY;
                        double newMaxX = viewRange.getMaxX() - (viewRange.getMaxX() - domainPoint.getX()) * deltaY;
                        double newMinY = viewRange.getMinY() + (domainPoint.getY() - viewRange.getMinY()) * deltaY;
                        double newMaxY = viewRange.getMaxY() - (viewRange.getMaxY() - domainPoint.getY()) * deltaY;
                        XYZDataViewRange newViewRange = new XYZDataViewRange(newMinX, newMaxX, newMinY, newMaxY, viewRange.getMinZ(), viewRange.getMaxZ(), viewRange.getMinW(), viewRange.getMaxW());
                        XYZChart2D.this.setSelectionViewRange(newViewRange);
                    }
                }
                finally {
                    XYZChart2D.this.setNotify(notify);
                }
            });
        }

        protected void initKeyHandlers() {
            XYZChart2D.this.setOnKeyReleased(event -> {
                if ((event.getCode() == KeyCode.DELETE || event.getCode() == KeyCode.BACK_SPACE) && XYZChart2D.this.editMode == EditMode.EditBounds && XYZChart2D.this.getEditAreaSeries() != null && XYZChart2D.this.currentEditBoundsPoint != null) {
                    XYZAreaSeries editAreaSeries = XYZChart2D.this.getEditAreaSeries();
                    boolean notify = XYZChart2D.this.isNotify();
                    try {
                        XYZChart2D.this.setNotify(false);
                        XYZChart2D.this.currentEditAreaBounds.removePoint(XYZChart2D.this.currentEditBoundsPoint);
                        if (XYZChart2D.this.currentEditAreaBounds.getPoints().length != 0) {
                            editAreaSeries.setXYAreaBounds(XYZChart2D.this.currentEditAreaBounds);
                        } else {
                            editAreaSeries.setXYAreaBounds(null);
                            XYZChart2D.this.currentEditAreaBounds = null;
                        }
                        XYZChart2D.this.currentEditBoundsPoint = null;
                        if (XYZChart2D.this.editEventListener != null) {
                            XYZChart2D.this.editEventListener.onEdit();
                        }
                        XYZChart2D.this.setHasChanges(true);
                    }
                    finally {
                        XYZChart2D.this.setNotify(notify);
                    }
                }
            });
        }

        protected void layoutChildren() {
            super.layoutChildren();
            this.chartCanvas.setLayoutX(0.0);
            this.chartCanvas.setLayoutY(0.0);
            this.chartCanvas.setWidth(this.getWidth());
            this.chartCanvas.setHeight(this.getHeight());
            this.overlayCanvas.setLayoutX(0.0);
            this.overlayCanvas.setLayoutY(0.0);
            this.overlayCanvas.setWidth(this.getWidth());
            this.overlayCanvas.setHeight(this.getHeight());
            this.draw(this.getWidth(), this.getHeight());
        }

        protected void draw(double width, double height) {
            GraphicsContext ctx = this.chartCanvas.getGraphicsContext2D();
            DrawBounds drawBounds = this.getDrawBounds();
            ctx.save();
            try {
                ctx.clearRect(0.0, 0.0, width, height);
                for (XYZSeries series : XYZChart2D.this.getSeriesList()) {
                    Optional<XYZSeries2DRenderer> renderer = XYZChart2D.this.seriesRenderers.stream().filter(r -> r.canRender(series)).findFirst();
                    renderer.ifPresent(r -> r.drawXYZSeries(XYZChart2D.this, series, ctx, drawBounds));
                }
                XYZChart2D.this.axisRenderer.drawXYZAxes(ctx, XYZChart2D.this, drawBounds);
            }
            finally {
                ctx.restore();
            }
        }

        protected DrawBounds getDrawBounds() {
            return new DrawBounds(XYZChart2D.this.getEffectiveViewRange(), this.getWidth(), this.getHeight(), XYZChart2D.this.getAxesPadding());
        }

        protected void clearOverlay() {
            GraphicsContext ctx = this.overlayCanvas.getGraphicsContext2D();
            ctx.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }

        protected void clearOverlayBounds() {
            GraphicsContext ctx = this.overlayCanvas.getGraphicsContext2D();
            DrawBounds drawBounds = this.getDrawBounds();
            Insets axesInsets = drawBounds.getAxesInsets();
            ctx.clearRect(0.0, 0.0, drawBounds.getCanvasWidth(), axesInsets.getTop());
            ctx.clearRect(0.0, drawBounds.getCanvasHeigth() - axesInsets.getBottom(), drawBounds.getCanvasWidth(), axesInsets.getBottom());
            ctx.clearRect(0.0, 0.0, axesInsets.getLeft(), drawBounds.getCanvasHeigth());
            ctx.clearRect(drawBounds.getCanvasWidth() - axesInsets.getRight(), 0.0, axesInsets.getRight(), drawBounds.getCanvasHeigth());
        }

        protected static void drawOverlaySelection(GraphicsContext ctx, Point2D drawPoint1, Point2D drawPoint2) {
            ctx.save();
            try {
                ctx.setStroke((Paint)new Color(0.0, 0.0, 0.9, 0.7));
                ctx.setLineWidth(0.5);
                ctx.setFill((Paint)new Color(0.0, 0.0, 0.9, 0.1));
                double drawWidth = drawPoint2.getX() - drawPoint1.getX();
                double drawHeight = drawPoint2.getY() - drawPoint1.getY();
                if (drawWidth > 0.0) {
                    if (drawHeight > 0.0) {
                        ctx.fillRect(drawPoint1.getX(), drawPoint1.getY(), drawWidth, drawHeight);
                        ctx.strokeRect(drawPoint1.getX(), drawPoint1.getY(), drawWidth, drawHeight);
                    } else {
                        ctx.fillRect(drawPoint1.getX(), drawPoint1.getY() + drawHeight, drawWidth, Math.abs(drawHeight));
                        ctx.strokeRect(drawPoint1.getX(), drawPoint1.getY() + drawHeight, drawWidth, Math.abs(drawHeight));
                    }
                }
            }
            finally {
                ctx.restore();
            }
        }

        public void drawIfNeed() {
            if (XYZChart2D.this.hasChanges() && XYZChart2D.this.isNotify() && XYZChart2D.this.getParent() != null) {
                this.draw(this.getWidth(), this.getHeight());
                XYZChart2D.this.setHasChanges(false);
            }
        }

        protected void drawMouseSurfaceEditTool(AreaSurfaceEditMode editMode, DrawBounds drawBounds, MouseEvent e, boolean active) {
            this.clearOverlay();
            double radius = 1.1 * drawBounds.getCanvasHeigth() / 100.0 * (double)XYZChart2D.this.surfaceEditRadius;
            DrawRegion.drawSurfaceEditTool(this.overlayCanvas.getGraphicsContext2D(), editMode, new Point2D(e.getX(), e.getY()), radius, XYZChart2D.this.surfaceEditAmplitude, active);
            this.clearOverlayBounds();
        }

        protected static void drawSurfaceEditTool(GraphicsContext ctx, AreaSurfaceEditMode editMode, Point2D drawPoint, double radius, int amplitude, boolean active) {
            ctx.save();
            try {
                double opacity = 0.2 + (double)amplitude / 30.0;
                ctx.setStroke((Paint)Color.VIOLET);
                ctx.setLineWidth((double)(active ? 2 : 1));
                switch (editMode) {
                    case Amplify: {
                        ctx.setFill((Paint)new RadialGradient(0.0, 0.0, drawPoint.getX(), drawPoint.getY(), radius * 1.2, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.VIOLET.deriveColor(1.0, 1.0, 1.0, opacity + (active ? 0.15 : 0.0))), new Stop(1.0, Color.WHITE.deriveColor(1.0, 1.0, 1.0, opacity))}));
                        break;
                    }
                    case Reduce: {
                        ctx.setFill((Paint)new RadialGradient(0.0, 0.0, drawPoint.getX(), drawPoint.getY(), radius * 2.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE.deriveColor(1.0, 1.0, 1.0, opacity + (active ? 0.15 : 0.0))), new Stop(1.0, Color.VIOLET.deriveColor(1.0, 1.0, 1.0, opacity))}));
                        break;
                    }
                    case Equate: {
                        ctx.setFill((Paint)Color.VIOLET.deriveColor(1.0, 1.0, 1.0, 0.2 + (active ? 0.15 : 0.0)));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)editMode));
                    }
                }
                ctx.fillOval(drawPoint.getX() - radius, drawPoint.getY() - radius, radius * 2.0, radius * 2.0);
                ctx.strokeOval(drawPoint.getX() - radius, drawPoint.getY() - radius, radius * 2.0, radius * 2.0);
            }
            finally {
                ctx.restore();
            }
        }

        /*
         * Unable to fully structure code
         */
        private /* synthetic */ void lambda$3(MouseEvent e) {
            XYZChart2D.this.editSurfaceAnimationTimer.stop();
            this.clearOverlay();
            if (XYZChart2D.this.editMode == EditMode.NoEdit && XYZChart2D.this.clickDomainPoint != null && XYZChart2D.this.currentDomainPoint != null) {
                xDistance = e.getX() - XYZChart2D.this.clickPoint.getX();
                yDistance = e.getY() - XYZChart2D.this.clickPoint.getY();
                notify = XYZChart2D.this.isNotify();
                try {
                    XYZChart2D.this.setNotify(false);
                    if (xDistance < -4.0) {
                        XYZChart2D.this.setSelectionViewRange(null);
                    }
                    if (!(xDistance > 1.0) || !(Math.abs(yDistance) > 1.0)) ** GOTO lbl24
                    newViewRange = new XYZDataViewRange(XYZChart2D.this.clickDomainPoint.getX(), XYZChart2D.this.currentDomainPoint.getX(), XYZChart2D.this.clickDomainPoint.getY() < XYZChart2D.this.currentDomainPoint.getY() ? XYZChart2D.this.clickDomainPoint.getY() : XYZChart2D.this.currentDomainPoint.getY(), XYZChart2D.this.clickDomainPoint.getY() < XYZChart2D.this.currentDomainPoint.getY() ? XYZChart2D.this.currentDomainPoint.getY() : XYZChart2D.this.clickDomainPoint.getY(), XYZChart2D.this.clickViewRange.getMinZ(), XYZChart2D.this.clickViewRange.getMaxZ(), XYZChart2D.this.clickViewRange.getMinW(), XYZChart2D.this.clickViewRange.getMaxW());
                    XYZChart2D.this.setSelectionViewRange(newViewRange);
                }
                finally {
                    XYZChart2D.this.setNotify(notify);
                }
            } else if (XYZChart2D.this.editMode == EditMode.EditSurface && XYZChart2D.this.getEditAreaSeries() != null) {
                drawBounds = this.getDrawBounds();
                if (drawBounds.getViewRange() == null) {
                    return;
                }
                this.drawMouseSurfaceEditTool(XYZChart2D.this.surfaceEditMode, drawBounds, e, false);
            }
lbl24:
            // 6 sources

            XYZChart2D.this.clickPoint = null;
            XYZChart2D.this.clickDomainPoint = null;
            XYZChart2D.this.currentDomainPoint = null;
            XYZChart2D.this.clickViewRange = null;
        }
    }

    public static interface EditEventListener {
        public void onEdit();
    }

    private static enum EditMode {
        NoEdit,
        EditBounds,
        EditSurface;

    }

    private class ToolboxContainer
    extends VBox {
        public ToolboxContainer() {
            this.getStyleClass().add((Object)"toolbox-container");
            this.setSpacing(10.0);
            CheckBox editZCB = new CheckBox("Edit Z-Values");
            editZCB.setSelected(XYZChart2D.this.surfaceEditZ);
            CheckBox editWCB = new CheckBox("Edit W-Values");
            editWCB.setSelected(XYZChart2D.this.surfaceEditW);
            editWCB.setDisable(XYZChart2D.this.axes.getWAxis() == null);
            ToggleGroup editModeTg = new ToggleGroup();
            RadioButton disableBtn = new RadioButton("No Edit");
            disableBtn.setSelected(XYZChart2D.this.editMode == EditMode.NoEdit);
            disableBtn.setToggleGroup(editModeTg);
            RadioButton editBoundsBtn = new RadioButton("Edit Bounds");
            editBoundsBtn.setSelected(XYZChart2D.this.editMode == EditMode.EditBounds);
            editBoundsBtn.setToggleGroup(editModeTg);
            RadioButton editSurfaceBtn = new RadioButton("Edit Surface");
            editSurfaceBtn.setSelected(XYZChart2D.this.editMode == EditMode.EditSurface);
            editSurfaceBtn.setToggleGroup(editModeTg);
            ToggleGroup surfaceEditModeTg = new ToggleGroup();
            RadioButton amplifyBtn = new RadioButton("Amplify");
            amplifyBtn.setSelected(XYZChart2D.this.surfaceEditMode == AreaSurfaceEditMode.Amplify);
            amplifyBtn.setToggleGroup(surfaceEditModeTg);
            RadioButton reduceBtn = new RadioButton("Reduce");
            reduceBtn.setSelected(XYZChart2D.this.surfaceEditMode == AreaSurfaceEditMode.Reduce);
            reduceBtn.setToggleGroup(surfaceEditModeTg);
            RadioButton equateBtn = new RadioButton("Equate");
            equateBtn.setSelected(XYZChart2D.this.surfaceEditMode == AreaSurfaceEditMode.Equate);
            equateBtn.setToggleGroup(surfaceEditModeTg);
            Slider radiusSlider = new Slider(1.0, 30.0, (double)XYZChart2D.this.surfaceEditRadius);
            radiusSlider.setSnapToTicks(true);
            radiusSlider.setShowTickLabels(true);
            radiusSlider.setShowTickMarks(true);
            radiusSlider.setBlockIncrement(1.0);
            radiusSlider.setMajorTickUnit(5.0);
            radiusSlider.setMinorTickCount(1);
            radiusSlider.valueProperty().addListener((o, ov, nv) -> {
                int n = XYZChart2D.this.surfaceEditRadius = nv.intValue();
            });
            Slider amplitudeSlider = new Slider(1.0, 20.0, (double)XYZChart2D.this.surfaceEditAmplitude);
            amplitudeSlider.setSnapToTicks(true);
            amplitudeSlider.setShowTickLabels(true);
            amplitudeSlider.setShowTickMarks(true);
            amplitudeSlider.setBlockIncrement(1.0);
            amplitudeSlider.setMajorTickUnit(5.0);
            amplitudeSlider.setMinorTickCount(1);
            amplitudeSlider.valueProperty().addListener((o, ov, nv) -> {
                int n = XYZChart2D.this.surfaceEditAmplitude = nv.intValue();
            });
            HBox editModeBox = new HBox(new Node[]{disableBtn, editBoundsBtn, editSurfaceBtn});
            editModeBox.setAlignment(Pos.CENTER);
            HBox surfaceCBBox = new HBox(5.0, new Node[]{editZCB, editWCB});
            surfaceCBBox.setAlignment(Pos.TOP_CENTER);
            HBox radiusBox = new HBox(5.0, new Node[]{new Label("Size"), radiusSlider});
            radiusBox.setAlignment(Pos.TOP_CENTER);
            HBox amplitudeBox = new HBox(5.0, new Node[]{new Label("Amplitude"), amplitudeSlider});
            amplitudeBox.setAlignment(Pos.TOP_CENTER);
            HBox surfaceBox = new HBox(20.0, new Node[]{surfaceCBBox, new HBox(new Node[]{amplifyBtn, reduceBtn, equateBtn}), radiusBox, amplitudeBox});
            surfaceBox.setAlignment(Pos.CENTER);
            editZCB.selectedProperty().addListener((o, ov, nv) -> {
                boolean bl = XYZChart2D.this.surfaceEditZ = nv.booleanValue();
            });
            editWCB.selectedProperty().addListener((o, ov, nv) -> {
                boolean bl = XYZChart2D.this.surfaceEditW = nv.booleanValue();
            });
            editModeTg.selectedToggleProperty().addListener((o, ov, nv) -> {
                XYZChart2D.this.editMode = nv == editBoundsBtn ? EditMode.EditBounds : (nv == editSurfaceBtn ? EditMode.EditSurface : EditMode.NoEdit);
                if (XYZChart2D.this.editMode != EditMode.EditSurface) {
                    this.getChildren().remove((Object)surfaceBox);
                } else if (!this.getChildren().contains((Object)surfaceBox)) {
                    this.getChildren().add((Object)surfaceBox);
                }
                XYZChart2D.this.drawRegion.clearOverlay();
            });
            surfaceEditModeTg.selectedToggleProperty().addListener((o, ov, nv) -> {
                XYZChart2D.this.surfaceEditMode = nv == amplifyBtn ? AreaSurfaceEditMode.Amplify : (nv == reduceBtn ? AreaSurfaceEditMode.Reduce : AreaSurfaceEditMode.Equate);
            });
            this.getChildren().add((Object)editModeBox);
            if (XYZChart2D.this.editMode == EditMode.EditSurface) {
                this.getChildren().add((Object)surfaceBox);
            }
        }
    }
}

