/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz;

import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.XYZViewSpace;
import de.elpro.ui.fx.charts.xyz.annotations.XYZAnnotationsRenderer;
import de.elpro.ui.fx.charts.xyz.annotations.XYZGridAnnotationRenderer;
import de.elpro.ui.fx.charts.xyz.axis.AxisLegend;
import de.elpro.ui.fx.charts.xyz.axis.ItemColorPolicy;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxes;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxis;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxis3DRenderer;
import de.elpro.ui.fx.charts.xyz.axis.XYZLabeledGridAxis3DRenderer;
import de.elpro.ui.fx.charts.xyz.events.XYZItemMouseClickEvent;
import de.elpro.ui.fx.charts.xyz.events.XYZItemMouseEnteredEvent;
import de.elpro.ui.fx.charts.xyz.events.XYZItemMouseExitedEvent;
import de.elpro.ui.fx.charts.xyz.series.XYZAreaSeries3DRenderer;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import de.elpro.ui.fx.charts.xyz.series.XYZItemSeries3DRenderer;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries3DRenderer;
import de.elpro.ui.fx.charts.xyz.series.XYZSeriesFlatLegendRenderer;
import de.elpro.ui.fx.charts.xyz.series.XYZSeriesLegendRenderer;
import de.elpro.ui.fx.charts.xyz.utils.XYZUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Point3D;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.chart.Chart;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.input.TouchPoint;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

public class XYZChart3D
extends Chart {
    private static final double DATA_VIEW_MARGIN = 0.05;
    private static final XYZDataViewRange EMPTY_SET_VIEW_RANGE = new XYZDataViewRange(0.0, 1.0, 0.0, 1.0, 0.0, 1.0, Double.NaN, Double.NaN);
    private final Group axesContainer = new Group();
    private final Group seriesContainer = new Group();
    private final Pane seriesLegendContainer = new Pane();
    private final Group annotationsContainer = new Group();
    private final AmbientLight ambientLight = new AmbientLight(new Color(0.3, 0.3, 0.3, 1.0));
    private final PointLight pointLight = new PointLight(new Color(0.7, 0.7, 0.7, 1.0));
    private final Group lightsContainer = new Group(new Node[]{this.ambientLight, this.pointLight});
    private final Group root3D = new Group(new Node[]{this.seriesContainer, this.axesContainer});
    private final Group labelsContainer = new Group();
    private final Group root2D = new Group(new Node[]{this.labelsContainer});
    private final Group root = new Group(new Node[]{this.root2D, this.root3D, this.lightsContainer});
    private final PerspectiveCamera camera = new PerspectiveCamera(true);
    private final SubScene scene = new SubScene((Parent)this.root, 1000.0, 1000.0, true, SceneAntialiasing.BALANCED);
    private ContextMenu contextMenu;
    private XYZAxis3DRenderer axisRenderer = new XYZLabeledGridAxis3DRenderer();
    private XYZAnnotationsRenderer annotationsRenderer = new XYZGridAnnotationRenderer();
    private final LinkedHashSet<XYZSeries3DRenderer> seriesRenderers = new LinkedHashSet();
    private XYZSeriesLegendRenderer seriesLegendRenderer = new XYZSeriesFlatLegendRenderer();
    private final XYZAxes axes;
    private final ObjectProperty<ItemColorPolicy> itemColorPolicy = new SimpleObjectProperty((Object)ItemColorPolicy.SeriesBaseColor);
    private final ObservableList<XYZSeries> seriesList = FXCollections.observableArrayList();
    private final ObservableList<XYZItem> selectedItems = FXCollections.observableArrayList();
    private final Map<XYZAxis, AxisLegend> axesLegends;
    private final ArrayList<EventHandler<? super XYZItemMouseClickEvent>> itemMouseClickEventHandlers = new ArrayList();
    private final ArrayList<EventHandler<? super XYZItemMouseEnteredEvent>> itemMouseEnteredEventHandlers = new ArrayList();
    private final ArrayList<EventHandler<? super XYZItemMouseExitedEvent>> itemMouseExitedEventHandlers = new ArrayList();
    private final XYZViewSpace viewSpace = new XYZViewSpace();
    private final BooleanProperty notify = new SimpleBooleanProperty(true);
    private final BooleanProperty hasChanges = new SimpleBooleanProperty(true);
    private final DoubleProperty rotateX = new SimpleDoubleProperty(15.0);
    private final DoubleProperty rotateY = new SimpleDoubleProperty(45.0);
    private final Point3D xAxis = new Point3D(1.0, 0.0, 0.0);
    private final Point3D yAxis = new Point3D(0.0, 1.0, 0.0);
    private double mouseClickX = 0.0;
    private double mouseClickY = 0.0;
    private double cameraX = 0.0;
    private double cameraY = 0.1 * XYZViewSpace.getAxisLentgh();
    private double cameraZ = -3.0 * XYZViewSpace.getAxisLentgh();
    private boolean touch = false;
    private double touchDistance = 0.0;
    private volatile double prevTop = -1.0;
    private volatile double prevLeft = -1.0;
    private volatile double prevWidth = -1.0;
    private volatile double prevHeight = -1.0;

    public XYZChart3D(String xAxisName, String yAxisName, String zAxisName) {
        this(new XYZAxes(xAxisName, yAxisName, zAxisName));
    }

    public XYZChart3D(String xAxisName, String yAxisName, String zAxisName, String wAxisName) {
        this(new XYZAxes(xAxisName, yAxisName, zAxisName, wAxisName));
    }

    public XYZChart3D(XYZAxes axes) {
        this.getStyleClass().setAll((Object[])new String[]{"xyz-chart"});
        String cssResource = ((Object)((Object)this)).getClass().getResource("xyz-chart-3d.css").toExternalForm();
        this.getStylesheets().add((Object)cssResource);
        this.root.getStylesheets().add((Object)cssResource);
        this.axes = axes;
        this.seriesRenderers.addAll(Arrays.asList(new XYZItemSeries3DRenderer(), new XYZAreaSeries3DRenderer()));
        this.axesLegends = this.axisRenderer.createAxesLegends(this);
        this.contextMenu = this.createContextMenu();
        this.setOnContextMenuRequested(event -> {
            if (this.contextMenu.getItems().isEmpty()) {
                return;
            }
            this.contextMenu.show(this.getScene().getWindow(), event.getScreenX(), event.getScreenY());
        });
        if (axes.getWAxis() != null) {
            this.setItemColorPolicy(ItemColorPolicy.WRedToGreen);
        }
        this.init();
        this.initMouseHandlers();
        this.initChartHandlers();
        this.initChangeHandlers();
    }

    protected void init() {
        this.scene.setFill((Paint)Color.TRANSPARENT);
        this.camera.setNearClip(0.1);
        this.camera.setFarClip(1000000.0);
        this.scene.setCamera((Camera)this.camera);
        this.pointLight.setTranslateZ(-XYZViewSpace.getAxisLentgh());
        this.seriesLegendContainer.getStyleClass().add((Object)"series-legend-root");
        this.updateTransorm();
        this.updateCameraPosition();
        this.getChartChildren().addAll((Object[])new Node[]{this.scene, this.seriesLegendContainer, this.annotationsContainer});
        this.axesLegends.values().forEach(r -> {
            boolean bl = this.getChartChildren().add((Object)((Node)r));
        });
    }

    protected void initMouseHandlers() {
        this.scene.setOnMousePressed(e -> {
            this.mouseClickX = e.getSceneX();
            this.mouseClickY = e.getSceneY();
        });
        this.scene.setOnMouseDragged(e -> {
            if (this.touch) {
                return;
            }
            double deltaX = e.getSceneX() - this.mouseClickX;
            double deltaY = e.getSceneY() - this.mouseClickY;
            this.mouseClickX = e.getSceneX();
            this.mouseClickY = e.getSceneY();
            double sceneSize = Math.min(this.getWidth(), this.getHeight());
            if (e.isPrimaryButtonDown()) {
                this.scene.setCursor(Cursor.CLOSED_HAND);
                this.rotateY.set((this.rotateY.get() + 180.0 * -deltaX / sceneSize) % 360.0);
                this.rotateX.set((this.rotateX.get() + 180.0 * deltaY / sceneSize) % 360.0);
                this.updateTransorm();
            } else if (e.isMiddleButtonDown()) {
                this.scene.setCursor(Cursor.MOVE);
                this.cameraX -= deltaX / sceneSize * XYZViewSpace.getAxisLentgh();
                this.cameraY -= deltaY / sceneSize * XYZViewSpace.getAxisLentgh();
                this.updateCameraPosition();
            }
        });
        this.scene.setOnMouseMoved(e -> {
            if (this.annotationsContainer.getChildren().isEmpty()) {
                return;
            }
            this.annotationsContainer.setLayoutX(e.getX() + 30.0);
            this.annotationsContainer.setLayoutY(e.getY() + 10.0);
        });
        this.scene.setOnMouseReleased(e -> {
            this.scene.setCursor(null);
            this.touch = false;
        });
        this.scene.setOnScroll(e -> {
            if (e.isDirect()) {
                return;
            }
            this.cameraZ = this.cameraZ * (100.0 + e.getDeltaY() / 10.0) / 100.0;
            this.updateCameraPosition();
        });
        this.scene.setOnTouchPressed(e -> {
            if (e.getTouchPoints().size() == 2) {
                this.touch = true;
                TouchPoint p1 = (TouchPoint)e.getTouchPoints().get(0);
                TouchPoint p2 = (TouchPoint)e.getTouchPoints().get(1);
                this.mouseClickX = p1.getSceneX();
                this.mouseClickY = p1.getSceneY();
                this.touchDistance = Math.sqrt(Math.pow(p1.getSceneX() - p2.getSceneX(), 2.0) + Math.pow(p1.getSceneY() - p2.getSceneY(), 2.0));
            }
        });
        this.scene.setOnTouchMoved(e -> {
            if (this.touch && e.getTouchPoints().size() == 2) {
                TouchPoint p1 = (TouchPoint)e.getTouchPoints().get(0);
                TouchPoint p2 = (TouchPoint)e.getTouchPoints().get(1);
                double currentX = p1.getSceneX();
                double currentY = p1.getSceneY();
                double deltaX = currentX - this.mouseClickX;
                double deltaY = currentY - this.mouseClickY;
                this.mouseClickX = currentX;
                this.mouseClickY = currentY;
                double sceneSize = Math.min(this.getWidth(), this.getHeight());
                this.cameraX -= deltaX / sceneSize * XYZViewSpace.getAxisLentgh();
                this.cameraY -= deltaY / sceneSize * XYZViewSpace.getAxisLentgh();
                double currentDistance = Math.sqrt(Math.pow(p1.getSceneX() - p2.getSceneX(), 2.0) + Math.pow(p1.getSceneY() - p2.getSceneY(), 2.0));
                double zoomFactor = 1.0 + (currentDistance / this.touchDistance - 1.0) / 2.0;
                this.touchDistance = currentDistance;
                this.cameraZ /= zoomFactor;
                this.updateCameraPosition();
            }
        });
        this.scene.setOnTouchReleased(e -> {
            this.touch = false;
        });
    }

    protected void initChartHandlers() {
        this.addItemMouseClickEventHandler((EventHandler<? super XYZItemMouseClickEvent>)((EventHandler)e -> this.getSelectedItems().setAll((Object[])new XYZItem[]{e.getItem()})));
        this.addItemMouseEnteredEventHandler((EventHandler<? super XYZItemMouseEnteredEvent>)((EventHandler)e -> {
            if (this.annotationsRenderer != null) {
                this.annotationsContainer.getChildren().setAll((Object[])new Node[]{this.annotationsRenderer.createItemAnnotation(this.axes, e.getSeries(), e.getItem())});
            }
        }));
        this.addItemMouseExitedEventHandler((EventHandler<? super XYZItemMouseExitedEvent>)((EventHandler)e -> this.annotationsContainer.getChildren().clear()));
        this.getSelectedItems().addListener(o -> this.seriesContainer.getChildren().filtered(n -> n instanceof Group && n.getUserData() instanceof XYZItemSeries3DRenderer).forEach(n -> {
            XYZItemSeries3DRenderer renderer = (XYZItemSeries3DRenderer)n.getUserData();
            renderer.updateSelection((List<XYZItem>)this.getSelectedItems(), (List<Node>)((Group)n).getChildren());
        }));
    }

    protected void initChangeHandlers() {
        InvalidationListener propListener = o -> {
            this.setHasChanges(true);
            this.drawIfNeed();
        };
        this.itemColorPolicyProperty().addListener(propListener);
        this.invertYAxisProperty().addListener(propListener);
        this.swapZWAxesProperty().addListener(propListener);
        this.getSeriesList().addListener(o -> {
            this.setHasChanges(true);
            this.drawIfNeed();
        });
        this.notifyProperty().addListener(o -> this.drawIfNeed());
        this.sceneProperty().addListener((o, ov, nv) -> {
            if (ov == null && nv != null) {
                this.updateLabels();
            }
        });
    }

    public void draw() {
        XYZDataViewRange dataViewRange = XYZDataViewRange.compute(this.axes, this.seriesList, 0.05);
        if (dataViewRange == null) {
            dataViewRange = EMPTY_SET_VIEW_RANGE;
        }
        this.viewSpace.setViewRange(dataViewRange);
        this.drawAxes();
        this.drawSeries();
        this.drawSeriesLegend();
        this.updateLabels();
        this.setHasChanges(false);
    }

    public void drawIfNeed() {
        if (this.hasChanges() && this.isNotify()) {
            this.draw();
        }
    }

    protected void updateTransorm() {
        Rotate yRotation = new Rotate(this.rotateY.get(), this.yAxis);
        Point3D xAxis = XYZUtils.rotate(this.xAxis, this.rotateY.get(), 0.0);
        Rotate xRotation = new Rotate(this.rotateX.get(), xAxis);
        this.root3D.getTransforms().setAll((Object[])new Transform[]{yRotation, new Rotate(180.0, this.xAxis), xRotation});
        this.updateLabels();
    }

    protected void updateCameraPosition() {
        this.camera.setTranslateX(this.cameraX);
        this.camera.setTranslateY(this.cameraY);
        this.camera.setTranslateZ(this.cameraZ);
    }

    protected void updateLabels() {
        LinkedHashMap<Node, Label> labels = new LinkedHashMap<Node, Label>();
        for (Node node : this.root3D.lookupAll(".label-point-box")) {
            Label label = (Label)node.getUserData();
            labels.put(node, label);
        }
        this.labelsContainer.getChildren().setAll(labels.values());
        this.labelsContainer.applyCss();
        this.labelsContainer.layout();
        for (Map.Entry entry : labels.entrySet()) {
            Node node = (Node)entry.getKey();
            Label label = (Label)entry.getValue();
            Point3D coordinates = node.localToScene(Point3D.ZERO);
            double x = coordinates.getX();
            double y = coordinates.getY();
            double z = coordinates.getZ();
            if (XYZChart3D.findParentByCssClass(node, "x-axis") != null) {
                x -= label.getWidth() / 2.0;
                y -= label.getHeight() / 2.0;
            }
            if (XYZChart3D.findParentByCssClass(node, "y-axis") != null) {
                x -= label.getWidth() / 2.0;
                y -= label.getHeight() / 2.0;
            }
            if (XYZChart3D.findParentByCssClass(node, "z-axis") != null) {
                x -= label.getWidth() / 2.0;
                y -= label.getHeight() / 2.0;
                z -= label.getWidth() / 2.0;
            }
            label.getTransforms().setAll((Object[])new Transform[]{new Translate(x, y, z)});
        }
    }

    protected void drawAxes() {
        this.axesContainer.getChildren().setAll(this.axisRenderer.createXYZVisibles(this.axes, this.viewSpace));
        for (XYZAxis axis : this.getAxes().getAxes()) {
            AxisLegend legend = this.axesLegends.get(axis);
            if (legend == null) continue;
            legend.updateLegend(this.viewSpace);
        }
    }

    protected void drawSeries() {
        ArrayList<Group> nodes = new ArrayList<Group>();
        for (XYZSeries3DRenderer renderer : this.seriesRenderers) {
            List<XYZSeries> rendererSeries;
            List<Node> visibles = renderer.createVisibles(this, rendererSeries = this.seriesList.stream().filter(s -> s.isVisible() && renderer.canRender((XYZSeries)s)).collect(Collectors.toList()), this.viewSpace);
            if (visibles == null) continue;
            Group group = new Group();
            group.getChildren().addAll(visibles);
            group.setUserData((Object)renderer);
            nodes.add(group);
        }
        this.seriesContainer.getChildren().setAll(nodes);
    }

    protected void drawSeriesLegend() {
        Node node = this.seriesLegendRenderer.createLegendVisibles((Collection<XYZSeries>)this.seriesList);
        if (node != null) {
            this.seriesLegendContainer.getChildren().setAll((Object[])new Node[]{this.seriesLegendRenderer.createLegendVisibles((Collection<XYZSeries>)this.seriesList)});
        } else {
            this.seriesLegendContainer.getChildren().clear();
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.drawIfNeed();
    }

    protected void layoutChartChildren(double top, double left, double width, double height) {
        if (this.prevTop == top && this.prevLeft == left && this.prevWidth == width && this.prevHeight == height) {
            return;
        }
        this.seriesLegendContainer.setLayoutX(left + 10.0);
        this.seriesLegendContainer.setLayoutY(top + 30.0);
        this.seriesLegendContainer.setMaxWidth((double)Math.max(200, (int)(width - this.seriesLegendContainer.getLayoutX())));
        for (XYZAxis axis : this.getAxes().getAxes()) {
            AxisLegend legend = this.axesLegends.get(axis);
            if (legend == null) continue;
            legend.layoutInChart(top, left, width, height);
        }
        this.scene.setWidth(width);
        this.scene.setHeight(height);
        this.prevTop = top;
        this.prevLeft = left;
        this.prevWidth = width;
        this.prevHeight = height;
    }

    public static Node findParentByCssClass(Node node, String className) {
        while (node != null) {
            if (node.getStyleClass().contains((Object)className)) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    public Collection<EventHandler<? super XYZItemMouseClickEvent>> getItemMouseClickEventHandlers() {
        return Collections.unmodifiableCollection(this.itemMouseClickEventHandlers);
    }

    public void addItemMouseClickEventHandler(EventHandler<? super XYZItemMouseClickEvent> handler) {
        this.itemMouseClickEventHandlers.add(handler);
    }

    public boolean removeItemMouseClickEventHandler(EventHandler<? super XYZItemMouseClickEvent> handler) {
        return this.itemMouseClickEventHandlers.remove(handler);
    }

    public Collection<EventHandler<? super XYZItemMouseEnteredEvent>> getItemMouseEnteredEventHandlers() {
        return Collections.unmodifiableCollection(this.itemMouseEnteredEventHandlers);
    }

    public void addItemMouseEnteredEventHandler(EventHandler<? super XYZItemMouseEnteredEvent> handler) {
        this.itemMouseEnteredEventHandlers.add(handler);
    }

    public boolean removeItemMouseEnteredEventHandler(EventHandler<? super XYZItemMouseEnteredEvent> handler) {
        return this.itemMouseEnteredEventHandlers.remove(handler);
    }

    public Collection<EventHandler<? super XYZItemMouseExitedEvent>> getItemMouseExitedEventHandlers() {
        return Collections.unmodifiableCollection(this.itemMouseExitedEventHandlers);
    }

    public void addItemMouseExitedEventHandler(EventHandler<? super XYZItemMouseExitedEvent> handler) {
        this.itemMouseExitedEventHandlers.add(handler);
    }

    public boolean removeItemMouseExitedEventHandler(EventHandler<? super XYZItemMouseExitedEvent> handler) {
        return this.itemMouseExitedEventHandlers.remove(handler);
    }

    public XYZAxes getAxes() {
        return this.axes;
    }

    public ObjectProperty<ItemColorPolicy> itemColorPolicyProperty() {
        return this.itemColorPolicy;
    }

    public XYZDataViewRange getDataViewRange() {
        return this.viewSpace.getViewRange();
    }

    public BooleanProperty invertYAxisProperty() {
        return this.viewSpace.invertYAxisProperty();
    }

    public boolean isInvertYAxis() {
        return this.viewSpace.isInvertYAxis();
    }

    public void setInvertYAxis(boolean invertYAxis) {
        this.viewSpace.setInvertYAxis(invertYAxis);
    }

    public BooleanProperty swapZWAxesProperty() {
        return this.viewSpace.swapZWAxesProperty();
    }

    public boolean isSwapZWAxes() {
        return this.viewSpace.isSwapZWAxes();
    }

    public void setSwapZWAxes(boolean swapZWAxes) {
        this.viewSpace.setSwapZWAxes(swapZWAxes);
    }

    public ItemColorPolicy getItemColorPolicy() {
        return (ItemColorPolicy)((Object)this.itemColorPolicyProperty().get());
    }

    public void setItemColorPolicy(ItemColorPolicy policy) {
        this.itemColorPolicyProperty().set((Object)policy);
    }

    public ObservableList<XYZSeries> getSeriesList() {
        return this.seriesList;
    }

    public ObservableList<XYZItem> getSelectedItems() {
        return this.selectedItems;
    }

    public LinkedHashSet<XYZSeries3DRenderer> getSeriesRenderers() {
        return this.seriesRenderers;
    }

    public ContextMenu getContextMenu() {
        return this.contextMenu;
    }

    private ContextMenu createContextMenu() {
        return new ContextMenu();
    }

    public final BooleanProperty notifyProperty() {
        return this.notify;
    }

    public final boolean isNotify() {
        return this.notifyProperty().get();
    }

    public final void setNotify(boolean notify) {
        this.notifyProperty().set(notify);
    }

    public final BooleanProperty hasChangesProperty() {
        return this.hasChanges;
    }

    public final boolean hasChanges() {
        return this.hasChangesProperty().get();
    }

    protected void setHasChanges(boolean hasChanges) {
        this.hasChanges.set(hasChanges);
    }
}

