/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz;

import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Point3D;

public class XYZViewSpace {
    private static final double AXIS_LENTGH = 1000.0;
    private XYZDataViewRange viewRange = null;
    private BooleanProperty invertYAxis = new SimpleBooleanProperty(false);
    private BooleanProperty swapZWAxes = new SimpleBooleanProperty(false);

    public static double getAxisLentgh() {
        return 1000.0;
    }

    public XYZDataViewRange getViewRange() {
        return this.viewRange;
    }

    public void setViewRange(XYZDataViewRange viewRange) {
        this.viewRange = viewRange;
    }

    public final boolean isInvertYAxis() {
        return this.invertYAxisProperty().get();
    }

    public final void setInvertYAxis(boolean invertYAxis) {
        this.invertYAxisProperty().set(invertYAxis);
    }

    public final BooleanProperty swapZWAxesProperty() {
        return this.swapZWAxes;
    }

    public final boolean isSwapZWAxes() {
        return this.swapZWAxesProperty().get();
    }

    public final void setSwapZWAxes(boolean swapZWAxes) {
        this.swapZWAxesProperty().set(swapZWAxes);
    }

    public Point3D getAxesNullPoint() {
        return this.getScenePositionInternal(this.viewRange.getMinX(), !this.swapZWAxes.get() ? this.viewRange.getMinZ() : this.viewRange.getMinW(), this.viewRange.getMinY(), 1000.0);
    }

    private Point3D getScenePositionInternal(double viewX, double viewY, double viewZ, double axisLength) {
        boolean swapZWAxes = this.swapZWAxes.get();
        boolean invertYAxis = this.invertYAxis.get();
        double minZW = !swapZWAxes ? this.viewRange.getMinZ() : this.viewRange.getMinW();
        double maxZW = !swapZWAxes ? this.viewRange.getMaxZ() : this.viewRange.getMaxW();
        double sceneX = axisLength * ((viewX - this.viewRange.getMinX()) / (this.viewRange.getMaxX() - this.viewRange.getMinX()) - 0.5);
        double sceneY = axisLength * ((viewY - minZW) / (maxZW - minZW) - 0.5);
        double sceneZ = axisLength * ((viewZ - this.viewRange.getMinY()) / (this.viewRange.getMaxY() - this.viewRange.getMinY()) - 0.5) * (double)(invertYAxis ? -1 : 1);
        return new Point3D(sceneX, sceneY, sceneZ);
    }

    public Point3D getScenePosition(XYZItem item) {
        return this.getScenePositionInternal(item.getX(), !this.swapZWAxes.get() ? item.getZ() : item.getW(), item.getY(), 1000.0);
    }

    public Point3D getScenePosition(double itemX, double itemY, double itemZ, double itemW) {
        return this.getScenePositionInternal(itemX, !this.swapZWAxes.get() ? itemZ : itemW, itemY, 1000.0);
    }

    public final BooleanProperty invertYAxisProperty() {
        return this.invertYAxis;
    }
}

