/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.annotations;

import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.charts.Messages;
import de.elpro.ui.fx.charts.xyz.annotations.XYZAnnotationsRenderer;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxes;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxis;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;

public class XYZGridAnnotationRenderer
implements XYZAnnotationsRenderer {
    public static final String ITEM_SERIES_NAME_CLASS = "item-series-name";
    public static final String ITEM_AXIS_NAME_CLASS = "item-axis-name";
    public static final String ITEM_AXIS_VALUE_CLASS = "item-value";
    public static final String ITEM_TIMESTAMP_VALUE_CLASS = "item-timestamp-value";
    public static final String ITEM_AXIS_MEASURING_UNIT_CLASS = "item-axis-mu";
    private static final String CSS_FILE = XYZGridAnnotationRenderer.class.getResource("xyz-annotations.css").toExternalForm();

    @Override
    public Node createItemAnnotation(XYZAxes axes, XYZSeries series, XYZItem item) {
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        int row = 0;
        if (series.getName() != null && !series.getName().isEmpty()) {
            Label seriesNameLabel = new Label(series.getName(), series.getGraphic());
            seriesNameLabel.getStyleClass().add((Object)ITEM_SERIES_NAME_CLASS);
            GridPane.setHalignment((Node)seriesNameLabel, (HPos)HPos.CENTER);
            grid.add((Node)seriesNameLabel, 0, row++, 3, 1);
        }
        grid.addRow(row++, new Node[]{XYZGridAnnotationRenderer.createAxisNameLabel(axes.getXAxis()), XYZGridAnnotationRenderer.createAxisValueLabel(item.getX()), XYZGridAnnotationRenderer.createAxisMULabel(axes.getXAxis())});
        grid.addRow(row++, new Node[]{XYZGridAnnotationRenderer.createAxisNameLabel(axes.getYAxis()), XYZGridAnnotationRenderer.createAxisValueLabel(item.getY()), XYZGridAnnotationRenderer.createAxisMULabel(axes.getYAxis())});
        grid.addRow(row++, new Node[]{XYZGridAnnotationRenderer.createAxisNameLabel(axes.getZAxis()), XYZGridAnnotationRenderer.createAxisValueLabel(item.getZ()), XYZGridAnnotationRenderer.createAxisMULabel(axes.getZAxis())});
        if (axes.getWAxis() != null && Double.isFinite(item.getW())) {
            grid.addRow(row++, new Node[]{XYZGridAnnotationRenderer.createAxisNameLabel(axes.getWAxis()), XYZGridAnnotationRenderer.createAxisValueLabel(item.getW()), XYZGridAnnotationRenderer.createAxisMULabel(axes.getWAxis())});
        }
        grid.add((Node)XYZGridAnnotationRenderer.createTimestampNameLabel(), 0, row);
        if (item.getTimetamp() != null) {
            grid.add((Node)XYZGridAnnotationRenderer.createTimestampValueLabel(item.getTimetamp()), 1, row++, 2, 1);
        }
        BorderPane pane = new BorderPane((Node)grid);
        pane.getStylesheets().add((Object)CSS_FILE);
        pane.getStyleClass().add((Object)"item-annotation-root");
        return pane;
    }

    private static Text createTimestampNameLabel() {
        Text label = new Text(Messages.xyzchart_axis_XYZGridAnnotationRenderer_timestamp);
        GridPane.setHalignment((Node)label, (HPos)HPos.RIGHT);
        label.getStyleClass().add((Object)ITEM_AXIS_NAME_CLASS);
        return label;
    }

    private static Text createAxisNameLabel(XYZAxis axis) {
        Text label = new Text(axis.getName());
        GridPane.setHalignment((Node)label, (HPos)HPos.RIGHT);
        label.getStyleClass().add((Object)ITEM_AXIS_NAME_CLASS);
        return label;
    }

    private static Text createTimestampValueLabel(Instant timestamp) {
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, ZoneOffset.systemDefault());
        Text label = new Text(TimeFormatType.DateTimeHMs.format((TemporalAccessor)ldt));
        label.getStyleClass().add((Object)ITEM_TIMESTAMP_VALUE_CLASS);
        return label;
    }

    private static Text createAxisValueLabel(double value) {
        Text label = new Text(NumberFormats.getOptimalFormat((double)value).format(value));
        GridPane.setHalignment((Node)label, (HPos)HPos.RIGHT);
        label.getStyleClass().add((Object)ITEM_AXIS_VALUE_CLASS);
        return label;
    }

    private static Text createAxisMULabel(XYZAxis axis) {
        Text label = new Text(axis.getMeasuringUnit() != null ? String.format("[%s]", axis.getMeasuringUnit()) : null);
        label.getStyleClass().add((Object)ITEM_AXIS_MEASURING_UNIT_CLASS);
        return label;
    }
}

