/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.axis;

import de.elpro.ui.fx.charts.xyz.axis.XYZAxis;
import java.util.Arrays;
import java.util.Collection;
import javafx.scene.paint.Color;

public class XYZAxes {
    public static final Color DEFAULT_X_AXIS_COLOR = Color.GREEN;
    public static final Color DEFAULT_Y_AXIS_COLOR = Color.BLUE;
    public static final Color DEFAULT_Z_AXIS_COLOR = Color.RED;
    public static final Color DEFAULT_W_AXIS_COLOR = Color.BLACK;
    private final XYZAxis xAxis;
    private final XYZAxis yAxis;
    private final XYZAxis zAxis;
    private final XYZAxis wAxis;

    public XYZAxes(String xAxisName, String yAxisName, String zAxisName) {
        this(xAxisName, DEFAULT_X_AXIS_COLOR, yAxisName, DEFAULT_Y_AXIS_COLOR, zAxisName, DEFAULT_Z_AXIS_COLOR);
    }

    public XYZAxes(String xAxisName, String yAxisName, String zAxisName, String wAxisName) {
        this(xAxisName, DEFAULT_X_AXIS_COLOR, yAxisName, DEFAULT_Y_AXIS_COLOR, zAxisName, DEFAULT_Z_AXIS_COLOR, wAxisName, DEFAULT_W_AXIS_COLOR);
    }

    public XYZAxes(String xAxisName, Color xAxisColor, String yAxisName, Color yAxisColor, String zAxisName, Color zAxisColor) {
        this.xAxis = new XYZAxis(xAxisName, xAxisColor);
        this.yAxis = new XYZAxis(yAxisName, yAxisColor);
        this.zAxis = new XYZAxis(zAxisName, zAxisColor);
        this.wAxis = null;
    }

    public XYZAxes(String xAxisName, Color xAxisColor, String yAxisName, Color yAxisColor, String zAxisName, Color zAxisColor, String wAxisName, Color wAxisColor) {
        this.xAxis = new XYZAxis(xAxisName, xAxisColor);
        this.yAxis = new XYZAxis(yAxisName, yAxisColor);
        this.zAxis = new XYZAxis(zAxisName, zAxisColor);
        this.wAxis = new XYZAxis(wAxisName, wAxisColor);
    }

    public XYZAxes(XYZAxis xAxis, XYZAxis yAxis, XYZAxis zAxis, XYZAxis wAxis) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        this.wAxis = wAxis;
    }

    public XYZAxis getXAxis() {
        return this.xAxis;
    }

    public XYZAxis getYAxis() {
        return this.yAxis;
    }

    public XYZAxis getZAxis() {
        return this.zAxis;
    }

    public XYZAxis getWAxis() {
        return this.wAxis;
    }

    public Collection<XYZAxis> getAxes() {
        if (this.wAxis == null) {
            return Arrays.asList(this.xAxis, this.yAxis, this.zAxis);
        }
        return Arrays.asList(this.xAxis, this.yAxis, this.zAxis, this.wAxis);
    }
}

