/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.axis;

import de.elpro.ui.fx.charts.xyz.XYZChart3D;
import de.elpro.ui.fx.charts.xyz.XYZViewSpace;
import de.elpro.ui.fx.charts.xyz.axis.AxisLegend;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxes;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxis;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point3D;
import javafx.scene.Group;
import javafx.scene.Node;

public interface XYZAxis3DRenderer {
    public static final String X_AXIS_STYLE_CLASS = "x-axis";
    public static final String Y_AXIS_STYLE_CLASS = "y-axis";
    public static final String Z_AXIS_STYLE_CLASS = "z-axis";
    public static final String XY_AREA_STYLE_CLASS = "xy-area";
    public static final String XZ_AREA_STYLE_CLASS = "xz-area";
    public static final String YZ_AREA_STYLE_CLASS = "yz-area";
    public static final String AXIS_TICK_LABEL_STYLE_CLASS = "axis-tick-label";
    public static final String AXIS_ARROW_STYLE_CLASS = "axis-arrow-label";
    public static final String AXIS_MEASURING_UNIT_LABEL_STYLE_CLASS = "axis-measuring-unit-label";
    public static final String AXIS_W_LEGEND_CONTAINER_CLASS = "w-axis-legend-container";
    public static final String LABEL_POINT_BOX_STYLE_CLASS = "label-point-box";

    public List<Node> createXYZVisibles(XYZAxes var1, XYZViewSpace var2);

    public Map<XYZAxis, AxisLegend> createAxesLegends(XYZChart3D var1);

    public void updatePositions(Group var1, Point3D var2);

    public static double getLinearAxisTickStep(double range, int tickCount) {
        if (!Double.isFinite(range)) {
            return Double.NaN;
        }
        double unroundedTickSize = range / (double)Math.max(tickCount, 1);
        double x = Math.floor(Math.log10(unroundedTickSize) - 1.0);
        double pow10x = Math.pow(10.0, x);
        double roundedTickRange = Math.floor(unroundedTickSize / pow10x);
        while (x != 0.0) {
            if (x > 0.0) {
                roundedTickRange *= 10.0;
                x -= 1.0;
                continue;
            }
            roundedTickRange /= 10.0;
            x += 1.0;
        }
        return roundedTickRange;
    }
}

