/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.axis;

import de.elpro.ui.fx.charts.xyz.XYZChart2D;
import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxes;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxis2DRenderer;
import java.text.DecimalFormat;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class XYZLabeldGridAxis2DRenderer
implements XYZAxis2DRenderer {
    @Override
    public void drawXYZAxes(GraphicsContext ctx, XYZChart2D chart2d, XYZChart2D.DrawBounds drawBounds) {
        ctx.save();
        try {
            XYZAxes axes = chart2d.getAxes();
            Insets axesInsets = drawBounds.getAxesInsets();
            ctx.clearRect(0.0, 0.0, drawBounds.getCanvasWidth(), axesInsets.getTop());
            ctx.clearRect(0.0, drawBounds.getCanvasHeigth() - axesInsets.getBottom(), drawBounds.getCanvasWidth(), axesInsets.getBottom());
            ctx.clearRect(0.0, 0.0, axesInsets.getLeft(), drawBounds.getCanvasHeigth());
            ctx.clearRect(drawBounds.getCanvasWidth() - axesInsets.getRight(), 0.0, axesInsets.getRight(), drawBounds.getCanvasHeigth());
            ctx.setStroke((Paint)Color.BLACK);
            ctx.setLineWidth(1.0);
            this.drawAxesLines(ctx, drawBounds);
            this.drawArrows(ctx, drawBounds);
            this.drawTicks(ctx, axes, drawBounds, chart2d.getXAxisTickStep(), chart2d.getYAxisTickStep());
            this.drawAxesLabels(ctx, axes, drawBounds);
        }
        finally {
            ctx.restore();
        }
    }

    private void drawAxesLines(GraphicsContext ctx, XYZChart2D.DrawBounds drawBounds) {
        Insets axesInsets = drawBounds.getAxesInsets();
        double height = drawBounds.getCanvasHeigth();
        double width = drawBounds.getCanvasWidth();
        ctx.beginPath();
        ctx.moveTo(axesInsets.getLeft(), axesInsets.getTop());
        ctx.lineTo(axesInsets.getLeft(), height - axesInsets.getBottom());
        ctx.lineTo(width - axesInsets.getRight(), height - axesInsets.getBottom());
        ctx.stroke();
    }

    private void drawArrows(GraphicsContext ctx, XYZChart2D.DrawBounds drawBounds) {
        Insets axesInsets = drawBounds.getAxesInsets();
        double height = drawBounds.getCanvasHeigth();
        double width = drawBounds.getCanvasWidth();
        ctx.beginPath();
        ctx.moveTo(axesInsets.getLeft(), axesInsets.getTop());
        ctx.lineTo(axesInsets.getLeft() - 3.0, axesInsets.getTop() + 9.0);
        ctx.bezierCurveTo(axesInsets.getLeft(), axesInsets.getTop() + 9.0 - 3.0, axesInsets.getLeft(), axesInsets.getTop() + 9.0 - 3.0, axesInsets.getLeft() + 3.0, axesInsets.getTop() + 9.0);
        ctx.closePath();
        ctx.fill();
        ctx.stroke();
        ctx.beginPath();
        ctx.moveTo(width - axesInsets.getRight(), height - axesInsets.getBottom());
        ctx.lineTo(width - axesInsets.getRight() - 9.0, height - axesInsets.getBottom() - 3.0);
        ctx.bezierCurveTo(width - axesInsets.getRight() - 9.0 + 3.0, height - axesInsets.getBottom(), width - axesInsets.getRight() - 9.0 + 3.0, height - axesInsets.getBottom(), width - axesInsets.getRight() - 9.0, height - axesInsets.getBottom() + 3.0);
        ctx.closePath();
        ctx.fill();
        ctx.stroke();
    }

    private void drawTicks(GraphicsContext ctx, XYZAxes axes, XYZChart2D.DrawBounds drawBounds, int xTickStepTarget, int yTickStepTarget) {
        XYZDataViewRange viewRange = drawBounds.getViewRange();
        Insets axesInsets = drawBounds.getAxesInsets();
        double height = drawBounds.getCanvasHeigth();
        double width = drawBounds.getCanvasWidth();
        double xAxisRange = viewRange.getMaxX() - viewRange.getMinX();
        int xAxisTickCount = Math.max((int)((width - axesInsets.getLeft() - axesInsets.getRight()) / (double)xTickStepTarget), 1);
        double xTickStep = XYZAxis2DRenderer.getLinearAxisTickStep(xAxisRange, xAxisTickCount);
        ctx.setFont(new Font(12.0));
        ctx.setFill((Paint)Color.BLACK);
        double xTick = Math.ceil(viewRange.getMinX() / xTickStep) * xTickStep;
        DecimalFormat optimalXAxisFormat = axes.getXAxis().getNumberFormatter().getDecimalFormat(Math.max(Math.abs(viewRange.getMinX()), Math.abs(viewRange.getMaxX())));
        while (xTick < viewRange.getMaxX()) {
            Point2D xTop = drawBounds.domainToDraw(new Point2D(xTick, viewRange.getMaxY()));
            Point2D xBottom = drawBounds.domainToDraw(new Point2D(xTick, viewRange.getMinY()));
            ctx.setStroke((Paint)Color.BLACK);
            ctx.setLineWidth(1.0);
            ctx.setLineDashes(new double[0]);
            ctx.strokeLine(xBottom.getX(), xBottom.getY(), xBottom.getX(), xBottom.getY() + 5.0);
            String text = optimalXAxisFormat.format(xTick);
            ctx.fillText(text, xBottom.getX() - 12.0 * ((double)text.length() / 4.0), xBottom.getY() + 20.0);
            ctx.setStroke((Paint)Color.GRAY);
            ctx.setLineWidth(0.5);
            ctx.setLineDashes(new double[]{10.0, 10.0});
            ctx.strokeLine(xBottom.getX(), xBottom.getY(), xTop.getX(), xTop.getY());
            xTick += xTickStep;
        }
        double yAxisRange = viewRange.getMaxY() - viewRange.getMinY();
        int yAxisTickCount = Math.max((int)((height - axesInsets.getTop() - axesInsets.getBottom()) / (double)yTickStepTarget), 1);
        double yTickStep = XYZAxis2DRenderer.getLinearAxisTickStep(yAxisRange, yAxisTickCount);
        double yTick = Math.ceil(viewRange.getMinY() / yTickStep) * yTickStep;
        DecimalFormat optimalYAxisFormat = axes.getYAxis().getNumberFormatter().getDecimalFormat(Math.max(Math.abs(viewRange.getMinY()), Math.abs(viewRange.getMaxY())));
        while (yTick < viewRange.getMaxY()) {
            Point2D yLeft = drawBounds.domainToDraw(new Point2D(viewRange.getMinX(), yTick));
            Point2D yRight = drawBounds.domainToDraw(new Point2D(viewRange.getMaxX(), yTick));
            ctx.setStroke((Paint)Color.BLACK);
            ctx.setLineWidth(1.0);
            ctx.setLineDashes(new double[0]);
            ctx.strokeLine(yLeft.getX(), yLeft.getY(), yLeft.getX() - 5.0, yLeft.getY());
            String text = optimalYAxisFormat.format(yTick);
            ctx.fillText(text, yLeft.getX() - 12.0 * ((double)text.length() / 4.0) - 20.0, yLeft.getY() + 4.0);
            yTick += yTickStep;
            ctx.setStroke((Paint)Color.GRAY);
            ctx.setLineWidth(0.5);
            ctx.setLineDashes(new double[]{10.0, 10.0});
            ctx.strokeLine(yLeft.getX(), yLeft.getY(), yRight.getX(), yRight.getY());
        }
    }

    private void drawAxesLabels(GraphicsContext ctx, XYZAxes axes, XYZChart2D.DrawBounds drawBounds) {
        double y;
        double x;
        String yAxisLabel;
        String xAxisLabel = axes.getXAxis().getName();
        if (xAxisLabel == null) {
            xAxisLabel = "";
        }
        if (axes.getXAxis().getMeasuringUnit() != null && !axes.getXAxis().getMeasuringUnit().isBlank()) {
            xAxisLabel = String.format("%s [%s]", xAxisLabel, axes.getXAxis().getMeasuringUnit());
        }
        if ((yAxisLabel = axes.getYAxis().getName()) == null) {
            yAxisLabel = "";
        }
        if (axes.getYAxis().getMeasuringUnit() != null && !axes.getYAxis().getMeasuringUnit().isBlank()) {
            yAxisLabel = String.format("%s [%s]", yAxisLabel, axes.getYAxis().getMeasuringUnit());
        }
        Insets axesInsets = drawBounds.getAxesInsets();
        ctx.setFont(Font.font((String)"System Regular", (FontWeight)FontWeight.BOLD, (double)14.0));
        ctx.setFill((Paint)Color.BLACK);
        if (!xAxisLabel.isBlank()) {
            x = axesInsets.getLeft() + (drawBounds.getCanvasWidth() - axesInsets.getLeft() - axesInsets.getRight()) / 2.0;
            y = drawBounds.getCanvasHeigth() - axesInsets.getBottom() + 50.0;
            ctx.fillText(xAxisLabel, x - 14.0 * (double)xAxisLabel.length() / 4.0, y);
        }
        if (!yAxisLabel.isBlank()) {
            x = axesInsets.getLeft() - 50.0;
            y = axesInsets.getTop() + (drawBounds.getCanvasHeigth() - axesInsets.getTop() - axesInsets.getBottom()) / 2.0;
            ctx.translate(x, y);
            ctx.rotate(-90.0);
            ctx.fillText(yAxisLabel, 0.0 - 14.0 * (double)yAxisLabel.length() / 4.0, 0.0);
        }
    }
}

