/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.axis;

import de.elpro.ui.fx.charts.xyz.XYZChart3D;
import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.XYZViewSpace;
import de.elpro.ui.fx.charts.xyz.axis.AxisLegend;
import de.elpro.ui.fx.charts.xyz.axis.WAxisLegend;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxes;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxis;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxis3DRenderer;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import de.elpro.ui.fx.charts.xyz.utils.XYZUtils;
import de.elpro.ui.fx.shapes.Cone;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point3D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Sphere;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

public class XYZLabeledGridAxis3DRenderer
implements XYZAxis3DRenderer {
    private final PhongMaterial tickMeterial = new PhongMaterial(Color.WHITE);

    @Override
    public List<Node> createXYZVisibles(XYZAxes axes, XYZViewSpace viewSpace) {
        double axisLength = XYZViewSpace.getAxisLentgh();
        ArrayList<Node> nodes = new ArrayList<Node>();
        Point3D nullPoint = viewSpace.getAxesNullPoint();
        Point3D yAxisEndPoint = !viewSpace.isInvertYAxis() ? new Point3D(0.0, 0.0, axisLength) : new Point3D(0.0, 0.0, -axisLength);
        nodes.add(XYZLabeledGridAxis3DRenderer.createAxisNode(axes.getXAxis(), nullPoint, new Point3D(axisLength, 0.0, 0.0), axisLength, "x-axis"));
        nodes.add(XYZLabeledGridAxis3DRenderer.createAxisNode(axes.getYAxis(), nullPoint, yAxisEndPoint, axisLength, "y-axis"));
        nodes.add(XYZLabeledGridAxis3DRenderer.createAxisNode(!viewSpace.isSwapZWAxes() ? axes.getZAxis() : axes.getWAxis(), nullPoint, new Point3D(0.0, axisLength, 0.0), axisLength, "z-axis"));
        Sphere nullPointShape = new Sphere(axisLength / 200.0);
        nullPointShape.setTranslateX(nullPoint.getX());
        nullPointShape.setTranslateY(nullPoint.getY());
        nullPointShape.setTranslateZ(nullPoint.getZ());
        nodes.add((Node)nullPointShape);
        nodes.addAll(this.createAxisTickArea(axes, viewSpace));
        return nodes;
    }

    @Override
    public Map<XYZAxis, AxisLegend> createAxesLegends(XYZChart3D chart) {
        LinkedHashMap<XYZAxis, AxisLegend> legends = new LinkedHashMap<XYZAxis, AxisLegend>();
        legends.put(chart.getAxes().getWAxis(), new WAxisLegend(chart));
        return legends;
    }

    @Override
    public void updatePositions(Group visibles, Point3D rotationVector) {
    }

    protected static Node createAxisNode(XYZAxis axis, Point3D nullPoint, Point3D vector, double axisLength, String cssClassName) {
        PhongMaterial material = new PhongMaterial();
        material.setDiffuseColor(axis.getColor());
        double axisRadius = axisLength / 350.0;
        double axisLengthScale = 1.02;
        Cylinder axisCylinder = new Cylinder(axisRadius, axisLength * axisLengthScale);
        axisCylinder.setMaterial((Material)material);
        Cone axisArrow = new Cone(20, (float)axisRadius * 2.0f, 0.0f, (float)axisRadius * 8.0f, axis.getColor());
        axisArrow.getTransforms().addAll((Object[])new Transform[]{new Translate(0.0, axisLength * axisLengthScale / 2.0 + (double)(axisArrow.getHeight() / 2.0f), 0.0), new Rotate(180.0, Rotate.X_AXIS)});
        Box axisLabelBox = new Box(0.0, 0.0, 0.0);
        axisLabelBox.setTranslateY(axisLength * axisLengthScale * 1.1 - axisLength / 2.0);
        axisLabelBox.getStyleClass().add((Object)"label-point-box");
        axisLabelBox.setVisible(false);
        Group axisNode = new Group(new Node[]{axisCylinder, axisArrow, axisLabelBox});
        axisNode.getTransforms().add((Object)new Translate(0.0, axisLength * axisLengthScale / 2.0));
        XYZUtils.applyTranslate((Node)axisNode, nullPoint);
        Label label = new Label();
        label.setText(axis.getName());
        label.getStyleClass().add((Object)"axis-arrow-label");
        axisLabelBox.setUserData((Object)label);
        if (vector.getX() != 0.0) {
            axisNode.getTransforms().add((Object)new Rotate(-90.0, 0.0, -axisLength * axisLengthScale / 2.0, 0.0, Rotate.Z_AXIS));
        }
        if (vector.getZ() != 0.0) {
            double rotationAngle = vector.getZ() > 0.0 ? 90 : -90;
            axisNode.getTransforms().add((Object)new Rotate(rotationAngle, 0.0, -axisLength * axisLengthScale / 2.0, 0.0, Rotate.X_AXIS));
        }
        axisNode.getStyleClass().add((Object)cssClassName);
        return axisNode;
    }

    protected List<Node> createAxisTickArea(XYZAxes axes, XYZViewSpace viewSpace) {
        ArrayList<Node> visibles = new ArrayList<Node>();
        double areaShift = 0.005;
        double axisLength = XYZViewSpace.getAxisLentgh();
        XYZDataViewRange dataViewRange = viewSpace.getViewRange();
        Point3D nullPoint = viewSpace.getAxesNullPoint();
        Rectangle xyTickArea = new Rectangle(axisLength, axisLength);
        xyTickArea.getStyleClass().add((Object)"xy-area");
        xyTickArea.setTranslateX(nullPoint.getX());
        xyTickArea.setTranslateY(-axisLength * (1.0 + areaShift));
        xyTickArea.setRotate(90.0);
        xyTickArea.setRotationAxis(Rotate.X_AXIS);
        visibles.add((Node)xyTickArea);
        Rectangle xzTickArea = new Rectangle(axisLength, axisLength);
        xzTickArea.getStyleClass().add((Object)"xz-area");
        xzTickArea.setTranslateX(nullPoint.getX());
        xzTickArea.setTranslateY(nullPoint.getY());
        xzTickArea.setTranslateZ(nullPoint.getZ() - axisLength * areaShift - (!viewSpace.isInvertYAxis() ? 0.0 : axisLength));
        visibles.add((Node)xzTickArea);
        Rectangle yzTickArea = new Rectangle(axisLength, axisLength);
        yzTickArea.getStyleClass().add((Object)"yz-area");
        yzTickArea.setTranslateX(-axisLength * (1.0 + areaShift));
        yzTickArea.setTranslateY(nullPoint.getY());
        yzTickArea.setRotate(90.0);
        yzTickArea.setRotationAxis(Rotate.Y_AXIS);
        visibles.add((Node)yzTickArea);
        double xRange = dataViewRange.getMaxX() - dataViewRange.getMinX();
        double xTickStep = XYZAxis3DRenderer.getLinearAxisTickStep(xRange, 10);
        double yRange = dataViewRange.getMaxY() - dataViewRange.getMinY();
        double yTickStep = XYZAxis3DRenderer.getLinearAxisTickStep(yRange, 10);
        double zwRange = !viewSpace.isSwapZWAxes() ? dataViewRange.getMaxZ() - dataViewRange.getMinZ() : dataViewRange.getMaxW() - dataViewRange.getMinW();
        double zwTickStep = XYZAxis3DRenderer.getLinearAxisTickStep(zwRange, 10);
        Group xOrientedGroup = new Group();
        Group yOrientedGroup = new Group();
        Group zOrientedGroup = new Group();
        xOrientedGroup.getStyleClass().add((Object)"x-axis");
        yOrientedGroup.getStyleClass().add((Object)"y-axis");
        zOrientedGroup.getStyleClass().add((Object)"z-axis");
        visibles.add((Node)xOrientedGroup);
        visibles.add((Node)yOrientedGroup);
        visibles.add((Node)zOrientedGroup);
        double xTick = Math.ceil(dataViewRange.getMinX() / xTickStep) * xTickStep;
        DecimalFormat optimalXAxisFormat = axes.getXAxis().getNumberFormatter().getDecimalFormat(Math.max(Math.abs(dataViewRange.getMinX()), Math.abs(dataViewRange.getMaxX())));
        while (xTick < dataViewRange.getMaxX()) {
            Point3D tickNullPoint = !viewSpace.isInvertYAxis() ? viewSpace.getScenePosition(xTick, dataViewRange.getMinY(), dataViewRange.getMinZ(), dataViewRange.getMinW()) : viewSpace.getScenePosition(xTick, dataViewRange.getMaxY(), dataViewRange.getMinZ(), dataViewRange.getMinW());
            if (Math.abs(tickNullPoint.getX() - nullPoint.getX()) < axisLength / 100.0) {
                xTick += xTickStep;
                continue;
            }
            String xTickStr = optimalXAxisFormat.format(xTick);
            Group line1 = XYZLabeledGridAxis3DRenderer.createDashedYLine(xTickStr, axisLength, this.tickMeterial, tickNullPoint);
            yOrientedGroup.getChildren().add((Object)line1);
            Group line2 = XYZLabeledGridAxis3DRenderer.createDashedYLine(xTickStr, axisLength, this.tickMeterial, tickNullPoint);
            line2.getTransforms().addAll((Object[])new Transform[]{new Rotate(90.0, Rotate.X_AXIS)});
            zOrientedGroup.getChildren().add((Object)line2);
            xTick += xTickStep;
        }
        double yTick = Math.ceil(dataViewRange.getMinY() / yTickStep) * yTickStep;
        DecimalFormat optimalZAxisFormat = axes.getYAxis().getNumberFormatter().getDecimalFormat(Math.max(Math.abs(dataViewRange.getMinY()), Math.abs(dataViewRange.getMaxY())));
        while (yTick < dataViewRange.getMaxY()) {
            Point3D tickNullPoint = viewSpace.getScenePosition(new XYZItem(dataViewRange.getMinX(), yTick, dataViewRange.getMinZ(), dataViewRange.getMinW()));
            if (Math.abs(tickNullPoint.getZ() - nullPoint.getZ()) < axisLength / 100.0) {
                yTick += yTickStep;
                continue;
            }
            String yTickStr = optimalZAxisFormat.format(yTick);
            Group line1 = XYZLabeledGridAxis3DRenderer.createDashedYLine(yTickStr, axisLength, this.tickMeterial, tickNullPoint);
            zOrientedGroup.getChildren().add((Object)line1);
            Group line2 = XYZLabeledGridAxis3DRenderer.createDashedYLine(yTickStr, axisLength, this.tickMeterial, tickNullPoint);
            line2.getTransforms().addAll((Object[])new Transform[]{new Rotate(-90.0, Rotate.Z_AXIS)});
            xOrientedGroup.getChildren().add((Object)line2);
            yTick += yTickStep;
        }
        double minZW = !viewSpace.isSwapZWAxes() ? dataViewRange.getMinZ() : dataViewRange.getMinW();
        double maxZW = !viewSpace.isSwapZWAxes() ? dataViewRange.getMaxZ() : dataViewRange.getMaxW();
        double zwTick = Math.ceil(minZW / zwTickStep) * zwTickStep;
        DecimalFormat optimalYAxisFormat = axes.getZAxis().getNumberFormatter().getDecimalFormat(Math.max(Math.abs(minZW), Math.abs(maxZW)));
        while (zwTick < maxZW) {
            double tickY = viewSpace.isInvertYAxis() ? dataViewRange.getMaxY() : dataViewRange.getMinY();
            double tickZ = viewSpace.isSwapZWAxes() ? dataViewRange.getMinZ() : zwTick;
            double tickW = viewSpace.isSwapZWAxes() ? zwTick : dataViewRange.getMinW();
            Point3D tickNullPoint = viewSpace.getScenePosition(dataViewRange.getMinX(), tickY, tickZ, tickW);
            if (Math.abs(tickNullPoint.getY() - nullPoint.getY()) < axisLength / 100.0) {
                zwTick += zwTickStep;
                continue;
            }
            String zwTickStr = optimalYAxisFormat.format(zwTick);
            Group line1 = XYZLabeledGridAxis3DRenderer.createDashedYLine(zwTickStr, axisLength, this.tickMeterial, tickNullPoint);
            line1.getTransforms().addAll((Object[])new Transform[]{new Rotate(-90.0, Rotate.Z_AXIS)});
            xOrientedGroup.getChildren().add((Object)line1);
            Group line2 = XYZLabeledGridAxis3DRenderer.createDashedYLine(zwTickStr, axisLength, this.tickMeterial, tickNullPoint);
            line2.getTransforms().addAll((Object[])new Transform[]{new Rotate(90.0, Rotate.X_AXIS)});
            yOrientedGroup.getChildren().add((Object)line2);
            zwTick += zwTickStep;
        }
        double muPadding = axisLength * 1.1;
        if (axes.getXAxis().getMeasuringUnit() != null) {
            Box xAxisMu1 = XYZLabeledGridAxis3DRenderer.createMeasuringUnitHoder(axes.getXAxis(), new Point3D(0.0, muPadding - axisLength / 2.0, -axisLength / 2.0));
            Box xAxisMu2 = XYZLabeledGridAxis3DRenderer.createMeasuringUnitHoder(axes.getXAxis(), new Point3D(0.0, -axisLength / 2.0, muPadding - axisLength / 2.0));
            yOrientedGroup.getChildren().add((Object)xAxisMu1);
            zOrientedGroup.getChildren().add((Object)xAxisMu2);
        }
        if (axes.getYAxis().getMeasuringUnit() != null) {
            Box yAxisMu1 = XYZLabeledGridAxis3DRenderer.createMeasuringUnitHoder(axes.getYAxis(), new Point3D(muPadding - axisLength / 2.0, -axisLength / 2.0, 0.0));
            Box yAxisMu2 = XYZLabeledGridAxis3DRenderer.createMeasuringUnitHoder(axes.getYAxis(), new Point3D(-axisLength / 2.0, muPadding - axisLength / 2.0, 0.0));
            xOrientedGroup.getChildren().add((Object)yAxisMu1);
            zOrientedGroup.getChildren().add((Object)yAxisMu2);
        }
        if (!viewSpace.isSwapZWAxes() && axes.getZAxis().getMeasuringUnit() != null) {
            Box zAxisMu1 = XYZLabeledGridAxis3DRenderer.createMeasuringUnitHoder(axes.getZAxis(), new Point3D(muPadding - axisLength / 2.0, 0.0, -axisLength / 2.0));
            Box zAxisMu2 = XYZLabeledGridAxis3DRenderer.createMeasuringUnitHoder(axes.getZAxis(), new Point3D(-axisLength / 2.0, 0.0, muPadding - axisLength / 2.0));
            xOrientedGroup.getChildren().add((Object)zAxisMu1);
            yOrientedGroup.getChildren().add((Object)zAxisMu2);
        }
        if (viewSpace.isSwapZWAxes() && axes.getWAxis().getMeasuringUnit() != null) {
            Box wAxisMu1 = XYZLabeledGridAxis3DRenderer.createMeasuringUnitHoder(axes.getWAxis(), new Point3D(muPadding - axisLength / 2.0, 0.0, -axisLength / 2.0));
            Box wAxisMu2 = XYZLabeledGridAxis3DRenderer.createMeasuringUnitHoder(axes.getWAxis(), new Point3D(-axisLength / 2.0, 0.0, muPadding - axisLength / 2.0));
            xOrientedGroup.getChildren().add((Object)wAxisMu1);
            yOrientedGroup.getChildren().add((Object)wAxisMu2);
        }
        return visibles;
    }

    private static Box createMeasuringUnitHoder(XYZAxis axis, Point3D point) {
        Box tickLabelBox = new Box(0.0, 0.0, 0.0);
        tickLabelBox.getStyleClass().add((Object)"label-point-box");
        tickLabelBox.setVisible(false);
        Label label = new Label();
        label.setText(String.format("[%s]", axis.getMeasuringUnit()));
        label.getStyleClass().addAll((Object[])new String[]{"axis-measuring-unit-label"});
        tickLabelBox.setUserData((Object)label);
        XYZUtils.applyTranslate((Node)tickLabelBox, point);
        return tickLabelBox;
    }

    private static Group createDashedYLine(String tickText, double axisLength, PhongMaterial tickMaterial, Point3D nullPoint) {
        Group line = new Group();
        double l = 0.0;
        double linePartLength = axisLength;
        double lineSpacing = axisLength / 40.0;
        while (l < axisLength) {
            Cylinder linePart = new Cylinder(axisLength / 600.0, Math.min(linePartLength, axisLength - l));
            linePart.setMaterial((Material)tickMaterial);
            linePart.setTranslateY(l + linePartLength / 2.0);
            line.getChildren().add((Object)linePart);
            l += linePartLength + lineSpacing;
        }
        Box tickLabelBox = new Box(0.0, 0.0, 0.0);
        tickLabelBox.setTranslateY(axisLength * 1.04);
        tickLabelBox.getStyleClass().add((Object)"label-point-box");
        tickLabelBox.setVisible(false);
        Label label = new Label(tickText);
        label.getStyleClass().addAll((Object[])new String[]{"axis-tick-label"});
        tickLabelBox.setUserData((Object)label);
        line.getChildren().add((Object)tickLabelBox);
        XYZUtils.applyTranslate((Node)line, nullPoint);
        return line;
    }
}

