/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.series;

import de.elpro.ui.fx.charts.xyz.XYZChart3D;
import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.XYZViewSpace;
import de.elpro.ui.fx.charts.xyz.axis.ItemColorPolicy;
import de.elpro.ui.fx.charts.xyz.series.XYZAreaSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries3DRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import javafx.geometry.Point3D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;

public class XYZAreaSeries3DRenderer
implements XYZSeries3DRenderer {
    private int resolution = 100;

    public int getResulution() {
        return this.resolution;
    }

    public void setResulution(int resulution) {
        if (resulution < 2) {
            throw new IllegalArgumentException();
        }
        this.resolution = resulution;
    }

    @Override
    public boolean canRender(XYZSeries series) {
        return series instanceof XYZAreaSeries;
    }

    @Override
    public List<Node> createVisibles(XYZChart3D chart, Collection<XYZSeries> seriesList, XYZViewSpace viewSpace) {
        if (seriesList.isEmpty()) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>(seriesList.size());
        for (XYZSeries series : seriesList) {
            XYZAreaSeries functionSeries = (XYZAreaSeries)series;
            Group g = new Group();
            g.getChildren().setAll((Object[])new Node[]{XYZAreaSeries3DRenderer.createNodeForSeries(functionSeries, viewSpace, chart.getItemColorPolicy(), this.resolution)});
            functionSeries.setInvalidationListener(o -> g.getChildren().setAll((Object[])new Node[]{XYZAreaSeries3DRenderer.createNodeForSeries(functionSeries, viewSpace, chart.getItemColorPolicy(), this.resolution)}));
            nodes.add((Node)g);
        }
        return nodes;
    }

    private static Node createNodeForSeries(XYZAreaSeries functionSeries, XYZViewSpace viewSpace, ItemColorPolicy itemColorPolicy, int resolution) {
        TriangleMesh mesh = new TriangleMesh();
        double axisLength = XYZViewSpace.getAxisLentgh();
        XYZDataViewRange dataViewRange = viewSpace.getViewRange();
        double startX = dataViewRange.getMinX();
        double startY = dataViewRange.getMinY();
        int xSegments = resolution;
        int ySegments = resolution;
        double[] xs = new double[xSegments + 1];
        double[] ys = new double[ySegments + 1];
        double xRange = dataViewRange.getMaxX() - dataViewRange.getMinX();
        double yRange = dataViewRange.getMaxY() - dataViewRange.getMinY();
        Point3D nullPoint = viewSpace.getAxesNullPoint();
        float minY = (float)nullPoint.getY();
        float maxY = minY + (float)axisLength;
        int x2 = 0;
        while (x2 <= xSegments) {
            xs[x2] = startX + xRange * ((double)x2 / (double)xSegments);
            ++x2;
        }
        int y = 0;
        while (y <= ySegments) {
            ys[y] = startY + yRange * ((double)y / (double)ySegments);
            ++y;
        }
        double[][][] resultZW = functionSeries.getZW(xs, ys);
        double maxZ = dataViewRange.getMaxZ();
        double maxW = dataViewRange.getMaxW();
        int x3 = 0;
        while (x3 <= xSegments) {
            int y2 = 0;
            while (y2 <= ySegments) {
                double itemW;
                double itemX = xs[x3];
                double itemY = ys[y2];
                double itemZ = resultZW[x3][y2][0];
                double d = itemW = functionSeries.hasW() ? resultZW[x3][y2][1] : Double.NaN;
                if (itemZ > maxZ) {
                    itemZ = maxZ + 1.0E-4;
                }
                if (itemW > maxW) {
                    itemW = maxW + 1.0E-4;
                }
                Point3D scenePoint = viewSpace.getScenePosition(itemX, itemY, itemZ, itemW);
                mesh.getPoints().addAll(new float[]{(float)scenePoint.getX(), (float)scenePoint.getY(), (float)scenePoint.getZ()});
                float texX = (float)x3 / (float)(xSegments + 1);
                float texY = (float)y2 / (float)(ySegments + 1);
                mesh.getTexCoords().addAll(new float[]{texX, texY});
                ++y2;
            }
            if (x3 != 0) {
                y2 = 0;
                while (y2 < ySegments) {
                    int i1 = (x3 - 1) * (ySegments + 1) + y2;
                    int i2 = i1 + 1;
                    int j1 = x3 * (ySegments + 1) + y2;
                    int j2 = j1 + 1;
                    float i1Y = mesh.getPoints().get(i1 * 3 + 1);
                    float i2Y = mesh.getPoints().get(i2 * 3 + 1);
                    float j1Y = mesh.getPoints().get(j1 * 3 + 1);
                    float j2Y = mesh.getPoints().get(j2 * 3 + 1);
                    boolean someAdded = false;
                    if (minY <= i1Y && i1Y <= maxY && minY <= i2Y && i2Y <= maxY && minY <= j1Y && j1Y <= maxY) {
                        mesh.getFaces().addAll(new int[]{i2, i2, j1, j1, i1, i1, i2, i2, i1, i1, j1, j1});
                        someAdded = true;
                    }
                    if (minY <= i2Y && i2Y <= maxY && minY <= j1Y && j1Y <= maxY && minY <= j2Y && j2Y <= maxY) {
                        mesh.getFaces().addAll(new int[]{i2, i2, j2, j2, j1, j1, i2, i2, j1, j1, j2, j2});
                    }
                    if (!someAdded) {
                        if (minY <= i1Y && i1Y <= maxY && minY <= j2Y && j2Y <= maxY && minY <= j1Y && j1Y <= maxY) {
                            mesh.getFaces().addAll(new int[]{j2, j2, j1, j1, i1, i1, j2, j2, i1, i1, j1, j1});
                        }
                        if (minY <= i1Y && i1Y <= maxY && minY <= i2Y && i2Y <= maxY && minY <= j2Y && j2Y <= maxY) {
                            mesh.getFaces().addAll(new int[]{j2, j2, i1, i1, i2, i2, j2, j2, i2, i2, i1, i1});
                        }
                    }
                    ++y2;
                }
            }
            ++x3;
        }
        MeshView mv = new MeshView((Mesh)mesh);
        Color baseColor = XYZSeries3DRenderer.getColor(functionSeries);
        WritableImage imgPalette = new WritableImage((xSegments + 1) * 5, (ySegments + 1) * 5);
        PixelWriter pw = imgPalette.getPixelWriter();
        IntStream.range(0, xSegments + 1).boxed().forEach(x -> IntStream.range(0, ySegments + 1).boxed().forEach(y -> {
            Color wColor;
            if (functionSeries.hasW()) {
                double viewZW;
                double minZW = viewSpace.isSwapZWAxes() ? dataViewRange.getMinZ() : dataViewRange.getMinW();
                double maxZW = viewSpace.isSwapZWAxes() ? dataViewRange.getMaxZ() : dataViewRange.getMaxW();
                double d = viewZW = viewSpace.isSwapZWAxes() ? resultZW[x][y][0] : resultZW[x][y][1];
                wColor = Double.isFinite(viewZW) ? itemColorPolicy.mapHpToColor(baseColor, viewZW, minZW, maxZW).deriveColor(1.0, 1.0, 1.0, functionSeries.getOpacityFactor()) : Color.TRANSPARENT;
            } else {
                wColor = baseColor.deriveColor(1.0, 1.0, 1.0, functionSeries.getOpacityFactor());
            }
            int i = 0;
            while (i < 5) {
                int j = 0;
                while (j < 5) {
                    pw.setColor(x * 5 + i, y * 5 + j, wColor);
                    ++j;
                }
                ++i;
            }
        }));
        if (functionSeries.isShowGrid()) {
            int step = resolution / 5;
            IntStream.range(0, (xSegments + 1) * 5 / step).boxed().forEach(x -> IntStream.range(0, (ySegments + 1) * 5 / step).boxed().forEach(y -> {
                Color wColor = functionSeries.getGridColor();
                int i = 0;
                while (i < step) {
                    pw.setColor(x * step + i, y * step, wColor);
                    pw.setColor(x * step, y * step + i, wColor);
                    ++i;
                }
            }));
        }
        PhongMaterial material = new PhongMaterial();
        material.setDiffuseMap((Image)imgPalette);
        mv.setMaterial((Material)material);
        return mv;
    }
}

