/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.series;

import de.elpro.ui.fx.charts.xyz.series.AreaSurfaceEditMode;
import de.elpro.ui.fx.charts.xyz.series.XYAreaBounds;
import de.elpro.ui.fx.charts.xyz.series.XYZAreaSeries;
import javafx.geometry.Point2D;

public class XYZFunctionSeries
extends XYZAreaSeries {
    private final ZFunction zFunction;
    private final WFunction wFunction;
    private double opacityFactor = 1.0;

    public XYZFunctionSeries(String name, ZFunction yFunction) {
        this(name, yFunction, null);
    }

    public XYZFunctionSeries(String name, ZFunction zFunction, WFunction wFunction) {
        super(name);
        this.zFunction = zFunction;
        this.wFunction = wFunction;
    }

    @Override
    public double[][][] getZW(double[] xs, double[] ys) {
        double[][][] result = new double[xs.length][ys.length][this.hasW() ? 2 : 1];
        int x = 0;
        while (x < xs.length) {
            int y = 0;
            while (y < ys.length) {
                result[x][y][0] = this.getZ(xs[x], ys[y]);
                if (this.hasW()) {
                    result[x][y][1] = this.getW(xs[x], ys[y], result[x][y][0]);
                }
                ++y;
            }
            ++x;
        }
        return result;
    }

    public double getZ(double x, double y) {
        return this.zFunction.getZ(x, y);
    }

    public double getW(double x, double y, double z) {
        return this.wFunction.getW(x, y, z);
    }

    @Override
    public boolean hasW() {
        return this.wFunction != null;
    }

    @Override
    public double getOpacityFactor() {
        return this.opacityFactor;
    }

    @Override
    public void setOpacityFactor(double opacityFactor) {
        this.opacityFactor = opacityFactor;
    }

    @Override
    public XYAreaBounds getXYAreaBounds() {
        return null;
    }

    @Override
    public void setXYAreaBounds(XYAreaBounds xyBounds) {
    }

    @Override
    public void modifySurface(AreaSurfaceEditMode editMode, Point2D initialPoint, Point2D editPoint, double xRadius, double yRadius, double zAmplitude, double wAmplitude) {
    }

    public static interface WFunction {
        public double getW(double var1, double var3, double var5);
    }

    public static interface ZFunction {
        public double getZ(double var1, double var3);
    }
}

