/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.series;

import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XYZItemSeries
extends XYZSeries {
    private double defaultItemSize = 2.0;
    private double lineWidth = Double.NaN;
    private final Map<XYZItem, Double> itemSizes = new HashMap<XYZItem, Double>();
    private boolean showItemLabels = false;
    private final List<XYZItem> items = new ArrayList<XYZItem>();

    public XYZItemSeries(String name) {
        super(name);
    }

    public List<XYZItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void addItem(XYZItem item) {
        this.items.add(item);
    }

    public void addItems(List<XYZItem> items) {
        this.items.addAll(items);
    }

    public double getDefaultItemSize() {
        return this.defaultItemSize;
    }

    public void setDefaultItemSize(double defaultItemSize) {
        this.defaultItemSize = defaultItemSize;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public boolean isShowItemLabels() {
        return this.showItemLabels;
    }

    public void setShowItemLabels(boolean showItemLabels) {
        this.showItemLabels = showItemLabels;
    }

    public double getItemSize(XYZItem item) {
        Double itemSize = this.itemSizes.get(item);
        if (itemSize == null) {
            return this.getDefaultItemSize();
        }
        return itemSize;
    }

    public void setItemSize(XYZItem item, Double size) {
        if (size == null) {
            this.itemSizes.remove(item);
        } else {
            this.itemSizes.put(item, size);
        }
    }

    public void clearItems() {
        this.items.clear();
        this.itemSizes.clear();
    }
}

