/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.series;

import de.elpro.ui.fx.charts.xyz.XYZChart2D;
import de.elpro.ui.fx.charts.xyz.axis.ItemColorPolicy;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import de.elpro.ui.fx.charts.xyz.series.XYZItemSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries2DRenderer;
import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class XYZItemSeries2DRenderer
implements XYZSeries2DRenderer {
    @Override
    public boolean canRender(XYZSeries series) {
        return series instanceof XYZItemSeries;
    }

    @Override
    public void drawXYZSeries(XYZChart2D chart, XYZSeries series, GraphicsContext ctx, XYZChart2D.DrawBounds drawBounds) {
        ctx.save();
        try {
            boolean drawLine;
            ItemColorPolicy itemColorPolicy = chart.isDeriveItemColorFromZAxis() ? (series.getZAxisColorPolicy() != null ? series.getZAxisColorPolicy() : chart.getZAxisColorPolicy()) : (series.getWAxisColorPolicy() != null ? series.getWAxisColorPolicy() : chart.getWAxisColorPolicy());
            XYZItemSeries itemSeries = (XYZItemSeries)series;
            boolean bl = drawLine = Double.isFinite(itemSeries.getLineWidth()) && itemSeries.getLineWidth() > 0.0;
            if (drawLine) {
                ctx.beginPath();
                ctx.setStroke((Paint)series.getBaseColor());
                ctx.setLineWidth(itemSeries.getLineWidth());
            }
            XYZItem lastItem = null;
            for (XYZItem item : itemSeries.getItems()) {
                if (!drawBounds.getViewRange().contains(item)) {
                    if (!drawLine || lastItem == null) continue;
                    ctx.stroke();
                    lastItem = null;
                    continue;
                }
                Point2D drawPoint = drawBounds.domainToDraw(new Point2D(item.getX(), item.getY()));
                double size = itemSeries.getItemSize(item);
                if (drawLine) {
                    if (lastItem == null) {
                        ctx.moveTo(drawPoint.getX(), drawPoint.getY());
                    } else {
                        ctx.lineTo(drawPoint.getX(), drawPoint.getY());
                    }
                    lastItem = item;
                }
                Color color = itemColorPolicy != null ? (chart.isDeriveItemColorFromZAxis() ? (Double.isFinite(item.getZ()) ? itemColorPolicy.mapHpToColor(series.getBaseColor(), item.getZ(), drawBounds.getViewRange().getMinZ(), drawBounds.getViewRange().getMaxZ()) : Color.LIGHTGRAY) : (Double.isFinite(item.getW()) ? itemColorPolicy.mapHpToColor(series.getBaseColor(), item.getW(), drawBounds.getViewRange().getMinW(), drawBounds.getViewRange().getMaxW()) : Color.LIGHTGRAY)) : Color.BLACK;
                if (color == null) {
                    color = Color.BLACK;
                }
                ctx.setFill((Paint)color);
                ctx.fillOval(drawPoint.getX() - size, drawPoint.getY() - size, size * 2.0, size * 2.0);
                if (!itemSeries.isShowItemLabels()) continue;
                String text = String.format("%s [%s]", chart.getAxes().getZAxis().getNumberFormatter().getDecimalFormat(item.getZ()).format(item.getZ()), chart.getAxes().getZAxis().getMeasuringUnit());
                if (chart.getAxes().getWAxis() == null || !Double.isFinite(item.getW())) continue;
                text = String.valueOf(text) + String.format(", %s [%s]", chart.getAxes().getWAxis().getNumberFormatter().getDecimalFormat(item.getW()).format(item.getW()), chart.getAxes().getWAxis().getMeasuringUnit());
                double expectedTextLength = 10.0 * ((double)text.length() / 2.0);
                ctx.fillText(text, drawPoint.getX() - expectedTextLength / 2.0, drawPoint.getY() - size - 5.0);
            }
            if (drawLine && lastItem != null) {
                ctx.stroke();
            }
        }
        finally {
            ctx.restore();
        }
    }
}

