/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.series;

import de.elpro.ui.fx.charts.xyz.XYZChart3D;
import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.XYZViewSpace;
import de.elpro.ui.fx.charts.xyz.axis.ItemColorPolicy;
import de.elpro.ui.fx.charts.xyz.events.XYZItemMouseClickEvent;
import de.elpro.ui.fx.charts.xyz.events.XYZItemMouseEnteredEvent;
import de.elpro.ui.fx.charts.xyz.events.XYZItemMouseExitedEvent;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import de.elpro.ui.fx.charts.xyz.series.XYZItemMeta;
import de.elpro.ui.fx.charts.xyz.series.XYZItemSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries3DRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Point3D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;
import javafx.scene.transform.Rotate;

public class XYZItemSeries3DRenderer
implements XYZSeries3DRenderer {
    private static final String ITEM_ANNOTATION_CLASS = "item-annotations-group";
    private static final String INNER_ITEMS_CLASS = "inner-items-group";
    private static final String ITEM_BOX_CLASS = "item-box";
    private static final int PROJECTIONS_IMAGE_RESOLUTION = 1000;
    private static final boolean DRAW_OUTER_ITEMS = false;

    @Override
    public boolean canRender(XYZSeries series) {
        return series instanceof XYZItemSeries;
    }

    @Override
    public List<Node> createVisibles(XYZChart3D chart, Collection<XYZSeries> seriesList, XYZViewSpace viewSpace) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        double axisLength = XYZViewSpace.getAxisLentgh();
        double referenceItemDrawSize = axisLength / 200.0;
        XYZDataViewRange dataViewRange = viewSpace.getViewRange();
        boolean invertYAxis = viewSpace.isInvertYAxis();
        double areaShift = -0.004;
        Point3D nullPoint = viewSpace.getAxesNullPoint();
        WritableImage imgXY = new WritableImage(1000, 1000);
        PixelWriter pwXY = imgXY.getPixelWriter();
        WritableImage imgXZ = new WritableImage(1000, 1000);
        PixelWriter pwXZ = imgXZ.getPixelWriter();
        WritableImage imgYZ = new WritableImage(1000, 1000);
        PixelWriter pwYZ = imgYZ.getPixelWriter();
        IntStream.range(0, 999).boxed().forEach(a -> IntStream.range(0, 999).boxed().forEach(b -> {
            pwXY.setColor(a.intValue(), b.intValue(), Color.TRANSPARENT);
            pwXZ.setColor(a.intValue(), b.intValue(), Color.TRANSPARENT);
            pwYZ.setColor(a.intValue(), b.intValue(), Color.TRANSPARENT);
        }));
        ImageView imgViewXY = new ImageView((Image)imgXY);
        imgViewXY.setFitWidth(axisLength);
        imgViewXY.setFitHeight(axisLength);
        imgViewXY.setTranslateX(nullPoint.getX());
        imgViewXY.setTranslateY(-axisLength * (1.0 + areaShift));
        imgViewXY.setRotate(90.0);
        imgViewXY.setRotationAxis(Rotate.X_AXIS);
        ImageView imgViewXZ = new ImageView((Image)imgXZ);
        imgViewXZ.setFitWidth(axisLength);
        imgViewXZ.setFitHeight(axisLength);
        imgViewXZ.setTranslateX(nullPoint.getX());
        imgViewXZ.setTranslateY(nullPoint.getY());
        imgViewXZ.setTranslateZ(nullPoint.getZ() - axisLength * areaShift - (!invertYAxis ? 0.0 : axisLength));
        ImageView imgViewYZ = new ImageView((Image)imgYZ);
        imgViewYZ.setFitWidth(axisLength);
        imgViewYZ.setFitHeight(axisLength);
        imgViewYZ.setTranslateX(-axisLength * (1.0 + areaShift));
        imgViewYZ.setTranslateY(nullPoint.getY());
        imgViewYZ.setRotate(-90.0);
        imgViewYZ.setRotationAxis(Rotate.Y_AXIS);
        AnnotationsMetadata annotationMetadata = new AnnotationsMetadata(viewSpace, referenceItemDrawSize);
        for (XYZSeries series : seriesList) {
            XYZItemSeries itemSeries = (XYZItemSeries)series;
            ArrayList<XYZItem> innerItems = new ArrayList<XYZItem>();
            ArrayList outerItems = new ArrayList();
            itemSeries.getItems().forEach(i -> {
                if (dataViewRange.contains((XYZItem)i)) {
                    innerItems.add((XYZItem)i);
                } else {
                    outerItems.add(i);
                }
            });
            Group itemAnnotationsGroup = new Group();
            itemAnnotationsGroup.getStyleClass().add((Object)ITEM_ANNOTATION_CLASS);
            itemAnnotationsGroup.setUserData((Object)annotationMetadata);
            Group innerItemsGroup = new Group(this.createInnerItemsVisibles(chart, itemSeries, (ObservableList<Node>)itemAnnotationsGroup.getChildren(), innerItems, viewSpace, referenceItemDrawSize));
            innerItemsGroup.getStyleClass().add((Object)INNER_ITEMS_CLASS);
            this.drawProjections(chart, itemSeries, innerItems, viewSpace, referenceItemDrawSize, pwXY, pwXZ, pwYZ);
            Group group = new Group(new Node[]{innerItemsGroup, itemAnnotationsGroup});
            nodes.add((Node)group);
        }
        nodes.add((Node)new Group(new Node[]{imgViewXY, imgViewXZ, imgViewYZ}));
        return nodes;
    }

    private List<Node> createInnerItemsVisibles(XYZChart3D chart, XYZItemSeries series, ObservableList<Node> annotationVisibles, List<XYZItem> innerItems, XYZViewSpace viewSpace, double referenceItemDrawSize) {
        Color baseColor = XYZSeries3DRenderer.getColor(series).brighter();
        XYZDataViewRange dataViewRange = viewSpace.getViewRange();
        ItemColorPolicy colorPolicy = chart.getItemColorPolicy();
        annotationVisibles.clear();
        ArrayList<Node> visibles = new ArrayList<Node>(innerItems.size());
        EventHandler onMouseEntered = e -> {
            Box box;
            if (e != null && e.getPickResult() != null && e.getPickResult().getIntersectedNode() instanceof Box && (box = (Box)e.getPickResult().getIntersectedNode()).getUserData() instanceof XYZItemMeta) {
                XYZItemMeta metadata = (XYZItemMeta)box.getUserData();
                ((PhongMaterial)box.getMaterial()).setDiffuseColor(metadata.getSelectedColor());
                box.setWidth(metadata.getSelectedDrawSize());
                box.setHeight(metadata.getSelectedDrawSize());
                box.setDepth(metadata.getSelectedDrawSize());
                XYZItemMouseEnteredEvent mouseEnteredEvent = new XYZItemMouseEnteredEvent(series, metadata.getItem(), (EventTarget)box);
                for (EventHandler<? super XYZItemMouseEnteredEvent> eventHandler : chart.getItemMouseEnteredEventHandlers()) {
                    if (mouseEnteredEvent.isConsumed()) break;
                    eventHandler.handle((Event)mouseEnteredEvent);
                }
            }
        };
        EventHandler onMouseExited = e -> {
            Box box;
            if (e != null && e.getSource() instanceof Box && (box = (Box)e.getSource()).getUserData() instanceof XYZItemMeta) {
                XYZItemMeta metadata = (XYZItemMeta)box.getUserData();
                if (!chart.getSelectedItems().contains((Object)metadata.getItem())) {
                    ((PhongMaterial)box.getMaterial()).setDiffuseColor(metadata.getBaseColor());
                    box.setWidth(metadata.getDrawSize());
                    box.setHeight(metadata.getDrawSize());
                    box.setDepth(metadata.getDrawSize());
                }
                XYZItemMouseExitedEvent mouseExitedEvent = new XYZItemMouseExitedEvent(series, metadata.getItem(), (EventTarget)box);
                for (EventHandler<? super XYZItemMouseExitedEvent> eventHandler : chart.getItemMouseExitedEventHandlers()) {
                    if (mouseExitedEvent.isConsumed()) break;
                    eventHandler.handle((Event)mouseExitedEvent);
                }
            }
        };
        EventHandler onMouseClicked = e -> {
            Box box;
            if (e != null && e.getPickResult() != null && e.getPickResult().getIntersectedNode() instanceof Box && (box = (Box)e.getPickResult().getIntersectedNode()).getUserData() instanceof XYZItemMeta) {
                XYZItemMeta metadata = (XYZItemMeta)box.getUserData();
                annotationVisibles.setAll(this.createSelectedItemAnnotationVisibles(metadata.getItem(), viewSpace, metadata.getDrawSize()));
                XYZItemMouseClickEvent mouseClickEvent = new XYZItemMouseClickEvent(series, metadata.getItem(), (EventTarget)box);
                for (EventHandler<? super XYZItemMouseClickEvent> eventHandler : chart.getItemMouseClickEventHandlers()) {
                    if (mouseClickEvent.isConsumed()) break;
                    eventHandler.handle((Event)mouseClickEvent);
                }
                visibles.forEach(n -> n.getOnMouseExited().handle(null));
            }
        };
        for (XYZItem item : innerItems) {
            boolean isSelected = chart.getSelectedItems().contains((Object)item);
            double itemDrawSize = referenceItemDrawSize * series.getItemSize(item);
            double itemSelectedSize = itemDrawSize * 1.7;
            Point3D scenePoint = viewSpace.getScenePosition(item);
            double x = scenePoint.getX();
            double y = scenePoint.getY();
            double z = scenePoint.getZ();
            if (isSelected) {
                annotationVisibles.addAll(this.createSelectedItemAnnotationVisibles(item, viewSpace, referenceItemDrawSize));
            }
            Color color = chart.getAxes().getWAxis() != null ? (!viewSpace.isSwapZWAxes() ? colorPolicy.mapHpToColor(baseColor, item.getW(), dataViewRange.getMinW(), dataViewRange.getMaxW()) : colorPolicy.mapHpToColor(baseColor, item.getZ(), dataViewRange.getMinZ(), dataViewRange.getMaxZ())) : baseColor;
            Box box = isSelected ? new Box(itemSelectedSize, itemSelectedSize, itemSelectedSize) : new Box(itemDrawSize, itemDrawSize, itemDrawSize);
            box.getStyleClass().add((Object)ITEM_BOX_CLASS);
            XYZItemMeta metadata = new XYZItemMeta(item, color, color.deriveColor(1.0, 1.0, 0.5, 1.0), itemDrawSize, itemSelectedSize);
            box.setUserData((Object)metadata);
            box.setTranslateX(x);
            box.setTranslateY(y);
            box.setTranslateZ(z);
            PhongMaterial material = new PhongMaterial();
            material.setDiffuseColor(isSelected ? metadata.getSelectedColor() : color);
            box.setMaterial((Material)material);
            box.setOnMouseEntered(onMouseEntered);
            box.setOnMouseExited(onMouseExited);
            box.setOnMouseClicked(onMouseClicked);
            visibles.add((Node)box);
        }
        return visibles;
    }

    public void updateSelection(List<XYZItem> selectedItems, List<Node> visibles) {
        for (Node node : visibles) {
            if (!(node instanceof Group)) continue;
            Group seriesGroup = (Group)node;
            Group itemAnnotationsGroup = seriesGroup.getChildren().stream().filter(v -> v.getStyleClass().contains((Object)ITEM_ANNOTATION_CLASS)).findAny().orElse(null);
            if (itemAnnotationsGroup == null) {
                return;
            }
            itemAnnotationsGroup.getChildren().clear();
            AnnotationsMetadata annotationsMetadata = (AnnotationsMetadata)itemAnnotationsGroup.getUserData();
            XYZViewSpace viewSpace = annotationsMetadata.getViewSpace();
            double referenceItemDrawSize = annotationsMetadata.getReferenceItemDrawSize();
            Group innerItemsGroup = seriesGroup.getChildren().stream().filter(v -> v.getStyleClass().contains((Object)INNER_ITEMS_CLASS)).findAny().orElse(null);
            if (innerItemsGroup == null) {
                return;
            }
            for (Node boxNode : innerItemsGroup.getChildren()) {
                Box box = (Box)boxNode;
                PhongMaterial material = (PhongMaterial)box.getMaterial();
                XYZItemMeta metadata = (XYZItemMeta)boxNode.getUserData();
                Color color = metadata.getBaseColor();
                if (selectedItems.contains(metadata.getItem())) {
                    material.setDiffuseColor(color.deriveColor(1.0, 1.0, 0.5, 1.0));
                    box.setWidth(metadata.getSelectedDrawSize());
                    box.setHeight(metadata.getSelectedDrawSize());
                    box.setDepth(metadata.getSelectedDrawSize());
                    itemAnnotationsGroup.getChildren().addAll(this.createSelectedItemAnnotationVisibles(metadata.getItem(), viewSpace, referenceItemDrawSize));
                    continue;
                }
                material.setDiffuseColor(color);
                box.setWidth(metadata.getDrawSize());
                box.setHeight(metadata.getDrawSize());
                box.setDepth(metadata.getDrawSize());
            }
        }
    }

    private List<Node> createOuterItemsVisibles(List<XYZItem> outerItems, XYZItemSeries series, XYZViewSpace viewSpace, double referenceItemDrawSize) {
        ArrayList<Node> visibles = new ArrayList<Node>(outerItems.size());
        for (XYZItem item : outerItems) {
            Point3D scenePoint = viewSpace.getScenePosition(item);
            double itemDrawSize = referenceItemDrawSize * series.getItemSize(item);
            Color color = Color.LIGHTGRAY.brighter();
            Box box = new Box(itemDrawSize, itemDrawSize, itemDrawSize);
            box.setTranslateX(scenePoint.getX());
            box.setTranslateY(scenePoint.getY());
            box.setTranslateZ(scenePoint.getZ());
            PhongMaterial material = new PhongMaterial();
            material.setDiffuseColor(color);
            box.setMaterial((Material)material);
            visibles.add((Node)box);
        }
        return visibles;
    }

    private void drawProjections(XYZChart3D chart, XYZItemSeries series, List<XYZItem> innerItems, XYZViewSpace viewSpace, double referenceItemDrawSize, PixelWriter pwXY, PixelWriter pwXZ, PixelWriter pwYZ) {
        Color baseColor = XYZSeries3DRenderer.getColor(series).brighter();
        boolean invertYAxis = viewSpace.isInvertYAxis();
        double axisLength = XYZViewSpace.getAxisLentgh();
        XYZDataViewRange dataViewRange = viewSpace.getViewRange();
        ItemColorPolicy colorPolicy = chart.getItemColorPolicy();
        for (XYZItem item : innerItems) {
            int x = (int)((item.getX() - dataViewRange.getMinX()) / (dataViewRange.getMaxX() - dataViewRange.getMinX()) * 1000.0);
            int y = !invertYAxis ? (int)((item.getY() - dataViewRange.getMinY()) / (dataViewRange.getMaxY() - dataViewRange.getMinY()) * 1000.0) : (int)((dataViewRange.getMaxY() - item.getY()) / (dataViewRange.getMaxY() - dataViewRange.getMinY()) * 1000.0);
            int zw = !viewSpace.isSwapZWAxes() ? (int)((item.getZ() - dataViewRange.getMinZ()) / (dataViewRange.getMaxZ() - dataViewRange.getMinZ()) * 1000.0) : (int)((item.getW() - dataViewRange.getMinW()) / (dataViewRange.getMaxW() - dataViewRange.getMinW()) * 1000.0);
            double itemDrawSize = referenceItemDrawSize * series.getItemSize(item);
            int pixels = Math.max(1, (int)(itemDrawSize * 1000.0 / axisLength));
            int prefix = pixels / 2;
            Color color = !viewSpace.isSwapZWAxes() ? colorPolicy.mapHpToColor(baseColor, item.getW(), dataViewRange.getMinW(), dataViewRange.getMaxW()) : colorPolicy.mapHpToColor(baseColor, item.getZ(), dataViewRange.getMinZ(), dataViewRange.getMaxZ());
            int i = 0;
            while (i < pixels) {
                int j = 0;
                while (j < pixels) {
                    int xr = Math.min(Math.max(0, x - prefix + i), 999);
                    int yr = Math.min(Math.max(0, y - prefix + j), 999);
                    int zr1 = Math.min(Math.max(0, zw - prefix + j), 999);
                    int zr2 = Math.min(Math.max(0, zw - prefix + i), 999);
                    pwXY.setColor(xr, yr, color);
                    pwXZ.setColor(xr, zr1, color);
                    pwYZ.setColor(yr, zr2, color);
                    ++j;
                }
                ++i;
            }
        }
    }

    private List<Node> createSelectedItemAnnotationVisibles(XYZItem item, XYZViewSpace viewSpace, double referenceItemDrawSize) {
        PhongMaterial material = new PhongMaterial();
        material.setDiffuseColor(Color.BLACK.deriveColor(1.0, 1.0, 1.0, 0.3));
        ArrayList<Node> visibles = new ArrayList<Node>(3);
        Point3D scenePoint = viewSpace.getScenePosition(item);
        double axisLength = XYZViewSpace.getAxisLentgh();
        Cylinder xAxisCylinder = new Cylinder(referenceItemDrawSize / 3.0, scenePoint.getX() + axisLength * 0.5);
        xAxisCylinder.setMaterial((Material)material);
        xAxisCylinder.setTranslateX(scenePoint.getX() - xAxisCylinder.getHeight() / 2.0);
        xAxisCylinder.setTranslateY(scenePoint.getY());
        xAxisCylinder.setTranslateZ(scenePoint.getZ());
        xAxisCylinder.getTransforms().add((Object)new Rotate(-90.0, Rotate.Z_AXIS));
        visibles.add((Node)xAxisCylinder);
        Cylinder yAxisCylinder = new Cylinder(referenceItemDrawSize / 3.0, scenePoint.getY() + axisLength * 0.5);
        yAxisCylinder.setMaterial((Material)material);
        yAxisCylinder.setTranslateX(scenePoint.getX());
        yAxisCylinder.setTranslateY(scenePoint.getY() - yAxisCylinder.getHeight() / 2.0);
        yAxisCylinder.setTranslateZ(scenePoint.getZ());
        visibles.add((Node)yAxisCylinder);
        Cylinder zAxisCylinder = new Cylinder(referenceItemDrawSize / 3.0, scenePoint.getZ() + axisLength * 0.5);
        zAxisCylinder.setMaterial((Material)material);
        zAxisCylinder.setTranslateX(scenePoint.getX());
        zAxisCylinder.setTranslateY(scenePoint.getY());
        zAxisCylinder.setTranslateZ(scenePoint.getZ() - zAxisCylinder.getHeight() / 2.0);
        zAxisCylinder.getTransforms().add((Object)new Rotate(90.0, Rotate.X_AXIS));
        visibles.add((Node)zAxisCylinder);
        return visibles;
    }

    private static class AnnotationsMetadata {
        private final XYZViewSpace viewSpace;
        private final double referenceItemDrawSize;

        public AnnotationsMetadata(XYZViewSpace viewSpace, double referenceItemDrawSize) {
            this.viewSpace = viewSpace;
            this.referenceItemDrawSize = referenceItemDrawSize;
        }

        public XYZViewSpace getViewSpace() {
            return this.viewSpace;
        }

        public double getReferenceItemDrawSize() {
            return this.referenceItemDrawSize;
        }
    }
}

