/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.tests;

import de.elpro.ui.fx.charts.xyz.XYZChart3D;
import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxes;
import de.elpro.ui.fx.charts.xyz.series.XYZFunctionSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import de.elpro.ui.fx.charts.xyz.series.XYZItemSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import java.time.Instant;
import javafx.application.Application;
import javafx.beans.property.Property;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class XYZChart3DTest
extends Application {
    public void start(Stage primaryStage) {
        XYZAxes axes = new XYZAxes("X Axis", "Y Axis", "Z Axis", "W Axis");
        XYZChart3D chart = new XYZChart3D(axes);
        chart.setInvertYAxis(true);
        chart.setSwapZWAxes(true);
        chart.getAxes().getXAxis().setMeasuringUnit("kg");
        chart.getAxes().getYAxis().setMeasuringUnit("C\u00b0");
        chart.getAxes().getZAxis().setMeasuringUnit("kmh");
        chart.getAxes().getWAxis().setMeasuringUnit("rpm");
        XYZItemSeries series1 = new XYZItemSeries("Series 1");
        series1.setDefaultItemSize(4.0);
        series1.setBaseColor(Color.ORANGERED);
        Instant timestamp = Instant.now();
        int i = 0;
        while (i < 5000) {
            double x2 = Math.random() * 100.0;
            double y2 = Math.random() * 100.0;
            double z2 = x2 / 30.0 * Math.random() + Math.sqrt(x2);
            double w = Math.sqrt(x2) * (0.75 + Math.random() * 0.05) * 100.0;
            series1.addItem(new XYZItem(timestamp, x2, y2, z2, w));
            ++i;
        }
        XYZItemSeries series2 = new XYZItemSeries("Series 2");
        series2.setBaseColor(Color.ORCHID);
        series2.setDefaultItemSize(1.0);
        int i2 = 0;
        while (i2 < 5000) {
            double x3 = Math.random() * 80.0;
            double y3 = Math.random() * 110.0;
            double z3 = x3 / 20.0 * Math.random() - Math.sqrt(x3);
            series2.addItem(new XYZItem(timestamp, x3, y3, z3));
            ++i2;
        }
        XYZItemSeries series3 = new XYZItemSeries("Series 3");
        series3.setBaseColor(Color.RED);
        series3.setDefaultItemSize(6.0);
        int i3 = -10;
        while (i3 < 90) {
            double x4 = i3;
            double y4 = i3;
            double z4 = i3 / 10;
            series3.addItem(new XYZItem(timestamp, x4, y4, z4, 200.0));
            ++i3;
        }
        XYZFunctionSeries functionSeries1 = new XYZFunctionSeries("Function Series 1", (x, y) -> {
            double z = Math.sqrt(x + 20.0) * 0.9 - Math.sqrt(y + 1.0) / 2.0 + 2.0;
            return z >= 0.0 ? z : Double.NaN;
        }, (x, y, z) -> z * (0.75 + Math.sin(x) * 0.01) * 100.0);
        functionSeries1.setDataViewRange(new XYZDataViewRange(-20.0, 100.0, -20.0, 95.0, -3.0, 10.0, -2.0, 1000.0));
        XYZFunctionSeries functionSeries2 = new XYZFunctionSeries("Function Series 2", (x, y) -> Math.sqrt(x) * 0.9 - Math.sqrt(y + 1.0) / 2.0 - 1.0);
        functionSeries2.setBaseColor(Color.AQUAMARINE.deriveColor(1.0, 1.0, 1.0, 0.5));
        chart.getAxes().getXAxis().setLowerBound(-10.0);
        chart.getAxes().getYAxis().setLowerBound(-10.0);
        chart.getAxes().getZAxis().setLowerBound(-3.0);
        chart.getSeriesList().addAll((Object[])new XYZSeries[]{functionSeries1, functionSeries2});
        Scene scene = new Scene((Parent)chart);
        scene.setOnKeyPressed(e -> {
            if (e.isControlDown() && e.getCode() == KeyCode.R) {
                chart.draw();
            }
        });
        CheckMenuItem invertYAxisMenuItem = new CheckMenuItem("Invert Y Axis");
        invertYAxisMenuItem.selectedProperty().bindBidirectional((Property)chart.invertYAxisProperty());
        CheckMenuItem swapZWAxisMenuItem = new CheckMenuItem("Swap ZW Axes");
        swapZWAxisMenuItem.selectedProperty().bindBidirectional((Property)chart.swapZWAxesProperty());
        chart.getContextMenu().getItems().addAll((Object[])new MenuItem[]{invertYAxisMenuItem, swapZWAxisMenuItem});
        primaryStage.setHeight(800.0);
        primaryStage.setWidth(1000.0);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    public static void main(String[] args) {
        XYZChart3DTest.launch((String[])args);
    }
}

