/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.utils;

import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.transform.Translate;

public interface XYZUtils {
    public static void applyTranslate(Node node, Point3D point) {
        node.getTransforms().add((Object)new Translate(point.getX(), point.getY(), point.getZ()));
    }

    public static Point3D rotate(Point3D vector, double yRotationAngle, double xRotationAngle) {
        double yRot = Math.PI * yRotationAngle / 180.0;
        double xRot = Math.PI * xRotationAngle / 180.0;
        double x = vector.getX();
        double y = vector.getY();
        double z = vector.getZ();
        double xOverY = x * Math.cos(yRot) + z * Math.sin(yRot);
        double yOverY = y;
        double zOverY = -x * Math.sin(yRot) + z * Math.cos(yRot);
        double xOverX = xOverY;
        double yOverX = yOverY * Math.cos(xRot) - zOverY * Math.sin(xRot);
        double zOverX = yOverY * Math.sin(xRot) + zOverY * Math.cos(xRot);
        return new Point3D(xOverX, yOverX, zOverX);
    }
}

