/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.shapes;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;

public class Cone
extends Group {
    private final int rounds;
    private final float r1;
    private final float r2;
    private final float h;

    public Cone(int rounds, float r1, float r2, float h, Color color) {
        this.rounds = rounds;
        this.r1 = r1;
        this.r2 = r2;
        this.h = h;
        Group cone = new Group();
        PhongMaterial material = new PhongMaterial(color);
        float[] points = new float[rounds * 12];
        float[] textCoords = new float[]{0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        int[] faces = new int[rounds * 12];
        int i = 0;
        while (i < rounds) {
            double angle = Math.toRadians(360.0 / (double)rounds * (double)i);
            double angleNext = Math.toRadians(360.0 / (double)rounds * (double)(i + 1));
            int index = i * 12;
            points[index] = (float)Math.cos(angle) * r2;
            points[index + 1] = (float)Math.sin(angle) * r2;
            points[index + 2] = h / 2.0f;
            points[index + 3] = (float)Math.cos(angle) * r1;
            points[index + 4] = (float)Math.sin(angle) * r1;
            points[index + 5] = -h / 2.0f;
            points[index + 6] = (float)Math.cos(angleNext) * r1;
            points[index + 7] = (float)Math.sin(angleNext) * r1;
            points[index + 8] = -h / 2.0f;
            points[index + 9] = (float)Math.cos(angleNext) * r2;
            points[index + 10] = (float)Math.sin(angleNext) * r2;
            points[index + 11] = h / 2.0f;
            ++i;
        }
        i = 0;
        while (i < rounds) {
            int index = i * 12;
            faces[index] = i * 4;
            faces[index + 1] = 0;
            faces[index + 2] = i * 4 + 1;
            faces[index + 3] = 1;
            faces[index + 4] = i * 4 + 2;
            faces[index + 5] = 2;
            faces[index + 6] = i * 4;
            faces[index + 7] = 0;
            faces[index + 8] = i * 4 + 2;
            faces[index + 9] = 1;
            faces[index + 10] = i * 4 + 3;
            faces[index + 11] = 2;
            ++i;
        }
        TriangleMesh mesh = new TriangleMesh();
        mesh.getPoints().addAll(points);
        mesh.getTexCoords().addAll(textCoords);
        mesh.getFaces().addAll(faces);
        Cylinder circle1 = new Cylinder((double)r1, 0.1);
        circle1.setMaterial((Material)material);
        circle1.setTranslateZ((double)(-h / 2.0f));
        circle1.setRotationAxis(Rotate.X_AXIS);
        circle1.setRotate(90.0);
        Cylinder circle2 = new Cylinder((double)r2, 0.1);
        circle2.setMaterial((Material)material);
        circle2.setTranslateZ((double)(h / 2.0f));
        circle2.setRotationAxis(Rotate.X_AXIS);
        circle2.setRotate(90.0);
        MeshView meshView = new MeshView();
        meshView.setMesh((Mesh)mesh);
        meshView.setMaterial((Material)material);
        cone.getChildren().addAll((Object[])new Node[]{meshView});
        Rotate rotate = new Rotate(90.0, Rotate.X_AXIS);
        cone.getTransforms().add((Object)rotate);
        this.getChildren().addAll((Object[])new Node[]{cone});
    }

    public float getHeight() {
        return this.h;
    }
}

