/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.perspectiveswitcher.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.ImageView;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;

public class SwitcherController {
    public static final String ICON_URI_SELECTED = "icon-uri-selected";
    public static final SwitcherController INSTANCE = new SwitcherController();
    private List<Consumer<MPerspectiveStack>> perspectiveStackChangedCallbacks = new ArrayList<Consumer<MPerspectiveStack>>();
    private Map<MPerspective, ToggleButton> btns = new HashMap<MPerspective, ToggleButton>();

    SwitcherController() {
    }

    public void registerPerspective(MPerspective perspective, ToggleButton button) {
        this.btns.put(perspective, button);
    }

    public void selectPerspective(MPerspective perspective) {
        for (MPerspective key : this.btns.keySet()) {
            ToggleButton btn = this.btns.get(key);
            if (key == perspective) {
                btn.setSelected(true);
                Map properties = key.getPersistedState();
                if (!properties.containsKey(ICON_URI_SELECTED)) continue;
                btn.setGraphic((Node)new ImageView((String)properties.get(ICON_URI_SELECTED)));
                continue;
            }
            String iconUri = key.getIconURI();
            if (iconUri == null) continue;
            btn.setGraphic((Node)new ImageView(iconUri));
        }
    }

    public void addPerspectivesChangedCallback(Consumer<MPerspectiveStack> callback) {
        this.perspectiveStackChangedCallbacks.add(callback);
    }

    public void firePerspectivesChangedCallback(MPerspectiveStack stack) {
        this.perspectiveStackChangedCallbacks.forEach(c -> c.accept(stack));
    }
}

