/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.FocusTraversalInputMap;
import com.sun.javafx.scene.control.inputmap.InputMap;
import de.elpro.ui.fx.controls.RangeSlider;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.controlsfx.tools.Utils;

public class RangeSliderBehavior
extends BehaviorBase<RangeSlider> {
    private final InputMap<RangeSlider> inputMap = this.createInputMap();
    private Callback<Void, FocusedChild> selectedValue;

    public RangeSliderBehavior(RangeSlider slider) {
        super((Node)slider);
        this.addDefaultMapping(this.inputMap, new InputMap.Mapping[]{new InputMap.KeyMapping(KeyCode.LEFT, FocusTraversalInputMap::traverseLeft), new InputMap.KeyMapping(KeyCode.KP_LEFT, FocusTraversalInputMap::traverseLeft), new InputMap.KeyMapping(KeyCode.UP, FocusTraversalInputMap::traverseUp), new InputMap.KeyMapping(KeyCode.KP_UP, FocusTraversalInputMap::traverseUp), new InputMap.KeyMapping(KeyCode.RIGHT, FocusTraversalInputMap::traverseRight), new InputMap.KeyMapping(KeyCode.KP_RIGHT, FocusTraversalInputMap::traverseRight), new InputMap.KeyMapping(KeyCode.DOWN, FocusTraversalInputMap::traverseDown), new InputMap.KeyMapping(KeyCode.KP_DOWN, FocusTraversalInputMap::traverseDown), new InputMap.KeyMapping(KeyCode.HOME, KeyEvent.KEY_RELEASED, e -> this.home()), new InputMap.KeyMapping(KeyCode.END, KeyEvent.KEY_RELEASED, e -> this.end())});
        InputMap horizontalMappings = new InputMap((Node)slider);
        horizontalMappings.setInterceptor(e -> slider.getOrientation() != Orientation.HORIZONTAL);
        horizontalMappings.getMappings().addAll((Object[])new InputMap.Mapping[]{new InputMap.KeyMapping(KeyCode.LEFT, e -> this.rtl(slider, this::incrementValue, this::decrementValue)), new InputMap.KeyMapping(KeyCode.KP_LEFT, e -> this.rtl(slider, this::incrementValue, this::decrementValue)), new InputMap.KeyMapping(KeyCode.RIGHT, e -> this.rtl(slider, this::decrementValue, this::incrementValue)), new InputMap.KeyMapping(KeyCode.KP_RIGHT, e -> this.rtl(slider, this::decrementValue, this::incrementValue))});
        this.addDefaultChildMap(this.inputMap, horizontalMappings);
        InputMap verticalMappings = new InputMap((Node)slider);
        verticalMappings.setInterceptor(e -> slider.getOrientation() != Orientation.VERTICAL);
        verticalMappings.getMappings().addAll((Object[])new InputMap.Mapping[]{new InputMap.KeyMapping(KeyCode.DOWN, e -> this.decrementValue()), new InputMap.KeyMapping(KeyCode.KP_DOWN, e -> this.decrementValue()), new InputMap.KeyMapping(KeyCode.UP, e -> this.incrementValue()), new InputMap.KeyMapping(KeyCode.KP_UP, e -> this.incrementValue())});
        this.addDefaultChildMap(this.inputMap, verticalMappings);
    }

    public void setSelectedValue(Callback<Void, FocusedChild> c) {
        this.selectedValue = c;
    }

    public InputMap<RangeSlider> getInputMap() {
        return this.inputMap;
    }

    public void trackPress(MouseEvent e, double position) {
        RangeSlider rangeSlider = (RangeSlider)this.getNode();
        if (!rangeSlider.isFocused()) {
            rangeSlider.requestFocus();
        }
        if (this.selectedValue != null) {
            double newPosition = rangeSlider.getOrientation().equals((Object)Orientation.HORIZONTAL) ? position * (rangeSlider.getMax() - rangeSlider.getMin()) + rangeSlider.getMin() : (1.0 - position) * (rangeSlider.getMax() - rangeSlider.getMin()) + rangeSlider.getMin();
            if (newPosition < rangeSlider.getLowValue()) {
                rangeSlider.adjustLowValue(newPosition);
            } else {
                rangeSlider.adjustHighValue(newPosition);
            }
        }
    }

    public void trackRelease(MouseEvent e, double position) {
    }

    public void lowThumbPressed(MouseEvent e, double position) {
        RangeSlider rangeSlider = (RangeSlider)this.getNode();
        if (!rangeSlider.isFocused()) {
            rangeSlider.requestFocus();
        }
        rangeSlider.setLowValueChanging(true);
    }

    public void lowThumbDragged(MouseEvent e, double position) {
        RangeSlider rangeSlider = (RangeSlider)this.getNode();
        double newValue = Utils.clamp((double)rangeSlider.getMin(), (double)(position * (rangeSlider.getMax() - rangeSlider.getMin()) + rangeSlider.getMin()), (double)rangeSlider.getMax());
        rangeSlider.setLowValue(newValue);
    }

    public void lowThumbReleased(MouseEvent e) {
        RangeSlider rangeSlider = (RangeSlider)this.getNode();
        rangeSlider.setLowValueChanging(false);
        if (rangeSlider.isSnapToTicks()) {
            rangeSlider.setLowValue(this.snapValueToTicks(rangeSlider.getLowValue()));
        }
    }

    void home() {
        RangeSlider slider = (RangeSlider)this.getNode();
        slider.adjustHighValue(slider.getMin());
    }

    void decrementValue() {
        RangeSlider slider = (RangeSlider)this.getNode();
        if (this.selectedValue != null) {
            if (this.selectedValue.call(null) == FocusedChild.HIGH_THUMB) {
                if (slider.isSnapToTicks()) {
                    slider.adjustHighValue(slider.getHighValue() - this.computeIncrement());
                } else {
                    slider.decrementHighValue();
                }
            } else if (slider.isSnapToTicks()) {
                slider.adjustLowValue(slider.getLowValue() - this.computeIncrement());
            } else {
                slider.decrementLowValue();
            }
        }
    }

    void end() {
        RangeSlider slider = (RangeSlider)this.getNode();
        slider.adjustHighValue(slider.getMax());
    }

    void incrementValue() {
        RangeSlider slider = (RangeSlider)this.getNode();
        if (this.selectedValue != null) {
            if (this.selectedValue.call(null) == FocusedChild.HIGH_THUMB) {
                if (slider.isSnapToTicks()) {
                    slider.adjustHighValue(slider.getHighValue() + this.computeIncrement());
                } else {
                    slider.incrementHighValue();
                }
            } else if (slider.isSnapToTicks()) {
                slider.adjustLowValue(slider.getLowValue() + this.computeIncrement());
            } else {
                slider.incrementLowValue();
            }
        }
    }

    double computeIncrement() {
        RangeSlider rangeSlider = (RangeSlider)this.getNode();
        double d = 0.0;
        d = rangeSlider.getMinorTickCount() != 0 ? rangeSlider.getMajorTickUnit() / (double)(Math.max(rangeSlider.getMinorTickCount(), 0) + 1) : rangeSlider.getMajorTickUnit();
        if (rangeSlider.getBlockIncrement() > 0.0 && rangeSlider.getBlockIncrement() < d) {
            return d;
        }
        return rangeSlider.getBlockIncrement();
    }

    void rtl(RangeSlider node, Runnable rtlMethod, Runnable nonRtlMethod) {
        switch (node.getEffectiveNodeOrientation()) {
            case RIGHT_TO_LEFT: {
                rtlMethod.run();
                break;
            }
            default: {
                nonRtlMethod.run();
            }
        }
    }

    private double snapValueToTicks(double d) {
        RangeSlider rangeSlider = (RangeSlider)this.getNode();
        double d1 = d;
        double d2 = 0.0;
        d2 = rangeSlider.getMinorTickCount() != 0 ? rangeSlider.getMajorTickUnit() / (double)(Math.max(rangeSlider.getMinorTickCount(), 0) + 1) : rangeSlider.getMajorTickUnit();
        int i = (int)((d1 - rangeSlider.getMin()) / d2);
        double d3 = (double)i * d2 + rangeSlider.getMin();
        double d4 = (double)(i + 1) * d2 + rangeSlider.getMin();
        d1 = Utils.nearest((double)d3, (double)d1, (double)d4);
        return Utils.clamp((double)rangeSlider.getMin(), (double)d1, (double)rangeSlider.getMax());
    }

    public void highThumbReleased(MouseEvent e) {
        RangeSlider slider = (RangeSlider)this.getNode();
        slider.setHighValueChanging(false);
        if (slider.isSnapToTicks()) {
            slider.setHighValue(this.snapValueToTicks(slider.getHighValue()));
        }
    }

    public void highThumbPressed(MouseEvent e, double position) {
        RangeSlider slider = (RangeSlider)this.getNode();
        if (!slider.isFocused()) {
            slider.requestFocus();
        }
        slider.setHighValueChanging(true);
    }

    public void highThumbDragged(MouseEvent e, double position) {
        RangeSlider slider = (RangeSlider)this.getNode();
        slider.setHighValue(Utils.clamp((double)slider.getMin(), (double)(position * (slider.getMax() - slider.getMin()) + slider.getMin()), (double)slider.getMax()));
    }

    public void moveRange(double position) {
        RangeSlider slider = (RangeSlider)this.getNode();
        double min = slider.getMin();
        double max = slider.getMax();
        double lowValue = slider.getLowValue();
        double newLowValue = Utils.clamp((double)min, (double)(lowValue + position * (max - min) / (slider.getOrientation() == Orientation.HORIZONTAL ? slider.getWidth() : slider.getHeight())), (double)max);
        double highValue = slider.getHighValue();
        double newHighValue = Utils.clamp((double)min, (double)(highValue + position * (max - min) / (slider.getOrientation() == Orientation.HORIZONTAL ? slider.getWidth() : slider.getHeight())), (double)max);
        if (newLowValue <= min || newHighValue >= max) {
            return;
        }
        slider.setLowValueChanging(true);
        slider.setHighValueChanging(true);
        slider.setLowValue(newLowValue);
        slider.setHighValue(newHighValue);
    }

    public void confirmRange() {
        RangeSlider slider = (RangeSlider)this.getNode();
        slider.setLowValueChanging(false);
        if (slider.isSnapToTicks()) {
            slider.setLowValue(this.snapValueToTicks(slider.getLowValue()));
        }
        slider.setHighValueChanging(false);
        if (slider.isSnapToTicks()) {
            slider.setHighValue(this.snapValueToTicks(slider.getHighValue()));
        }
    }

    public static enum FocusedChild {
        LOW_THUMB,
        HIGH_THUMB,
        RANGE_BAR,
        NONE;

    }
}

