/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells;

import java.time.Duration;
import javafx.scene.control.TreeTableCell;

public class DurationTreeTableCell<S>
extends TreeTableCell<S, Duration> {
    protected void updateItem(Duration item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null) {
            this.setGraphic(null);
            this.textProperty().unbind();
            this.setText(null);
        } else {
            String text;
            long second = item.getSeconds();
            long nano = item.getNano();
            if (second < 60L) {
                text = String.format("%ds %03dms", second, nano / 1000000L);
            } else {
                long hours = second / 3600L;
                long minutes = second % 3600L / 60L;
                long seconds = second % 60L;
                text = hours > 0L ? String.format("%dh %dm %ds", hours, minutes, seconds) : String.format("%dm %ds", minutes, seconds);
            }
            this.setText(text);
        }
    }
}

