/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javafx.scene.control.TreeTableCell;

public class InstantTreeTableCell<S>
extends TreeTableCell<S, Instant> {
    private final DateTimeFormatter formatter;
    private final ZoneId atZone;

    public InstantTreeTableCell(DateTimeFormatter formatter) {
        this(ZoneId.systemDefault(), formatter);
    }

    public InstantTreeTableCell(ZoneId atZone, DateTimeFormatter formatter) {
        this.formatter = formatter;
        this.atZone = atZone;
    }

    protected void updateItem(Instant item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.textProperty().unbind();
            this.setText(null);
        } else {
            ZonedDateTime zdt = item.atZone(this.atZone);
            this.setText(zdt.format(this.formatter));
        }
    }
}

