/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells;

import de.elpro.ui.formats.TimeFormatType;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javafx.scene.control.TableCell;

public class LocalDateTableCell<S>
extends TableCell<S, LocalDate> {
    private final DateTimeFormatter formatter;

    public LocalDateTableCell() {
        this(TimeFormatType.Date.getFormatter());
    }

    public LocalDateTableCell(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    protected void updateItem(LocalDate item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.textProperty().unbind();
            this.setText(null);
        } else {
            this.setText(this.formatter.format(item));
        }
    }
}

