/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells;

import de.elpro.ui.formats.TimeFormatType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javafx.scene.control.TableCell;

public class LocalDateTimeTableCell<S>
extends TableCell<S, LocalDateTime> {
    private final DateTimeFormatter formatter;

    public LocalDateTimeTableCell() {
        this(TimeFormatType.DateTimeHMs.getFormatter());
    }

    public LocalDateTimeTableCell(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    protected void updateItem(LocalDateTime item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.textProperty().unbind();
            this.setText(null);
        } else {
            this.setText(this.formatter.format(item));
        }
    }
}

