/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells;

import java.text.DecimalFormat;
import javafx.scene.control.TableCell;

public class NumberTableCell<S, T extends Number>
extends TableCell<S, T> {
    private final DecimalFormat format;

    public NumberTableCell(DecimalFormat format) {
        this.format = format;
        this.getStyleClass().add((Object)"number-table-cell");
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.textProperty().unbind();
            this.setText(null);
        } else {
            this.setText(this.format.format(item));
        }
    }
}

