/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells.editable;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.TableCell;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.StringConverter;

public class ColorPickerTableCell<S>
extends TableCell<S, Color> {
    private ColorPicker colorPicker;
    private static final StringConverter<Color> defaultStringConverter = new StringConverter<Color>(){

        public String toString(Color t) {
            return t == null ? null : t.toString();
        }

        public Color fromString(String string) {
            return Color.valueOf((String)string);
        }
    };
    private ObjectProperty<StringConverter<Color>> converter = new SimpleObjectProperty((Object)this, "converter");
    private BooleanProperty comboBoxEditable = new SimpleBooleanProperty((Object)this, "comboBoxEditable");

    public ColorPickerTableCell() {
        this(null);
    }

    public ColorPickerTableCell(StringConverter<Color> converter) {
        this.setConverter(converter != null ? converter : defaultStringConverter);
    }

    public final ObjectProperty<StringConverter<Color>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<Color> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<Color> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public final BooleanProperty comboBoxEditableProperty() {
        return this.comboBoxEditable;
    }

    public final void setComboBoxEditable(boolean value) {
        this.comboBoxEditableProperty().set(value);
    }

    public final boolean isComboBoxEditable() {
        return this.comboBoxEditableProperty().get();
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        if (this.colorPicker == null) {
            this.colorPicker = ColorPickerTableCell.createColorPicker((Cell<Color>)this);
            this.colorPicker.editableProperty().bind((ObservableValue)this.comboBoxEditableProperty());
        }
        super.startEdit();
        this.setText(null);
        this.setGraphic((Node)this.colorPicker);
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(null);
        this.setGraphic(ColorPickerTableCell.getItemGraphic((Cell<Color>)this));
    }

    public void updateItem(Color item, boolean empty) {
        super.updateItem((Object)item, empty);
        ColorPickerTableCell.updateItem((Cell<Color>)this, this.getConverter(), this.colorPicker);
    }

    static void updateItem(Cell<Color> cell, StringConverter<Color> converter, ColorPicker colorPicker) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (colorPicker != null) {
                colorPicker.setValue((Object)((Color)cell.getItem()));
            }
            cell.setText(null);
            cell.setGraphic((Node)colorPicker);
        } else {
            cell.setText(null);
            cell.setGraphic(ColorPickerTableCell.getItemGraphic(cell));
        }
    }

    static ColorPicker createColorPicker(Cell<Color> cell) {
        ColorPicker colorPicker = new ColorPicker();
        colorPicker.setMaxWidth(Double.MAX_VALUE);
        colorPicker.valueProperty().addListener((ov, oldValue, newValue) -> {
            if (cell.isEditing()) {
                cell.commitEdit(newValue);
            }
        });
        return colorPicker;
    }

    private static Node getItemGraphic(Cell<Color> cell) {
        if (cell.getItem() != null) {
            return new Rectangle(16.0, 16.0, (Paint)cell.getItem());
        }
        return null;
    }
}

