/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells.editable.internal;

import de.elpro.ui.fx.controls.NumericField;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Cell;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;

public class CellUtils {
    public static <T> ComboBox<T> createComboBox(Cell<T> cell, ObservableList<T> items, ObjectProperty<StringConverter<T>> converter) {
        ComboBox comboBox = new ComboBox(items);
        comboBox.converterProperty().bind(converter);
        comboBox.setMaxWidth(Double.MAX_VALUE);
        comboBox.getSelectionModel().selectedItemProperty().addListener((ov, oldValue, newValue) -> {
            if (cell.isEditing()) {
                cell.commitEdit(newValue);
            }
        });
        return comboBox;
    }

    public static <T> void updateItem(Cell<T> cell, StringConverter<T> converter, HBox hbox, Node graphic, ComboBox<T> comboBox) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (comboBox != null) {
                comboBox.getSelectionModel().select(cell.getItem());
            }
            cell.setText(null);
            if (graphic != null) {
                hbox.getChildren().setAll((Object[])new Node[]{graphic, comboBox});
                cell.setGraphic((Node)hbox);
            } else {
                cell.setGraphic(comboBox);
            }
        } else {
            cell.setText(CellUtils.getItemText(cell, converter));
            cell.setGraphic(graphic);
        }
    }

    public static <T> void startEdit(Cell<T> cell, StringConverter<T> converter, HBox hbox, Node graphic, TextField textField) {
        if (textField != null) {
            textField.setText(CellUtils.getItemText(cell, converter));
        }
        cell.setText(null);
        if (graphic != null) {
            hbox.getChildren().setAll((Object[])new Node[]{graphic, textField});
            cell.setGraphic((Node)hbox);
        } else {
            cell.setGraphic((Node)textField);
        }
        textField.selectAll();
        textField.requestFocus();
    }

    public static <T extends Number> void startEdit(Cell<T> cell, NumericField numberField) {
        if (numberField != null) {
            numberField.setValue((Number)cell.getItem());
        }
        cell.setText(null);
        cell.setGraphic((Node)numberField);
        numberField.selectAll();
        numberField.requestFocus();
    }

    public static <T> void startEdit(Cell<T> cell, StringConverter<T> converter, TextField textField) {
        if (textField != null) {
            textField.setText(CellUtils.getItemText(cell, converter));
        }
        cell.setText(null);
        cell.setGraphic((Node)textField);
        textField.selectAll();
        textField.requestFocus();
    }

    private static <T> String getItemText(Cell<T> cell, StringConverter<T> converter) {
        return converter == null ? (cell.getItem() == null ? "" : cell.getItem().toString()) : converter.toString(cell.getItem());
    }

    public static <T> TextField createTextField(Cell<T> cell, StringConverter<T> converter) {
        TextField textField = new TextField(CellUtils.getItemText(cell, converter));
        textField.setOnAction(event -> {
            if (converter == null) {
                throw new IllegalStateException("Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.");
            }
            try {
                cell.commitEdit(converter.fromString(textField.getText()));
            }
            catch (Exception exception) {
                cell.cancelEdit();
            }
            event.consume();
        });
        textField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                cell.cancelEdit();
                t.consume();
            }
        });
        return textField;
    }

    public static void requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(Control c) {
        Node focusOwner;
        Scene scene = c.getScene();
        Node node = focusOwner = scene == null ? null : scene.getFocusOwner();
        if (focusOwner == null) {
            c.requestFocus();
        } else if (!c.equals(focusOwner)) {
            Parent p = focusOwner.getParent();
            while (p != null) {
                if (c.equals(p)) {
                    c.requestFocus();
                    break;
                }
                p = p.getParent();
            }
        }
    }
}

