/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells.uimodel;

import de.elpro.ui.fx.controls.tree.LazyTreeItem;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.model.UILabeledElement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class UIModelTreeCell<T extends UILabeledElement>
extends TreeCell<T> {
    private final EventHandler<? super MouseEvent> defaultDoubleClickHandler;
    private final List<String> defaultStyleClasses = new LinkedList<String>((Collection<String>)this.getStyleClass());
    private final Font defaultFont = this.getFont();
    private ProgressIndicator pinMain;
    private Node errorIndicator;

    public UIModelTreeCell() {
        this(null);
    }

    public UIModelTreeCell(EventHandler<? super MouseEvent> value) {
        this.defaultDoubleClickHandler = value;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.textProperty().unbind();
            this.setText(null);
            this.setStyleClass(new String[0]);
        } else {
            EventDispatcher originalDispatcher;
            if (this.defaultDoubleClickHandler != null && !((originalDispatcher = this.getEventDispatcher()) instanceof TreeMouseEventDispatcher)) {
                TreeMouseEventDispatcher tmed = new TreeMouseEventDispatcher((Cell<?>)this, originalDispatcher, this.defaultDoubleClickHandler);
                this.setEventDispatcher(tmed);
            }
            this.setGraphic(this.getItemGraphic(item));
            this.textProperty().bind(item.textProperty());
            this.setTextFill(item.getTextFill());
            this.setFont(this.getFont(item.getFontWeight()));
            this.setStyleClass(item.isEnabled() ? "enabled" : "disabled");
        }
    }

    private Node getItemGraphic(T item) {
        TreeItem treeItem = this.getTreeItem();
        double size = 16.0;
        if (treeItem instanceof LazyTreeItem) {
            LazyTreeItem lti = (LazyTreeItem)treeItem;
            switch (lti.getState()) {
                case Loading: {
                    if (this.pinMain == null) {
                        this.pinMain = new ProgressIndicator();
                        this.pinMain.setPrefSize(size, size);
                    }
                    return this.pinMain;
                }
                case Error: {
                    if (this.errorIndicator == null) {
                        StackPane region = new StackPane();
                        Shape shape = this.createErrorShape(size / 2.0);
                        shape.setRotate(45.0);
                        region.getChildren().add((Object)shape);
                        region.setPrefSize(size, size);
                        StackPane.setAlignment((Node)shape, (Pos)Pos.CENTER);
                        this.errorIndicator = region;
                    }
                    return this.errorIndicator;
                }
            }
        }
        return item.getGraphic();
    }

    private Shape createErrorShape(double size) {
        Polygon polygon = new Polygon();
        polygon.getPoints().addAll((Object[])new Double[]{size * 3.0 / 8.0, 0.0, size * 5.0 / 8.0, 0.0, size * 5.0 / 8.0, size * 3.0 / 8.0, size, size * 3.0 / 8.0, size, size * 5.0 / 8.0, size * 5.0 / 8.0, size * 5.0 / 8.0, size * 5.0 / 8.0, size, size * 3.0 / 8.0, size, size * 3.0 / 8.0, size * 5.0 / 8.0, 0.0, size * 5.0 / 8.0, 0.0, size * 3.0 / 8.0, size * 3.0 / 8.0, size * 3.0 / 8.0});
        polygon.setFill((Paint)Color.CRIMSON);
        polygon.setStroke((Paint)Color.CRIMSON);
        return polygon;
    }

    public Font getFont(FontWeight fontWeight) {
        return Font.font((String)this.defaultFont.getFamily(), (FontWeight)fontWeight, (double)this.defaultFont.getSize());
    }

    private void setStyleClass(String ... classNames) {
        LinkedList<String> defaultClasses = new LinkedList<String>(this.defaultStyleClasses);
        if (classNames != null) {
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                defaultClasses.add(className);
                ++n2;
            }
        }
        this.getStyleClass().setAll(defaultClasses);
    }

    private static class TreeMouseEventDispatcher
    implements EventDispatcher {
        private final EventDispatcher originalDispatcher;
        private final Cell<?> cell;
        private final EventHandler<? super MouseEvent> defaultDoubleClickHandler;

        public TreeMouseEventDispatcher(Cell<?> cell, EventDispatcher originalDispatcher, EventHandler<? super MouseEvent> defaultDoubleClickHandler) {
            this.originalDispatcher = originalDispatcher;
            this.cell = cell;
            this.defaultDoubleClickHandler = defaultDoubleClickHandler;
        }

        public Event dispatchEvent(Event event, EventDispatchChain tail) {
            Node node;
            Cell cell;
            MouseEvent me;
            if (event instanceof MouseEvent && (me = (MouseEvent)event).getButton() == MouseButton.PRIMARY && me.getClickCount() >= 2 && (cell = FXUtils.findParent(node = me.getPickResult().getIntersectedNode(), Cell.class)) == this.cell && this.defaultDoubleClickHandler != null && !event.isConsumed()) {
                if (me.getEventType() == MouseEvent.MOUSE_CLICKED) {
                    this.defaultDoubleClickHandler.handle((Event)me);
                }
                event.consume();
            }
            return this.originalDispatcher.dispatchEvent(event, tail);
        }
    }
}

