/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls;

import de.elpro.ui.fx.Messages;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class CheckBoxDialog
extends Dialog<Boolean> {
    private final CheckBox checkBox;
    private final boolean defaultValue;

    public CheckBoxDialog() {
        this(false);
    }

    public CheckBoxDialog(@NamedArg(value="defaultValue") boolean defaultValue) {
        DialogPane dialogPane = this.getDialogPane();
        this.checkBox = new CheckBox(dialogPane.getContentText());
        this.checkBox.setSelected(defaultValue);
        this.checkBox.setMaxWidth(Double.MAX_VALUE);
        this.checkBox.textProperty().bind((ObservableValue)dialogPane.contentTextProperty());
        GridPane.setHgrow((Node)this.checkBox, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.checkBox, (Boolean)true);
        this.defaultValue = defaultValue;
        dialogPane.contentTextProperty().addListener(o -> this.updateGrid());
        this.setTitle(Messages.controls_CheckBoxDialog_title);
        dialogPane.setHeaderText(Messages.controls_CheckBoxDialog_header);
        dialogPane.getStyleClass().add((Object)"text-input-dialog");
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.updateGrid();
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? Boolean.valueOf(this.checkBox.isSelected()) : null;
        });
    }

    public final CheckBox getEditor() {
        return this.checkBox;
    }

    public final boolean getDefaultValue() {
        return this.defaultValue;
    }

    private void updateGrid() {
        this.getDialogPane().setContent((Node)this.checkBox);
        Platform.runLater(() -> this.checkBox.requestFocus());
    }
}

