/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public class CustomColorPicker
extends VBox {
    private final ObjectProperty<Color> currentColorProperty = new SimpleObjectProperty((Object)Color.WHITE);
    private final ObjectProperty<Color> customColorProperty = new SimpleObjectProperty((Object)Color.TRANSPARENT);
    private Pane colorRect;
    private final Pane colorBar;
    private final Pane colorRectOverlayOne;
    private final Pane colorRectOverlayTwo;
    private Region colorRectIndicator;
    private final Region colorBarIndicator;
    private Pane newColorRect;
    private DoubleProperty hue = new SimpleDoubleProperty(-1.0);
    private DoubleProperty sat = new SimpleDoubleProperty(-1.0);
    private DoubleProperty bright = new SimpleDoubleProperty(-1.0);
    private DoubleProperty alpha = new SimpleDoubleProperty(100.0){

        protected void invalidated() {
            CustomColorPicker.this.setCustomColor(new Color(CustomColorPicker.this.getCustomColor().getRed(), CustomColorPicker.this.getCustomColor().getGreen(), CustomColorPicker.this.getCustomColor().getBlue(), CustomColorPicker.clamp(CustomColorPicker.this.alpha.get() / 100.0)));
        }
    };

    public CustomColorPicker() {
        this.getStylesheets().add((Object)CustomColorPicker.class.getResource("custom-color-picker.css").toExternalForm());
        this.getStyleClass().add((Object)"my-custom-color");
        VBox box = new VBox();
        box.getStyleClass().add((Object)"color-rect-pane");
        this.customColorProperty().addListener((ov, t, t1) -> this.colorChanged());
        this.colorRectIndicator = new Region();
        this.colorRectIndicator.setId("color-rect-indicator");
        this.colorRectIndicator.setManaged(false);
        this.colorRectIndicator.setMouseTransparent(true);
        this.colorRectIndicator.setCache(true);
        StackPane colorRectOpacityContainer = new StackPane();
        this.colorRect = new StackPane();
        this.colorRect.getStyleClass().addAll((Object[])new String[]{"color-rect", "transparent-pattern"});
        Pane colorRectHue = new Pane();
        colorRectHue.backgroundProperty().bind((ObservableValue)new ObjectBinding<Background>(){
            {
                this.bind(new Observable[]{CustomColorPicker.this.hue});
            }

            protected Background computeValue() {
                return new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.hsb((double)CustomColorPicker.this.hue.getValue(), (double)1.0, (double)1.0), CornerRadii.EMPTY, Insets.EMPTY)});
            }
        });
        this.colorRectOverlayOne = new Pane();
        this.colorRectOverlayOne.getStyleClass().add((Object)"color-rect");
        this.colorRectOverlayOne.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)1.0)), new Stop(1.0, Color.rgb((int)255, (int)255, (int)255, (double)0.0))}), CornerRadii.EMPTY, Insets.EMPTY)}));
        EventHandler rectMouseHandler = event -> {
            double x = event.getX();
            double y = event.getY();
            this.sat.set(CustomColorPicker.clamp(x / this.colorRect.getWidth()) * 100.0);
            this.bright.set(100.0 - CustomColorPicker.clamp(y / this.colorRect.getHeight()) * 100.0);
            this.updateHSBColor();
        };
        this.colorRectOverlayTwo = new Pane();
        this.colorRectOverlayTwo.getStyleClass().addAll((Object[])new String[]{"color-rect"});
        this.colorRectOverlayTwo.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)0, (int)0, (double)0.0)), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)1.0))}), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.colorRectOverlayTwo.setOnMouseDragged(rectMouseHandler);
        this.colorRectOverlayTwo.setOnMousePressed(rectMouseHandler);
        Pane colorRectBlackBorder = new Pane();
        colorRectBlackBorder.setMouseTransparent(true);
        colorRectBlackBorder.getStyleClass().addAll((Object[])new String[]{"color-rect", "color-rect-border"});
        this.colorBar = new Pane();
        this.colorBar.getStyleClass().add((Object)"color-bar");
        this.colorBar.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)CustomColorPicker.createHueGradient(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.colorBarIndicator = new Region();
        this.colorBarIndicator.setId("color-bar-indicator");
        this.colorBarIndicator.setMouseTransparent(true);
        this.colorBarIndicator.setCache(true);
        this.colorRectIndicator.layoutXProperty().bind((ObservableValue)this.sat.divide(100).multiply((ObservableNumberValue)this.colorRect.widthProperty()));
        this.colorRectIndicator.layoutYProperty().bind((ObservableValue)Bindings.subtract((int)1, (ObservableNumberValue)this.bright.divide(100)).multiply((ObservableNumberValue)this.colorRect.heightProperty()));
        this.colorBarIndicator.layoutXProperty().bind((ObservableValue)this.hue.divide(360).multiply((ObservableNumberValue)this.colorBar.widthProperty()));
        colorRectOpacityContainer.opacityProperty().bind((ObservableValue)this.alpha.divide(100));
        EventHandler barMouseHandler = event -> {
            double x = event.getX();
            this.hue.set(CustomColorPicker.clamp(x / this.colorRect.getWidth()) * 360.0);
            this.updateHSBColor();
        };
        this.colorBar.setOnMouseDragged(barMouseHandler);
        this.colorBar.setOnMousePressed(barMouseHandler);
        this.newColorRect = new Pane();
        this.newColorRect.getStyleClass().add((Object)"color-new-rect");
        this.newColorRect.setId("new-color");
        this.newColorRect.backgroundProperty().bind((ObservableValue)new ObjectBinding<Background>(){
            {
                this.bind(new Observable[]{CustomColorPicker.this.customColorProperty});
            }

            protected Background computeValue() {
                return new Background(new BackgroundFill[]{new BackgroundFill((Paint)CustomColorPicker.this.customColorProperty.get(), CornerRadii.EMPTY, Insets.EMPTY)});
            }
        });
        this.colorBar.getChildren().setAll((Object[])new Node[]{this.colorBarIndicator});
        colorRectOpacityContainer.getChildren().setAll((Object[])new Node[]{colorRectHue, this.colorRectOverlayOne, this.colorRectOverlayTwo});
        this.colorRect.getChildren().setAll((Object[])new Node[]{colorRectOpacityContainer, colorRectBlackBorder, this.colorRectIndicator});
        VBox.setVgrow((Node)this.colorRect, (Priority)Priority.SOMETIMES);
        box.getChildren().addAll((Object[])new Node[]{this.colorBar, this.colorRect, this.newColorRect});
        this.getChildren().add((Object)box);
        if (this.currentColorProperty.get() == null) {
            this.currentColorProperty.set((Object)Color.TRANSPARENT);
        }
        this.updateValues();
    }

    private void updateValues() {
        this.hue.set(this.getCurrentColor().getHue());
        this.sat.set(this.getCurrentColor().getSaturation() * 100.0);
        this.bright.set(this.getCurrentColor().getBrightness() * 100.0);
        this.alpha.set(this.getCurrentColor().getOpacity() * 100.0);
        this.setCustomColor(Color.hsb((double)this.hue.get(), (double)CustomColorPicker.clamp(this.sat.get() / 100.0), (double)CustomColorPicker.clamp(this.bright.get() / 100.0), (double)CustomColorPicker.clamp(this.alpha.get() / 100.0)));
    }

    private void colorChanged() {
        this.hue.set(this.getCustomColor().getHue());
        this.sat.set(this.getCustomColor().getSaturation() * 100.0);
        this.bright.set(this.getCustomColor().getBrightness() * 100.0);
    }

    private void updateHSBColor() {
        Color newColor = Color.hsb((double)this.hue.get(), (double)CustomColorPicker.clamp(this.sat.get() / 100.0), (double)CustomColorPicker.clamp(this.bright.get() / 100.0), (double)CustomColorPicker.clamp(this.alpha.get() / 100.0));
        this.setCustomColor(newColor);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.colorRectIndicator.autosize();
    }

    static double clamp(double value) {
        return value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
    }

    private static LinearGradient createHueGradient() {
        Stop[] stops = new Stop[255];
        int x = 0;
        while (x < 255) {
            double offset = 0.00392156862745098 * (double)x;
            int h = (int)((double)x / 255.0 * 360.0);
            stops[x] = new Stop(offset, Color.hsb((double)h, (double)1.0, (double)1.0));
            ++x;
        }
        return new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stops);
    }

    public void setCurrentColor(Color currentColor) {
        this.currentColorProperty.set((Object)currentColor);
        this.updateValues();
    }

    Color getCurrentColor() {
        return (Color)this.currentColorProperty.get();
    }

    public final ObjectProperty<Color> customColorProperty() {
        return this.customColorProperty;
    }

    void setCustomColor(Color color) {
        this.customColorProperty.set((Object)color);
    }

    public Color getCustomColor() {
        return (Color)this.customColorProperty.get();
    }
}

