/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.control.DatePicker;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;

public class DateTimePicker
extends DatePicker {
    public static final String DEFAULT_FORMAT = "yyyy.MM.dd[[ ]HH[:mm[:ss]]]";
    private static final Function<LocalDate, LocalDateTime> INIT_DATE_CONVERTER = ld -> LocalDateTime.of(ld, LocalTime.of(0, 0));
    private static Function<LocalDate, LocalDateTime> defaultDateConverter = ld -> LocalDateTime.of(ld, LocalTime.of(0, 0));
    private DateTimeFormatter formatter;
    private ObjectProperty<LocalDateTime> dateTimeValue = new SimpleObjectProperty();
    private ObjectProperty<String> format = new SimpleObjectProperty<String>(){

        public void set(String newValue) {
            super.set((Object)newValue);
            DateTimePicker.this.formatter = DateTimeFormatter.ofPattern(newValue);
        }
    };
    private Function<LocalDate, LocalDateTime> dateConverter;

    public DateTimePicker() {
        this.getStyleClass().add((Object)"datetime-picker");
        this.setFormat(DEFAULT_FORMAT);
        this.setConverter(new InternalConverter());
        this.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.dateTimeValue.set(null);
            } else if (this.dateTimeValue.get() == null) {
                this.dateTimeValue.set((Object)this.getDateConverter().apply((LocalDate)newValue));
            } else {
                LocalTime time = ((LocalDateTime)this.dateTimeValue.get()).toLocalTime();
                this.dateTimeValue.set((Object)LocalDateTime.of(newValue, time));
            }
        });
        this.dateTimeValue.addListener((observable, oldValue, newValue) -> this.setValue(newValue == null ? null : newValue.toLocalDate()));
        ChangeListener focusListener = (o, ov, nv) -> {
            if (!nv.booleanValue()) {
                this.simulateEnterReleased();
            }
        };
        this.focusedProperty().addListener(focusListener);
        this.getEditor().focusedProperty().addListener(focusListener);
        this.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ENTER) {
                e.consume();
            }
        });
        this.setOnKeyReleased(e -> {
            if (e.getCode() == KeyCode.ENTER) {
                e.consume();
                try {
                    LocalDateTime ldt = DateTimePicker.tryReadValue(this.formatter, this.getEditor().getText());
                    this.dateTimeValue.set((Object)ldt);
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public static void setDefaultDateConverter(Function<LocalDate, LocalDateTime> dateConverter) {
        defaultDateConverter = dateConverter;
    }

    private void simulateEnterReleased() {
        this.fireEvent((Event)new KeyEvent((Object)this.getEditor(), (EventTarget)this, KeyEvent.KEY_RELEASED, null, null, KeyCode.ENTER, false, false, false, false));
    }

    public LocalDateTime getDateTimeValue() {
        return (LocalDateTime)this.dateTimeValue.get();
    }

    public void setDateTimeValue(LocalDateTime dateTimeValue) {
        this.dateTimeValue.set((Object)dateTimeValue);
    }

    private Function<LocalDate, LocalDateTime> getDateConverter() {
        if (this.dateConverter != null) {
            return this.dateConverter;
        }
        if (defaultDateConverter != null) {
            return defaultDateConverter;
        }
        return INIT_DATE_CONVERTER;
    }

    public void setDateConverter(Function<LocalDate, LocalDateTime> dateConverter) {
        this.dateConverter = dateConverter;
    }

    public ObjectProperty<LocalDateTime> dateTimeValueProperty() {
        return this.dateTimeValue;
    }

    public String getFormat() {
        return (String)this.format.get();
    }

    public ObjectProperty<String> formatProperty() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format.set((Object)format);
    }

    private static LocalDateTime tryReadValue(DateTimeFormatter formatter, String value) throws DateTimeException {
        if (value == null || value.isBlank()) {
            return null;
        }
        TemporalAccessor ts = formatter.parseBest(value.trim(), ZonedDateTime::from, LocalDateTime::from, LocalDate::from);
        LocalDateTime ldt = ts instanceof ZonedDateTime ? ((ZonedDateTime)ts).toLocalDateTime() : (ts instanceof LocalDateTime ? (LocalDateTime)ts : ((LocalDate)ts).atStartOfDay());
        return ldt;
    }

    class InternalConverter
    extends StringConverter<LocalDate> {
        InternalConverter() {
        }

        public String toString(LocalDate object) {
            LocalDateTime value = DateTimePicker.this.getDateTimeValue();
            return value != null ? value.format(DateTimePicker.this.formatter) : "";
        }

        public LocalDate fromString(String value) {
            LocalDateTime localDateTime = DateTimePicker.tryReadValue(DateTimePicker.this.formatter, value);
            DateTimePicker.this.dateTimeValue.set((Object)localDateTime);
            return ((LocalDateTime)DateTimePicker.this.dateTimeValue.get()).toLocalDate();
        }
    }
}

