/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls;

import de.elpro.ui.fx.controls.skins.LocaleTextFieldSkin;
import de.elpro.ui.text.LocaleDescriptor;
import de.elpro.ui.text.LocaleDescriptors;
import de.elpro.ui.text.LocaleText;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class LocaleTextField
extends Control {
    private static final PseudoClass PSEUDO_CLASS_SHOWING = PseudoClass.getPseudoClass((String)"showing");
    private static final PseudoClass PSEUDO_CLASS_ARMED = PseudoClass.getPseudoClass((String)"armed");
    private final SimpleObjectProperty<Locale> locale = new SimpleObjectProperty();
    private final ObservableList<Locale> locales = FXCollections.observableArrayList();
    private final SimpleStringProperty text = new SimpleStringProperty();
    private final SimpleStringProperty localeText = new SimpleStringProperty();
    private final SimpleObjectProperty<LocaleText> value = new SimpleObjectProperty();
    private final SimpleStringProperty promptText = new SimpleStringProperty();
    private final Map<Locale, LocaleDescriptor> localeDescriptors = new HashMap<Locale, LocaleDescriptor>();
    private ReadOnlyBooleanWrapper showing;
    private BooleanProperty armed = new SimpleBooleanProperty((Object)this, "armed", false){

        protected void invalidated() {
            LocaleTextField.this.pseudoClassStateChanged(PSEUDO_CLASS_ARMED, this.get());
        }
    };

    public LocaleTextField() {
        this(Locale.getDefault(), LocaleDescriptors.getDescriptors());
    }

    public LocaleTextField(Locale locale, LocaleDescriptor[] localeDescriptors) {
        this.getStylesheets().add((Object)LocaleTextField.class.getResource("locale-text-field.css").toExternalForm());
        this.locale.set((Object)locale);
        LocaleDescriptor[] localeDescriptorArray = localeDescriptors;
        int n = localeDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            LocaleDescriptor ld = localeDescriptorArray[n2];
            this.locales.add((Object)ld.getLocale());
            this.localeDescriptors.put(ld.getLocale(), ld);
            ++n2;
        }
        this.value.addListener(il -> {
            LocaleText localeText = this.getValue();
            this.setText(localeText != null ? localeText.getText(this.getLocale()) : null);
            this.setLocaleText(localeText.toJson());
            this.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
        });
        this.locale.addListener(il -> {
            LocaleText localeText = this.getValue();
            this.setText(localeText != null ? localeText.getText(this.getLocale()) : null);
            this.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
        });
        this.localeText.addListener(arg_0 -> this.lambda$2(localeDescriptors, arg_0));
        this.text.addListener(il -> {
            String text = this.getText();
            LocaleText oldLocaleText = this.getValue();
            if (text == null && oldLocaleText == null) {
                return;
            }
            if (oldLocaleText != null) {
                String oldText = oldLocaleText.getText(this.getLocale());
                if (oldText == null && text == null) {
                    return;
                }
                if (oldText != null && oldText.equals(text)) {
                    return;
                }
            }
            LocaleText localeText = oldLocaleText != null ? oldLocaleText.copy() : new LocaleText();
            localeText.setText(this.getLocale(), text);
            this.setValue(localeText);
        });
        this.getProperties().addListener(change -> {
            if (change.wasAdded() && change.getKey() == "FOCUSED") {
                this.setFocused((Boolean)change.getValueAdded());
                this.getProperties().remove((Object)"FOCUSED");
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new LocaleTextFieldSkin(this);
    }

    public final LocaleDescriptor getLocaleDescriptor(Locale locale) {
        return this.localeDescriptors.get(locale);
    }

    public final Locale getLocale() {
        return (Locale)this.locale.get();
    }

    public final void setLocale(Locale locale) {
        this.locale.set((Object)locale);
    }

    public final ObjectProperty<Locale> localeProperty() {
        return this.locale;
    }

    public final ObservableList<Locale> getLocales() {
        return this.locales;
    }

    public final String getText() {
        return this.text.get();
    }

    public final void setText(String text) {
        this.text.set(text);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final String getLocaleText() {
        return this.localeText.get();
    }

    public final void setLocaleText(String text) {
        this.localeText.set(text);
    }

    public final StringProperty localeTextProperty() {
        return this.localeText;
    }

    public final LocaleText getValue() {
        return (LocaleText)this.value.get();
    }

    public final void setValue(LocaleText value) {
        this.value.set((Object)value);
    }

    public final ObjectProperty<LocaleText> valueProperty() {
        return this.value;
    }

    public final StringProperty promptTextProperty() {
        return this.promptText;
    }

    public final String getPromptText() {
        return this.promptText.get();
    }

    public final void setPromptText(String value) {
        this.promptText.set(value);
    }

    public ReadOnlyBooleanProperty showingProperty() {
        return this.showingPropertyImpl().getReadOnlyProperty();
    }

    public final boolean isShowing() {
        return this.showingPropertyImpl().get();
    }

    private void setShowing(boolean value) {
        Event.fireEvent((EventTarget)this, (Event)(value ? new Event(ComboBoxBase.ON_SHOWING) : new Event(ComboBoxBase.ON_HIDING)));
        this.showingPropertyImpl().set(value);
        Event.fireEvent((EventTarget)this, (Event)(value ? new Event(ComboBoxBase.ON_SHOWN) : new Event(ComboBoxBase.ON_HIDDEN)));
    }

    private ReadOnlyBooleanWrapper showingPropertyImpl() {
        if (this.showing == null) {
            this.showing = new ReadOnlyBooleanWrapper(false){

                protected void invalidated() {
                    LocaleTextField.this.pseudoClassStateChanged(PSEUDO_CLASS_SHOWING, this.get());
                    LocaleTextField.this.notifyAccessibleAttributeChanged(AccessibleAttribute.EXPANDED);
                }

                public Object getBean() {
                    return LocaleTextField.this;
                }

                public String getName() {
                    return "showing";
                }
            };
        }
        return this.showing;
    }

    public BooleanProperty armedProperty() {
        return this.armed;
    }

    private final void setArmed(boolean value) {
        this.armedProperty().set(value);
    }

    public final boolean isArmed() {
        return this.armedProperty().get();
    }

    public void show() {
        if (!this.isDisabled()) {
            this.setShowing(true);
        }
    }

    public void hide() {
        if (this.isShowing()) {
            this.setShowing(false);
        }
    }

    public void arm() {
        if (!this.armedProperty().isBound()) {
            this.setArmed(true);
        }
    }

    public void disarm() {
        if (!this.armedProperty().isBound()) {
            this.setArmed(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$2(LocaleDescriptor[] var1_1, Observable il) {
        block9: {
            text = this.getLocaleText();
            if (text == null && this.getValue() == null) {
                return;
            }
            if (text == null) {
                this.setValue(null);
            } else if (this.getValue() == null) {
                try {
                    this.setValue(LocaleText.parse((String)text));
                    break block9;
                }
                catch (Exception v0) {
                    localeText = new LocaleText();
                    var8_5 = var1_1;
                    var7_6 = var1_1.length;
                    var6_7 = 0;
                    ** while (var6_7 < var7_6)
                }
lbl-1000:
                // 1 sources

                {
                    descr = var8_5[var6_7];
                    localeText.setText(descr.getLocale(), text);
                    ++var6_7;
                    continue;
                }
lbl21:
                // 1 sources

                this.setValue(localeText);
            } else if (text.equals(this.getValue().toJson())) {
                this.setValue(LocaleText.tryParse((String)text));
            }
        }
    }
}

