/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls;

import de.elpro.ui.fx.controls.skins.TimespanPickerSkin;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;

public class TimespanPicker
extends Control {
    private final ObservableList<Timespan> timespans = FXCollections.observableArrayList();
    private SimpleObjectProperty<OffsetDateTime> from = new SimpleObjectProperty();
    private SimpleObjectProperty<OffsetDateTime> to = new SimpleObjectProperty();
    private final ColorGenerator colorGenerator;
    private SimpleObjectProperty<Consumer<? super Timespan>> onTimespanClicked = new SimpleObjectProperty();

    public TimespanPicker() {
        this(new ColorGenerator(Color.web((String)"#66a1d2"), Color.web((String)"#66A1D2").deriveColor(1.0, 1.0, 0.9, 1.0), Color.web((String)"#66A1D2")));
    }

    public TimespanPicker(ColorGenerator colorGenerator) {
        this.colorGenerator = colorGenerator;
        this.timespans.addListener(il -> this.requestLayout());
        this.from.addListener(il -> this.requestLayout());
        this.to.addListener(to -> this.requestLayout());
        this.setMinHeight(30.0);
    }

    protected Skin<?> createDefaultSkin() {
        return new TimespanPickerSkin(this);
    }

    public ObservableList<Timespan> getTimespans() {
        return this.timespans;
    }

    public OffsetDateTime getFrom() {
        return (OffsetDateTime)this.from.get();
    }

    public void setFrom(OffsetDateTime from) {
        this.from.set((Object)from);
    }

    public ObjectProperty<OffsetDateTime> fromProperty() {
        return this.from;
    }

    public OffsetDateTime getTo() {
        return (OffsetDateTime)this.to.get();
    }

    public void setTo(OffsetDateTime to) {
        this.to.set((Object)to);
    }

    public ObjectProperty<OffsetDateTime> toProperty() {
        return this.to;
    }

    public ColorGenerator getColorGenerator() {
        return this.colorGenerator;
    }

    public Consumer<? super Timespan> getOnTimespanClicked() {
        return (Consumer)this.onTimespanClicked.get();
    }

    public void setOnTimespanClicked(Consumer<? super Timespan> onTimespanClicked) {
        this.onTimespanClicked.set(onTimespanClicked);
    }

    public static class ColorGenerator {
        private final Color emptyColor;
        private int index = 0;
        private final Color[] paints;
        private Map<Timespan, Color> fixedColors = new HashMap<Timespan, Color>();

        public ColorGenerator(Color emptyColor, Color ... paints) {
            this.emptyColor = emptyColor;
            this.paints = paints;
        }

        public Color getEmptyColor() {
            return this.emptyColor;
        }

        public void cleadFixedColors() {
            this.fixedColors.clear();
        }

        public void setFixedColor(Timespan timespan, Color color) {
            this.fixedColors.put(timespan, color);
        }

        public Color getNextColor(Timespan timespan) {
            if (timespan == null) {
                return this.emptyColor;
            }
            Color fixedColor = this.fixedColors.get(timespan);
            if (fixedColor != null) {
                return fixedColor;
            }
            if (this.paints.length == 0) {
                return Color.rgb((int)((int)(Math.random() * 255.0)), (int)((int)(Math.random() * 255.0)), (int)((int)(Math.random() * 255.0)));
            }
            if (this.index >= this.paints.length) {
                this.index = 0;
            }
            return this.paints[this.index++];
        }
    }

    public static class Timespan {
        private final OffsetDateTime from;
        private final OffsetDateTime to;
        private final String name;

        public Timespan(OffsetDateTime from, OffsetDateTime to, String name) {
            this.from = from;
            this.to = to;
            this.name = name;
        }

        public OffsetDateTime getFrom() {
            return this.from;
        }

        public OffsetDateTime getTo() {
            return this.to;
        }

        public String getName() {
            return this.name;
        }
    }
}

